/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.action;

import com.hs.atic.collect.service.ZipCommandResult;
import com.hs.atic.collect.service.attack.CollectParam;
import com.hs.atic.collect.service.attack.CollectResult;
import com.hs.atic.collect.service.attack.EnumCollectClassification;
import com.hs.atic.collect.service.attack.IAttackDefenceCollect;
import com.hs.atic.collect.util.ConstantUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.AddressUtil;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.sdk.common.util.ProgressMgr;
import com.huawei.atic.util.AticInstallUtil;
import com.opensymphony.xwork2.ActionContext;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipOutputStream;
import org.apache.struts2.ServletActionContext;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OneKeyAttackDefenceAction
extends BaseAction {
    private static final long serialVersionUID = -4294853623237485003L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private long progressId;
    private Map<EnumCollectClassification, CollectParam> collectParamMap;

    public String execDownload() {
        this.logger.info((Object)"execDownload start!");
        if (null == this.collectParamMap) {
            return "error";
        }
        HashMap<EnumCollectClassification, IAttackDefenceCollect> preExecObj = new HashMap<EnumCollectClassification, IAttackDefenceCollect>();
        this.progressId = System.currentTimeMillis();
        this.initExecObj(preExecObj);
        if (preExecObj.size() == 0) {
            return "error";
        }
        ProgressMgr.getInstance().createProgressBar(preExecObj.size() + 1, this.progressId);
        String webPath = ServletActionContext.getServletContext().getRealPath("/");
        User user = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        this.initThreadPool(preExecObj, this.progressId, webPath, ActionContext.getContext().getLocale(), user, ServletActionContext.getRequest().getRemoteAddr());
        return "success";
    }

    private void initThreadPool(final Map<EnumCollectClassification, IAttackDefenceCollect> preExecObj, final long id, final String webPath, final Locale locale, final User user, final String remoteAddr) {
        final CountDownLatch end = new CountDownLatch(preExecObj.size());
        final ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 20, 30L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
        ExecutorService cache = Executors.newFixedThreadPool(1);
        cache.execute(new Runnable(){

            @Override
            public void run() {
                ArrayList<Future<CollectResult>> futures = new ArrayList<Future<CollectResult>>();
                for (final Map.Entry preExec : preExecObj.entrySet()) {
                    Future<CollectResult> future = executor.submit(new Callable<CollectResult>(){

                        @Override
                        public CollectResult call() {
                            CollectResult result = null;
                            try {
                                CollectParam cr = (CollectParam)OneKeyAttackDefenceAction.this.collectParamMap.get(preExec.getKey());
                                result = ((IAttackDefenceCollect)preExec.getValue()).collectData(cr);
                            }
                            catch (LegoCheckedException e) {
                                OneKeyAttackDefenceAction.this.logger.error((Object)("preExec : " + preExec.getClass().getSimpleName() + " exec error cause of :"), (Throwable)e);
                            }
                            finally {
                                end.countDown();
                                ProgressMgr.getInstance().getProgressBar(id).next();
                            }
                            return result;
                        }
                    });
                    futures.add(future);
                }
                try {
                    end.await();
                    executor.shutdown();
                }
                catch (InterruptedException e) {
                    OneKeyAttackDefenceAction.this.logger.error((Object)e);
                }
                OneKeyAttackDefenceAction.this.record(futures, locale, user, remoteAddr);
                OneKeyAttackDefenceAction.this.zipDir(id, webPath);
            }
        });
    }

    private void record(List<Future<CollectResult>> futures, Locale locale, User user, String remoteAddr) {
        int successCount = 0;
        int failedCount = 0;
        String success = "SUCCESS : [";
        String failed = "FAILED : [";
        for (Future<CollectResult> future : futures) {
            if (null == future) continue;
            try {
                CollectResult eachResult = future.get();
                if (eachResult.isSuccess()) {
                    this.logger.info((Object)((Object)((Object)eachResult.getCollectClassification()) + " success, file path is " + eachResult.getDownloadFilePath()));
                    success = success + eachResult.getTarget() + ";";
                    if (success.endsWith(";")) {
                        success = success.substring(0, success.length() - 1);
                    }
                    ++successCount;
                    continue;
                }
                this.logger.error((Object)((Object)((Object)eachResult.getCollectClassification()) + " failed, maybe cause of : " + eachResult.getDetail()));
                if (null != eachResult.getDetail() && ConstantUtil.isNumeric(eachResult.getDetail().trim())) {
                    String txt = ConstantUtil.getMessage("lego.err." + eachResult.getDetail().trim(), "AticResources", locale);
                    this.logger.error((Object)((Object)((Object)eachResult.getCollectClassification()) + " failed, maybe cause of : " + txt));
                }
                if ((failed = failed + eachResult.getTarget() + ";").endsWith(";")) {
                    failed = failed.substring(0, failed.length() - 1);
                }
                ++failedCount;
            }
            catch (InterruptedException e) {
                this.logger.error((Object)e);
            }
            catch (ExecutionException e) {
                this.logger.error((Object)e);
            }
        }
        success = success + "]\n\r";
        failed = failed + "]";
        String str = "atic.bis.unicom.operate.status.zero";
        boolean succ = true;
        if (failedCount > 0 && successCount > 0) {
            str = "atic.bis.onekeyCollection.part.success";
            succ = true;
        } else if (successCount == 0 && failedCount > 0) {
            succ = false;
        } else if (successCount > 0 && failedCount == 0) {
            succ = true;
        }
        ConstantUtil.writSyslog(succ, success + failed, "atic.bis.onekeyCollection.attackdefense", str, "atic.bis.unicom.operate.status.one", "atic.bis.onekeyCollection.attackdefense", user, remoteAddr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipDir(long id, String webPath) {
        boolean isCreate;
        String dstPath = webPath + ConstantUtil.PACKAGE_DIR + id;
        File dstDir = new File(dstPath);
        if (!dstDir.exists() && !(isCreate = dstDir.mkdirs())) {
            this.logger.error((Object)("create dir file = " + dstPath));
        }
        File dstFile = new File(dstPath + File.separator + id + ".zip");
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        ZipOutputStream zos = null;
        try {
            boolean is;
            fos = new FileOutputStream(dstFile);
            bos = new BufferedOutputStream(fos);
            zos = new ZipOutputStream(bos);
            String inPath = webPath + ConstantUtil.EXPORT_ATTACKDEFENCE_DIR + id;
            File inDir = new File(inPath);
            if (!inDir.exists() && !(is = inDir.mkdirs())) {
                this.logger.error((Object)(inDir.getPath() + " create dir failed!"));
            }
            Date date = new Date(id);
            String dirName = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(date);
            ZipCommandResult.zipFile(inDir, zos, "", dirName);
            this.close(fos, bos, zos);
            ProgressMgr.getInstance().getProgressBar(id).next();
        }
        catch (FileNotFoundException e) {
            try {
                this.logger.error((Object)e);
                this.close(fos, bos, zos);
                ProgressMgr.getInstance().getProgressBar(id).next();
            }
            catch (Throwable throwable) {
                this.close(fos, bos, zos);
                ProgressMgr.getInstance().getProgressBar(id).next();
                throw throwable;
            }
        }
    }

    private void close(FileOutputStream fos, BufferedOutputStream bos, ZipOutputStream zos) {
        try {
            if (null != zos) {
                zos.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        try {
            if (null != bos) {
                bos.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        try {
            if (null != fos) {
                fos.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
    }

    private void initExecObj(Map<EnumCollectClassification, IAttackDefenceCollect> preExecObj) {
        for (Map.Entry<EnumCollectClassification, CollectParam> entry : this.collectParamMap.entrySet()) {
            if (null == entry || null == entry.getValue()) continue;
            Class<? extends IAttackDefenceCollect> clazz = entry.getKey().getClazz();
            try {
                IAttackDefenceCollect eachCollector = clazz.newInstance();
                preExecObj.put(entry.getKey(), eachCollector);
            }
            catch (InstantiationException e) {
                this.logger.error((Object)e);
            }
            catch (IllegalAccessException e) {
                this.logger.error((Object)e);
            }
            Object objTmp = ServletActionContext.getRequest().getSession().getAttribute("CFNMAE_S");
            String httpSessionId = ServletActionContext.getRequest().getSession().getId();
            if (null != objTmp) {
                entry.getValue().setCfNameHF(String.valueOf(objTmp));
            }
            entry.getValue().setHttpSessionId(httpSessionId);
            Object objUser = ServletActionContext.getRequest().getSession().getAttribute("currentUser");
            entry.getValue().setCurUserId(null != objUser ? Long.valueOf(((User)objUser).getUserID()) : 1L);
            entry.getValue().setCurUserName(null != objUser ? ((User)objUser).getUserName() : "");
            entry.getValue().setLocale(ActionContext.getContext().getLocale());
            entry.getValue().setWebPath(ServletActionContext.getServletContext().getRealPath("/"));
            entry.getValue().setProgressId(this.progressId);
            String serverIpAddress = this.getInstallXmlIp();
            if (serverIpAddress.isEmpty()) {
                serverIpAddress = AddressUtil.getLocalIP();
            }
            entry.getValue().setSchemeServer(ServletActionContext.getRequest().getScheme() + "://" + serverIpAddress + ":" + ServletActionContext.getRequest().getServerPort());
            this.logger.info((Object)("getScheme : " + ServletActionContext.getRequest().getScheme() + "://" + serverIpAddress + ":" + ServletActionContext.getRequest().getServerPort()));
            try {
                entry.getValue().setStartTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(entry.getValue().getStartTimeSimpleDate()));
                entry.getValue().setEndTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(entry.getValue().getEndTimeSimpleDate()));
            }
            catch (ParseException e) {
                this.logger.error((Object)e);
            }
        }
    }

    private String getInstallXmlIp() {
        String serverIpAddress = "";
        try {
            String path = AticInstallUtil.getInstance().getLegoPlatInstalledXMLPath();
            Document doc = new SAXReader().read(new File(path));
            Element element = (Element)doc.selectSingleNode("//entry/string[text()='lego.base.serverIpAddress']");
            serverIpAddress = element.getParent().selectSingleNode("com.huawei.elog.base.model.ContextPropVal").selectSingleNode("value").getText();
        }
        catch (DocumentException e) {
            this.logger.error((Object)"getInstallXmlIp error", (Throwable)e);
        }
        return serverIpAddress;
    }

    public long getProgressId() {
        return this.progressId;
    }

    public void setProgressId(long progressId) {
        this.progressId = progressId;
    }

    public Map<EnumCollectClassification, CollectParam> getCollectParamMap() {
        return this.collectParamMap;
    }

    public void setCollectParamMap(Map<EnumCollectClassification, CollectParam> collectParamMap) {
        this.collectParamMap = collectParamMap;
    }
}

