/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.action;

import com.hs.atic.collect.Model.CollectModel;
import com.hs.atic.collect.Model.CollectParam;
import com.hs.atic.collect.service.CommandCollectPool;
import com.hs.atic.collect.service.CommandCollectResult;
import com.hs.atic.collect.service.CommandTranslate;
import com.hs.atic.collect.service.EnumCommandOrder;
import com.hs.atic.collect.service.EnumFileCommandOrder;
import com.hs.atic.collect.service.IssuedCommandResults;
import com.hs.atic.collect.util.ConstantUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.common.util.ProgressMgr;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import com.opensymphony.xwork2.ActionContext;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OneKeyCollectAction
extends BaseAction {
    private static final int MASK_IPV4_ACL = 0;
    private static final int MASK_IPV6_ACL = 1;
    private static final long serialVersionUID = -2320713946758535651L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private CollectModel collectModel;
    private List<AticDevice> devices;
    @Autowired
    private IAticDeviceService aticDeviceService;
    @Autowired
    private CommandTranslate commandTranslate;
    @Autowired
    private CommandCollectPool commandCollectPool;
    private long progressId;
    private int progress;
    private InputStream inputStream;
    private String downLoadName;
    private Map<Long, Boolean> devicesStatus;
    private String result;
    private Map<String, Map<String, List<String>>> devices2Command2Result = new HashMap<String, Map<String, List<String>>>();
    private String userCommand;
    private Map<Long, String> cfcards;
    private Map<Long, String> cfcardResult;
    private int length;

    public String sendCommand() {
        if (null == this.collectModel) {
            this.logger.error((Object)"collectModel is null!");
            return "error";
        }
        Set<AticDevice> sets = this.devicesValidate();
        if (sets.size() == 0) {
            this.logger.error((Object)"devices is null!");
            return "error";
        }
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        Map<String, String> commands = this.commandTranslate.doTranslate(this.collectModel, cmdParams);
        if (commands.size() == 0) {
            this.logger.error((Object)"commands size is 0!");
            return "error";
        }
        this.progressId = new Date().getTime();
        ProgressBar progressBar = ProgressMgr.getInstance().createProgressBar(commands.size() * sets.size() + 1, this.progressId);
        this.commandCollectPool.createThreadPool(progressBar, commands, sets, ServletActionContext.getServletContext().getRealPath("/"), ActionContext.getContext().getLocale(), 0);
        String devicesx = this.devNames(sets);
        String target = "device=[" + devicesx + "]" + " commands=" + commands.toString();
        this.writSyslog(true, target, "atic.bis.onekeyCollection.operation.download", "atic.bis.onekeyCollection.operation.download.success", "atic.bis.onekeyCollection.operation.download.failed");
        return "success";
    }

    private String devNames(Set<AticDevice> sets) {
        if (null == sets) {
            return "";
        }
        StringBuffer devicesx = new StringBuffer();
        for (AticDevice device : sets) {
            if (null == device) continue;
            devicesx.append(device.getName());
            devicesx.append(";");
        }
        String temp = devicesx.toString();
        temp = temp.endsWith(";") ? temp.substring(0, temp.length() - 1) : temp;
        return temp;
    }

    private Set<AticDevice> devicesValidate() {
        HashSet<AticDevice> sets = new HashSet<AticDevice>();
        if (this.collectModel.getDeviceId() != 0L) {
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(this.collectModel.getDeviceId());
            sets.add(aticDevice);
        }
        if (this.collectModel.getDeviceId() == 0L) {
            User user = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
            List devicesl = this.aticDeviceService.getAntiDDoSDevice(user.getUserID());
            for (AticDevice aticDevice : devicesl) {
                sets.add(aticDevice);
            }
        }
        return sets;
    }

    public String fetchCollectProgress() {
        if (this.progressId == 0L) {
            return "error";
        }
        ProgressBar progressBar = ProgressMgr.getInstance().getProgressBar(this.progressId);
        if (null == progressBar) {
            return "error";
        }
        this.progress = progressBar.getProgress();
        return "success";
    }

    public String fetchIssuedStatus() {
        if (this.progressId == 0L) {
            return "error";
        }
        this.devicesStatus = IssuedCommandResults.getInstance().getIssuedResults().get(this.progressId);
        ProgressBar progressBar = ProgressMgr.getInstance().getProgressBar(this.progressId);
        if (null != progressBar) {
            this.result = progressBar.getCurrentTask();
            this.cfcards = IssuedCommandResults.getInstance().getCfcards().get(this.progressId);
            this.cfcardResult = IssuedCommandResults.getInstance().getCfcardResult().get(this.progressId);
        }
        return "success";
    }

    public String downloadCollectZip() {
        if (this.progressId == 0L) {
            this.logger.error((Object)"downloadCollectZip error cause of progressId is 0 !");
            return "error";
        }
        String path = ServletActionContext.getServletContext().getRealPath("/") + ConstantUtil.PACKAGE_DIR + this.progressId + File.separator + this.progressId + ".zip";
        File downloadFile = new File(path);
        if (!downloadFile.exists()) {
            this.logger.error((Object)("download collect zip error cause of file : " + path + "not exists!"));
            return "error";
        }
        FileInputStream is = null;
        String fileNameTime = "";
        if (this.progressId > 0L) {
            Date date = new Date(this.progressId);
            fileNameTime = this.format(date);
        } else {
            Date date = new Date();
            fileNameTime = this.format(date);
        }
        this.downLoadName = "output_" + fileNameTime + ".zip";
        try {
            is = new FileInputStream(downloadFile);
            this.inputStream = new BufferedInputStream(is);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"download CollectZip error !");
        }
        CommandCollectResult.getInstance().clear(this.progressId);
        return "success";
    }

    private String format(Date date) {
        String fileNameTime = new SimpleDateFormat("yyyyMMddHHmmssSS").format(date);
        return fileNameTime;
    }

    public String issuedCommand() {
        if (null == this.collectModel) {
            this.logger.error((Object)"action: issuedCommand collectModel is null!");
            return "error";
        }
        Set<AticDevice> sets = this.devicesValidate();
        if (sets.size() == 0) {
            this.logger.error((Object)"issued command device is null!");
            return "error";
        }
        this.progressId = new Date().getTime();
        ProgressMgr.getInstance().createProgressBar(EnumCommandOrder.values().length * sets.size() + 1, this.progressId);
        String target = this.generateLogTarget(sets);
        this.collectModel.setTarget(target);
        User user = (User)this.getSession().getAttribute("currentUser");
        this.collectModel.setUser(user);
        this.collectModel.setModule("lego.dic.onekeycollection");
        this.collectModel.setRemoteAddr(this.fetchRequest().getRemoteAddr());
        ConstantUtil.factoryInstance(this.progressId, sets, this.collectModel, ActionContext.getContext().getLocale(), 0, EnumCommandOrder.values().length, EnumCommandOrder.COMMAND_ACL_ISSUED_COMMAND.getIndex(), ServletActionContext.getServletContext().getRealPath("/"));
        return "success";
    }

    private String generateLogTarget(Set<AticDevice> sets) {
        StringBuffer commands = new StringBuffer();
        for (EnumCommandOrder command : EnumCommandOrder.values()) {
            CollectParam collectParam;
            if (null == command || null == command.getCommand() || null == (collectParam = this.collectModel.getCollectParam().get(EnumCommandOrder.COMMAND_ACL_ISSUED_COMMAND.getIndex()))) continue;
            String cmdLog = this.translateCmd(collectParam, command);
            commands.append(cmdLog);
            commands.append(";");
        }
        String cmd = commands.toString();
        cmd = cmd.length() > 0 && cmd.endsWith(";") ? cmd.substring(0, cmd.length() - 1) : cmd;
        String devicesx = this.devNames(sets);
        return "device=[" + devicesx + "]" + " commands=" + cmd;
    }

    private String translateCmd(CollectParam collectParam, EnumCommandOrder each) {
        String sourceIp = null == collectParam || null == collectParam.getSourceIp() ? "" : collectParam.getSourceIp();
        String destIp = null == collectParam || null == collectParam.getDestIp() ? "" : collectParam.getDestIp();
        String type = "";
        String mask = "0";
        if (IPUtil.isIpv6((String)sourceIp) || IPUtil.isIpv6((String)destIp)) {
            type = "ipv6";
            mask = "1";
        }
        String cmd = each.getCommand();
        if (each == EnumCommandOrder.COMMAND_RULE) {
            cmd = String.format(cmd, ConstantUtil.placeholder(collectParam.getSourceIp()), mask, ConstantUtil.placeholder(collectParam.getDestIp()), mask);
            cmd = ConstantUtil.re(ConstantUtil.cut(cmd));
        }
        if (each == EnumCommandOrder.COMMAND_ACL_NUM) {
            cmd = String.format(cmd, type, 3998);
        }
        if (each == EnumCommandOrder.COMMAND_ACL_ISSUED_COMMAND) {
            cmd = String.format(cmd, 3998);
        }
        this.logger.info((Object)("EnumCommandOrder --- cmd : " + cmd));
        return cmd;
    }

    public String fetchDevices() {
        if (null == this.devices) {
            this.devices = new ArrayList<AticDevice>();
        }
        User user = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        List des = this.aticDeviceService.getAntiDDoSDevice(user.getUserID());
        this.devices.addAll(des);
        return "success";
    }

    public boolean validateIpMayNull(String parameteName) {
        HttpServletRequest request = this.fetchRequest();
        String ipTemp = request.getParameter(parameteName);
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateProgresId() {
        long id = 0L;
        try {
            id = this.progressId;
        }
        catch (NumberFormatException e) {
            return false;
        }
        return id >= 1L;
    }

    public boolean validateParam4UserCommand() {
        return true;
    }

    public String sendUserCommand() {
        if (null == this.collectModel) {
            this.logger.error((Object)"collectModel is null!");
            return "error";
        }
        Set<AticDevice> sets = this.devicesValidate();
        if (sets.size() == 0) {
            this.logger.error((Object)"devices is null!");
            return "error";
        }
        if (null == this.userCommand) {
            return "error";
        }
        String[] cmds = this.userCommand.split(";");
        LinkedHashMap<String, String> commands = new LinkedHashMap<String, String>();
        int index = 1;
        for (String cmd : cmds) {
            if (null == cmd || cmd.trim().isEmpty()) continue;
            commands.put(index + cmd.replace(" ", "_"), cmd);
            ++index;
        }
        if (commands.size() == 0) {
            return "error";
        }
        if (commands.size() > 5) {
            this.length = commands.size();
            return "error";
        }
        this.progressId = new Date().getTime();
        ProgressBar progressBar = ProgressMgr.getInstance().createProgressBar(commands.size() * sets.size() + 1, this.progressId);
        this.commandCollectPool.createThreadPool(progressBar, commands, sets, ServletActionContext.getServletContext().getRealPath("/"), ActionContext.getContext().getLocale(), 1);
        String devicesx = this.devNames(sets);
        String target = "device=[" + devicesx + "]" + " commands=" + commands.toString();
        this.writSyslog(true, target, "atic.bis.onekeyCollection.operation.run", "atic.bis.onekeyCollection.operation.run.success", "atic.bis.onekeyCollection.operation.run.failed");
        return "success";
    }

    public String readCommandResult() {
        if (this.progressId == 0L) {
            return "error";
        }
        this.devices2Command2Result = CommandCollectResult.getInstance().getCollect4DeviceResult().get(this.progressId);
        if (null == this.devices2Command2Result) {
            return "success";
        }
        CommandCollectResult.getInstance().clear(this.progressId);
        return "success";
    }

    public String sendCommand4Log() {
        if (null == this.collectModel) {
            this.logger.error((Object)"collectModel is null!");
            return "error";
        }
        Set<AticDevice> sets = this.devicesValidate();
        if (sets.size() == 0) {
            this.logger.error((Object)"devices is null!");
            return "error";
        }
        this.progressId = new Date().getTime();
        this.collectModel.setWebPath(ServletActionContext.getServletContext().getRealPath("/"));
        ProgressMgr.getInstance().createProgressBar(EnumFileCommandOrder.values().length * sets.size() + 1, this.progressId);
        ConstantUtil.factoryInstance(this.progressId, sets, this.collectModel, ActionContext.getContext().getLocale(), 1, EnumFileCommandOrder.values().length, "log", ServletActionContext.getServletContext().getRealPath("/"));
        return "success";
    }

    private void writSyslog(boolean isSucc, String target, String operation, String success, String failed) {
        if (null == target) {
            target = "";
        }
        if (target.length() >= 255) {
            target = target.substring(0, 250);
        }
        SysOptLog sysOptLog = new SysOptLog();
        sysOptLog.setOperation(operation);
        sysOptLog.setModule("lego.dic.onekeycollection");
        sysOptLog.setLevel(SysoplogLevel.normal.getValue());
        sysOptLog.setTarget(target);
        if (isSucc) {
            sysOptLog.setResult(1);
            sysOptLog.setDetail(success);
            sysOptLog.setDetailPara(new String[0]);
        } else {
            sysOptLog.setResult(0);
            sysOptLog.setDetail(failed);
            sysOptLog.setDetailPara(new String[0]);
        }
        User user = (User)this.getSession().getAttribute("currentUser");
        sysOptLog.setOperator(user.getUserName());
        sysOptLog.setTerminalIp(this.fetchRequest().getRemoteAddr());
        sysOptLog.setDate(new Date());
        ISysOptLog service = ZoneReferUtil.getSysOptLog();
        service.writeOptLog(sysOptLog);
    }

    public CollectModel getCollectModel() {
        return this.collectModel;
    }

    public void setCollectModel(CollectModel collectModel) {
        this.collectModel = collectModel;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getDownLoadName() {
        return this.downLoadName;
    }

    public void setDownLoadName(String downLoadName) {
        this.downLoadName = downLoadName;
    }

    public long getProgressId() {
        return this.progressId;
    }

    public void setProgressId(long progressId) {
        this.progressId = progressId;
    }

    public Map<Long, Boolean> getDevicesStatus() {
        return this.devicesStatus;
    }

    public void setDevicesStatus(Map<Long, Boolean> devicesStatus) {
        this.devicesStatus = devicesStatus;
    }

    public List<AticDevice> getDevices() {
        return this.devices;
    }

    public void setDevices(List<AticDevice> devices) {
        this.devices = devices;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getUserCommand() {
        return this.userCommand;
    }

    public void setUserCommand(String userCommand) {
        this.userCommand = userCommand;
    }

    public Map<String, Map<String, List<String>>> getDevices2Command2Result() {
        return this.devices2Command2Result;
    }

    public void setDevices2Command2Result(Map<String, Map<String, List<String>>> devices2Command2Result) {
        this.devices2Command2Result = devices2Command2Result;
    }

    public Map<Long, String> getCfcards() {
        return this.cfcards;
    }

    public void setCfcards(Map<Long, String> cfcards) {
        this.cfcards = cfcards;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Map<Long, String> getCfcardResult() {
        return this.cfcardResult;
    }

    public void setCfcardResult(Map<Long, String> cfcardResult) {
        this.cfcardResult = cfcardResult;
    }
}

