/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.service;

import com.hs.atic.collect.Model.CollectModel;
import com.hs.atic.collect.Model.CollectParam;
import com.hs.atic.collect.util.EnumCommand;
import com.hs.atic.collect.util.ReflectionUtils;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

@Service
public class CommandTranslate {
    public static final String DOLLAR = "$$";
    public static final String DOLLAR_REPLACEMENT = "%{$$}%";
    public static final String IP = "ip";
    public static final String IPV6 = "ipv6";
    private static final Pattern PATTERN = Pattern.compile("\\$\\{(.*?)\\}");
    private static final String PATTERN_REPLACE = "%\\{(.(?!\\}%))*\\$\\$(.(?!%\\{))*\\}%";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public static String replaceWithObject(String sourceString, Object param) {
        String targetString = sourceString;
        Matcher matcher = PATTERN.matcher(sourceString);
        while (matcher.find()) {
            String key = matcher.group();
            String holderName = key.substring(2, key.length() - 1).trim();
            try {
                Object value = ReflectionUtils.getFieldValue(param, holderName);
                if (value != null && !value.toString().trim().equals("")) {
                    targetString = targetString.replace(key, value.toString());
                    continue;
                }
                targetString = targetString.replace(key, DOLLAR);
            }
            catch (Exception e) {
                throw new RuntimeException("String formatter failed", e);
            }
        }
        return targetString;
    }

    public Map<String, String> doTranslate(CollectModel collectModel, List<CmdParam> cmdParams) {
        LinkedHashMap<String, String> cmds = new LinkedHashMap<String, String>();
        Map<String, CollectParam> map = collectModel.getCollectParam();
        EnumCommand[] each = EnumCommand.values();
        if (null == map) {
            this.logger.error((Object)"doTranslate failed cause of parmaters is null!");
            return cmds;
        }
        for (EnumCommand enumCommand : each) {
            String[] ipType;
            CollectParam collectParam;
            if (!map.containsKey(enumCommand.getIndex()) || null == (collectParam = map.get(enumCommand.getIndex()))) continue;
            for (String type : ipType = collectParam.getIpTypes(enumCommand.isConsider())) {
                collectParam.setIpTypeStr(type);
                String targetCmd = CommandTranslate.replaceWithObject(enumCommand.getCommand(), collectParam);
                targetCmd = targetCmd.replaceAll(PATTERN_REPLACE, "");
                targetCmd = targetCmd.replace("%{", "");
                targetCmd = targetCmd.replace("}%", "");
                if (type.equals(IPV6)) {
                    targetCmd = targetCmd.replace("global", "");
                    cmds.put(enumCommand.getIndex() + "_" + type, targetCmd);
                } else {
                    cmds.put(enumCommand.getIndex(), targetCmd);
                }
                this.logger.info((Object)("EnumCommand -- " + enumCommand.getIndex() + " : " + targetCmd));
            }
        }
        return cmds;
    }
}

