/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.service;

import com.hs.atic.collect.Model.CollectParam;
import com.hs.atic.collect.service.IEnumCommand;
import com.hs.atic.collect.service.IIssuedCommandResultAnalyze;
import com.hs.atic.collect.service.IssuedCommandStep;
import com.hs.atic.collect.util.ConstantUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.huawei.atic.secne.service.impl.ExcmdConnectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class IssuedCommandExec<T>
extends IssuedCommandStep<IIssuedCommandResultAnalyze> {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public IssuedCommandExec(IssuedCommandStep<IIssuedCommandResultAnalyze> step, IIssuedCommandResultAnalyze analyse, long progressId, IEnumCommand command, long deviceId, int commandLenth, String paramKey) {
        super(step, analyse, progressId, command, deviceId, commandLenth, paramKey);
    }

    private void execReturn(ExcmdConnectUtil excmdConnectUtil) {
        List<String> ret = null;
        try {
            ret = CmdUtil.execCmds4OneKeyCollect(excmdConnectUtil, Arrays.asList("return"), true, 0, false);
            this.logger.info(ret);
        }
        catch (RuntimeException e) {
            try {
                ret = CmdUtil.execCmds4OneKeyCollect(excmdConnectUtil, Arrays.asList("return"), true, 0, false);
            }
            catch (Exception ex) {
                this.logger.error((Object)"exec return error : ", (Throwable)ex);
            }
            this.logger.error((Object)("exec return error : " + (null == ret ? "--" : ret)));
        }
    }

    @Override
    protected void execStep(IssuedCommandStep<IIssuedCommandResultAnalyze> cur) throws Exception {
        if (null != cur.getLastResult() && cur.getLastResult().equals("skip")) {
            cur.setResults(Collections.singletonList(""));
            return;
        }
        List<String> ret = null;
        if (null == cur.getCollectModel() || null == cur.getCollectModel().getCollectParam() || null == cur.getCollectModel().getCollectParam().get(cur.getParamKey())) {
            ret = Collections.singletonList("error");
            cur.setResults(ret);
            return;
        }
        CollectParam collectParam = cur.getCollectModel().getCollectParam().get(cur.getParamKey());
        String cmd = ConstantUtil.translateCmd(collectParam, cur.getCommand());
        this.logger.info((Object)(cmd + " exec on device : " + this.getDeviceId()));
        if (cur.getCommand().isRetun()) {
            this.execReturn(this.excmdConnectUtil);
        }
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add(cmd);
            ret = CmdUtil.execCmds4OneKeyCollect(this.excmdConnectUtil, list, 0, cur.getCommand().isRetun(), false);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)(cmd + " exec error! device : " + this.getDeviceId()));
            ret = Collections.singletonList("lego.err." + e.getErrorCode());
        }
        catch (Exception e) {
            this.logger.error((Object)(cmd + " exec error! device : " + this.getDeviceId()));
            ret = Collections.singletonList("error");
        }
        cur.setResults(ret);
    }
}

