/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.service;

import com.hs.atic.collect.Model.LocaleKeyModel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IssuedCommandResults {
    private Map<Long, Map<Long, Boolean>> issuedResults = new ConcurrentHashMap<Long, Map<Long, Boolean>>();
    private Map<Long, Map<Long, LocaleKeyModel>> localKeyinfo = new ConcurrentHashMap<Long, Map<Long, LocaleKeyModel>>();
    private Map<Long, Map<Long, String>> cfcards = new ConcurrentHashMap<Long, Map<Long, String>>();
    private Map<Long, Map<Long, String>> cfcardResult = new ConcurrentHashMap<Long, Map<Long, String>>();

    private IssuedCommandResults() {
    }

    public Map<Long, Map<Long, Boolean>> getIssuedResults() {
        HashMap<Long, Map<Long, Boolean>> ret = new HashMap<Long, Map<Long, Boolean>>();
        for (Map.Entry<Long, Map<Long, Boolean>> entry : this.issuedResults.entrySet()) {
            HashMap<Long, Boolean> re = new HashMap<Long, Boolean>();
            for (Map.Entry<Long, Boolean> each : entry.getValue().entrySet()) {
                re.put(each.getKey(), each.getValue());
            }
            ret.put(entry.getKey(), re);
        }
        return ret;
    }

    public Map<Long, Map<Long, String>> getCfcardResult() {
        HashMap<Long, Map<Long, String>> ret = new HashMap<Long, Map<Long, String>>();
        for (Map.Entry<Long, Map<Long, String>> entry : this.cfcardResult.entrySet()) {
            HashMap<Long, String> re = new HashMap<Long, String>();
            for (Map.Entry<Long, String> each : entry.getValue().entrySet()) {
                re.put(each.getKey(), each.getValue());
            }
            ret.put(entry.getKey(), re);
        }
        return ret;
    }

    public Map<Long, Map<Long, String>> getCfcards() {
        HashMap<Long, Map<Long, String>> ret = new HashMap<Long, Map<Long, String>>();
        for (Map.Entry<Long, Map<Long, String>> entry : this.cfcards.entrySet()) {
            HashMap<Long, String> re = new HashMap<Long, String>();
            for (Map.Entry<Long, String> each : entry.getValue().entrySet()) {
                re.put(each.getKey(), each.getValue());
            }
            ret.put(entry.getKey(), re);
        }
        return ret;
    }

    public static IssuedCommandResults getInstance() {
        return IssuedCommandResultsHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putStatus(long progressId, long deviceId, boolean status) {
        Class<IssuedCommandResults> clazz = IssuedCommandResults.class;
        synchronized (IssuedCommandResults.class) {
            Map<Long, Boolean> temp;
            if (!this.issuedResults.containsKey(progressId)) {
                this.issuedResults.put(progressId, new HashMap());
            }
            if (null == (temp = this.issuedResults.get(progressId))) {
                temp = new HashMap<Long, Boolean>();
            }
            temp.put(deviceId, status);
            this.issuedResults.put(progressId, temp);
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLocalKey(long progressIdx, long deviceId, String localKey, String deviceName, String localeValue) {
        Class<IssuedCommandResults> clazz = IssuedCommandResults.class;
        synchronized (IssuedCommandResults.class) {
            LocaleKeyModel model;
            Map<Long, LocaleKeyModel> tempx;
            if (!this.localKeyinfo.containsKey(progressIdx)) {
                this.localKeyinfo.put(progressIdx, new HashMap());
            }
            if (null == (tempx = this.localKeyinfo.get(progressIdx))) {
                tempx = new HashMap<Long, LocaleKeyModel>();
            }
            if (null == (model = tempx.get(deviceId))) {
                model = new LocaleKeyModel();
                model.setKey(localKey);
                model.setValue(localeValue);
                model.setDeviceName(deviceName);
            }
            tempx.put(deviceId, model);
            this.localKeyinfo.put(progressIdx, tempx);
            // ** MonitorExit[var8_6] (shouldn't be in output)
            return;
        }
    }

    public Map<Long, Map<Long, LocaleKeyModel>> getLocalKey() {
        HashMap<Long, Map<Long, LocaleKeyModel>> ret = new HashMap<Long, Map<Long, LocaleKeyModel>>();
        for (Map.Entry<Long, Map<Long, LocaleKeyModel>> entry : this.localKeyinfo.entrySet()) {
            HashMap<Long, LocaleKeyModel> re = new HashMap<Long, LocaleKeyModel>();
            for (Map.Entry<Long, LocaleKeyModel> each : entry.getValue().entrySet()) {
                LocaleKeyModel model = each.getValue();
                LocaleKeyModel clone = model.clone();
                re.put(each.getKey(), clone);
            }
            ret.put(entry.getKey(), re);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCfcardResult(long progressId, long deviceId, String result) {
        Class<IssuedCommandResults> clazz = IssuedCommandResults.class;
        synchronized (IssuedCommandResults.class) {
            Map<Long, String> temp;
            if (!this.cfcardResult.containsKey(progressId)) {
                this.cfcardResult.put(progressId, new HashMap());
            }
            if (null == (temp = this.cfcardResult.get(progressId))) {
                temp = new HashMap<Long, String>();
            }
            temp.put(deviceId, result);
            this.cfcardResult.put(progressId, temp);
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCfcard(long progressId, long deviceId, String cfcard) {
        Class<IssuedCommandResults> clazz = IssuedCommandResults.class;
        synchronized (IssuedCommandResults.class) {
            Map<Long, String> temp;
            if (!this.cfcards.containsKey(progressId)) {
                this.cfcards.put(progressId, new HashMap());
            }
            if (null == (temp = this.cfcards.get(progressId))) {
                temp = new HashMap<Long, String>();
            }
            temp.put(deviceId, cfcard);
            this.cfcards.put(progressId, temp);
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return;
        }
    }

    private static class IssuedCommandResultsHolder {
        private static final IssuedCommandResults INSTANCE = new IssuedCommandResults();

        private IssuedCommandResultsHolder() {
        }
    }
}

