/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.service.attack.impl;

import com.hs.atic.collect.service.attack.CollectParam;
import com.hs.atic.collect.service.attack.CollectResult;
import com.hs.atic.collect.service.attack.IAttackDefenceCollect;
import com.hs.atic.collect.util.ConstantUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;

public class AttackDefenceDetailCollect
implements IAttackDefenceCollect {
    static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }};
    private static final String REPORT_ID = "attackLogAnalysis";
    private static final String EXPORT_TYPE = "pdf";
    private static final String DEVICE_TYPE_CLEANING = "\u6e05\u6d17";
    private static final String DEVICE_TYPE_DETECTING = "\u68c0\u6d4b";
    private static final String TOTAL_ZH = "\u5168\u90e8";
    private static final String TOTAL_EN = "Total";
    private static final String ABNORMAL_ZH = "\u5f02\u5e38";
    private static final String ABNORMAL_EN = "Abnormal";
    private static final String DEVICE_TYPE_CLEANING_EN = "Cleaning";
    private static final String DEVICE_TYPE_DETECTING_EN = "Detecting";
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CollectResult doHttpsPost(CollectResult collectResult, String objectJson, String uri) {
        block14: {
            CollectResult collectResult2;
            HttpsURLConnection conn;
            BufferedReader bufferedReader;
            InputStreamReader inputStreamReader;
            InputStream inputStream;
            OutputStreamWriter osw;
            PrintWriter pw;
            block13: {
                logger.info((Object)("doHttpsPost is start.objectJson is:" + objectJson + ",and uri is:" + uri));
                HttpsURLConnection.setDefaultHostnameVerifier(new NullHostNameVerifier());
                SSLContext sc = null;
                try {
                    sc = SSLContext.getInstance("TLS");
                    sc.init(null, trustAllCerts, new SecureRandom());
                }
                catch (KeyManagementException e1) {
                    collectResult.setDetail("certificate is error");
                    collectResult.setSuccess(false);
                    return collectResult;
                }
                catch (NoSuchAlgorithmException e2) {
                    collectResult.setDetail("certificate is error");
                    collectResult.setSuccess(false);
                    return collectResult;
                }
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                pw = null;
                osw = null;
                inputStream = null;
                inputStreamReader = null;
                bufferedReader = null;
                conn = null;
                try {
                    URL url = new URL(uri);
                    conn = (HttpsURLConnection)url.openConnection();
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.setUseCaches(false);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("content-type", "application/json;charset=utf-8");
                    osw = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
                    pw = new PrintWriter(osw);
                    pw.print(objectJson);
                    pw.flush();
                    inputStream = conn.getInputStream();
                    inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                    bufferedReader = new BufferedReader(inputStreamReader);
                    String str = null;
                    StringBuffer buffer = new StringBuffer();
                    while ((str = bufferedReader.readLine()) != null) {
                        buffer.append(str);
                    }
                    logger.info((Object)("REPORT_ID = attackLogAnalysis output: " + buffer.toString()));
                    IOUtils.closeQuietly((Writer)pw);
                    IOUtils.closeQuietly((Writer)osw);
                    IOUtils.closeQuietly((Reader)bufferedReader);
                    IOUtils.closeQuietly((Reader)inputStreamReader);
                    IOUtils.closeQuietly((InputStream)inputStream);
                    if (!buffer.toString().equals("success")) {
                        collectResult.setDetail(buffer.toString());
                        collectResult.setSuccess(false);
                        collectResult2 = collectResult;
                        IOUtils.closeQuietly((Writer)pw);
                        break block13;
                    }
                    collectResult.setDetail(buffer.toString());
                    collectResult.setSuccess(true);
                    IOUtils.closeQuietly((Writer)pw);
                }
                catch (IOException e) {
                    logger.error((Object)e);
                    collectResult.setDetail(e.getMessage());
                    collectResult.setSuccess(false);
                    CollectResult collectResult3 = collectResult;
                    return collectResult3;
                }
            }
            IOUtils.closeQuietly((Writer)osw);
            IOUtils.closeQuietly((Reader)bufferedReader);
            IOUtils.closeQuietly((Reader)inputStreamReader);
            IOUtils.closeQuietly((InputStream)inputStream);
            if (null == conn) return collectResult2;
            conn.disconnect();
            return collectResult2;
            IOUtils.closeQuietly((Writer)osw);
            IOUtils.closeQuietly((Reader)bufferedReader);
            IOUtils.closeQuietly((Reader)inputStreamReader);
            IOUtils.closeQuietly((InputStream)inputStream);
            if (null != conn) {
                conn.disconnect();
            }
            break block14;
            finally {
                IOUtils.closeQuietly(pw);
                IOUtils.closeQuietly(osw);
                IOUtils.closeQuietly(bufferedReader);
                IOUtils.closeQuietly(inputStreamReader);
                IOUtils.closeQuietly(inputStream);
                if (null != conn) {
                    conn.disconnect();
                }
            }
        }
        logger.info((Object)("hcc doHttpsPost is end:objectJson is:" + objectJson + ",and uri is:" + uri + " and result is:" + collectResult.getDetail()));
        return collectResult;
    }

    @Override
    public CollectResult collectData(CollectParam collectParam) {
        boolean isCreate;
        int type = 0;
        String typeNameZh = TOTAL_ZH;
        String typeNameEn = TOTAL_EN;
        int which = 0;
        if (collectParam.getDeviceName().contains(DEVICE_TYPE_CLEANING) || collectParam.getDeviceName().contains(DEVICE_TYPE_CLEANING_EN)) {
            type = 0;
            typeNameZh = TOTAL_ZH;
            typeNameEn = TOTAL_EN;
            which = 0;
        }
        if (collectParam.getDeviceName().contains(DEVICE_TYPE_DETECTING) || collectParam.getDeviceName().contains(DEVICE_TYPE_DETECTING_EN)) {
            type = 1;
            typeNameZh = ABNORMAL_ZH;
            typeNameEn = ABNORMAL_EN;
            which = 1;
        }
        StringBuffer pathsb = new StringBuffer();
        pathsb.append(collectParam.getWebPath()).append(ConstantUtil.EXPORT_ATTACKDEFENCE_DIR).append(collectParam.getProgressId()).append(File.separator).append(REPORT_ID).append(File.separator);
        File dir = new File(pathsb.toString());
        if (!dir.exists() && !(isCreate = dir.mkdirs())) {
            logger.error((Object)("REPORT_ID : attackLogAnalysis create dir fail = " + dir.getPath()));
        }
        int unit = 1;
        String unitName = "pps";
        CollectResult collectResult = new CollectResult();
        collectResult.setTarget(ConstantUtil.getMessage("atic.analysis.report.tab.attackAnalysis", "AticResources", collectParam.getLocale()));
        this.sendPost(collectParam, unit, unitName, collectResult, type, typeNameZh, typeNameEn, which);
        if (!collectResult.isSuccess() && null != collectResult.getDetail() && ConstantUtil.isNumeric(collectResult.getDetail().trim())) {
            this.recordErrorLog(collectParam, pathsb, collectResult);
            return collectResult;
        }
        unit = 0;
        unitName = "kbps";
        this.sendPost(collectParam, unit, unitName, collectResult, type, typeNameZh, typeNameEn, which);
        if (!collectResult.isSuccess() && null != collectResult.getDetail() && ConstantUtil.isNumeric(collectResult.getDetail().trim())) {
            this.recordErrorLog(collectParam, pathsb, collectResult);
            return collectResult;
        }
        return collectResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordErrorLog(CollectParam collectParam, StringBuffer pathsb, CollectResult collectResult) {
        String log = "error.log";
        pathsb.append(log);
        File logFile = new File(pathsb.toString());
        if (!logFile.exists()) {
            BufferedWriter bw = null;
            OutputStreamWriter osw = null;
            FileOutputStream fos = null;
            try {
                boolean isCreate = logFile.createNewFile();
                if (!isCreate) {
                    logger.error((Object)("file create error : " + pathsb.toString()));
                } else {
                    String txt = ConstantUtil.getMessage("lego.err." + collectResult.getDetail().trim(), "AticResources", collectParam.getLocale());
                    fos = new FileOutputStream(logFile);
                    osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                    bw = new BufferedWriter(osw);
                    bw.write(txt);
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                if (null != bw) {
                    try {
                        bw.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
                if (null != osw) {
                    try {
                        osw.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
                if (null != fos) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPost(CollectParam collectParam, int unit, String unitText, CollectResult collectResult, int type, String typeNameZh, String typeNameEn, int which) {
        PrintWriter out = null;
        BufferedReader br = null;
        InputStreamReader isr = null;
        try {
            if (collectParam.getSchemeServer().contains("https")) {
                this.doHttpsPost(collectResult, this.createBody(collectParam, unit, unitText, type, typeNameZh, typeNameEn, which), collectParam.getSchemeServer() + "/rest/openapi/ireport/export");
            } else {
                URL realUrl = new URL(collectParam.getSchemeServer() + "/rest/openapi/ireport/export");
                HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
                conn.setRequestProperty("Accept", "application/json");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                out = new PrintWriter(new OutputStreamWriter(conn.getOutputStream(), "UTF-8"));
                out.print(this.createBody(collectParam, unit, unitText, type, typeNameZh, typeNameEn, which));
                out.flush();
                isr = new InputStreamReader(conn.getInputStream(), "utf-8");
                br = new BufferedReader(isr);
                String output = "";
                StringBuffer sb = new StringBuffer();
                while ((output = br.readLine()) != null) {
                    sb.append(output);
                }
                logger.info((Object)("REPORT_ID = attackLogAnalysis output: " + sb.toString()));
                if (!sb.toString().equals("success")) {
                    collectResult.setDetail(sb.toString());
                    collectResult.setSuccess(false);
                    this.close(br, isr, out);
                    return;
                }
                collectResult.setDetail(sb.toString());
                collectResult.setSuccess(true);
            }
        }
        catch (LegoCheckedException e) {
            e.printStackTrace();
            logger.error((Object)e);
            collectResult.setSuccess(false);
        }
        catch (ProtocolException e) {
            e.printStackTrace();
            logger.error((Object)e);
            collectResult.setSuccess(false);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            logger.error((Object)e);
            collectResult.setSuccess(false);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)e);
            collectResult.setSuccess(false);
        }
        finally {
            this.close(br, isr, out);
        }
    }

    private void close(BufferedReader br, InputStreamReader isr, PrintWriter out) {
        if (out != null) {
            out.close();
        }
        try {
            if (br != null) {
                br.close();
            }
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
        try {
            if (isr != null) {
                isr.close();
            }
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
    }

    private String createBody(CollectParam collectParam, int unit, String unitText, int type, String typeNameZh, String typeNameEn, int which) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("\"localeStr\":\"" + collectParam.getLocale().toString() + "\"");
        sb.append(",");
        sb.append("\"httpSessionId\":\"" + UUID.randomUUID().toString().replace("-", "") + "\"");
        sb.append(",");
        sb.append("\"formType\":\"pdf\"");
        sb.append(",");
        sb.append("\"userId\":\"" + collectParam.getCurUserId() + "\"");
        sb.append(",");
        sb.append("\"userName\":\"" + collectParam.getCurUserName() + "\"");
        sb.append(",");
        boolean isWinSeparator = false;
        if (File.separator.equals("\\")) {
            isWinSeparator = true;
        }
        sb.append("\"path\":\"").append(collectParam.getWebPath().substring(0, collectParam.getWebPath().length() - 1).replace(File.separator, isWinSeparator ? "\\\\" : "/")).append(ConstantUtil.EXPORT_ATTACKDEFENCE_DIR.replace(File.separator, isWinSeparator ? "\\\\" : "/")).append(collectParam.getProgressId()).append(File.separator.replace(File.separator, isWinSeparator ? "\\\\" : "/")).append(REPORT_ID).append(File.separator.replace(File.separator, isWinSeparator ? "\\\\" : "/")).append("\"");
        sb.append(",");
        sb.append("\"unitText\":\"" + unitText + "\"");
        sb.append(",");
        sb.append("\"reportId\":\"attackLogAnalysis\"");
        sb.append(",");
        sb.append("\"reportFileName\":\"attackLogAnalysis\"");
        sb.append(",");
        String switchOption = "detect_less1day_pps";
        if (0 == which) {
            switchOption = 0 == unit ? "clean_less1day_pps" : "clean_less2day_pps";
        } else if (1 == which) {
            switchOption = 0 == unit ? "detect_less1day_pps" : "detect_less2day_pps";
        }
        String condition = "[{\"showInfo\":true,\"id\":\"direction_combobox\",\"label\":\"\u65b9\u5411:\",\"value\":{\"value\":\"1\",\"text\":\"Inbound\"},\"type\":\"combobox\",\"subGroupId\":\"subGroup_0_attackLogAnalysis\",\"subGroupLabel\":\"\u65b9\u5411:\",\"groupOrder\":0},{\"showInfo\":true,\"id\":\"netDevice_combobox\",\"label\":\"\u8bbe\u5907:\",\"value\":{\"value\":\"" + collectParam.getDeviceId() + "_" + which + "\",\"text\":\"" + collectParam.getDeviceName() + "\"},\"type\":\"combobox\",\"subGroupId\":\"subGroup_1_attackLogAnalysis\",\"subGroupLabel\":\"\u8bbe\u5907:\",\"groupOrder\":1},{\"showInfo\":true,\"id\":\"zone_combobox\",\"label\":\"\u9632\u62a4\u5bf9\u8c61:\",\"value\":[{\"value\":\"" + collectParam.getZoneId() + "\",\"text\":\"" + collectParam.getZoneName() + "\"}],\"type\":\"ComboButton\",\"subGroupId\":\"subGroup_2_attackLogAnalysis\",\"subGroupLabel\":\"\u9632\u62a4\u5bf9\u8c61:\",\"groupOrder\":2},{\"showInfo\":true,\"id\":\"bis_combobox\",\"value\":{\"value\":\"0\",\"text\":\"0\"},\"type\":\"hidden\",\"subGroupId\":\"subGroup_3_attackLogAnalysis\",\"subGroupLabel\":\"\",\"groupOrder\":3},{\"showInfo\":true,\"id\":\"zone_ip\",\"label\":\"IP\u5730\u5740:\",\"value\":{\"value\":\"" + collectParam.getIpAddr() + "\",\"text\":\"" + collectParam.getIpAddr() + "\"},\"type\":\"ipv6AddressLego\",\"subGroupId\":\"subGroup_4_attackLogAnalysis\",\"subGroupLabel\":\"IP\u5730\u5740:\",\"groupOrder\":4},{\"showInfo\":true,\"id\":\"dateRange\",\"label\":\"\u65f6\u95f4:\",\"value\":[{\"value\":\"" + collectParam.getStartTimeMil() + "\",\"text\":\"" + collectParam.getStartTimeStr() + "\"},{\"value\":\"" + collectParam.getEndTimeMil() + "\",\"text\":\"" + collectParam.getEndTimeStr() + "\"}],\"type\":\"dateRange\",\"subGroupId\":\"subGroup_5_attackLogAnalysis\",\"subGroupLabel\":\"\u65f6\u95f4:\",\"groupOrder\":5},{\"showInfo\":true,\"id\":\"logType\",\"label\":\"\u7c7b\u578b:\",\"value\":{\"value\":\"" + type + "\",\"text\":\"" + typeNameZh + "\"},\"type\":\"combobox\",\"subGroupId\":\"subGroup_6_attackLogAnalysis\",\"subGroupLabel\":\"\u7c7b\u578b:\",\"groupOrder\":6},{\"showInfo\":true,\"id\":\"dropPacket\",\"label\":\"\u6700\u5c0f\u653b\u51fb\u62a5\u6587\u6570:\",\"value\":{\"value\":\"0\",\"text\":\"0\"},\"type\":\"textField\",\"subGroupId\":\"subGroup_7_attackLogAnalysis\",\"subGroupLabel\":\"\u6700\u5c0f\u653b\u51fb\u62a5\u6587\u6570:\",\"groupOrder\":7},{\"showInfo\":true,\"id\":\"minInFlow\",\"label\":\"\u6700\u5c0f\u5165\u6d41\u91cf:\",\"value\":{\"value\":\"0\",\"text\":\"0\"},\"type\":\"textField\",\"subGroupId\":\"subGroup_8_attackLogAnalysis\",\"subGroupLabel\":\"\u6700\u5c0f\u5165\u6d41\u91cf:\",\"groupOrder\":8},{\"showInfo\":true,\"id\":\"minAttackFlowPeak\",\"label\":\"\u6700\u5c0f\u653b\u51fb\u6d41\u91cf\u5cf0\u503c:\\t\",\"value\":{\"value\":\"0\",\"text\":\"0\"},\"type\":\"textField\",\"subGroupId\":\"subGroup_9_attackLogAnalysis\",\"subGroupLabel\":\"\u6700\u5c0f\u653b\u51fb\u6d41\u91cf\u5cf0\u503c:\\t\",\"groupOrder\":9},{\"showInfo\":true,\"id\":\"unit\",\"label\":\"\u5355\u4f4d:\",\"value\":[{\"value\":\"" + unit + "\",\"text\":\"" + unitText + "\"}],\"type\":\"radioGroup\",\"subGroupId\":\"subGroup_10_attackLogAnalysis\",\"subGroupLabel\":\"\u5355\u4f4d:\",\"groupOrder\":10},{\"showInfo\":true,\"id\":\"protocol_combobox\",\"value\":{\"value\":\"0\",\"text\":\"0\"},\"type\":\"hidden\",\"subGroupId\":\"subGroup_10_attackLogAnalysis\",\"subGroupLabel\":\"\u5355\u4f4d:\",\"groupOrder\":10},{\"showInfo\":true,\"id\":\"type_combobox\",\"value\":{\"value\":\"2\",\"text\":\"2\"},\"type\":\"hidden\",\"subGroupId\":\"subGroup_10_attackLogAnalysis\",\"subGroupLabel\":\"\u5355\u4f4d:\",\"groupOrder\":10},{\"showInfo\":true,\"id\":\"switchOption\",\"value\":{\"value\":\"" + switchOption + "\",\"text\":\"" + switchOption + "\"},\"type\":\"hidden\",\"subGroupId\":\"subGroup_10_attackLogAnalysis\",\"subGroupLabel\":\"\u5355\u4f4d:\",\"groupOrder\":10}]";
        condition = condition.replace("\"", "\\\"");
        String conditiox = "[{\"showInfo\":true,\"id\":\"direction_combobox\",\"label\":\"Direction:\",\"value\":{\"value\":\"1\",\"text\":\"Inbound\"},\"type\":\"combobox\",\"subGroupId\":\"subGroup_0_attackLogAnalysis\",\"subGroupLabel\":\"Direction:\",\"groupOrder\":0},{\"showInfo\":true,\"id\":\"netDevice_combobox\",\"label\":\"Device:\",\"value\":{\"value\":\"" + collectParam.getDeviceId() + "_" + which + "\",\"text\":\"" + collectParam.getDeviceName() + "\"},\"type\":\"combobox\",\"subGroupId\":\"subGroup_1_attackLogAnalysis\",\"subGroupLabel\":\"Device:\",\"groupOrder\":1},{\"showInfo\":true,\"id\":\"zone_combobox\",\"label\":\"Zone:\",\"value\":[{\"value\":\"" + collectParam.getZoneId() + "\",\"text\":\"" + collectParam.getZoneName() + "\"}],\"type\":\"ComboButton\",\"subGroupId\":\"subGroup_2_attackLogAnalysis\",\"subGroupLabel\":\"Zone:\",\"groupOrder\":2},{\"showInfo\":true,\"id\":\"bis_combobox\",\"value\":{\"value\":\"0\",\"text\":\"0\"},\"type\":\"hidden\",\"subGroupId\":\"subGroup_3_attackLogAnalysis\",\"subGroupLabel\":\"\",\"groupOrder\":3},{\"showInfo\":true,\"id\":\"zone_ip\",\"label\":\"IP Address:\",\"value\":{\"value\":\"" + collectParam.getIpAddr() + "\",\"text\":\"" + collectParam.getIpAddr() + "\"},\"type\":\"ipv6AddressLego\",\"subGroupId\":\"subGroup_4_attackLogAnalysis\",\"subGroupLabel\":\"IP Address:\",\"groupOrder\":4},{\"showInfo\":true,\"id\":\"dateRange\",\"label\":\"Time:\",\"value\":[{\"value\":\"" + collectParam.getStartTimeMil() + "\",\"text\":\"" + collectParam.getStartTimeStr() + "\"},{\"value\":\"" + collectParam.getEndTimeMil() + "\",\"text\":\"" + collectParam.getEndTimeStr() + "\"}],\"type\":\"dateRange\",\"subGroupId\":\"subGroup_5_attackLogAnalysis\",\"subGroupLabel\":\"Time:\",\"groupOrder\":5},{\"showInfo\":true,\"id\":\"logType\",\"label\":\"Type:\",\"value\":{\"value\":\"" + type + "\",\"text\":\"" + typeNameEn + "\"},\"type\":\"combobox\",\"subGroupId\":\"subGroup_6_attackLogAnalysis\",\"subGroupLabel\":\"Type:\",\"groupOrder\":6},{\"showInfo\":true,\"id\":\"dropPacket\",\"label\":\"Minimum Number of Attack Packets:\",\"value\":{\"value\":\"0\",\"text\":\"0\"},\"type\":\"textField\",\"subGroupId\":\"subGroup_7_attackLogAnalysis\",\"subGroupLabel\":\"Minimum Number of Attack Packets:\",\"groupOrder\":7},{\"showInfo\":true,\"id\":\"minInFlow\",\"label\":\"Min. Incoming Traffic:\",\"value\":{\"value\":\"0\",\"text\":\"0\"},\"type\":\"textField\",\"subGroupId\":\"subGroup_8_attackLogAnalysis\",\"subGroupLabel\":\"Min. Incoming Traffic:\",\"groupOrder\":8},{\"showInfo\":true,\"id\":\"minAttackFlowPeak\",\"label\":\"Min. Peak Attack Traffi:\",\"value\":{\"value\":\"0\",\"text\":\"0\"},\"type\":\"textField\",\"subGroupId\":\"subGroup_9_attackLogAnalysis\",\"subGroupLabel\":\"Min. Peak Attack Traffi:\",\"groupOrder\":9},{\"showInfo\":true,\"id\":\"unit\",\"label\":\"Unit:\",\"value\":[{\"value\":\"" + unit + "\",\"text\":\"" + unitText + "\"}],\"type\":\"radioGroup\",\"subGroupId\":\"subGroup_10_attackLogAnalysis\",\"subGroupLabel\":\"Unit:\",\"groupOrder\":10},{\"showInfo\":true,\"id\":\"protocol_combobox\",\"value\":{\"value\":\"0\",\"text\":\"0\"},\"type\":\"hidden\",\"subGroupId\":\"subGroup_10_attackLogAnalysis\",\"subGroupLabel\":\"Unit:\",\"groupOrder\":10},{\"showInfo\":true,\"id\":\"type_combobox\",\"value\":{\"value\":\"2\",\"text\":\"2\"},\"type\":\"hidden\",\"subGroupId\":\"subGroup_10_attackLogAnalysis\",\"subGroupLabel\":\"Unit:\",\"groupOrder\":10},{\"showInfo\":true,\"id\":\"switchOption\",\"value\":{\"value\":\"" + switchOption + "\",\"text\":\"" + switchOption + "\"},\"type\":\"hidden\",\"subGroupId\":\"subGroup_10_attackLogAnalysis\",\"subGroupLabel\":\"Unit:\",\"groupOrder\":10}]";
        conditiox = conditiox.replace("\"", "\\\"");
        if (collectParam.getLocale().toString().contains("zh")) {
            sb.append("\"condition\":\"" + condition + "\"");
        } else {
            sb.append("\"condition\":\"" + conditiox + "\"");
        }
        sb.append("}");
        logger.info((Object)("create body for attackLogAnalysis : " + sb.toString()));
        return sb.toString();
    }

    static class NullHostNameVerifier
    implements HostnameVerifier {
        NullHostNameVerifier() {
        }

        @Override
        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    }
}

