/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.service.impl;

import com.hs.atic.collect.service.IssuedFileCommandExec;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;

public class CheckLogfile
extends IssuedFileCommandExec {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    @Override
    protected void execStep() {
        boolean isHaveSec = this.isHaveLogFile("/seclog", "log.sec");
        boolean isHaveLog = this.isHaveLogFile("/log", "log.log");
        boolean isHighDevice = this.isHighDevice(true);
        boolean isInterrupt = false;
        if (!(!isHighDevice || isHaveSec && isHaveLog)) {
            logger.error((Object)(super.getFtpPara().getServiceIp() + " : FTP file " + "log.sec" + " is not found!"));
            logger.error((Object)(super.getFtpPara().getServiceIp() + " : FTP file " + "log.log" + " is not found!"));
            super.setErrorCode(604L);
            isInterrupt = true;
        } else if (!isHighDevice && !isHaveLog) {
            logger.error((Object)"This is low Device : log.log is not found!");
            logger.error((Object)(super.getFtpPara().getServiceIp() + " : FTP file " + "log.log" + " is not found!"));
            super.setErrorCode(604L);
            isInterrupt = true;
        }
        super.setInterrupt(isInterrupt);
    }

    private boolean isHaveLogFile(String logpath, String logname) {
        FTPClient ftp = super.getFtpClient();
        try {
            ftp.changeWorkingDirectory(new String(logpath.getBytes("utf-8"), "iso-8859-1"));
            ftp.enterLocalPassiveMode();
            ftp.configure(new FTPClientConfig("UNIX"));
            FTPFile[] fs = ftp.listFiles();
            try {
                String[] names = ftp.listNames();
                logger.info((Object)("PATH [" + logpath + "] : " + Arrays.asList(null == names ? new String[]{} : names)));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (null == fs) {
                return false;
            }
            for (FTPFile ftpFile : fs) {
                if (!ftpFile.getName().equalsIgnoreCase(logname)) continue;
                return true;
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("isHaveLogFile : [" + logpath + "] [" + logname + "]"), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("isHaveLogFile : [" + logpath + "] [" + logname + "]"), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("isHaveLogFile : [" + logpath + "] [" + logname + "]"), (Throwable)e);
        }
        return false;
    }
}

