/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.service.impl;

import com.hs.atic.collect.service.IssuedFileCommandExec;
import com.hs.atic.collect.util.ConstantUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;

public class DownloadLogFile
extends IssuedFileCommandExec {
    private static final int BUFFER = 0x100000;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    @Override
    protected void execStep() {
        boolean a;
        String dstPath = super.getWebPath() + ConstantUtil.EXPORT_FTP_DIR + super.getProgressBar().getProgressBarID() + File.separator + super.getAticDevice().getName();
        File dstDir = new File(dstPath);
        if (!dstDir.exists() && !(a = dstDir.mkdirs())) {
            logger.error((Object)(dstDir + " create dir fail!"));
        }
        try {
            boolean resultLog = this.downloadLibFileToFtp("/log", "log.log", dstPath, super.getFtpClient());
            boolean isHighDevice = this.isHighDevice(true);
            if (isHighDevice) {
                boolean resultSec = this.downloadLibFileToFtp("/seclog", "log.sec", dstPath, super.getFtpClient());
                logger.info((Object)("DownloadLogFile - execStep : Download file log.sec " + resultSec));
            }
            if (!isHighDevice) {
                logger.info((Object)("DownloadLogFile - just exec download log.log cause of this is a low device log.log " + resultLog));
            }
            logger.info((Object)("DownloadLogFile - execStep : Download file log.log " + resultLog));
        }
        catch (LegoCheckedException e) {
            super.setErrorCode(e.getErrorCode());
            super.setInterrupt(false);
        }
        if (null != super.getFtpClient() && super.getFtpClient().isConnected()) {
            try {
                super.getFtpClient().disconnect();
            }
            catch (IOException f) {
                logger.error((Object)"DownloadLogFile - execStep : disconnect ftp exception", (Throwable)f);
            }
        }
    }

    private boolean downloadLibFileToFtp(String filePath, String fileName, String dstPath, FTPClient ftp) {
        OutputStream outputStream = null;
        FilterOutputStream bos = null;
        try {
            ftp.setFileType(2);
            File localFilex = new File(dstPath + File.separator + fileName);
            outputStream = new FileOutputStream(localFilex);
            bos = new BufferedOutputStream(outputStream);
            ftp.setBufferSize(0x100000);
            ftp.retrieveFile(filePath + "/" + fileName, (OutputStream)bos);
            boolean bl = true;
            return bl;
        }
        catch (FTPConnectionClosedException e) {
            logger.error((Object)"DownloadLogFile - downloadLibFileToFtp : Server closed connection.", (Throwable)e);
            throw new LegoCheckedException(String.valueOf(603L));
        }
        catch (FileNotFoundException e) {
            if (fileName.equals("log.log")) {
                throw new LegoCheckedException(String.valueOf(605L));
            }
            if (fileName.equals("log.sec")) {
                throw new LegoCheckedException(String.valueOf(604L));
            }
        }
        catch (IOException e) {
            logger.error((Object)"DownloadLogFile - downloadLibFileToFtp : Could not connect to server.", (Throwable)e);
            throw new LegoCheckedException(String.valueOf(601L));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"DownloadLogFile - downloadLibFileToFtp : unknow error,", (Throwable)e);
            throw e;
        }
        finally {
            if (null != bos) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    logger.error((Object)("instream.close() error," + e));
                }
            }
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)("instream.close() error," + e));
                }
            }
        }
        return false;
    }
}

