/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.service.impl;

import com.hs.atic.collect.service.IssuedFileCommandExec;
import com.hs.atic.collect.service.ZipCommandResult;
import com.hs.atic.collect.util.ConstantUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipOutputStream;

public class LogFileCompression
extends IssuedFileCommandExec {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execStep() {
        boolean a;
        String srcPath = super.getWebPath() + ConstantUtil.EXPORT_FTP_DIR + super.getProgressBar().getProgressBarID() + File.separator + super.getAticDevice().getName();
        String zipPath = super.getWebPath() + ConstantUtil.PACKAGE_DIR + super.getProgressBar().getProgressBarID();
        File zipDir = new File(zipPath);
        if (!zipDir.exists() && !(a = zipDir.mkdirs())) {
            logger.error((Object)(zipDir + " create dir fail!"));
        }
        File zipFile = new File(zipPath + File.separator + super.getProgressBar().getProgressBarID() + ".zip");
        File inFile = new File(srcPath);
        ZipOutputStream zos = null;
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            Date date = new Date(super.getProgressBar().getProgressBarID());
            String dirName = new SimpleDateFormat("yyyyMMddHHmmssSS").format(date);
            fos = new FileOutputStream(zipFile);
            bos = new BufferedOutputStream(fos);
            zos = new ZipOutputStream(bos);
            ZipCommandResult.zipFile(inFile, zos, "", dirName);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"LogFileCompression - execStep error!", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"LogFileCompression - execStep error!", (Throwable)e);
        }
        finally {
            try {
                if (null != zos) {
                    zos.close();
                }
                if (null != bos) {
                    bos.close();
                }
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }
}

