/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.service.impl;

import com.hs.atic.collect.service.IssuedFileCommandExec;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.south.model.FtpPara;
import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPReply;

public class TestFtpReachable
extends IssuedFileCommandExec {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final int TIME_OUT = 20000;

    private boolean isFtpReachable(FtpPara ftpPara) {
        FTPClient ftp = new FTPClient();
        ftp.setConnectTimeout(20000);
        ftp.setDefaultPort(ftpPara.getPort().intValue());
        try {
            ftp.connect(ftpPara.getServiceIp());
            int replyCode = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                TestFtpReachable.disConnectFtp(ftp);
                logger.error((Object)"isFtpReachable : FTP server refused connection.");
                throw new LegoCheckedException(600L);
            }
        }
        catch (IOException e) {
            TestFtpReachable.disConnectFtp(ftp);
            logger.error((Object)"isFtpReachable : Could not connect to server.");
            throw new LegoCheckedException(601L);
        }
        try {
            if (!ftp.login(ftpPara.getUserName(), ftpPara.getFtpPassWord())) {
                logger.error((Object)"isFtpReachable : user name or password error.");
                try {
                    ftp.logout();
                }
                catch (IOException e) {
                    logger.error((Object)"logout error! run continue!");
                }
                TestFtpReachable.disConnectFtp(ftp);
                throw new LegoCheckedException(602L);
            }
            logger.info((Object)("isFtpReachable : remote system is " + ftp.getSystemType()));
            super.setFtpClient(ftp);
            return true;
        }
        catch (FTPConnectionClosedException e) {
            TestFtpReachable.disConnectFtp(ftp);
            logger.error((Object)"isFtpReachable : Server closed connection.", (Throwable)e);
            throw new LegoCheckedException(603L);
        }
        catch (IOException e) {
            TestFtpReachable.disConnectFtp(ftp);
            logger.error((Object)"isFtpReachable : FTP transfer error.", (Throwable)e);
            throw new LegoCheckedException(603L);
        }
    }

    private static void disConnectFtp(FTPClient ftp) {
        if (ftp.isConnected()) {
            try {
                ftp.disconnect();
            }
            catch (IOException f) {
                logger.error((Object)"isFtpReachable : disconnect ftp exception");
            }
        }
    }

    @Override
    protected void execStep() {
        try {
            boolean isReach = this.isFtpReachable(super.getFtpPara());
            logger.info((Object)("TestFtpReachable - execStep : FTP Server is connected " + isReach + " :" + super.getFtpPara().getServiceIp()));
        }
        catch (LegoCheckedException e) {
            super.setErrorCode(e.getErrorCode());
            super.setInterrupt(true);
        }
    }
}

