/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.util;

import com.hs.atic.collect.Model.CollectModel;
import com.hs.atic.collect.Model.CollectParam;
import com.hs.atic.collect.Model.LocaleKeyModel;
import com.hs.atic.collect.service.EnumCommandOrder;
import com.hs.atic.collect.service.EnumFileCommandOrder;
import com.hs.atic.collect.service.IEnumCommand;
import com.hs.atic.collect.service.IIssuedCommandResultAnalyze;
import com.hs.atic.collect.service.IssuedCommandExec;
import com.hs.atic.collect.service.IssuedCommandResults;
import com.hs.atic.collect.service.IssuedCommandStep;
import com.hs.atic.collect.service.IssuedFileCommandExec;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.common.util.ProgressMgr;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.south.model.FtpPara;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConstantUtil {
    public static final int NUM = 3998;
    public static final int CORE_POOL_SIZE = 1;
    public static final int NUMBER_TOW = 2;
    public static final int ALL_DEVICE_CORE_POOL_SIZE = 5;
    public static final int MAXIMUM_POOL_SIZE = 20;
    public static final int KEEP_ALIVE_TIME = 30;
    public static final String EXPORT_DIR = File.separator + "temp" + File.separator + "one_key" + File.separator;
    public static final String EXPORT_FTP_DIR = File.separator + "temp" + File.separator + "one_key" + File.separator + "ftp" + File.separator;
    public static final String PACKAGE_DIR = File.separator + "temp" + File.separator + "one_key" + File.separator + "zip" + File.separator;
    public static final String EXPORT_ATTACKDEFENCE_DIR = File.separator + "temp" + File.separator + "one_key" + File.separator + "attack" + File.separator;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final int MASK_IPV4_ACL = 0;
    private static final int MASK_IPV6_ACL = 1;

    public static void factoryInstance(long progressId, Set<AticDevice> devices, CollectModel collectModel, Locale locale, int type, int commandLenth, String paramKey, String webPath) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 20, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch end = new CountDownLatch(devices.size());
        ArrayList<Future<String>> results = new ArrayList<Future<String>>();
        for (AticDevice aticDevice : devices) {
            Future<String> future = ConstantUtil.eachSetpExecutor(progressId, executor, start, end, aticDevice, collectModel, locale, devices.size(), type, commandLenth, paramKey);
            results.add(future);
        }
        ConstantUtil.start(start, end, results, executor, progressId, type, collectModel);
    }

    private static void start(final CountDownLatch start, final CountDownLatch end, final List<Future<String>> results, final ThreadPoolExecutor executor, final long progressId, final int type, final CollectModel collectModel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    start.countDown();
                    end.await();
                    executor.shutdown();
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)"end factoryInstance main thread error");
                }
                for (Future future : results) {
                    if (null == future) continue;
                    try {
                        String ret = (String)future.get();
                        LOGGER.info((Object)("eachSetpExecutor : device " + ret));
                    }
                    catch (InterruptedException e) {
                        LOGGER.error((Object)"eachSetpExecutor : error! ", (Throwable)e);
                    }
                    catch (ExecutionException e) {
                        LOGGER.error((Object)"eachSetpExecutor : error! ", (Throwable)e);
                    }
                }
                ProgressMgr.getInstance().getProgressBar(progressId).next();
                if (type == 0) {
                    ConstantUtil.generateIssuedLog(progressId, collectModel);
                }
            }
        }).start();
    }

    private static void generateIssuedLog(long progressId, CollectModel collectModel) {
        Map<Long, Boolean> devicesStatus = IssuedCommandResults.getInstance().getIssuedResults().get(progressId);
        Map<Long, LocaleKeyModel> localeKeyModels = IssuedCommandResults.getInstance().getLocalKey().get(progressId);
        String localeInfo = "atic.bis.onekeyCollection.operation.deliver.failed";
        String[] detail = new String[]{"", ""};
        for (Map.Entry<Long, LocaleKeyModel> entry : localeKeyModels.entrySet()) {
            String deviceName = entry.getValue().getDeviceName();
            String key = entry.getValue().getKey();
            String cmd = entry.getValue().getValue();
            if (key.contains("lego.err")) {
                localeInfo = key;
            }
            if (key.equals("error")) {
                localeInfo = localeInfo + ".error";
            }
            if (key.equals("wrong")) {
                localeInfo = localeInfo + ".wrong";
            }
            if (key.equals("unsupport")) {
                localeInfo = localeInfo + ".unsupport";
            }
            detail[0] = deviceName;
            detail[1] = cmd;
        }
        boolean result = false;
        for (Map.Entry<Long, Boolean> entry : devicesStatus.entrySet()) {
            if (!entry.getValue().booleanValue()) break;
            result = true;
        }
        ConstantUtil.writSyslog(result, collectModel.getTarget(), "atic.bis.onekeyCollection.operation.deliver", "atic.bis.onekeyCollection.operation.deliver.success", localeInfo, collectModel.getModule(), collectModel.getUser(), collectModel.getRemoteAddr(), detail);
    }

    private static Future<String> eachSetpExecutor(final long progressId, ThreadPoolExecutor executor, final CountDownLatch start, final CountDownLatch end, final AticDevice aticDevice, final CollectModel collectModel, final Locale locale, final int deviceCount, final int type, final int commandLenth, final String paramKey) {
        Future<String> future = executor.submit(new Callable<String>(){

            @Override
            public String call() {
                try {
                    start.await();
                }
                catch (InterruptedException e1) {
                    LOGGER.error((Object)e1);
                }
                try {
                    if (type == 0) {
                        IssuedCommandStep step = ConstantUtil.setp(progressId, aticDevice, collectModel, locale, deviceCount, commandLenth, paramKey);
                        step.execute();
                    } else if (type == 1) {
                        IssuedFileCommandExec step = ConstantUtil.step(progressId, aticDevice, collectModel, locale, deviceCount);
                        step.exec();
                    }
                }
                catch (IllegalAccessException e) {
                    String string = "error";
                    return string;
                }
                catch (InstantiationException e) {
                    String string = "error";
                    return string;
                }
                finally {
                    end.countDown();
                }
                return "success";
            }
        });
        return future;
    }

    private static IssuedCommandStep<IIssuedCommandResultAnalyze> setp(long progressId, AticDevice aticDevice, CollectModel collectModel, Locale locale, int deviceCount, int commandLenth, String paramKey) throws InstantiationException, IllegalAccessException {
        IssuedCommandExec next = null;
        for (int i = 0; i <= EnumCommandOrder.values().length - 1; ++i) {
            IssuedCommandExec step;
            next = step = new IssuedCommandExec(next, EnumCommandOrder.values()[i].getClazz().newInstance(), progressId, (IEnumCommand)EnumCommandOrder.values()[i], aticDevice.getMoId(), commandLenth, paramKey);
            if (i != EnumCommandOrder.values().length - 1) continue;
            step.setCollectModel(collectModel);
            step.setLocale(locale);
            return step;
        }
        return null;
    }

    private static IssuedFileCommandExec step(long progressId, AticDevice aticDevice, CollectModel collectModel, Locale locale, int deviceCount) throws InstantiationException, IllegalAccessException {
        IssuedFileCommandExec next = null;
        for (int i = 0; i <= EnumFileCommandOrder.values().length - 1; ++i) {
            IssuedFileCommandExec commandExec = EnumFileCommandOrder.values()[i].getClazz().newInstance();
            FtpPara ftpPara = new FtpPara();
            ftpPara.setServiceIp(aticDevice.getIpAddress());
            ftpPara.setPort(Integer.valueOf(21));
            ftpPara.setUserName(collectModel.getFtpUsername());
            ftpPara.setFtpPassWord(collectModel.getPassword());
            commandExec.setFtpPara(ftpPara);
            commandExec.setNext(next);
            commandExec.setProgressBar(ProgressMgr.getInstance().getProgressBar(progressId));
            commandExec.setAticDevice(aticDevice);
            commandExec.setWebPath(collectModel.getWebPath());
            commandExec.setLocale(locale);
            next = commandExec;
            if (i != EnumFileCommandOrder.values().length - 1) continue;
            return commandExec;
        }
        return null;
    }

    public static String cut(String cmd) {
        String regx = "\\{[\\w\\s\\]\\[]+\\$\\$[\\w\\s\\]\\[]+\\}|\\{[\\w\\s\\]\\[]+\\$\\$\\}|\\{\\$\\$[\\w\\s\\]\\[]+\\}|\\{\\$\\$\\}";
        return cmd.replaceAll(regx, " ");
    }

    public static String re(String cmd) {
        return cmd.replace("{", " ").replace("}", " ");
    }

    public static String translateCmd(CollectParam collectParam, IEnumCommand each) {
        String sourceIp = null == collectParam || null == collectParam.getSourceIp() ? "" : collectParam.getSourceIp();
        String destIp = null == collectParam || null == collectParam.getDestIp() ? "" : collectParam.getDestIp();
        String type = "";
        String mask = "0";
        if (IPUtil.isIpv6((String)sourceIp) || IPUtil.isIpv6((String)destIp)) {
            type = "ipv6";
            mask = "1";
        }
        String cmd = each.getCommand();
        if (each == EnumCommandOrder.COMMAND_RULE) {
            cmd = String.format(cmd, ConstantUtil.placeholder(collectParam.getSourceIp()), mask, ConstantUtil.placeholder(collectParam.getDestIp()), mask);
            cmd = ConstantUtil.re(ConstantUtil.cut(cmd));
        }
        if (each == EnumCommandOrder.COMMAND_ACL_NUM) {
            cmd = String.format(cmd, type, 3998);
        }
        if (each == EnumCommandOrder.COMMAND_ACL_ISSUED_COMMAND) {
            cmd = String.format(cmd, 3998);
        }
        LOGGER.info((Object)("EnumCommandOrder --- cmd : " + cmd));
        return cmd;
    }

    public static String placeholder(String ip) {
        return null == ip || "".equals(ip.trim()) ? "$$" : ip;
    }

    public static String getMessage(String key, String properties, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(properties, locale = null == locale ? Locale.getDefault() : locale);
        if (bundle.containsKey(key)) {
            String a = bundle.getString(key);
            return a;
        }
        return "";
    }

    public static <T> List<T> deepCopyList(List<T> src) {
        List dest = null;
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(src);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            dest = (List)in.readObject();
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)e);
        }
        return dest;
    }

    public static String getClassPackage(String fullClass) {
        String packgName = "";
        int lastDot = (fullClass = Normalizer.normalize(fullClass, Normalizer.Form.NFKC)).lastIndexOf(".");
        if (lastDot > 0) {
            packgName = fullClass.substring(0, lastDot);
        }
        return packgName;
    }

    public static String getSimpleClassName(String fullClass) {
        String simpleName = "";
        int lastDot = fullClass.lastIndexOf(".");
        simpleName = fullClass.substring(lastDot + 1);
        return simpleName;
    }

    public static String getFileNameNotSuffix(String fileName) {
        String fileNameNotSuffix = null;
        if (fileName != null) {
            fileName = Normalizer.normalize(fileName, Normalizer.Form.NFKC);
            int index = fileName.lastIndexOf(46);
            fileNameNotSuffix = fileName.substring(0, index);
        }
        return fileNameNotSuffix;
    }

    public static boolean isNumeric(String str) {
        try {
            double d = Double.parseDouble(str);
            LOGGER.info((Object)d);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static void writSyslog(boolean isSucc, String target, String operation, String success, String failed, String module, User user, String remoteAddr, String[] detail) {
        if (null == target) {
            target = "";
        }
        if (target.length() >= 255) {
            target = target.substring(0, 250);
        }
        if (null == detail) {
            detail = new String[]{};
        }
        SysOptLog sysOptLog = new SysOptLog();
        sysOptLog.setOperation(operation);
        sysOptLog.setModule(module);
        sysOptLog.setLevel(SysoplogLevel.normal.getValue());
        sysOptLog.setTarget(target);
        if (isSucc) {
            sysOptLog.setResult(1);
            sysOptLog.setDetail(success);
            sysOptLog.setDetailPara(detail);
        } else {
            sysOptLog.setResult(0);
            sysOptLog.setDetail(failed);
            sysOptLog.setDetailPara(detail);
        }
        sysOptLog.setOperator(user.getUserName());
        sysOptLog.setTerminalIp(remoteAddr);
        sysOptLog.setDate(new Date());
        ISysOptLog service = ZoneReferUtil.getSysOptLog();
        service.writeOptLog(sysOptLog);
    }
}

