/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ReflectionUtils {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    private ReflectionUtils() {
    }

    public static Object getFieldValue(Object object, Field field) {
        ReflectionUtils.makeAccessible(field);
        Object result = null;
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public static Object getFieldValue(Object object, String fieldName) {
        if (fieldName.equals("")) {
            return null;
        }
        try {
            Field field = ReflectionUtils.getDeclaredField(object, fieldName);
            if (field == null) {
                return null;
            }
            return ReflectionUtils.getFieldValue(object, field);
        }
        catch (Exception e) {
            String methodName = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            try {
                Method method = object.getClass().getMethod(methodName, new Class[0]);
                return method.invoke(object, new Object[0]);
            }
            catch (NoSuchMethodException e2) {
                logger.error((Object)e2);
            }
            catch (SecurityException e2) {
                logger.error((Object)e2);
            }
            catch (IllegalAccessException e2) {
                logger.error((Object)e2);
            }
            catch (IllegalArgumentException e2) {
                logger.error((Object)e2);
            }
            catch (InvocationTargetException e2) {
                logger.error((Object)e2);
            }
            return null;
        }
    }

    public static <T> void setFieldValue(T object, Field field, Object value) {
        ReflectionUtils.makeAccessible(field);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
    }

    public static <T> void setFieldValue(T object, String fieldName, Object value) {
        try {
            Field field = ReflectionUtils.getDeclaredField(object, fieldName);
            if (field == null) {
                throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + object + "]");
            }
            ReflectionUtils.setFieldValue(object, field, value);
        }
        catch (RuntimeException e) {
            String methodName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            try {
                Method method = object.getClass().getMethod(methodName, value.getClass());
                method.invoke(object, value);
            }
            catch (NoSuchMethodException e2) {
                logger.error((Object)e2);
            }
            catch (SecurityException e2) {
                logger.error((Object)e2);
            }
            catch (IllegalAccessException e2) {
                logger.error((Object)e2);
            }
            catch (IllegalArgumentException e2) {
                logger.error((Object)e2);
            }
            catch (InvocationTargetException e2) {
                logger.error((Object)e2);
            }
        }
    }

    public static Field getDeclaredField(Object object, String fieldName) {
        for (Class<?> superClass = object.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                logger.error((Object)e);
                continue;
            }
        }
        return null;
    }

    public static List<Field> getDeclaredFields(Object object) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> superClass = object.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            Field[] f = superClass.getDeclaredFields();
            fields.addAll(Arrays.asList(f));
        }
        return fields;
    }

    protected static void makeAccessible(final Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        }
    }
}

