/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.common.service.impl;

import com.hs.atic.collector.entity.BizInfoEntity;
import com.hs.atic.collector.entity.DefaultBizMappingEntity;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FoundDefaultIdCommonServiceImpl {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private IAticDeviceService aticDeviceService;
    private IZoneService zoneService;
    private IZoneDeviceService zoneDeviceService;
    private IZoneServiceService zoneServiceService;

    public IZoneServiceService getZoneServiceService() {
        return this.zoneServiceService;
    }

    public void setZoneServiceService(IZoneServiceService zoneServiceService) {
        this.zoneServiceService = zoneServiceService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public Map<String, Long> getAllDefaultZoneId() throws RemoteException {
        this.logger.info((Object)"enter getAllDefaultZoneId() ");
        List<ZoneInfoForm> listForm = this.zoneService.getAllDefaultZones();
        HashMap<String, Long> returnMap = new HashMap<String, Long>();
        if (null != listForm && !listForm.isEmpty()) {
            for (ZoneInfoForm form : listForm) {
                List zoneDeviceFormList = this.zoneDeviceService.queryZoneDeviceFormsByZoneID(form.getZoneId());
                if (null == zoneDeviceFormList || zoneDeviceFormList.isEmpty()) {
                    this.logger.info((Object)"zoneDeviceForm is null or isEmpty");
                    continue;
                }
                for (ZoneDeviceForm zdf : zoneDeviceFormList) {
                    this.logger.info((Object)("get zoneDevice: " + this.getcleanedMessage(zdf.toString())));
                    AticDevice device = this.aticDeviceService.getDeviceByMoid(zdf.getDeviceId().longValue());
                    if (null == device) continue;
                    String fwIP = AticUtil.formatIpAddress((String)device.getIpAddress());
                    this.logger.info((Object)("get firewall DeviceIp: " + this.getcleanedMessage(fwIP) + ",zoneId:" + form.getZoneId()));
                    returnMap.put(fwIP, form.getZoneId());
                }
            }
        } else {
            this.logger.info((Object)"getAllDefaultZones() maybe ZoneInfoForm is null or isEmpty ");
        }
        this.logger.info((Object)("getAllDefaultZoneId return map is: " + this.getcleanedMessage(((Object)returnMap).toString())));
        return returnMap;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public Map<DefaultBizMappingEntity, Long> getAllDefaultBizId() throws RemoteException {
        List zoneServiceFormList;
        this.logger.info((Object)"enter  getAllDefaultBizId() ");
        HashMap<DefaultBizMappingEntity, Long> returnMap = new HashMap<DefaultBizMappingEntity, Long>();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("protocol", "DEFAULT");
        Paging page = this.zoneServiceService.queryByPage(queryMap, 0, Integer.MAX_VALUE);
        List aticDevicesList = this.aticDeviceService.getAllDevice();
        HashMap<Long, String> deviceMap = new HashMap<Long, String>();
        if (null != aticDevicesList && !aticDevicesList.isEmpty()) {
            for (AticDevice aticDevice : aticDevicesList) {
                deviceMap.put(aticDevice.getMoId(), aticDevice.getIpAddress());
            }
        }
        if (null != (zoneServiceFormList = page.getData()) && !zoneServiceFormList.isEmpty()) {
            for (ZoneServiceForm zsi : zoneServiceFormList) {
                DefaultBizMappingEntity defaultBizMappingEntity = new DefaultBizMappingEntity();
                String deviceIp = (String)deviceMap.get(zsi.getDeviceId());
                if (null == deviceIp || "".equals(deviceIp)) continue;
                defaultBizMappingEntity.setDirection(zsi.getDirection());
                defaultBizMappingEntity.setBizId(zsi.getPkid());
                defaultBizMappingEntity.setDeviceIp(AticUtil.formatIpAddress((String)deviceIp));
                defaultBizMappingEntity.setZoneId(zsi.getZoneId());
                returnMap.put(defaultBizMappingEntity, zsi.getPkid());
            }
        } else {
            this.logger.info((Object)"zoneServiceFormList maybe zoneServiceFormList is null or isEmpty ");
        }
        return returnMap;
    }

    public Map<BizInfoEntity, Long> getAllBizInfo() throws RemoteException {
        List<ZoneServiceForm> listForm = this.zoneServiceService.queryAll();
        HashMap<BizInfoEntity, Long> bizMap = new HashMap<BizInfoEntity, Long>();
        HashMap<Long, String> deviceIdAndIpMap = new HashMap<Long, String>();
        for (ZoneServiceForm form : listForm) {
            try {
                String port;
                String portStartAndEnd;
                AticDevice device;
                String[] portList;
                if (null == form.getPortList() || "".equals(form.getPortList()) || (portList = form.getPortList().trim().split(";")).length <= 0) continue;
                String protocol = form.getProtocol();
                String deviceIp = (String)deviceIdAndIpMap.get(form.getDeviceId());
                if (AticUtil.isNull((String)deviceIp) && null != (device = this.aticDeviceService.getDeviceByMoid(form.getDeviceId().longValue()))) {
                    deviceIp = device.getIpAddress();
                    deviceIdAndIpMap.put(form.getDeviceId(), deviceIp);
                }
                if (StringUtils.isEmpty((CharSequence)(portStartAndEnd = portList[0])) || null == (port = portStartAndEnd.split("~")[0]) || "".equals(port)) continue;
                BizInfoEntity entity = new BizInfoEntity(form.getZoneId(), protocol, Integer.parseInt(port), AticUtil.formatIpAddress((String)deviceIp));
                entity.setServiceId(form.getPkid());
                entity.setServiceName(form.getServiceName());
                bizMap.put(entity, form.getPkid());
            }
            catch (Exception e) {
                this.logger.error((Object)"getAllBizInfo error ", (Throwable)e);
            }
        }
        this.logger.info((Object)("result List<BizInfoEntity> are : " + this.getcleanedMessage(((Object)bizMap).toString())));
        return bizMap;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }
}

