/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.intelligentdefense.impl;

import com.hs.atic.intelligentdefense.dao.StreamMonitorMeasureNameDao;
import com.hs.atic.intelligentdefense.dao.StreamMonitorRuleConditionRelationDao;
import com.hs.atic.intelligentdefense.dao.StreamMonitorRuleDao;
import com.hs.atic.intelligentdefense.dao.StreamMonitorRuleZoneMappingDao;
import com.hs.atic.intelligentdefense.entity.StreamMonitorMeasureName;
import com.hs.atic.intelligentdefense.entity.StreamMonitorRule;
import com.hs.atic.intelligentdefense.entity.StreamMonitorRuleConditionRelationship;
import com.hs.atic.intelligentdefense.entity.StreamMonitorRuleDetail;
import com.hs.atic.intelligentdefense.entity.StreamMonitorRuleZoneMapping;
import com.hs.atic.rmi.IntelligentDefenseConfigService;
import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.Collector;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StreamMonitorRuleManager {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ICollectorDeviceService collectorDeviceService;
    private ICollectorService collectorService;
    private StreamMonitorRuleDao streamMonitorRuleDao;
    private StreamMonitorRuleConditionRelationDao streamMonitorRuleConditionRelationDao;
    private StreamMonitorMeasureNameDao streamMonitorMeasureNameDao;
    private StreamMonitorRuleZoneMappingDao streamMonitorRuleZoneMappingDao;

    public StreamMonitorRuleDao getStreamMonitorRuleDao() {
        return this.streamMonitorRuleDao;
    }

    public void setStreamMonitorRuleDao(StreamMonitorRuleDao streamMonitorRuleDao) {
        this.streamMonitorRuleDao = streamMonitorRuleDao;
    }

    public StreamMonitorRuleConditionRelationDao getStreamMonitorRuleConditionRelationDao() {
        return this.streamMonitorRuleConditionRelationDao;
    }

    public void setStreamMonitorRuleConditionRelationDao(StreamMonitorRuleConditionRelationDao streamMonitorRuleConditionRelationDao) {
        this.streamMonitorRuleConditionRelationDao = streamMonitorRuleConditionRelationDao;
    }

    public StreamMonitorMeasureNameDao getStreamMonitorMeasureNameDao() {
        return this.streamMonitorMeasureNameDao;
    }

    public void setStreamMonitorMeasureNameDao(StreamMonitorMeasureNameDao streamMonitorMeasureNameDao) {
        this.streamMonitorMeasureNameDao = streamMonitorMeasureNameDao;
    }

    public StreamMonitorRuleZoneMappingDao getStreamMonitorRuleZoneMappingDao() {
        return this.streamMonitorRuleZoneMappingDao;
    }

    public void setStreamMonitorRuleZoneMappingDao(StreamMonitorRuleZoneMappingDao streamMonitorRuleZoneMappingDao) {
        this.streamMonitorRuleZoneMappingDao = streamMonitorRuleZoneMappingDao;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public StreamMonitorRule getRule(int id) {
        StreamMonitorRule rule = null;
        rule = this.streamMonitorRuleDao.get(id);
        return rule;
    }

    public StreamMonitorRule getRuleByName(String ruleName) {
        StreamMonitorRule rule = null;
        rule = this.streamMonitorRuleDao.getByName(ruleName);
        return rule;
    }

    public StreamMonitorRuleDetail getRuleDetail(int ruleId) {
        StreamMonitorRuleDetail ruleDetail = null;
        StreamMonitorRule rule = this.streamMonitorRuleDao.get(ruleId);
        if (rule != null) {
            List<StreamMonitorRuleConditionRelationship> relationships = this.streamMonitorRuleConditionRelationDao.getRelationshipsByRuleId(ruleId);
            ruleDetail = new StreamMonitorRuleDetail();
            ruleDetail.setDescription(rule.getDescription());
            ruleDetail.setRuleName(rule.getRuleName());
            ruleDetail.setRuleId(rule.getId());
            ArrayList<Integer> ruleIds = new ArrayList<Integer>();
            ruleIds.add(ruleId);
            ArrayList<Long> zoneIds = new ArrayList<Long>();
            List<StreamMonitorRuleZoneMapping> mappings = this.streamMonitorRuleZoneMappingDao.getByRuleId(ruleIds);
            for (StreamMonitorRuleZoneMapping mapping : mappings) {
                zoneIds.add(mapping.getZoneId());
            }
            ruleDetail.setConditionRelationships(relationships);
            ruleDetail.setZoneIds(zoneIds);
        }
        return ruleDetail;
    }

    public List<StreamMonitorRule> getAllRules() {
        List<StreamMonitorRule> rules = this.streamMonitorRuleDao.getAll();
        return rules;
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.streamMonitorRuleDao.queryByPage(queryMap, start, pageSize);
        List rules = page.getData();
        ArrayList<StreamMonitorRule> ruleForms = new ArrayList<StreamMonitorRule>();
        for (StreamMonitorRule rule : rules) {
            StreamMonitorRule ruleForm = new StreamMonitorRule();
            AticUtil.copyProperties((Object)rule, (Object)ruleForm);
            ruleForms.add(ruleForm);
        }
        page.setData(ruleForms);
        this.logger.info((Object)("ruleForms size: " + ruleForms.size()));
        return page;
    }

    public void addRuleRMI(StreamMonitorRuleDetail ruleDetail) throws RemoteException {
        List<IntelligentDefenseConfigService> services = this.getRMIService();
        for (IntelligentDefenseConfigService service : services) {
            if (null != service) {
                service.addRule(ruleDetail);
                continue;
            }
            this.logger.error((Object)("IntelligentDefenseConfigService is null , add " + ruleDetail.toString() + " error"));
        }
    }

    public void removeRuleRMI(List<Integer> ruleIds) throws RemoteException {
        List<IntelligentDefenseConfigService> services = this.getRMIService();
        for (IntelligentDefenseConfigService service : services) {
            if (null != service) {
                service.removeRule(ruleIds);
                continue;
            }
            this.logger.error((Object)("IntelligentDefenseConfigService is null , remove " + ruleIds.toString() + " error"));
        }
    }

    public void updateRuleRMI(StreamMonitorRuleDetail ruleDetail) throws RemoteException {
        List<IntelligentDefenseConfigService> services = this.getRMIService();
        for (IntelligentDefenseConfigService service : services) {
            if (null != service) {
                service.updateRule(ruleDetail);
                continue;
            }
            this.logger.error((Object)("IntelligentDefenseConfigService is null , update " + ruleDetail.toString() + " error"));
        }
    }

    private List<IntelligentDefenseConfigService> getRMIService() throws RemoteException {
        ArrayList<IntelligentDefenseConfigService> serviceList = new ArrayList<IntelligentDefenseConfigService>();
        List collectors = this.collectorService.getAllCollector();
        for (Collector collector : collectors) {
            CollectorInfo info = this.collectorService.getCollectorInfo(collector.getMoId().longValue());
            if (info == null) continue;
            ZoneCollectorRMIProxy rmiProxy = new ZoneCollectorRMIProxy();
            IntelligentDefenseConfigService service = rmiProxy.getIntelligentDefenseService(info.getIpAddress());
            if (service == null) {
                throw new RemoteException(String.format("call getIntelligentDefenseService RMI service on collector %s failed", info.getIpAddress()));
            }
            serviceList.add(service);
        }
        return serviceList;
    }

    public int addRule(StreamMonitorRuleDetail ruleDetail) throws RemoteException {
        int ruleId = -1;
        if (ruleDetail == null) {
            return ruleId;
        }
        StreamMonitorRule rule = this.streamMonitorRuleDao.getByName(ruleDetail.getRuleName());
        if (rule != null) {
            return rule.getId();
        }
        rule = new StreamMonitorRule();
        rule.setRuleName(ruleDetail.getRuleName());
        rule.setDescription(ruleDetail.getDescription());
        ruleId = (Integer)this.streamMonitorRuleDao.save(rule);
        ruleDetail.setRuleId(ruleId);
        for (StreamMonitorRuleConditionRelationship relationship : ruleDetail.getConditionRelationships()) {
            relationship.setRuleId(ruleId);
            this.streamMonitorRuleConditionRelationDao.save(relationship);
        }
        ArrayList<StreamMonitorRuleZoneMapping> ruleZones = new ArrayList<StreamMonitorRuleZoneMapping>();
        for (Long zoneId : ruleDetail.getZoneIds()) {
            StreamMonitorRuleZoneMapping ruleZone = new StreamMonitorRuleZoneMapping();
            ruleZone.setRuleId(ruleId);
            ruleZone.setZoneId(zoneId);
            ruleZones.add(ruleZone);
        }
        this.streamMonitorRuleZoneMappingDao.save(ruleZones);
        this.addRuleRMI(ruleDetail);
        ruleId = 0;
        return ruleId;
    }

    public void updateRule(StreamMonitorRuleDetail ruleDetail) throws RemoteException {
        if (ruleDetail == null) {
            return;
        }
        StreamMonitorRule rule = new StreamMonitorRule();
        rule.setId(ruleDetail.getRuleId());
        rule.setRuleName(ruleDetail.getRuleName());
        rule.setDescription(ruleDetail.getDescription());
        this.streamMonitorRuleDao.update(rule);
        List<StreamMonitorRuleConditionRelationship> existingRelationshipList = this.streamMonitorRuleConditionRelationDao.getRelationshipsByRuleId(ruleDetail.getRuleId());
        ArrayList<Integer> relationIdList = new ArrayList<Integer>();
        for (StreamMonitorRuleConditionRelationship streamMonitorRuleConditionRelationship : existingRelationshipList) {
            relationIdList.add(streamMonitorRuleConditionRelationship.getConditionId());
        }
        this.streamMonitorRuleConditionRelationDao.remove(relationIdList);
        for (StreamMonitorRuleConditionRelationship streamMonitorRuleConditionRelationship : ruleDetail.getConditionRelationships()) {
            streamMonitorRuleConditionRelationship.setRuleId(rule.getId());
            streamMonitorRuleConditionRelationship.setConditionId(null);
            this.streamMonitorRuleConditionRelationDao.saveOrUpdate(streamMonitorRuleConditionRelationship);
        }
        ArrayList<StreamMonitorRuleZoneMapping> ruleZones = new ArrayList<StreamMonitorRuleZoneMapping>();
        for (Long l : ruleDetail.getZoneIds()) {
            StreamMonitorRuleZoneMapping ruleZone = new StreamMonitorRuleZoneMapping();
            ruleZone.setRuleId(rule.getId());
            ruleZone.setZoneId(l);
            ruleZones.add(ruleZone);
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (StreamMonitorRuleZoneMapping ruleZone : ruleZones) {
            arrayList.add(ruleZone.getZoneId());
        }
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        List<StreamMonitorRuleZoneMapping> mappings = this.streamMonitorRuleZoneMappingDao.getByRuleId(Collections.singletonList(ruleDetail.getRuleId()));
        for (StreamMonitorRuleZoneMapping streamMonitorRuleZoneMapping : mappings) {
            arrayList2.add(streamMonitorRuleZoneMapping.getZoneId());
        }
        ArrayList<Long> needRemovedRuleZoneIds = new ArrayList<Long>();
        for (Long l : arrayList2) {
            if (arrayList.contains(l)) continue;
            needRemovedRuleZoneIds.add(l);
        }
        ArrayList<Long> arrayList3 = new ArrayList<Long>();
        for (Long ruleZoneId : arrayList) {
            if (arrayList2.contains(ruleZoneId)) continue;
            arrayList3.add(ruleZoneId);
        }
        ArrayList<StreamMonitorRuleZoneMapping> arrayList4 = new ArrayList<StreamMonitorRuleZoneMapping>();
        for (Long id : arrayList3) {
            StreamMonitorRuleZoneMapping tempRuleZone = new StreamMonitorRuleZoneMapping();
            tempRuleZone.setRuleId(ruleDetail.getRuleId());
            tempRuleZone.setZoneId(id);
            arrayList4.add(tempRuleZone);
        }
        this.streamMonitorRuleZoneMappingDao.save(arrayList4);
        this.streamMonitorRuleZoneMappingDao.removeByRuleZoneId(ruleDetail.getRuleId(), needRemovedRuleZoneIds);
        this.updateRuleRMI(ruleDetail);
    }

    public void removeRule(int id) throws RemoteException {
        StreamMonitorRuleDetail ruleDetail = this.getRuleDetail(id);
        for (StreamMonitorRuleConditionRelationship relationship : ruleDetail.getConditionRelationships()) {
            this.streamMonitorRuleConditionRelationDao.remove(relationship.getConditionId());
        }
        ArrayList<Integer> ruleIds = new ArrayList<Integer>();
        ruleIds.add(id);
        List<StreamMonitorRuleZoneMapping> mappings = this.streamMonitorRuleZoneMappingDao.getByRuleId(ruleIds);
        for (StreamMonitorRuleZoneMapping mapping : mappings) {
            this.streamMonitorRuleZoneMappingDao.remove(mapping.getId());
        }
        this.removeRuleRMI(Collections.singletonList(id));
        this.streamMonitorRuleDao.remove(id);
    }

    public List<StreamMonitorRuleDetail> loadRules() {
        ArrayList<StreamMonitorRuleDetail> ruleDetails = new ArrayList<StreamMonitorRuleDetail>();
        List<StreamMonitorRule> rules = this.getAllRules();
        for (StreamMonitorRule rule : rules) {
            StreamMonitorRuleDetail ruleDetail = new StreamMonitorRuleDetail();
            ruleDetail.setRuleName(rule.getRuleName());
            ruleDetail.setRuleId(rule.getId());
            ArrayList<Integer> ruleIds = new ArrayList<Integer>();
            ruleIds.add(rule.getId());
            ArrayList<Long> zoneIds = new ArrayList<Long>();
            List<StreamMonitorRuleZoneMapping> mappings = this.streamMonitorRuleZoneMappingDao.getByRuleId(ruleIds);
            for (StreamMonitorRuleZoneMapping mapping : mappings) {
                zoneIds.add(mapping.getZoneId());
            }
            ruleDetail.setZoneIds(zoneIds);
            List<StreamMonitorRuleConditionRelationship> relationships = this.streamMonitorRuleConditionRelationDao.getRelationshipsByRuleId(rule.getId());
            ruleDetail.setConditionRelationships(relationships);
            ruleDetails.add(ruleDetail);
        }
        return ruleDetails;
    }

    public List<StreamMonitorMeasureName> getMeasures() {
        List<StreamMonitorMeasureName> measures = this.streamMonitorMeasureNameDao.getAll();
        return measures;
    }

    public List<StreamMonitorMeasureName> getMeasuresByType(Integer typeId) {
        List<StreamMonitorMeasureName> measures = this.streamMonitorMeasureNameDao.getByType(typeId);
        return measures;
    }

    public void associateRuleZone(int ruleId, List<Long> zoneIds) throws RemoteException {
        ArrayList<StreamMonitorRuleZoneMapping> ruleZones = new ArrayList<StreamMonitorRuleZoneMapping>();
        for (Long zoneId : zoneIds) {
            StreamMonitorRuleZoneMapping ruleZone = new StreamMonitorRuleZoneMapping();
            ruleZone.setRuleId(ruleId);
            ruleZone.setZoneId(zoneId);
            ruleZones.add(ruleZone);
        }
        this.streamMonitorRuleZoneMappingDao.save(ruleZones);
        StreamMonitorRuleDetail rule = this.getRuleDetail(ruleId);
        this.updateRuleRMI(rule);
    }

    public List<StreamMonitorRule> getRulesByZoneId(Long zoneId) {
        List<Object> rules = null;
        rules = null == zoneId ? new ArrayList() : this.streamMonitorRuleDao.getRulesByZoneId(zoneId);
        return rules;
    }

    public void updateRuleFromZone(Long zoneId, List<String> orginRuleIds, List<String> currentRuleIds) throws RemoteException {
        StreamMonitorRuleDetail rule;
        List<String> addList = this.getDeleteStringList(currentRuleIds, orginRuleIds);
        List<String> deleteList = this.getDeleteStringList(orginRuleIds, currentRuleIds);
        if (0 < addList.size()) {
            for (String ruleId : addList) {
                StreamMonitorRuleZoneMapping ruleZone = new StreamMonitorRuleZoneMapping();
                ruleZone.setRuleId(Integer.parseInt(ruleId));
                ruleZone.setZoneId(zoneId);
                this.streamMonitorRuleZoneMappingDao.save(ruleZone);
                rule = this.getRuleDetail(Integer.parseInt(ruleId));
                this.updateRuleRMI(rule);
            }
        }
        if (0 < deleteList.size()) {
            for (String ruleId : deleteList) {
                ArrayList<Long> zoneIds = new ArrayList<Long>();
                zoneIds.add(zoneId);
                this.streamMonitorRuleZoneMappingDao.removeByRuleZoneId(Integer.parseInt(ruleId), zoneIds);
                rule = this.getRuleDetail(Integer.parseInt(ruleId));
                this.updateRuleRMI(rule);
            }
        }
    }

    private List<String> getDeleteStringList(List<String> orginList, List<String> currentList) {
        ArrayList<String> deleteList = new ArrayList<String>();
        for (String orgin : orginList) {
            boolean isToDelete = true;
            for (String current : currentList) {
                if (!current.equals(orgin)) continue;
                isToDelete = false;
                break;
            }
            if (!isToDelete) continue;
            deleteList.add(orgin);
        }
        return deleteList;
    }

    public List<StreamMonitorRuleZoneMapping> getRuleZoneMappingsByRuleId(List<Integer> ruleIds) {
        List<StreamMonitorRuleZoneMapping> mappings = this.streamMonitorRuleZoneMappingDao.getByRuleId(ruleIds);
        return mappings;
    }

    public List<StreamMonitorRuleZoneMapping> getRuleZoneMappingsByZoneId(List<Long> zoneIds) {
        List<StreamMonitorRuleZoneMapping> mappings = this.streamMonitorRuleZoneMappingDao.getByZoneId(zoneIds);
        return mappings;
    }

    public void disassociateRuleZone(List<Long> zoneIds) throws RemoteException {
        List<Integer> ruleIds = this.streamMonitorRuleZoneMappingDao.getRuleIdByZoneId(zoneIds);
        for (Integer ruleId : ruleIds) {
            StreamMonitorRuleDetail rule = this.getRuleDetail(ruleId);
            List<Long> ruleZoneIds = rule.getZoneIds();
            if (rule.getZoneIds() != null) {
                rule.getZoneIds().removeAll(ruleZoneIds);
            }
            this.updateRuleRMI(rule);
        }
        this.streamMonitorRuleZoneMappingDao.removeByZoneId(zoneIds);
    }
}

