/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.restful.client;

import com.hs.atic.notify.restful.model.RestfulConfigForm;
import com.hs.atic.restful.client.BaseRestClient;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;

public class LoginClient
extends BaseRestClient {
    private IDataProtectService dataProtectService;
    private String user;
    private String password;
    private String domainName;
    private String projectName;
    private String loginUrl;
    private volatile String token;
    private Lock lock = new ReentrantLock();

    private boolean login() {
        if (null != this.token) {
            LOGGER.info((Object)"token is not null.");
            return true;
        }
        LOGGER.info((Object)"try lock... ");
        while (!this.lock.tryLock()) {
            if (null == this.token) continue;
            return true;
        }
        try {
            LOGGER.info((Object)"get lock success.get token now .");
            this.token();
        }
        catch (IOException e) {
            LOGGER.error((Object)"getToken error. ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
        return null != this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void token() throws IOException {
        if (null != this.token) {
            return;
        }
        String json = this.assemblyLoginJson();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json;charset=utf8");
        LOGGER.info((Object)("begin to connect loginUrl . loginUrl : " + this.loginUrl));
        HttpPost post = new HttpPost(this.loginUrl);
        try {
            CloseableHttpResponse response = this.sendRequest(post, json, this.loginUrl, headers);
            if (response != null) {
                int httpCode = response.getStatusLine().getStatusCode();
                if (httpCode == 201) {
                    Header[] aHeaders = response.getHeaders("X-Subject-Token");
                    boolean isGet = false;
                    for (Header header : aHeaders) {
                        if (null == header.getName()) continue;
                        this.token = header.getValue();
                        isGet = true;
                        break;
                    }
                    if (!isGet) {
                        LOGGER.error((Object)"get Token error. httpCode : 200 . header does not have token. please check.");
                    }
                } else {
                    LOGGER.warn((Object)("get token error. httpCode : " + httpCode));
                }
            }
        }
        finally {
            post.releaseConnection();
        }
    }

    private String assemblyLoginJson() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        if (this.hasDomain()) {
            sb.append("\"auth\":{\"identity\":{\"methods\":[\"password\"],\"password\":{\"user\":{");
        }
        sb.append("\"name\":");
        sb.append("\"");
        sb.append(this.user);
        sb.append("\"");
        sb.append(",");
        sb.append("\"password\":");
        sb.append("\"");
        sb.append(this.password);
        sb.append("\"");
        if (this.hasDomain()) {
            sb.append(",");
            sb.append("\"domain\":{\"name\":");
            sb.append("\"");
            sb.append(this.domainName);
            sb.append("\"");
            sb.append("}}}},");
            sb.append("\"scope\":{");
            if (this.hasProject()) {
                sb.append("\"project\":{\"name\":\"");
                sb.append(this.projectName);
                sb.append("\"");
                sb.append(",");
            }
            sb.append("\"domain\":{\"name\":");
            sb.append("\"");
            sb.append(this.domainName);
            sb.append("\"");
            if (this.hasProject()) {
                sb.append("}");
            }
            sb.append("}}}}");
        } else {
            sb.append("}");
        }
        return sb.toString();
    }

    private boolean hasDomain() {
        return null != this.domainName && !"".equals(this.domainName) && !"domainName".equals(this.domainName);
    }

    private boolean hasProject() {
        return null != this.projectName && !"".equals(this.projectName) && !"projectName".equals(this.projectName);
    }

    protected final boolean needLogin(RestfulConfigForm form) {
        this.loginUrl = form.getLoginUrl();
        if (null == this.loginUrl || "".equals(this.loginUrl)) {
            return false;
        }
        this.user = form.getUserName();
        String password2 = form.getPassword();
        this.password = this.dataProtectService.sdpDecrypt(0L, password2);
        this.domainName = form.getDomainName();
        this.projectName = form.getProjectName();
        return true;
    }

    protected final boolean doLogin(RestfulConfigForm form) {
        boolean isLogin = false;
        if (!this.needLogin(form)) {
            LOGGER.info((Object)"do not need login.");
            return true;
        }
        for (int i = 0; i < 3; ++i) {
            isLogin = this.login();
            if (isLogin) {
                isLogin = true;
                break;
            }
            LOGGER.info((Object)("login faild . begin to retry. retry : " + i));
        }
        return isLogin;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public IDataProtectService getDataProtectService() {
        return this.dataProtectService;
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }
}

