/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.restful.client;

import com.hs.atic.notify.restful.dao.RestfulConfigDao;
import com.hs.atic.notify.restful.model.RestfulConfigForm;
import com.hs.atic.restful.client.BaseRestClient;
import com.hs.atic.restful.client.LoginClient;
import com.hs.atic.restful.client.model.NotifyBlackholeForm;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.secservice.nfa.util.JSONUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;

public class NotifyBlackholeIp
extends BaseRestClient {
    private static final String DEFAULT_ATTACK_IP_URL = "https://host:port/v1/cad/attackip";
    private static final String DEFAULT_RELEASE_URL = "http://host:port/release/blackhole";
    private static final String UNBLOCK = "unblock";
    private static final String BLOCK = "block";
    private final String notifyTime = prop.getProperty("notifyTime");
    private final String notifyReleaseTime = prop.getProperty("notifyReleaseTime");
    private final String notifyBlackholeType;
    private final String notifyBlackholeTime;
    private final String notifyLogTime;
    private final String notifyStaticBlackhole = prop.getProperty("notifyStaticBlackhole");
    private LoginClient loginClient;
    private ISysOptLog sysOptLog;
    private RestfulConfigDao restfulConfigDao;

    public NotifyBlackholeIp() {
        this.notifyBlackholeType = prop.getProperty("notifyBlackholeType");
        this.notifyBlackholeTime = prop.getProperty("notifyBlackholeTime");
        this.notifyLogTime = prop.getProperty("notifyLogTime");
    }

    public void sendBlackholeIp(NotifyBlackholeForm form) {
        SendTask task = new SendTask(form);
        if (!task.isOpen()) {
            return;
        }
        try {
            this.createExecutor();
        }
        catch (Exception e) {
            LOGGER.error((Object)("get connection error. send type : " + form.getType() + " ,send json : " + form.getIp()), (Throwable)e);
            return;
        }
        this.executor.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendBlackholeIp(String url, String json, Map<String, String> headers) {
        CloseableHttpResponse response = null;
        String result = "";
        HttpPost post = new HttpPost(url);
        try {
            LOGGER.info((Object)("thread : " + Thread.currentThread().getName() + " ,sendRequest() start . json : " + json));
            response = this.sendRequest(post, json, url, headers);
            LOGGER.info((Object)("thread : " + Thread.currentThread().getName() + " ,sendRequest() end . "));
            result = this.dealResponse(response);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"send request error. ", (Throwable)e);
        }
        finally {
            post.releaseConnection();
        }
        return result;
    }

    private String assemblyAttackIpJson(NotifyBlackholeForm form) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("ip", form.getIp());
        content.put("subnet", form.getSubnet());
        content.put("type", form.getType());
        this.assemblyOptionalParams(content, form);
        String json = JSONUtil.getInstance().toJSON(content);
        return json;
    }

    private void assemblyOptionalParams(Map<String, Object> content, NotifyBlackholeForm form) {
        if ("2".equals(this.notifyBlackholeTime)) {
            content.put("blackhole_time", form.getBlackholeTime());
        }
        if ("2".equals(this.notifyBlackholeType)) {
            content.put("blackhole_type", form.getBlackholeType());
        }
        if ("2".equals(this.notifyLogTime)) {
            content.put("log_time", form.getLogTime());
        }
    }

    private void writeSysLog(List<String> blackholeIps, String type, int result) {
        SysOptLog sysLog = new SysOptLog();
        sysLog.setDate(new Date());
        sysLog.setTerminalIp("127.0.0.1");
        sysLog.setOperator("system");
        if (result == 0) {
            sysLog.setLevel(SysoplogLevel.warning.getValue());
        } else if (result == 1) {
            sysLog.setLevel(SysoplogLevel.normal.getValue());
        }
        sysLog.setOperation("atic.bis.blackhole.operate");
        sysLog.setModule("lego.dic.module.restful");
        sysLog.setTarget(blackholeIps.get(0));
        if (BLOCK.equals(type)) {
            sysLog.setDetail("atic.bis.blackhole.operate.notify");
        } else {
            sysLog.setDetail("atic.bis.blackhole.operate.release");
        }
        sysLog.setDetailPara(new String[]{blackholeIps.get(0)});
        sysLog.setResult(result);
        this.sysOptLog.writeOptLog(sysLog);
    }

    public LoginClient getLoginClient() {
        return this.loginClient;
    }

    public void setLoginClient(LoginClient loginClient) {
        this.loginClient = loginClient;
    }

    public ISysOptLog getSysOptLog() {
        return this.sysOptLog;
    }

    public void setSysOptLog(ISysOptLog sysOptLog) {
        this.sysOptLog = sysOptLog;
    }

    public RestfulConfigDao getRestfulConfigDao() {
        return this.restfulConfigDao;
    }

    public void setRestfulConfigDao(RestfulConfigDao restfulConfigDao) {
        this.restfulConfigDao = restfulConfigDao;
    }

    public String getNotifyTime() {
        return this.notifyTime;
    }

    public String getNotifyReleaseTime() {
        return this.notifyReleaseTime;
    }

    public String getNotifyStaticBlackhole() {
        return this.notifyStaticBlackhole;
    }

    private class SendTask
    extends Thread {
        private NotifyBlackholeForm form;
        private RestfulConfigForm config;
        private String attackIpUrl;
        private String releaseUrl;

        public SendTask(NotifyBlackholeForm form) {
            super(form.getType() + "Thread-" + System.currentTimeMillis());
            this.form = form;
        }

        @Override
        public void run() {
            BaseRestClient.LOGGER.info((Object)("begin to send black hole ip, blackhole ip is " + this.form.getIp()));
            try {
                this.send();
            }
            catch (Error e) {
                BaseRestClient.LOGGER.error((Object)("send error , blackhole ip is " + this.form.getIp()), (Throwable)e);
            }
        }

        private boolean readConfig() {
            this.config = NotifyBlackholeIp.this.restfulConfigDao.getRestfulConfigByType(1);
            if (null == this.config) {
                return false;
            }
            this.attackIpUrl = this.config.getAttackUrl();
            this.releaseUrl = this.config.getReleaseUrl();
            return true;
        }

        private void send() {
            String url;
            ArrayList<String> blackholeIps = new ArrayList<String>();
            blackholeIps.addAll(this.form.getIp());
            blackholeIps.addAll(this.form.getSubnet());
            boolean login = NotifyBlackholeIp.this.loginClient.doLogin(this.config);
            if (!login) {
                BaseRestClient.LOGGER.error((Object)"getToken error. ");
                String alarmId = NotifyBlackholeIp.BLOCK.equals(this.form.getType()) ? "0x10010014" : "0x10010015";
                NotifyBlackholeIp.this.alarmService.callAlarmQueue(NotifyBlackholeIp.this.generateAlarm(alarmId, blackholeIps));
                return;
            }
            String json = NotifyBlackholeIp.this.assemblyAttackIpJson(this.form);
            BaseRestClient.LOGGER.info((Object)("json : " + json));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json;charset=utf-8");
            headers.put("Accept", "application/json;charset=utf-8");
            String string = url = NotifyBlackholeIp.BLOCK.equals(this.form.getType()) ? this.attackIpUrl : this.releaseUrl;
            if (NotifyBlackholeIp.this.loginClient.needLogin(this.config)) {
                headers.put("X-Auth-Token", NotifyBlackholeIp.this.loginClient.getToken());
            }
            for (int retry = 0; retry <= 3; ++retry) {
                String retryResult = NotifyBlackholeIp.this.sendBlackholeIp(url, json, headers);
                if ("success".equals(retryResult)) {
                    BaseRestClient.LOGGER.info((Object)("thread : " + Thread.currentThread().getName() + " ,send blackhole ip success. json : " + json));
                    NotifyBlackholeIp.this.writeSysLog(blackholeIps, this.form.getType(), 1);
                    return;
                }
                if ("tokenIllegal".equals(retryResult)) {
                    BaseRestClient.LOGGER.warn((Object)("thread : " + Thread.currentThread().getName() + " ,token is error. begin to get token again."));
                    NotifyBlackholeIp.this.loginClient.setToken(null);
                    NotifyBlackholeIp.this.loginClient.doLogin(this.config);
                    headers.put("X-Auth-Token", NotifyBlackholeIp.this.loginClient.getToken());
                }
                BaseRestClient.LOGGER.info((Object)("thread : " + Thread.currentThread().getName() + " ,send faild. begin to retry. retry times : " + retry));
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    BaseRestClient.LOGGER.error((Object)"sleep error.", (Throwable)e);
                }
            }
            BaseRestClient.LOGGER.warn((Object)("thread : " + Thread.currentThread().getName() + " ,retry 3 times . can't connect service. json : " + json));
            String alarmId = NotifyBlackholeIp.BLOCK.equals(this.form.getType()) ? "0x10010014" : "0x10010015";
            NotifyBlackholeIp.this.alarmService.callAlarmQueue(NotifyBlackholeIp.this.generateAlarm(alarmId, blackholeIps));
            NotifyBlackholeIp.this.writeSysLog(blackholeIps, this.form.getType(), 0);
        }

        protected boolean isOpen() {
            boolean b = this.readConfig();
            BaseRestClient.LOGGER.info((Object)b);
            if (b) {
                if (NotifyBlackholeIp.BLOCK.equals(this.form.getType())) {
                    if (null == this.attackIpUrl || "".equals(this.attackIpUrl) || NotifyBlackholeIp.DEFAULT_ATTACK_IP_URL.equals(this.attackIpUrl)) {
                        b = false;
                    }
                } else if (NotifyBlackholeIp.UNBLOCK.equals(this.form.getType())) {
                    if (this.releaseUrl == null || NotifyBlackholeIp.DEFAULT_RELEASE_URL.equals(this.releaseUrl) || "".equals(this.releaseUrl)) {
                        b = false;
                    }
                } else {
                    BaseRestClient.LOGGER.warn((Object)("send type is illegal. type : " + this.form.getType()));
                    b = false;
                }
            }
            return b;
        }
    }
}

