/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi;

import com.hs.atic.rmi.AnalyzeSuccessRateService;
import com.hs.atic.rmi.AttackDataRmiService;
import com.hs.atic.rmi.BaseLineDataRmiService;
import com.hs.atic.rmi.BlackListRmiService;
import com.hs.atic.rmi.CapturePcapService;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.CollectorLocationDevService;
import com.hs.atic.rmi.CollectorSendSyslogService;
import com.hs.atic.rmi.DataStatService;
import com.hs.atic.rmi.DnsTopNRmiService;
import com.hs.atic.rmi.FileTransService;
import com.hs.atic.rmi.FlowCompareService;
import com.hs.atic.rmi.FoundDefaultIdRmiService;
import com.hs.atic.rmi.IntelligentDefenseConfigService;
import com.hs.atic.rmi.MssConfService;
import com.hs.atic.rmi.NormalAndExceptService;
import com.hs.atic.rmi.NotifyFaultSeverityRuleService;
import com.hs.atic.rmi.ServiceLearningRmiService;
import com.hs.atic.rmi.ShowCollectorCounterService;
import com.hs.atic.rmi.SysManagerService;
import com.hs.atic.rmi.ZoneStateService;
import com.hs.atic.system.SysConfigManager;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.NotBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.HashMap;
import java.util.Map;

public class ZoneCollectorRMIProxy
implements Serializable {
    public static final String COLLECTOR_INTELLIGENT_DEFENSE_CONFIG_SERVICE = "IntelligentDefenseConfigService";
    private static final long serialVersionUID = -7353997750449280835L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private Map<String, Registry> map = new HashMap<String, Registry>();
    private transient SysConfigManager sysConfigManager;

    public BaseLineDataRmiService getBaselineDataService(String collectorIpStr) {
        BaseLineDataRmiService baseline = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                baseline = (BaseLineDataRmiService)registry.lookup("zoneBaselineService");
            }
            catch (Exception e) {
                logger.error((Object)"Get zoneBaselineService interface object failed !", (Throwable)e);
            }
        }
        if (baseline != null) {
            logger.info((Object)("Get baseline rmi service success:" + baseline.toString()));
        }
        return baseline;
    }

    public AttackDataRmiService getAttackDataService(String collectorIpStr) {
        AttackDataRmiService baseline = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                baseline = (AttackDataRmiService)registry.lookup("attackDataService");
            }
            catch (Exception e) {
                logger.error((Object)"Get AttackDataService interface object failed !", (Throwable)e);
                throw new LegoCheckedException(570504L, (Throwable)e);
            }
        }
        if (baseline != null) {
            logger.info((Object)("Get AttackDataService rmi service success:" + baseline.toString()));
        }
        return baseline;
    }

    public BlackListRmiService getBlackListService(String collectorIpStr) {
        BlackListRmiService service = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                service = (BlackListRmiService)registry.lookup("blackListService");
            }
            catch (Exception e) {
                logger.error((Object)"Get getBlackListService interface object failed !", (Throwable)e);
                throw new LegoCheckedException(570504L, (Throwable)e);
            }
        }
        if (service != null) {
            logger.info((Object)("Get getBlackListService rmi service success:" + service.toString()));
        }
        return service;
    }

    public ServiceLearningRmiService getServiceLearningRmiService(String collectorIpStr) {
        ServiceLearningRmiService service = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                service = (ServiceLearningRmiService)registry.lookup("serviceLearningService");
            }
            catch (Exception e) {
                logger.error((Object)"Get getServiceLearningRmiService interface object failed !", (Throwable)e);
                throw new LegoCheckedException(570504L, (Throwable)e);
            }
        }
        if (service != null) {
            logger.info((Object)("Get getServiceLearningRmiService rmi service success:" + service.toString()));
        }
        return service;
    }

    public ZoneStateService getZoneStateService(String collectorIpStr) {
        ZoneStateService service = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                service = (ZoneStateService)registry.lookup("zoneStateService");
            }
            catch (Exception e) {
                logger.error((Object)"Get getzoneStateService interface object failed !", (Throwable)e);
                throw new LegoCheckedException(570504L, (Throwable)e);
            }
        }
        if (service != null) {
            logger.info((Object)("Get getzoneStateService rmi service success:" + service.toString()));
        }
        return service;
    }

    public DataStatService getDataStatService(String collectorIpStr) {
        DataStatService dataSta = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                dataSta = (DataStatService)registry.lookup("dataStatService");
            }
            catch (Exception e) {
                logger.error((Object)"Get DataStatService interface object failed !", (Throwable)e);
                dataSta = null;
            }
        }
        if (dataSta != null) {
            logger.info((Object)("Get dataSta success:" + this.getcleanedMessage(dataSta.toString())));
        }
        return dataSta;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public FoundDefaultIdRmiService getFoundDefaultIdRelationService(String collectorIpStr) {
        FoundDefaultIdRmiService foundDefaultIdService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                foundDefaultIdService = (FoundDefaultIdRmiService)registry.lookup("foundDefaultIdRelationService");
            }
            catch (Exception e) {
                logger.error((Object)"Get FoundDefaultIdService interface object failed !", (Throwable)e);
                foundDefaultIdService = null;
            }
        }
        if (foundDefaultIdService != null) {
            logger.info((Object)("Get FoundDefaultIdService success:" + this.getcleanedMessage(foundDefaultIdService.toString())));
        }
        return foundDefaultIdService;
    }

    public NormalAndExceptService getNormalAndExceptionService(String collectorIpStr) {
        NormalAndExceptService normalAndExceptionService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                normalAndExceptionService = (NormalAndExceptService)registry.lookup("normalAndExceptionService");
            }
            catch (Exception e) {
                logger.error((Object)"Get NormalAndExceptionService interface object failed !", (Throwable)e);
                normalAndExceptionService = null;
            }
        }
        if (normalAndExceptionService != null) {
            logger.info((Object)("Get NormalAndExceptionService success:" + normalAndExceptionService));
        }
        return normalAndExceptionService;
    }

    public AnalyzeSuccessRateService getAnalyzeSuccessRateService(String collectorIpStr) {
        AnalyzeSuccessRateService analyzeSuccessRateService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                analyzeSuccessRateService = (AnalyzeSuccessRateService)registry.lookup("analyzeSuccessRateService");
            }
            catch (Exception e) {
                logger.error((Object)"Get AnalyzeSuccessRateService interface object failed !", (Throwable)e);
                analyzeSuccessRateService = null;
            }
        }
        if (analyzeSuccessRateService != null) {
            logger.info((Object)("Get AnalyzeSuccessRateService success:" + analyzeSuccessRateService));
        }
        return analyzeSuccessRateService;
    }

    public FlowCompareService getFlowCompareService(String collectorIpStr) {
        FlowCompareService flowCompareService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                flowCompareService = (FlowCompareService)registry.lookup("flowCompareService");
            }
            catch (Exception e) {
                logger.error((Object)"Get FlowCompareService interface object failed !", (Throwable)e);
                flowCompareService = null;
            }
        }
        if (flowCompareService != null) {
            logger.info((Object)("Get FlowCompareService success:" + flowCompareService));
        }
        return flowCompareService;
    }

    public SysConfigManager getSysConfigManager() {
        return this.sysConfigManager;
    }

    public SysManagerService getSysManagerService(String collectorIpStr) {
        SysManagerService sysManagerService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                sysManagerService = (SysManagerService)registry.lookup("sysManagerService");
            }
            catch (Exception e) {
                logger.error((Object)"Get SysManagerService interface object failed !", (Throwable)e);
                sysManagerService = null;
            }
        }
        if (sysManagerService != null) {
            logger.info((Object)("Get sysManagerService success:" + sysManagerService.toString()));
        }
        return sysManagerService;
    }

    private Registry getCollectorRegistry(String collectorIpStr) {
        logger.info((Object)("collectorIpStr:" + collectorIpStr));
        if (null != this.map.get(collectorIpStr)) {
            return this.map.get(collectorIpStr);
        }
        Registry registry = null;
        try {
            ClientSocketFactory csf = new ClientSocketFactory(true);
            registry = LocateRegistry.getRegistry(collectorIpStr, 11099, (RMIClientSocketFactory)csf);
            this.map.put(collectorIpStr, registry);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("collectorIpStr:" + collectorIpStr + " have exist in the map"), (Throwable)e);
            return registry;
        }
        catch (Exception e) {
            logger.error((Object)"Regist failed !", (Throwable)e);
            registry = null;
        }
        return registry;
    }

    public CapturePcapService getCapturePcapService(String collectorIpStr) {
        CapturePcapService capturePcapService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                capturePcapService = (CapturePcapService)registry.lookup("capturePcapService");
            }
            catch (Exception e) {
                logger.error((Object)"Get CapturePcapService interface object failed !", (Throwable)e);
                capturePcapService = null;
            }
        }
        return capturePcapService;
    }

    public void setSysConfigManager(SysConfigManager sysConfigManager) {
        this.sysConfigManager = sysConfigManager;
    }

    public DnsTopNRmiService getDnsTopNRmiService(String collectorIpStr) {
        DnsTopNRmiService dnsTopNService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                dnsTopNService = (DnsTopNRmiService)registry.lookup("zoneDnsSrcTopNService");
            }
            catch (Exception e) {
                logger.error((Object)"Get DNSTOPN interface object failed !", (Throwable)e);
                dnsTopNService = null;
            }
        }
        if (dnsTopNService != null) {
            logger.info((Object)("Get DNSTOPN rmi service success:" + dnsTopNService.toString()));
        }
        return dnsTopNService;
    }

    public NotifyFaultSeverityRuleService getNotifyFaultSeverityRuleService(String collectorIpStr) {
        NotifyFaultSeverityRuleService service = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                service = (NotifyFaultSeverityRuleService)registry.lookup("notifyFaultSeverityRuleService");
            }
            catch (Exception e) {
                logger.error((Object)"Get NotifyFaultSeverityRuleService interface object failed !", (Throwable)e);
                service = null;
            }
        }
        if (service != null) {
            logger.info((Object)("Get NotifyFaultSeverityRuleService success:" + service));
        }
        return service;
    }

    public ShowCollectorCounterService getShowCollectorCounterService(String collectorIpStr) {
        ShowCollectorCounterService service = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                service = (ShowCollectorCounterService)registry.lookup("showCollectorCounterService");
            }
            catch (IOException e) {
                logger.error((Object)"Get ShowCollectorCounterService interface object failed !", (Throwable)e);
                service = null;
            }
            catch (NotBoundException e) {
                logger.error((Object)"Get ShowCollectorCounterService interface object failed !", (Throwable)e);
                service = null;
            }
        }
        if (service != null) {
            logger.info((Object)("Get ShowCollectorCounterService success:" + service));
        }
        return service;
    }

    public CollectorSendSyslogService getCollectorSendSyslogService(String collectorIpStr) {
        CollectorSendSyslogService service = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                service = (CollectorSendSyslogService)registry.lookup("collectorSendSyslogService");
            }
            catch (Exception e) {
                logger.error((Object)"Get CollectorSendSyslogService interface object failed !", (Throwable)e);
                service = null;
            }
        }
        if (service != null) {
            logger.info((Object)("Get CollectorSendSyslogService success:" + service));
        }
        return service;
    }

    public CollectorLocationDevService getCollectorLocationDevService(String collectorIpStr) {
        CollectorLocationDevService service = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                service = (CollectorLocationDevService)registry.lookup("collectorLocationDevService");
            }
            catch (Exception e) {
                logger.error((Object)"Get CollectorSendSyslogService interface object failed !", (Throwable)e);
                service = null;
            }
        }
        if (service != null) {
            logger.info((Object)("Get CollectorSendSyslogService success:" + service));
        }
        return service;
    }

    public MssConfService getMssConfService(String collectorIpStr) {
        MssConfService service = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                service = (MssConfService)registry.lookup("mssConfService");
            }
            catch (Exception e) {
                logger.error((Object)"Get MssConfService interface object failed !", (Throwable)e);
                service = null;
            }
        }
        if (service != null) {
            logger.info((Object)("Get MssConfService success:" + service));
        }
        return service;
    }

    public FileTransService getFileTransService(String collectorIpStr) {
        FileTransService fileTransService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                fileTransService = (FileTransService)registry.lookup("fileTransService");
            }
            catch (Exception e) {
                logger.error((Object)"getFileTransService interface object failed !", (Throwable)e);
                fileTransService = null;
            }
        }
        return fileTransService;
    }

    public IntelligentDefenseConfigService getIntelligentDefenseService(String collectorIpStr) {
        IntelligentDefenseConfigService intelligentDefenseConfigService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                intelligentDefenseConfigService = (IntelligentDefenseConfigService)registry.lookup(COLLECTOR_INTELLIGENT_DEFENSE_CONFIG_SERVICE);
            }
            catch (Exception e) {
                logger.error((Object)"getIntelligentDefenseService interface object failed !", (Throwable)e);
                intelligentDefenseConfigService = null;
            }
        }
        return intelligentDefenseConfigService;
    }
}

