/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.hcc.impl;

import com.hs.atic.bis.service.IZoneCollectorRmiProxyService;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.rmi.hcc.HccAttackDataEntity;
import com.hs.atic.rmi.hcc.HccAttackDataService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.hcc.model.HccAttackBuffer;
import com.hs.vsm.secservice.hcc.util.HccUtil;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;

public class HccAttackDataServiceImpl
extends UnicastRemoteObject
implements HccAttackDataService {
    private static final long serialVersionUID = 5951655169968578486L;
    private transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private transient HccAttackBuffer buffer;

    protected HccAttackDataServiceImpl() throws RemoteException {
    }

    public HccAttackDataServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, (RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
        IZoneCollectorRmiProxyService proxyService = ZoneReferUtil.getZoneCollectorRmiProxyService();
        this.buffer = proxyService.getHccAttackBuffer();
    }

    @Override
    public void notifyAttackDatas(List<HccAttackDataEntity> attackDatas) throws RemoteException {
        if (null == attackDatas || attackDatas.isEmpty()) {
            this.logger.info((Object)"HccAttackDatas attackList is null");
            return;
        }
        HccUtil.initHccConfig(this.buffer, this.logger);
        if (null == this.buffer || null == this.buffer.getConfigMap() || this.buffer.getConfigMap().get("hccEnable").equals("false")) {
            this.logger.info((Object)"HccAttackDatas CloudUnionBuffer is null or CloudUnionBuffer.isOpen() is false.");
            return;
        }
        this.logger.info((Object)("HccAttackDatas attackList size : " + attackDatas.size()));
        this.logger.info((Object)("HccAttackDatas attackList is : " + attackDatas));
        if (attackDatas.size() > 10000) {
            this.logger.info((Object)"HccAttackDatas attackList size too long");
            return;
        }
        try {
            this.buffer.addCleanLogList(attackDatas);
        }
        catch (Exception e) {
            this.logger.error((Object)"HccAttackDatas error", (Throwable)e);
        }
    }

    public HccAttackBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(HccAttackBuffer buffer) {
        this.buffer = buffer;
    }
}

