/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.bis.dao.ZoneBaseLineStudyDao;
import com.hs.atic.bis.service.IZoneCollectorRmiProxyService;
import com.hs.atic.collector.entity.ServiceLearningTask;
import com.hs.atic.collector.entity.baseline.BaseLineTask;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ColBaseLineOrSrvLearningTaskService;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.sdk.bis.model.ZoneBaseLineStudyInfo;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ServiceLearningParamForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IServiceLearningParamService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;

public class ColBaseLineOrSrvLearningTaskServiceImpl
extends UnicastRemoteObject
implements ColBaseLineOrSrvLearningTaskService {
    private static final long serialVersionUID = -3966283765399734265L;
    private transient ZoneBaseLineStudyDao zoneBaseLineStudyDao;
    private transient ICommonUtilService commonUtilService;
    private transient IZoneService zoneService;
    private transient IServiceLearningParamService serviceLearningParamService;
    private transient IAticDeviceService aticDeviceService;

    protected ColBaseLineOrSrvLearningTaskServiceImpl() throws RemoteException {
    }

    public ColBaseLineOrSrvLearningTaskServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, (RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
        IZoneCollectorRmiProxyService proxyService = (IZoneCollectorRmiProxyService)ServiceContext.getInstance().getService("zoneCollectorRmiProxyService", IZoneCollectorRmiProxyService.class);
        this.zoneBaseLineStudyDao = proxyService.getZoneBaseLineStudyDao();
        this.commonUtilService = proxyService.getCommonUtilService();
        this.zoneService = proxyService.getZoneService();
        this.serviceLearningParamService = proxyService.getServiceLearningParamService();
        this.aticDeviceService = proxyService.getAticDeviceService();
    }

    @Override
    public List<BaseLineTask> getRemoveBaselineTaskByDevId(long devId, String collectorIp) {
        List<ZoneBaseLineStudyInfo> zones = this.zoneBaseLineStudyDao.getBaseLineTaskByDevId(devId);
        ArrayList<BaseLineTask> result = new ArrayList<BaseLineTask>();
        if (null == zones) {
            return result;
        }
        if (null == collectorIp) {
            return null;
        }
        if (!IPUtil.isIpv4((String)collectorIp)) {
            return null;
        }
        for (ZoneBaseLineStudyInfo info : zones) {
            Long zoneId = info.getZoneId();
            List<String> collectorIps = null;
            collectorIps = this.zoneBaseLineStudyDao.getCollectorIpNoSigByZoneId(zoneId, devId);
            if (null != collectorIps && collectorIps.contains(collectorIp)) continue;
            BaseLineTask task = new BaseLineTask();
            task.setPkid(info.getStudyId());
            task.setZoneId(zoneId);
            task.setStartup(false);
            result.add(task);
        }
        return result;
    }

    @Override
    public List<BaseLineTask> getAddBaselineTaskByDevId(long devId) throws RemoteException {
        List<ZoneBaseLineStudyInfo> zones = this.zoneBaseLineStudyDao.getBaseLineTaskByDevId(devId);
        ArrayList<BaseLineTask> result = new ArrayList<BaseLineTask>();
        AticDevice device = this.aticDeviceService.getDeviceByMoid(devId);
        if (null == device) {
            return result;
        }
        if (null == zones) {
            return result;
        }
        return result;
    }

    @Override
    public List<ServiceLearningTask> getSrvLearningTaskByDevId(long devId) throws RemoteException {
        ArrayList<ServiceLearningTask> result = new ArrayList<ServiceLearningTask>();
        AticDevice device = this.aticDeviceService.getDeviceByMoid(devId);
        if (device == null) {
            return result;
        }
        if (!this.commonUtilService.isSupportSrvLearning(device)) {
            return result;
        }
        List<ServiceLearningParamForm> list = this.serviceLearningParamService.getSrvLearningTaskByDev(devId);
        for (ServiceLearningParamForm form : list) {
            ServiceLearningTask task = new ServiceLearningTask();
            task.setStartTime(form.getStartupTime());
            task.setStopTime(form.getStopTime());
            task.setZoneId(Long.parseLong(form.getZoneId()));
            task.setDeviceIp(device.getIpAddress());
            result.add(task);
        }
        return result;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public ICommonUtilService getCommonUtilService() {
        return this.commonUtilService;
    }

    public void setCommonUtilService(ICommonUtilService commonUtilService) {
        this.commonUtilService = commonUtilService;
    }

    public IServiceLearningParamService getServiceLearningParamService() {
        return this.serviceLearningParamService;
    }

    public void setServiceLearningParamService(IServiceLearningParamService serviceLearningParamService) {
        this.serviceLearningParamService = serviceLearningParamService;
    }

    public ZoneBaseLineStudyDao getZoneBaseLineStudyDao() {
        return this.zoneBaseLineStudyDao;
    }

    public void setZoneBaseLineStudyDao(ZoneBaseLineStudyDao zoneBaseLineStudyDao) {
        this.zoneBaseLineStudyDao = zoneBaseLineStudyDao;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }
}

