/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.alarm.entity.ZoneAlarmEntityBuffer;
import com.hs.atic.bis.service.IZoneCollectorRmiProxyService;
import com.hs.atic.collector.entity.alarm.DnsDefendAlarmEntity;
import com.hs.atic.collector.entity.alarm.DynBlistAlarmEntity;
import com.hs.atic.collector.entity.alarm.IpAlarmEntity;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.rmi.ZoneNotifyAlarmService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;

public class ZoneNotifyAlarmServiceImpl
extends UnicastRemoteObject
implements ZoneNotifyAlarmService {
    private static final long serialVersionUID = 7311956924104990848L;
    transient ZoneAlarmEntityBuffer buffer;
    private transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    protected ZoneNotifyAlarmServiceImpl() throws RemoteException {
    }

    public ZoneNotifyAlarmServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, (RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
        IZoneCollectorRmiProxyService proxyService = ZoneReferUtil.getZoneCollectorRmiProxyService();
        this.buffer = proxyService.getAlarmEntityBuffer();
    }

    public ZoneAlarmEntityBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ZoneAlarmEntityBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void notifyAlert(List<IpAlarmEntity> alertList) throws RemoteException {
        if (null == alertList || alertList.isEmpty()) {
            this.logger.info((Object)"notifyAlert alertList is null");
            return;
        }
        this.logger.info((Object)("notifyAlert data size : " + alertList.size()));
        if (alertList.size() > 10000) {
            this.logger.info((Object)"notifyAlert data size to long");
            return;
        }
        try {
            this.buffer.addZoneAlarmList(alertList);
        }
        catch (Exception e) {
            this.logger.error((Object)"notifyAlert error", (Throwable)e);
        }
    }

    @Override
    public void notifyBlackholeAlert(List<IpAlarmEntity> alarmList) throws RemoteException {
        if (null == alarmList || alarmList.isEmpty()) {
            this.logger.info((Object)"notifyBlackholeAlert alertList is null");
            return;
        }
        this.logger.info((Object)("notifyBlackholeAlert data size : " + alarmList.size()));
        for (IpAlarmEntity alarm : alarmList) {
            this.logger.info((Object)("notify blackhole alert:" + alarm.toString()));
        }
        try {
            this.buffer.addZoneBlackholeAlarmList(alarmList);
        }
        catch (Exception e) {
            this.logger.error((Object)"notifyBlackholeAlert error", (Throwable)e);
        }
    }

    @Override
    public void notifyDivertAlert(List<IpAlarmEntity> alarmList) throws RemoteException {
        if (null == alarmList || alarmList.isEmpty()) {
            this.logger.info((Object)"notifyDivertAlert alertList is null");
            return;
        }
        this.logger.info((Object)("notifyDivertAlert data size : " + alarmList.size()));
        for (IpAlarmEntity alarm : alarmList) {
            this.logger.info((Object)("notify divert alert:" + alarm.toString()));
        }
        try {
            this.buffer.addZoneDivertAlarmList(alarmList);
        }
        catch (Exception e) {
            this.logger.error((Object)"notifyDivertAlert error", (Throwable)e);
        }
    }

    @Override
    public void notifyBlacklist(List<DynBlistAlarmEntity> dynAlarm) throws RemoteException {
        if (null == dynAlarm || dynAlarm.isEmpty()) {
            this.logger.info((Object)"notifyBlacklist dynAlarm is null");
            return;
        }
        this.logger.info((Object)("notifyBlacklist data size : " + dynAlarm.size()));
        if (dynAlarm.size() > 10000) {
            this.logger.info((Object)"notifyBlacklist data size to long");
            return;
        }
        try {
            this.buffer.addDynBlackList(dynAlarm);
        }
        catch (Exception e) {
            this.logger.error((Object)"notifyManuleBlist", (Throwable)e);
        }
    }

    @Override
    public void notifyDnsDefendAlert(List<DnsDefendAlarmEntity> dnsDefendAlarmList) throws RemoteException {
        if (null == dnsDefendAlarmList || dnsDefendAlarmList.isEmpty()) {
            this.logger.info((Object)"notifyDnsDefendAlert dnsDefendAlarmList is null");
            return;
        }
        this.logger.info((Object)("notifyDnsDefendAlert data size : " + dnsDefendAlarmList.size()));
        if (dnsDefendAlarmList.size() > 10000) {
            this.logger.info((Object)"notifyDnsDefendAlert data size to long");
            return;
        }
        try {
            this.buffer.addDnsDefendAlarmList(dnsDefendAlarmList);
        }
        catch (Exception e) {
            this.logger.error((Object)"notifyDnsDefendAlert error ", (Throwable)e);
        }
    }
}

