/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.sdk.backup.util;

import com.hs.atic.sdk.backup.exception.ConfigBackupException;
import com.hs.atic.sdk.backup.form.BackupConfig;
import com.hs.atic.sdk.backup.form.BackupFile;
import com.hs.atic.sdk.backup.form.BackupMoInfo;
import com.hs.atic.sdk.backup.form.ConfigBackupDBBean;
import com.hs.atic.sdk.backup.util.BackupConfigUtil;
import com.hs.atic.sdk.backup.util.SystemCmdTool;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class BackupCheckKit {
    public static final char RT = '\n';
    public static final String COMFIRM_CODE = "/*======F\n";
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final String MD_CF = "CF:";
    private static final String MD_FP = "FP:";
    private static final String MD_SIZE = "SIZE:";
    private static final String MD_PREFIX = "/*======";
    private static final String MD_POSTFIX_READ = "*/";
    private static final String MD_POSTFIX_WRITE = "*/\n";
    private static final String FI_PREFIX = "/*######";
    private static final String FI_POSTFIX_READ = "*/";
    private static final String FI_POSTFIX_WRITE = "*/\n";
    private static final String MO_MASTER_COUNT = "WebNmsdbMOCount:";
    private static final String MO_MASTER_MAX_ID = "WebNmsdbMaxMOID:";
    private static final String MO_SLAVE_COUNT = "MOCount:";
    private static final String MO_SLAVE_MAX_ID = "MaxMOID:";
    private static final String FI_VER = "VER:";
    private static final String FI_TIME = "TIME:";
    private static final String FI_NAME = "NAME:";
    private static final String SPACE = " ";

    private BackupCheckKit() {
    }

    public static void setLogger(Log logger) {
        log = logger;
    }

    public static String getFileHash(File file) throws ConfigBackupException {
        if (!file.isFile()) {
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                log.error((Object)"getCanonicalPath() throws IOException", (Throwable)e);
            }
            throw new ConfigBackupException(571605, new String[]{path});
        }
        MessageDigest digest = null;
        FileInputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            int len;
            digest = MessageDigest.getInstance("SHA-256");
            in = new FileInputStream(file);
            while ((len = in.read(buffer, 0, 1024)) != -1) {
                digest.update(buffer, 0, len);
            }
            BigInteger bigInt = new BigInteger(1, digest.digest());
            String string = bigInt.toString(16);
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConfigBackupException(571607, new String[]{"SHA-256"}, e);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("getCanonicalPath() throws IOException" + file.getName()));
            throw new ConfigBackupException(571604, (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"getCanonicalPath() throws IOException", (Throwable)e);
            throw new ConfigBackupException(571606, (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static String getFileHashMD(File file) throws ConfigBackupException {
        if (!file.isFile()) {
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                log.error((Object)"getCanonicalPath() throws IOException", (Throwable)e);
            }
            throw new ConfigBackupException(571605, new String[]{path});
        }
        MessageDigest digest = null;
        FileInputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            int len;
            digest = MessageDigest.getInstance("MD5");
            in = new FileInputStream(file);
            while ((len = in.read(buffer, 0, 1024)) != -1) {
                digest.update(buffer, 0, len);
            }
            BigInteger bigInt = new BigInteger(1, digest.digest());
            String string = bigInt.toString(16);
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConfigBackupException(571607, new String[]{"SHA-256"}, e);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("getCanonicalPath() throws IOException" + file.getName()));
            throw new ConfigBackupException(571604, (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"getCanonicalPath() throws IOException", (Throwable)e);
            throw new ConfigBackupException(571606, (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static BackupFile fileFingerprintGeneratorWithInfo(String filePath, String fileName, String version, Long backuptime, BackupMoInfo bmo) throws ConfigBackupException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new ConfigBackupException(571604, new String[]{filePath});
        }
        if (!file.isFile()) {
            throw new ConfigBackupException(571605, new String[]{filePath});
        }
        BackupFile backupFile = new BackupFile();
        backupFile.setFilePath(filePath);
        backupFile.setVersion(version);
        backupFile.setBackupTime(backuptime);
        backupFile.setBackupMoInfo(bmo);
        backupFile.setFileName(fileName);
        SystemCmdTool.appendInfoToFile(backupFile);
        String fileFingerprint = BackupCheckKit.getFileHash(file);
        backupFile.setFingerprint(fileFingerprint);
        backupFile.setSize(file.length());
        return backupFile;
    }

    public static String fileFingerprintGenerator(String filePath) throws ConfigBackupException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new ConfigBackupException(571604, new String[]{filePath});
        }
        if (!file.isFile()) {
            throw new ConfigBackupException(571605, new String[]{filePath});
        }
        String fileFingerprint = BackupCheckKit.getFileHash(file);
        return fileFingerprint;
    }

    public static String getBackupFileFPInfo(ConfigBackupDBBean bean) throws ConfigBackupException {
        String backupFileFP = bean.getFileHashCode();
        String fingerprint = BackupCheckKit.fileFingerprintGenerator(bean.getBackupBase());
        File file = new File(bean.getBackupBase());
        log.info((Object)("getBackupFileFPInfo-> file:" + bean.getBackupBase() + " backupFileFP:" + backupFileFP + " fingerprint:" + fingerprint));
        if (!fingerprint.equals(backupFileFP)) {
            throw new ConfigBackupException(571609, new String[]{bean.getBackupBase()});
        }
        StringBuffer buff = new StringBuffer();
        buff.append(MD_PREFIX).append(MD_FP).append(backupFileFP).append(SPACE);
        buff.append(MD_SIZE).append(file.length()).append(SPACE).append("*/\n");
        return buff.toString();
    }

    public static String getBackupFileInfo(BackupFile backupFile) throws ConfigBackupException {
        String backupFileVersion = backupFile.getVersion();
        String backupTime = String.valueOf(backupFile.getBackupTime());
        String backupFileName = backupFile.getFileName();
        BackupMoInfo bmo = backupFile.getBackupMoInfo();
        StringBuffer buff = new StringBuffer();
        buff.append(FI_PREFIX).append(MO_SLAVE_COUNT).append(bmo.getMoCount()).append(SPACE).append(MO_SLAVE_MAX_ID).append(bmo.getMaxMOId()).append(SPACE).append(MO_MASTER_COUNT).append(SPACE).append(MO_MASTER_MAX_ID).append(SPACE).append(FI_VER).append(backupFileVersion).append(SPACE).append(FI_TIME).append(backupTime).append(SPACE).append(FI_NAME).append(backupFileName).append(SPACE).append("*/\n");
        return buff.toString();
    }

    public static void getFpCodeFromFile(String fpInfo, BackupFile fileInfoObj) throws ConfigBackupException {
        try {
            log.info((Object)("getFpCodeFromFile-> fpInfo:" + fpInfo));
            String fpCode = fpInfo.substring(fpInfo.indexOf(MD_FP) + MD_FP.length(), fpInfo.indexOf(MD_SIZE) - 1);
            String fileSize = fpInfo.substring(fpInfo.indexOf(MD_SIZE) + MD_SIZE.length(), fpInfo.indexOf("*/") - 1);
            fileInfoObj.setFingerprint(fpCode);
            fileInfoObj.setSize(Long.parseLong(fileSize));
        }
        catch (Exception e) {
            throw new ConfigBackupException(571608, (Throwable)e);
        }
    }

    public static BackupFile getFileInfoFromUploadFile(String fileInfo, String fpInfo, boolean isOnlyFileInfo) throws ConfigBackupException {
        BackupFile fileInfoObj = new BackupFile();
        try {
            String slaveCount = fileInfo.substring(fileInfo.indexOf(MO_SLAVE_COUNT) + MO_SLAVE_COUNT.length(), fileInfo.indexOf(MO_SLAVE_MAX_ID) - 1);
            String slaveMaxId = fileInfo.substring(fileInfo.indexOf(MO_SLAVE_MAX_ID) + MO_SLAVE_MAX_ID.length(), fileInfo.indexOf(MO_MASTER_COUNT) - 1);
            String version = fileInfo.substring(fileInfo.indexOf(FI_VER) + FI_VER.length(), fileInfo.indexOf(FI_TIME) - 1);
            String fileTime = fileInfo.substring(fileInfo.indexOf(FI_TIME) + FI_TIME.length(), fileInfo.indexOf(FI_NAME) - 1);
            String fileName = fileInfo.substring(fileInfo.indexOf(FI_NAME) + FI_NAME.length(), fileInfo.indexOf("*/") - 1);
            if (!isOnlyFileInfo) {
                BackupCheckKit.getFpCodeFromFile(fpInfo, fileInfoObj);
            }
            BackupMoInfo backupMoInfo = new BackupMoInfo();
            backupMoInfo.setMaxMOId(Integer.parseInt(slaveMaxId));
            backupMoInfo.setMoCount(Integer.parseInt(slaveCount));
            fileInfoObj.setFileName(fileName);
            fileInfoObj.setBackupTime(Long.valueOf(fileTime));
            fileInfoObj.setVersion(version);
            fileInfoObj.setBackupMoInfo(backupMoInfo);
            return fileInfoObj;
        }
        catch (ConfigBackupException e) {
            throw new ConfigBackupException(571610, (Throwable)e);
        }
    }

    public static void checkFingerprintFromUploadFile(BackupFile fileInfo, String comfirmCode, String comfirmInfo) throws ConfigBackupException {
        String cfCode = "";
        try {
            cfCode = comfirmInfo.substring(comfirmInfo.indexOf(MD_CF) + MD_CF.length(), comfirmInfo.indexOf("*/") - 1);
        }
        catch (Exception e) {
            log.error((Object)"comfirmInfo.substring error", (Throwable)e);
        }
        log.info((Object)("checkFingerprintFromUploadFile -> cfCode:" + cfCode + " comfirmCode:" + comfirmCode));
        if (!comfirmCode.equals(cfCode)) {
            SystemCmdTool.deleteFile(fileInfo.getFilePath());
            throw new ConfigBackupException(571611);
        }
        String upfp = BackupCheckKit.fileFingerprintGenerator(fileInfo.getFilePath());
        log.info((Object)("checkFingerprintFromUploadFile -> upfp:" + upfp + " fp:" + fileInfo.getFingerprint()));
        if (!upfp.equals(fileInfo.getFingerprint())) {
            SystemCmdTool.deleteFile(fileInfo.getFilePath());
            throw new ConfigBackupException(571632);
        }
    }

    public static byte[] getFileConfirmInfo(String cf) {
        StringBuffer flagbuff = new StringBuffer();
        String csn = Charset.defaultCharset().name();
        flagbuff.append(MD_PREFIX).append(MD_CF).append(cf).append(SPACE).append("*/\n");
        byte[] byts = null;
        try {
            byts = flagbuff.toString().getBytes(csn);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
        }
        return byts;
    }

    public static boolean isMatchFileInfo(String info) {
        int hdindex = info.indexOf(FI_PREFIX);
        int scindex = info.indexOf(MO_SLAVE_COUNT);
        int smiindex = info.indexOf(MO_SLAVE_MAX_ID);
        int verindex = info.indexOf(FI_VER);
        int rtindex = info.indexOf("*/");
        return hdindex == 0 && scindex > hdindex && smiindex > scindex && rtindex > verindex;
    }

    public static boolean isMatchFingerPrint(String info) {
        int hdindex = info.indexOf(MD_PREFIX);
        int fpindex = info.indexOf(MD_FP);
        int szindex = info.indexOf(MD_SIZE);
        int rtindex = info.indexOf("*/");
        return hdindex == 0 && hdindex < fpindex && fpindex < szindex && szindex < rtindex;
    }

    public static boolean isMatchCF(String info) {
        int hdindex = info.indexOf(MD_PREFIX);
        int cfindex = info.indexOf(MD_CF);
        int rtindex = info.indexOf("*/");
        return hdindex == 0 && hdindex < cfindex && cfindex < rtindex;
    }

    public static void isMoCheckSuccess(int moResult, int checkedMOResult) throws ConfigBackupException {
        log.info((Object)("isMoCheckSuccess(2)-> moResult:" + moResult + " checkedMOResult:" + checkedMOResult));
        BackupConfig backupConfig = BackupConfigUtil.getCurrentBackupConfig();
        if ("loose".equalsIgnoreCase(backupConfig.getMoCheckMode())) {
            if (moResult != 1 && moResult != 2) {
                throw new ConfigBackupException(571612);
            }
            if (moResult == 1 && checkedMOResult == 2) {
                throw new ConfigBackupException(571613);
            }
        } else if (moResult != 2) {
            throw new ConfigBackupException(571613);
        }
    }

    public static void isMoCheckSuccess(int moResult) throws ConfigBackupException {
        log.info((Object)("isMoCheckSuccess(1)-> moResult:" + moResult));
        BackupConfig backupConfig = BackupConfigUtil.getCurrentBackupConfig();
        if ("loose".equalsIgnoreCase(backupConfig.getMoCheckMode())) {
            if (moResult != 2 && moResult != 1) {
                throw new ConfigBackupException(571612);
            }
        } else if (moResult != 2) {
            throw new ConfigBackupException(571613);
        }
    }

    public static int checkMOForRestore(BackupMoInfo backupFileMO, BackupMoInfo currentMOInfo) throws ConfigBackupException {
        log.info((Object)"checkMOForRestore start");
        if (null == backupFileMO || null == currentMOInfo) {
            throw new ConfigBackupException(571614);
        }
        log.info((Object)("checkMOForRestore-> backupFileMO.getMaxMOId():" + backupFileMO.getMaxMOId() + " currentMOInfo.getMaxMOId():" + currentMOInfo.getMaxMOId()));
        log.info((Object)("checkMOForRestore-> backupFileMO.getMoCount():" + backupFileMO.getMoCount() + " currentMOInfo.getMoCount():" + currentMOInfo.getMoCount()));
        if (backupFileMO.getMaxMOId() < currentMOInfo.getMaxMOId() || backupFileMO.getMoCount() < currentMOInfo.getMoCount()) {
            return 0;
        }
        if (backupFileMO.getMaxMOId() >= currentMOInfo.getMaxMOId() && backupFileMO.getMoCount() > currentMOInfo.getMoCount()) {
            return 1;
        }
        if (backupFileMO.getMaxMOId() == currentMOInfo.getMaxMOId() && backupFileMO.getMoCount() == currentMOInfo.getMoCount()) {
            return 2;
        }
        return 3;
    }

    public static void checkMOForBackup(BackupMoInfo bmo, BackupMoInfo amo) throws ConfigBackupException {
        if (null == bmo || null == amo) {
            throw new ConfigBackupException(571615);
        }
        if (bmo.getMaxMOId() != amo.getMaxMOId() || bmo.getMoCount() != amo.getMoCount()) {
            throw new ConfigBackupException(571616);
        }
    }
}

