/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.sdk.zone.util;

import com.hs.atic.sdk.zone.util.ProgressState;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public final class ProgressManage {
    private static final ProgressManage MGR = new ProgressManage();
    private static ReentrantLock lock = new ReentrantLock();
    private Map<Long, ProgressState> progressCollection = new HashMap<Long, ProgressState>();

    private ProgressManage() {
    }

    public Map<Long, ProgressState> getProgressCollection() {
        lock.lock();
        try {
            Map<Long, ProgressState> map = this.progressCollection;
            return map;
        }
        finally {
            lock.unlock();
        }
    }

    public void setProgressCollection(Map<Long, ProgressState> progressCollection) {
        lock.lock();
        try {
            this.progressCollection = progressCollection;
        }
        finally {
            lock.unlock();
        }
    }

    public static ProgressManage getInstance() {
        return MGR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressState createProgress(int totalStep, long id) {
        lock.lock();
        try {
            ProgressState progressState = new ProgressState(totalStep, id);
            this.progressCollection.put(id, progressState);
            ProgressState progressState2 = progressState;
            return progressState2;
        }
        finally {
            lock.unlock();
        }
    }

    public ProgressState getProgressState(Long id) {
        lock.lock();
        try {
            ProgressState progressState = this.progressCollection.get(id);
            return progressState;
        }
        finally {
            lock.unlock();
        }
    }

    public void removeProgressState(Long id) {
        lock.lock();
        try {
            if (this.progressCollection.containsKey(id)) {
                this.progressCollection.remove(id);
            }
        }
        finally {
            lock.unlock();
        }
    }
}

