/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.bis.dao.LibraryFileDao;
import com.hs.atic.bis.dao.LocationCustomDao;
import com.hs.atic.bis.model.LibraryFile;
import com.hs.atic.bis.model.LocationCustom;
import com.hs.atic.sdk.bis.service.ILibraryFileService;
import com.hs.atic.util.IpLocationUtil;
import com.hs.atic.util.LibFilePathUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;

public class InitLocationCustomPkid
implements InitializingBean {
    public static final String LOCATION_SDB_FILE_NAME = "location_sdb_default.zip";
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private LocationCustomDao locationCustomDao;
    private ILibraryFileService libraryFileService;
    private LibraryFileDao libraryFileDao;

    public void afterPropertiesSet() {
        this.setPkidFromNum();
        this.loadIpLocationToMemery();
    }

    private void loadIpLocationToMemery() {
        this.processIpLocationLibFile();
        this.processIpLocationCustom();
    }

    private void processIpLocationLibFile() {
        String libFilePath = LibFilePathUtil.getLibFilePath();
        LibraryFile libFile = this.libraryFileDao.getDeployedIpLocationFile();
        libFilePath = null == libFile ? libFilePath + LOCATION_SDB_FILE_NAME : libFilePath + libFile.getLibName();
        IpLocationUtil.loadIpLocFileDataToMemery(libFilePath);
    }

    private void processIpLocationCustom() {
        List<LocationCustom> locCusList = this.locationCustomDao.getAll();
        for (LocationCustom locCus : locCusList) {
            IpLocationUtil.loadIpLocCusDataToMemery(locCus);
        }
    }

    private void setPkidFromNum() {
        String setTablePkidStartNumHQL = "ALTER TABLE t_atic_location_custom AUTO_INCREMENT=3000";
        try {
            this.locationCustomDao.updateBySql("ALTER TABLE t_atic_location_custom AUTO_INCREMENT=3000");
            this.logger.info((Object)"ALTER TABLE t_atic_location_custom AUTO_INCREMENT=3000");
        }
        catch (Exception e) {
            this.logger.error((Object)"setPkidFromNum Error ALTER TABLE t_atic_location_custom AUTO_INCREMENT=3000");
        }
    }

    public LocationCustomDao getLocationCustomDao() {
        return this.locationCustomDao;
    }

    public void setLocationCustomDao(LocationCustomDao locationCustomDao) {
        this.locationCustomDao = locationCustomDao;
    }

    public ILibraryFileService getLibraryFileService() {
        return this.libraryFileService;
    }

    public void setLibraryFileService(ILibraryFileService libraryFileService) {
        this.libraryFileService = libraryFileService;
    }

    public LibraryFileDao getLibraryFileDao() {
        return this.libraryFileDao;
    }

    public void setLibraryFileDao(LibraryFileDao libraryFileDao) {
        this.libraryFileDao = libraryFileDao;
    }
}

