/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.bis.model.LocationCustom;
import com.hs.atic.sdk.bis.form.IpLocation;
import com.hs.atic.sdk.bis.service.ILocationCustomService;
import com.hs.atic.util.AticConstants;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.ZipUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public final class IpLocationUtil {
    private static Map<Long, IpLocation> ipLocationMap = new TreeMap<Long, IpLocation>();
    private static Map<String, IpLocation> ipLocationMapTemp = new TreeMap<String, IpLocation>();
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static ILocationCustomService locationCustomService;
    private static final int IPV4_ADDRESS_LENGTH = 4;
    private static final int COLUMN_NUM = 7;
    private static final String OTHER_LOCATION = "0";
    private static final String COUNTRY_LOCATION = "0000";
    private static final String COUNTRY_PART = "000000";
    private static final String SPRIT = "/";

    private IpLocationUtil() {
    }

    /*
     * Exception decompiling
     */
    public static void loadIpLocFileDataToMemery(String libFileAllPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void copyMap(Map<String, IpLocation> map) {
        for (Map.Entry<String, IpLocation> entry : map.entrySet()) {
            if (entry.getKey().equals(OTHER_LOCATION) || entry.getKey().endsWith(COUNTRY_PART)) {
                IpLocation ipLocation = entry.getValue();
                ipLocation.setLocationNameZh(SPRIT + ipLocation.getLocationNameZh());
                ipLocation.setLocationNameEn(SPRIT + ipLocation.getLocationNameEn());
                ipLocation.setCountry(true);
                ipLocationMap.put(ipLocation.getLocationId(), ipLocation);
                continue;
            }
            if (!entry.getKey().endsWith(COUNTRY_LOCATION)) continue;
            String country = entry.getKey().substring(0, 1);
            String locationNameZh = map.get(country + COUNTRY_PART).getLocationNameZh() + SPRIT + entry.getValue().getLocationNameZh();
            String locationNameEn = map.get(country + COUNTRY_PART).getLocationNameEn() + SPRIT + entry.getValue().getLocationNameEn();
            IpLocation ipLocation = entry.getValue();
            ipLocation.setShortName(map.get(country + COUNTRY_PART).getShortName());
            ipLocation.setLocationNameZh(locationNameZh);
            ipLocation.setLocationNameEn(locationNameEn);
            ipLocationMap.put(ipLocation.getLocationId(), ipLocation);
        }
    }

    private static void closeInputStream(InputStream input) {
        if (null != input) {
            try {
                input.close();
            }
            catch (IOException e) {
                logger.error((Object)"close InputStream IOException:", (Throwable)e);
            }
            finally {
                input = null;
            }
        }
    }

    private static void closeReader(Reader reader) {
        if (null != reader) {
            try {
                reader.close();
            }
            catch (IOException e) {
                logger.error((Object)"close reader IOException:", (Throwable)e);
            }
            finally {
                reader = null;
            }
        }
    }

    public static void loadIpLocCusDataToMemery(LocationCustom locCus) {
        if (null == locCus) {
            return;
        }
        IpLocation ipLocation = new IpLocation();
        ipLocation.setLocationId(locCus.getPkId());
        ipLocation.setLocationType("Location_Custom");
        ipLocation.setLocationMask(locCus.getPkId());
        ipLocation.setLocationNameZh(locCus.getLocationName());
        ipLocation.setLocationNameEn(locCus.getLocationName());
        ipLocation.setShortName("");
        ipLocation.setLongitude(locCus.getLongitude());
        ipLocation.setLatitude(locCus.getLatitude());
        boolean hasSameName = false;
        long sameNameCountryId = 0L;
        for (Map.Entry<Long, IpLocation> entry : ipLocationMap.entrySet()) {
            IpLocation temp = entry.getValue();
            if (null == temp || !"Location_Custom".equals(temp.getLocationType()) || !ipLocation.getLocationNameZh().equals(temp.getLocationNameZh())) continue;
            hasSameName = true;
            sameNameCountryId = entry.getKey();
        }
        if (hasSameName) {
            ipLocationMap.remove(sameNameCountryId);
        }
        ipLocationMap.put(locCus.getPkId(), ipLocation);
    }

    private static boolean deleteFileDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            if (null != children) {
                for (int i = 0; i < children.length; ++i) {
                    boolean success = IpLocationUtil.deleteFileDir(new File(dir, children[i]));
                    if (success) continue;
                    return false;
                }
            } else {
                return true;
            }
        }
        return dir.delete();
    }

    private static void setIpLocationDataToMap(String lineContent) {
        String locationType = "Lib_Location";
        IpLocation ipLocation = new IpLocation();
        long countryIdFromDev = 0L;
        try {
            String[] info = lineContent.split(",");
            if (7 != info.length) {
                return;
            }
            long locationMask = Long.parseLong(info[1].replace("\"", "").trim());
            String locationNameZh = info[2].replace("\"", "").trim();
            String locationNameEn = info[3].replace("\"", "").trim();
            String shortName = info[4].replace("\"", "").trim();
            BigDecimal longitude = new BigDecimal(info[5].replace("\"", "").trim());
            BigDecimal latitude = new BigDecimal(info[6].replace("\"", "").trim());
            if (0L == locationMask) {
                locationNameZh = locationNameZh + "(\u5305\u542b\u79c1\u7f51\u5730\u5740)";
                locationNameEn = locationNameEn + "(including private IP addresses)";
            }
            if (!IpLocationUtil.isCountryName(locationNameZh)) {
                return;
            }
            if (!IpLocationUtil.isCountryName(locationNameEn)) {
                return;
            }
            if (!AticUtil.isNull((String)shortName) && !shortName.matches("^[A-Za-z]+$")) {
                return;
            }
            ipLocation.setLocationType(locationType);
            ipLocation.setLocationMask(locationMask);
            ipLocation.setLocationNameZh(locationNameZh);
            ipLocation.setLocationNameEn(locationNameEn);
            ipLocation.setShortName(shortName);
            ipLocation.setLongitude(longitude);
            ipLocation.setLatitude(latitude);
            String locationMaskStr = Long.toHexString(locationMask);
            if (0L == locationMask || !AticUtil.isNull((String)shortName)) {
                if (locationMaskStr.length() > 6) {
                    countryIdFromDev = Long.parseLong(locationMaskStr.substring(0, locationMaskStr.length() - 6), 16);
                }
                ipLocation.setLocationId(countryIdFromDev);
                ipLocationMapTemp.put(locationMaskStr, ipLocation);
            } else if (locationMaskStr.contains(COUNTRY_LOCATION)) {
                countryIdFromDev = Long.parseLong(locationMaskStr.substring(1, locationMaskStr.length() - 4), 16);
                ipLocation.setLocationId(countryIdFromDev + 512L);
                ipLocationMapTemp.put(locationMaskStr, ipLocation);
            }
        }
        catch (Exception e) {
            logger.error((Object)("setIpLocationDataToMap unknow error:" + e));
        }
    }

    private static boolean isCountryName(String fileName) {
        return fileName.matches("^[\\u4e00-\\u9fa5a-zA-Z\\.\\-\\'\\(\\)\\ ]{1,}$");
    }

    private static String checkLibFileIsRight(String libFileAllPath) {
        String filePath = "";
        try {
            File locationFile;
            String pathZip = libFileAllPath;
            String unZipPath = pathZip.substring(0, pathZip.lastIndexOf("."));
            ZipUtil.unZip(pathZip, unZipPath);
            if (IpLocationUtil.createFile(unZipPath) && (locationFile = new File(unZipPath)).isDirectory()) {
                String[] files = locationFile.list();
                if (null != files) {
                    if (3 == files.length) {
                        boolean fileIsRight = true;
                        for (String file : files) {
                            if (AticConstants.LOCATION_FILE_NAME.contains(file.toLowerCase(Locale.getDefault()))) continue;
                            fileIsRight = false;
                            break;
                        }
                        if (fileIsRight) {
                            logger.info((Object)"location lib file is right: ");
                            filePath = unZipPath;
                        } else {
                            logger.error((Object)"location lib file is wrong: ");
                        }
                    } else {
                        logger.error((Object)"location lib file does not continue three file: ");
                    }
                } else {
                    logger.error((Object)"location lib file does not continue three file: ");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("checkLibFileIsRight unknow error:" + e));
        }
        return filePath;
    }

    private static boolean createFile(String importPath) {
        File file = new File(importPath);
        if (!file.exists()) {
            boolean ret = file.mkdir();
            return ret;
        }
        return true;
    }

    public static String getCountryName(String srcIp, String language, String deviceIp) {
        logger.info((Object)"begin getCountryName()...");
        Map<Long, IpLocation> map = ipLocationMap;
        if (null == locationCustomService) {
            locationCustomService = ZoneReferUtil.getLocationCustomService();
        }
        if (AticUtil.isNull((String)srcIp)) {
            return "";
        }
        String unknownLocStr = "";
        unknownLocStr = language.equals("zh") ? map.get(0L).getLocationNameZh() : map.get(0L).getLocationNameEn();
        String[] ids = srcIp.split(",");
        StringBuffer sb = new StringBuffer();
        for (String idTemp : ids) {
            Long locationIdFromDev = null;
            String id = idTemp.trim();
            if (IpLocationUtil.isNumebr(id)) {
                locationIdFromDev = Long.valueOf(id);
            } else {
                String[] idStr = id.split("\\.");
                if (!(4 == idStr.length && IpLocationUtil.isNumebr(idStr[0].trim()) && IpLocationUtil.isNumebr(idStr[1].trim()) && IpLocationUtil.isNumebr(idStr[2].trim()) && IpLocationUtil.isNumebr(idStr[3].trim()))) {
                    logger.error((Object)("Location Attack srcIp is wrong. srcIp =  " + id));
                    sb.append(unknownLocStr + id + ";");
                    continue;
                }
                Long id0 = Long.valueOf(idStr[0].trim());
                Long id1 = Long.valueOf(idStr[1].trim());
                Long id2 = Long.valueOf(idStr[2].trim());
                Long id3 = Long.valueOf(idStr[3].trim());
                locationIdFromDev = id0 * 0x1000000L + id1 * 65536L + id2 * 256L + id3;
            }
            Long aticLocationId = null;
            aticLocationId = (long)AticConstants.FROMDEV_SELF_DEFINED_LOCATION_STRAT_ID.intValue() <= locationIdFromDev ? locationCustomService.findIdByIdFromDev(locationIdFromDev, deviceIp) : locationIdFromDev;
            if (null == aticLocationId) {
                sb.append(unknownLocStr + locationIdFromDev + ";");
                continue;
            }
            IpLocation ipLocation = map.get(aticLocationId);
            if (null == ipLocation) {
                sb.append(unknownLocStr + locationIdFromDev + ";");
                continue;
            }
            if (language.equals("zh")) {
                sb.append(ipLocation.getLocationNameZh()).append(';');
                continue;
            }
            sb.append(ipLocation.getLocationNameEn()).append(';');
        }
        logger.info((Object)("end getCountryName()..." + sb.toString()));
        return sb.toString();
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equalsIgnoreCase(str);
    }

    public static boolean isNumebr(String str) {
        String regex = "^[0-9]*$";
        return !IpLocationUtil.isNull(str) && str.matches(regex);
    }

    public static Map<Long, IpLocation> getIpLocationMap() {
        return ipLocationMap;
    }
}

