/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.dao;

import com.hs.atic.zone.util.ZoneUtil;
import com.hs.lego.core.sdk.comm.Paging;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class BaseDao<T, PK extends Serializable>
extends HibernateDaoSupport {
    protected Class<T> persistentClass;

    public BaseDao(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    public List<T> findPageByHql(final String hql, final int start, final int pageSize) {
        return (List)new HibernateTemplate(this.getSessionFactory()).execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery(hql);
                query.setFirstResult(start);
                if (pageSize != 0) {
                    query.setMaxResults(pageSize);
                }
                return query.list();
            }
        });
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        String hql = this.initQuery(queryMap, new StringBuffer());
        List<T> list = this.findPageByHql(hql, start, pageSize);
        Paging page = new Paging();
        page.setData(list);
        page.setCount(this.getRowCountByHsql(this.generateRowCountSqlByHsql(hql)));
        return page;
    }

    public void remove(PK id) {
        this.getHibernateTemplate().delete(this.get(id));
    }

    public T get(PK id) {
        return (T)this.getHibernateTemplate().get(this.persistentClass, id);
    }

    public T save(T object) {
        return (T)this.getHibernateTemplate().merge(object);
    }

    public List<T> getAll() {
        return this.findByHql(this.basicHql());
    }

    protected String generateRowCountSqlByHsql(String hsql) {
        String hsqlLowerCase = hsql.toLowerCase(Locale.getDefault());
        int sqlFrom = hsqlLowerCase.indexOf("from ");
        int sqlOrderby = hsqlLowerCase.lastIndexOf("order by");
        int sqlGroupby = hsqlLowerCase.lastIndexOf("group by");
        String rowCountSql = "";
        rowCountSql = sqlOrderby > 0 ? "select count(*) AS rowCount " + hsql.substring(sqlFrom, sqlOrderby) : (sqlGroupby > 0 ? "select count(*) from (select count(*) AS rowCount " + hsql.substring(sqlFrom) + ") as tab" : "select count(*) AS rowCount " + hsql.substring(sqlFrom));
        return rowCountSql;
    }

    protected String generateRowCountForReportByHsql(String hsql) {
        String hsqlLowerCase = hsql.toLowerCase(Locale.getDefault());
        int sqlFrom = hsqlLowerCase.indexOf("from ");
        int sqlOrderby = hsqlLowerCase.lastIndexOf("order by");
        int sqlGroupby = hsqlLowerCase.lastIndexOf("group by");
        String rowCountSql = "";
        rowCountSql = sqlOrderby > 0 ? "select count(distinct zoneInfo) AS rowCount " + hsql.substring(sqlFrom, sqlOrderby) : (sqlGroupby > 0 ? "select count(*) from (select count(distinct zoneInfo) AS rowCount " + hsql.substring(sqlFrom) + ") as tab" : "select count(distinct zoneInfo) AS rowCount " + hsql.substring(sqlFrom));
        return rowCountSql;
    }

    public int getRowCountByHsql(String hsql) {
        return Integer.parseInt(super.getHibernateTemplate().find(this.generateRowCountSqlByHsql(hsql), new Object[0]).get(0).toString());
    }

    public int getAllZoneCount() {
        String hql = "select count(zi.zoneId) from ZoneInfo zi";
        int allZoneSize = 0;
        List zoneIdList = super.getHibernateTemplate().find(hql, new Object[0]);
        if (zoneIdList != null && !zoneIdList.isEmpty()) {
            allZoneSize = ((Long)zoneIdList.get(0)).intValue();
        }
        return allZoneSize;
    }

    public int getRowCountForReportByHsql(String hsql) {
        return Integer.parseInt(super.getHibernateTemplate().find(this.generateRowCountForReportByHsql(hsql), new Object[0]).get(0).toString());
    }

    public List<T> findByHql(String hql) {
        return super.getHibernateTemplate().find(hql, new Object[0]);
    }

    public List<T> findByHql(String hql, Object object) {
        return super.getHibernateTemplate().find(hql, new Object[]{object});
    }

    protected String initQuery(Map<String, String> queryMap, StringBuffer hql) {
        this.basicHql(hql);
        this.conditionHql(queryMap, hql);
        this.sortHql(queryMap, hql);
        return hql.toString();
    }

    protected void conditionHql(Map<String, String> queryMap, StringBuffer hql) {
    }

    protected String basicHql() {
        StringBuffer hql = new StringBuffer();
        this.basicHql(hql);
        return hql.toString();
    }

    private void basicHql(StringBuffer hql) {
        hql.append("from ").append(this.persistentClass.getSimpleName());
    }

    protected void sortHql(Map<String, String> queryMap, StringBuffer hql) {
        String sortType = queryMap.get("sortType");
        String sortName = queryMap.get("sortName");
        if (!ZoneUtil.isNull(sortType) && !ZoneUtil.isNull(sortName)) {
            String regular = "^[A-Za-z0-9|_]+$";
            if (Pattern.matches(regular, sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
                hql.append(" order by ").append("lower(" + sortName + ")").append(' ').append(sortType);
            }
        } else {
            hql.append(" order by ").append("zoneId").append(' ').append("desc");
        }
    }
}

