/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.dao;

import com.hs.atic.zone.dao.BaseDao;
import com.hs.atic.zone.model.ZoneInfo;
import com.hs.atic.zone.util.ZoneConstants;
import java.util.List;

public class SigZoneInfoDao
extends BaseDao<ZoneInfo, Long> {
    public SigZoneInfoDao() {
        super(ZoneInfo.class);
    }

    public List<ZoneInfo> findZoneInfoByZoneDesc(String zoneDesc) {
        String hql = "from ZoneInfo zi where zi.zoneDesc = ?";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneDesc});
    }

    public List<ZoneInfo> findZoneInfoByZoneDescExcepteZoneId(long zoneId, String zoneDesc) {
        String hql = "from ZoneInfo zi where zi.zoneDesc = ? and zi.zoneId <> ?";
        Object[] objArr = new Object[]{zoneDesc, zoneId};
        return this.getHibernateTemplate().find(hql, objArr);
    }

    public List<ZoneInfo> findZoneInfoByZoneName(String zoneName) {
        String hql = "from ZoneInfo zi where zi.zoneName = ?";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneName});
    }

    public int getZoneCounts() {
        String hql = "from ZoneInfo";
        return this.getRowCountByHsql(hql);
    }

    public void deleteById(Long id) {
        this.remove(id);
    }

    public ZoneInfo saveZoneInfo(ZoneInfo zoneInfo) {
        return (ZoneInfo)this.getHibernateTemplate().save((Object)zoneInfo);
    }

    public ZoneInfo getByZoneId(Long id) {
        List result = this.getHibernateTemplate().find("from ZoneInfo where zoneId = ?", new Object[]{id});
        return result.isEmpty() ? new ZoneInfo() : (ZoneInfo)result.get(0);
    }

    public List<ZoneInfo> getAllSigZone() {
        String hql = "from ZoneInfo where zoneType = ? ";
        return this.getHibernateTemplate().find(hql, new Object[]{ZoneConstants.ZONE_TYPE_SIG});
    }

    public List<ZoneInfo> getByZoneNameAndDesc(String sigZoneName, String sigZoneDesc) {
        String hql = "from ZoneInfo where zoneType = ? and zoneName = ? and zoneDesc = ?";
        Object[] objArr = new Object[]{ZoneConstants.ZONE_TYPE_SIG, sigZoneName, sigZoneDesc};
        return this.getHibernateTemplate().find(hql, objArr);
    }
}

