/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.dao;

import com.hs.atic.zone.dao.BaseDao;
import com.hs.atic.zone.model.ZoneIpInfo;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import java.util.List;

public class SigZoneIpDao
extends BaseDao<ZoneIpInfo, Long> {
    public SigZoneIpDao() {
        super(ZoneIpInfo.class);
    }

    public List<ZoneIpInfo> getZoneIpListByZoneIdAndStartIpAndEndIp(long zoneId, String startIp, String endIp) {
        String hql = "from ZoneIpInfo zi where zi.zoneId = ? and zi.startIp >= ? and zi.endIp <= ? and LENGTH(zi.startIp) = ? AND LENGTH(zi.endIp) = ?";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId, IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)endIp), (long)IPUtil4Atic.convert2CompleteIp((String)startIp).length(), (long)IPUtil4Atic.convert2CompleteIp((String)endIp).length()});
    }

    public void deleteByZoneIdAndStartIpAndEndIp(long zoneId, String startIp, String endIp) {
        String hql = "delete from ZoneIpInfo zi where zi.zoneId = ? and zi.startIp >= ? and zi.endIp <= ? and LENGTH(zi.startIp) = ? AND LENGTH(zi.endIp) = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId, IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)endIp), (long)IPUtil4Atic.convert2CompleteIp((String)startIp).length(), (long)IPUtil4Atic.convert2CompleteIp((String)endIp).length()});
    }

    public boolean isOverlapped(String startIp, String endIp) {
        String hql = "from ZoneIpInfo zi where (( zi.startIp <= ? and zi.endIp >= ? ) or ( zi.startIp <= ? and zi.endIp >= ? ) or ( zi.startIp >= ? and zi.endIp <= ? )) and LENGTH(zi.startIp) = ? AND LENGTH(zi.endIp) = ?";
        List list = this.getHibernateTemplate().find(hql, new Object[]{IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)endIp), IPUtil4Atic.convert2CompleteIp((String)endIp), IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)endIp), (long)IPUtil4Atic.convert2CompleteIp((String)startIp).length(), (long)IPUtil4Atic.convert2CompleteIp((String)endIp).length()});
        return list != null && !list.isEmpty();
    }

    public boolean isOverlappedExceptZoneId(long zoneId, String startIp, String endIp) {
        String hql = "from ZoneIpInfo zi where (( zi.startIp <= ? and zi.endIp >= ? ) or ( zi.startIp <= ? and zi.endIp >= ? ) or ( zi.startIp >= ? and zi.endIp <= ? )) and zi.zoneId <> ? and LENGTH(zi.startIp) = ? AND LENGTH(zi.endIp) = ?";
        List zoneIpList = super.getHibernateTemplate().find(hql, new Object[]{IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)endIp), IPUtil4Atic.convert2CompleteIp((String)endIp), IPUtil4Atic.convert2CompleteIp((String)startIp), IPUtil4Atic.convert2CompleteIp((String)endIp), zoneId, (long)IPUtil4Atic.convert2CompleteIp((String)startIp).length(), (long)IPUtil4Atic.convert2CompleteIp((String)endIp).length()});
        return zoneIpList != null && !zoneIpList.isEmpty();
    }

    public void deleteById(Long zoneIpId) {
        String hql = "delete from ZoneIpInfo zi where zi.id = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneIpId});
    }

    public void saveZoneIp(ZoneIpInfo zoneIp) {
        this.getHibernateTemplate().save((Object)zoneIp);
    }

    public void deleteByZoneId(long zoneId) {
        String hql = "delete from ZoneIpInfo zi where zi.zoneId = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId});
    }

    public List<ZoneIpInfo> getByZoneId(long zoneId) {
        String hql = "from ZoneIpInfo zi where zi.zoneId = ?";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }
}

