/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.dao;

import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.model.CurrentZoneId;
import com.hs.atic.zone.model.ZoneInfo;
import com.hs.atic.zone.util.ZoneUtil;
import com.hs.lego.cbb.resource.sdk.model.DeviceTypeRelation;
import com.hs.lego.cbb.resource.sdk.model.MainDeviceType;
import com.hs.lego.cbb.resource.sdk.model.SubDeviceType;
import com.hs.lego.cbb.user.sdk.service.CheckChildrenMoUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.resource.dao.AticDeviceDao;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class ZoneDao
extends CommonDaoImpl {
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private AticDeviceDao aticDeviceDao;

    public void deleteByZoneId(Long zoneId) {
        ZoneInfo zone = this.getByZoneId(zoneId);
        if (null != zone) {
            super.delete((Object)zone);
        } else {
            this.logger.error((Object)"deleteByZoneId method ,zone is null");
        }
    }

    public ZoneInfo getByZoneId(long id) {
        String hql = "from ZoneInfo where zoneId = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(id));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (ZoneInfo)result.get(0);
    }

    public List<ZoneInfo> getAllDefaultZones() {
        String hql = "from ZoneInfo where zoneType = 1";
        List result = this.findByHql(hql);
        if (result == null) {
            return new ArrayList<ZoneInfo>();
        }
        return result;
    }

    public Long getLastInsertZoneId() {
        String hql = "select max(zoneId) from ZoneInfo";
        List zoneIdList = this.findByHql(hql);
        if (zoneIdList != null && !zoneIdList.isEmpty()) {
            return (Long)zoneIdList.get(0);
        }
        return null;
    }

    public int getTotalZoneNumber() {
        String hql = "select count(zoneId) from ZoneInfo";
        List zoneIdList = this.findByHql(hql);
        if (zoneIdList != null && !zoneIdList.isEmpty()) {
            return ((Long)zoneIdList.get(0)).intValue();
        }
        return 0;
    }

    public List<ZoneInfo> getAll(Long userId, Boolean userIsAdmin) {
        List result;
        String hql = "from ZoneInfo ";
        if (null != userId && userIsAdmin != null && userIsAdmin.equals(false)) {
            hql = hql + "where moId in(" + CheckChildrenMoUtil.getInstanse().getHql(userId.longValue()) + ")";
        }
        if ((result = this.findByHql(hql)) == null || result.isEmpty()) {
            return new ArrayList<ZoneInfo>();
        }
        return result;
    }

    public List<CurrentZoneId> getAllCurrentZoneId() {
        return super.getHibernateTemplate().find("from CurrentZoneId", new Object[0]);
    }

    public void saveOrUpdate(Object object) {
        super.getHibernateTemplate().saveOrUpdate(object);
    }

    public List<ZoneInfo> getAll() {
        return this.getAll(null, null);
    }

    public boolean isZoneDesExists(String zoneDesc, Long zoneId) {
        String hql = "from ZoneInfo where zoneId <> ? and lower(zoneDesc) = ?";
        String idString = zoneId == null ? "-1" : zoneId.toString();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, idString);
        param.put(1, zoneDesc.trim().toLowerCase(Locale.ENGLISH));
        List result = this.findByHql(hql, param);
        return result != null && !result.isEmpty();
    }

    public boolean isZoneNameExists(String zoneName, Long zoneId) {
        String hql = "from ZoneInfo where zoneId <> ? and lower(zoneName) = ?";
        String idString = zoneId == null ? "-1" : zoneId.toString();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, idString);
        param.put(1, zoneName.trim().toLowerCase(Locale.ENGLISH));
        List result = this.findByHql(hql, param);
        return result != null && !result.isEmpty();
    }

    public int checkZoneNameDesc(String zoneName, String zoneDesc) {
        String hql = "from ZoneInfo where lower(zoneName) = ? or lower(zoneDesc) = ?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneName.trim().toLowerCase(Locale.ENGLISH));
        param.put(1, zoneDesc.trim().toLowerCase(Locale.ENGLISH));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return 0;
        }
        ZoneInfo zoneInfo = (ZoneInfo)result.get(0);
        if (zoneInfo.getName().equalsIgnoreCase(zoneName)) {
            return 570604;
        }
        return 570605;
    }

    public Long getZoneIdByIpAndMask(String startIp, String endIp) {
        startIp = IPUtil4Atic.convert2CompleteIp((String)startIp);
        endIp = IPUtil4Atic.convert2CompleteIp((String)endIp);
        String hql = "SELECT zoneId FROM ZoneIpInfo WHERE startIp <= ? and endIp >= ? and LENGTH(startIp) = ?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, startIp);
        param.put(1, endIp);
        param.put(2, String.valueOf(endIp.length()));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (Long)result.get(0);
    }

    public List<ZoneInfo> getDeployZoneInfoByDeviceId(Long userId, Boolean userIsAdmin, Long deviceId) {
        List result;
        List nfaList;
        if (null == deviceId) {
            return new ArrayList<ZoneInfo>();
        }
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByMoid(deviceId.longValue());
        if (null == aticDevice) {
            return new ArrayList<ZoneInfo>();
        }
        if (7 == aticDevice.getDeviceType() && null != (nfaList = this.aticDeviceDao.queryNfaByClusterId(deviceId)) && !nfaList.isEmpty()) {
            deviceId = ((AticDevice)nfaList.get(0)).getMoId();
        }
        String hql = "select distinct zoneInfo from ZoneInfo zoneInfo, ZoneDeviceDeployStatusInfo zoneStatus ";
        hql = hql + " where zoneInfo.zoneId=zoneStatus.zoneId and (zoneStatus.deployType=1 or zoneStatus.deployType=3)";
        if (null != userId && userIsAdmin.equals(false)) {
            hql = hql + " and zoneInfo.moId in(" + CheckChildrenMoUtil.getInstanse().getHql(userId.longValue()) + ")";
        }
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        if (deviceId != null) {
            hql = hql + " and zoneStatus.deviceId= ? ";
            param.put(0, deviceId.toString());
        }
        if ((result = this.findByHql(hql, param)) == null) {
            return new ArrayList<ZoneInfo>();
        }
        if (result instanceof ArrayList) {
            return (ArrayList)result;
        }
        return new ArrayList<ZoneInfo>();
    }

    private String getDeviceIds(int deviceType) {
        List deviceList = this.aticDeviceDao.queryDevice(deviceType);
        StringBuffer buf = new StringBuffer();
        if (!deviceList.isEmpty()) {
            for (int i = 0; i < deviceList.size(); ++i) {
                if (0 == i) {
                    buf.append(((AticDevice)deviceList.get(i)).getMoId());
                    continue;
                }
                buf.append("," + ((AticDevice)deviceList.get(i)).getMoId());
            }
        }
        return buf.toString();
    }

    public List<ZoneInfo> getDeployZoneInfoByDeviceType(Long userId, Boolean userIsAdmin, int deviceType) {
        List result;
        String moIdsStr = this.getDeviceIds(deviceType);
        if (ZoneUtil.isNull(moIdsStr)) {
            return new ArrayList<ZoneInfo>();
        }
        String hql = "select distinct zoneInfo from ZoneInfo zoneInfo, ZoneDeviceDeployStatusInfo zoneStatus ";
        hql = hql + " where zoneInfo.zoneId=zoneStatus.zoneId and (zoneStatus.deployType=1 or zoneStatus.deployType=3)";
        if (null != userId && userIsAdmin.equals(false)) {
            hql = hql + " and zoneInfo.moId in(" + CheckChildrenMoUtil.getInstanse().getHql(userId.longValue()) + ")";
        }
        if (moIdsStr.length() > 0) {
            hql = hql + " and zoneStatus.deviceId in ( " + moIdsStr + " )";
        }
        if ((result = this.findByHql(hql)) == null) {
            return new ArrayList<ZoneInfo>();
        }
        if (result instanceof ArrayList) {
            return (ArrayList)result;
        }
        return new ArrayList<ZoneInfo>();
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        String zoneType;
        Paging page = new Paging();
        String hql = "from ZoneInfo where (1=1) ";
        String hql4Count = "select count(*) as rowCount ";
        String userId = conditionMap.get("currentUserId");
        String userIsAdmin = conditionMap.get("currentUserIsAdmin");
        if (null != userId && userIsAdmin.equals(String.valueOf(false))) {
            Long uid = Long.valueOf(userId);
            hql = hql + " and moId in(" + CheckChildrenMoUtil.getInstanse().getHql(uid.longValue()) + ")";
        }
        int index = 0;
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String zoneName = conditionMap.get("zoneName");
        if (!ZoneUtil.isNull(zoneName)) {
            zoneName = zoneName.trim().toLowerCase(Locale.ENGLISH);
            hql = hql + "and lower(zoneName) like ? or lower(zoneDesc) like ? ";
            queryMap.put(index++, "%" + zoneName + "%");
            queryMap.put(index++, "%" + zoneName + "%");
        }
        if (!ZoneUtil.isNull(zoneType = conditionMap.get("zoneType"))) {
            hql = hql + " and zoneType = ? ";
            queryMap.put(index++, zoneType);
        }
        String startIp = conditionMap.get("startIp");
        String endIp = conditionMap.get("endIp");
        if (!ZoneUtil.isNull(startIp) && !ZoneUtil.isNull(endIp)) {
            startIp = IPUtil4Atic.convert2CompleteIp((String)startIp);
            endIp = IPUtil4Atic.convert2CompleteIp((String)endIp);
            hql = hql + " and zoneId IN (SELECT zoneId FROM ZoneIpInfo  WHERE startIp<=? and endIp>=? and LENGTH(startIp)=?)";
            queryMap.put(index++, endIp);
            queryMap.put(index++, startIp);
            queryMap.put(index++, String.valueOf(startIp.length()));
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public Paging getPageDeployZoneInfo(Map<String, String> conditionMap, int start, int pageSize, boolean needNfa) {
        String regular;
        String deviceId;
        String zoneType;
        String moIdsStr;
        String deviceType;
        Paging page = new Paging();
        String hql = " from ZoneInfo zoneInfo, ZoneDeviceDeployStatusInfo zoneStatus ";
        hql = hql + " where zoneInfo.zoneId=zoneStatus.zoneId and (zoneStatus.deployType=1 or zoneStatus.deployType=3)";
        String hql4Count = "select count(distinct zoneInfo) as rowCount ";
        String userId = conditionMap.get("currentUserId");
        String userIsAdmin = conditionMap.get("currentUserIsAdmin");
        if (null != userId && "false".equalsIgnoreCase(userIsAdmin)) {
            Long uid = Long.valueOf(userId);
            hql = hql + " and zoneInfo.moId in(" + CheckChildrenMoUtil.getInstanse().getHql(uid.longValue()) + ")";
        }
        int index = 0;
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String zoneName = conditionMap.get("zoneName");
        if (!ZoneUtil.isNull(zoneName)) {
            zoneName = zoneName.trim().toLowerCase(Locale.ENGLISH);
            hql = hql + "and (lower(zoneInfo.zoneName) like ? or lower(zoneInfo.zoneDesc) like ? )";
            queryMap.put(index++, "%" + zoneName + "%");
            queryMap.put(index++, "%" + zoneName + "%");
        }
        if (!ZoneUtil.isNull(deviceType = conditionMap.get("deviceType")) && !(moIdsStr = this.getDeviceIds(Integer.parseInt(deviceType))).equals("")) {
            hql = hql + " and zoneStatus.deviceId in ( " + moIdsStr + " )";
        }
        if (!ZoneUtil.isNull(zoneType = conditionMap.get("zoneType"))) {
            hql = hql + " and  zoneInfo.zoneType = ? ";
            queryMap.put(index++, zoneType);
        }
        if (!ZoneUtil.isNull(deviceId = conditionMap.get("deviceId"))) {
            hql = hql + " and  zoneStatus.deviceId = ? ";
            queryMap.put(index++, deviceId);
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by zoneInfo." + sortName + " " + sortType;
        }
        hql = "select distinct zoneInfo " + hql;
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public Paging getPageZoneInfoWithDevice(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        String deviceId;
        Paging page = new Paging();
        String hql = "from ZoneInfo zoneInfo, ZoneDeviceInfo zoneDeviceInfo ";
        hql = hql + " where zoneInfo.zoneId = zoneDeviceInfo.zoneId ";
        String hql4Count = "select count(distinct zoneInfo) as rowCount ";
        String userId = conditionMap.get("currentUserId");
        String userIsAdmin = conditionMap.get("currentUserIsAdmin");
        if (userId != null && userIsAdmin != null && userIsAdmin.equals(String.valueOf(false))) {
            Long uid = Long.valueOf(userId);
            hql = hql + " and zoneInfo.moId in(" + CheckChildrenMoUtil.getInstanse().getHql(uid.longValue()) + ")";
        }
        int index = 0;
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String zoneName = conditionMap.get("zoneName");
        if (!ZoneUtil.isNull(zoneName)) {
            zoneName = zoneName.trim().toLowerCase(Locale.ENGLISH);
            hql = hql + "and (lower(zoneInfo.zoneName) like ? or lower(zoneInfo.zoneDesc) like ? )";
            queryMap.put(index++, "%" + zoneName + "%");
            queryMap.put(index++, "%" + zoneName + "%");
        }
        if (conditionMap.containsKey("deviceId") && !ZoneUtil.isNull(deviceId = conditionMap.get("deviceId")) && !deviceId.equals("0")) {
            hql = hql + " and  zoneDeviceInfo.deviceId = ? ";
            queryMap.put(index++, deviceId);
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by  zoneInfo." + sortName + " " + sortType;
        }
        hql = "select distinct zoneInfo " + hql;
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public Paging getPageDeployDDoSZoneInfo(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        String deviceId;
        String zoneType;
        String deviceType;
        Paging page = new Paging();
        String hql = " from ZoneInfo zoneInfo, ZoneFeatureStatusInfo zoneStatus ";
        hql = hql + " where zoneInfo.zoneId=zoneStatus.zoneId and zoneStatus.featureType='ZoneInfoForm' ";
        String hql4Count = "select count(distinct zoneInfo) as rowCount ";
        String userId = conditionMap.get("currentUserId");
        String userIsAdmin = conditionMap.get("currentUserIsAdmin");
        if (null != userId && "false".equalsIgnoreCase(userIsAdmin)) {
            Long uid = Long.valueOf(userId);
            hql = hql + " and zoneInfo.moId in(" + CheckChildrenMoUtil.getInstanse().getHql(uid.longValue()) + ")";
        }
        int index = 0;
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String zoneName = conditionMap.get("zoneName");
        if (!ZoneUtil.isNull(zoneName)) {
            zoneName = zoneName.trim().toLowerCase(Locale.ENGLISH);
            hql = hql + "and (lower(zoneInfo.zoneName) like ? or lower(zoneInfo.zoneDesc) like ? )";
            queryMap.put(index++, "%" + zoneName + "%");
            queryMap.put(index++, "%" + zoneName + "%");
        }
        if (!ZoneUtil.isNull(deviceType = conditionMap.get("deviceType"))) {
            String moIdsStr = this.getDeviceIds(Integer.parseInt(deviceType));
            if (ZoneUtil.isNull(moIdsStr)) {
                moIdsStr = "0";
            }
            hql = hql + " and zoneStatus.deviceId in ( " + moIdsStr + " )";
        }
        if (!ZoneUtil.isNull(zoneType = conditionMap.get("zoneType"))) {
            hql = hql + " and  zoneInfo.zoneType = ? ";
            queryMap.put(index++, zoneType);
        }
        if (!ZoneUtil.isNull(deviceId = conditionMap.get("deviceId"))) {
            hql = hql + " and  zoneStatus.deviceId = ? ";
            queryMap.put(index++, deviceId);
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by zoneInfo." + sortName + " " + sortType;
        }
        hql = "select distinct zoneInfo " + hql;
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public Boolean isExistConn(Long zoneId, Long deviceId) {
        List result = null;
        if (null == zoneId && null == deviceId) {
            return false;
        }
        String hql = "from ZoneDeviceInfo where zoneId = ? and deviceId = ?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        if (zoneId != null) {
            param.put(0, zoneId.toString());
        }
        param.put(1, deviceId.toString());
        result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return false;
        }
        return true;
    }

    public void processZoneMO() {
        if (this.getHibernateTemplate().find("from MainDeviceType where name = ? ", new Object[]{"atic.portal.mainType.zone"}).isEmpty()) {
            this.logger.info((Object)"zone mo info hasn't been set.Process it!!");
            MainDeviceType main = new MainDeviceType();
            main.setName("atic.portal.mainType.zone");
            this.getHibernateTemplate().save((Object)main);
            SubDeviceType sub = new SubDeviceType();
            sub.setName("atic.portal.subType.dsosZone");
            this.getHibernateTemplate().save((Object)sub);
            DeviceTypeRelation relation = new DeviceTypeRelation();
            relation.setParentType("atic.portal.mainType.zone");
            relation.setChildType("atic.portal.subType.dsosZone");
            Long relationId = (Long)this.getHibernateTemplate().save((Object)relation);
            this.logger.info((Object)("relation Id = " + relationId));
            this.logger.info((Object)"Process zone MO info successfully.");
        } else {
            this.logger.info((Object)"zone mo info has been set.No need process it!!");
        }
    }

    public void setAticDeviceDao(AticDeviceDao aticDeviceDao) {
        this.aticDeviceDao = aticDeviceDao;
    }

    public AticDeviceDao getAticDeviceDao() {
        return this.aticDeviceDao;
    }

    public Long getMoIdByZoneNameForRestIf(String zoneName) {
        String hql = "select zoneId from ZoneInfo where lower(zoneName) = ?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneName.trim().toLowerCase(Locale.ENGLISH));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return 0L;
        }
        if (result instanceof ArrayList) {
            return (Long)((ArrayList)result).get(0);
        }
        return 0L;
    }

    public List<ZoneInfo> getZoneByNameOrDesc(String zoneName, String zoneDesc) {
        String hql = "from ZoneInfo where lower(zoneName) = ? or lower(zoneDesc) = ?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneName.trim().toLowerCase(Locale.ENGLISH));
        param.put(1, zoneName.trim().toLowerCase(Locale.ENGLISH));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return new ArrayList<ZoneInfo>();
        }
        if (result instanceof ArrayList) {
            return (ArrayList)result;
        }
        return new ArrayList<ZoneInfo>();
    }

    public ZoneInfo getZoneByName(String zoneName) {
        String hql = "from ZoneInfo where lower(zoneName) = ?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneName.trim().toLowerCase(Locale.ENGLISH));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result instanceof ArrayList) {
            return (ZoneInfo)((ArrayList)result).get(0);
        }
        return null;
    }

    public ZoneInfo getCustomZoneByName(String zoneName) {
        String hql = "from ZoneInfo where lower(zoneName) = ? and zoneType = 2";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneName.trim().toLowerCase(Locale.ENGLISH));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result instanceof ArrayList) {
            return (ZoneInfo)((ArrayList)result).get(0);
        }
        return null;
    }

    public long getDeployDefaultZoneInfoByDeviceId(Long deviceId) {
        List result;
        String hql = "select zoneInfo from ZoneInfo zoneInfo, ZoneFeatureStatusInfo zoneStatus ";
        hql = hql + " where zoneInfo.zoneId=zoneStatus.zoneId and zoneStatus.featureType='ZoneInfoForm' and zoneInfo.zoneType = 1";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        if (deviceId != null) {
            hql = hql + " and zoneStatus.deviceId= ? ";
            param.put(0, deviceId.toString());
        }
        if ((result = this.findByHql(hql, param)) == null || result.isEmpty()) {
            return 0L;
        }
        if (result instanceof ArrayList) {
            ArrayList aZoneInfos = (ArrayList)result;
            return ((ZoneInfo)aZoneInfos.get(0)).getZoneId();
        }
        return 0L;
    }

    public ZoneInfo getDefaultZoneInfoByDeviceId(long deviceId) {
        String hql = "select zoneInfo from ZoneInfo zoneInfo, ZoneDeviceInfo zoneDeviceInfo ";
        hql = hql + " where (zoneInfo.zoneId = zoneDeviceInfo.zoneId) and (zoneInfo.zoneType = 1)";
        hql = hql + " and (zoneDeviceInfo.deviceId = ?)";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(deviceId));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (ZoneInfo)result.get(0);
    }

    public ZoneInfo getZoneInfoForRestIf(String sql, Map<Integer, String> param) {
        Session session = null;
        NativeQuery query = null;
        ZoneInfo zoneInfo = null;
        session = this.currentSession();
        query = session.createSQLQuery(sql);
        Set<Map.Entry<Integer, String>> entrys = param.entrySet();
        for (Map.Entry<Integer, String> entry : entrys) {
            query.setString(entry.getKey().intValue(), entry.getValue());
        }
        query.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
        List results = query.list();
        if (null != results && !results.isEmpty()) {
            zoneInfo = new ZoneInfo();
            Map result = (Map)results.get(0);
            Long zoneId = ((BigInteger)result.get("zone_id")).longValue();
            zoneInfo.setZoneId(zoneId);
            zoneInfo.setZoneDesc((String)result.get("zone_desc"));
            zoneInfo.setZoneName((String)result.get("zone_name"));
            Long moid = ((BigInteger)result.get("moid")).longValue();
            zoneInfo.setMoId(moid);
            Integer zoneType = (Integer)result.get("zone_type");
            zoneInfo.setZoneType(zoneType);
            zoneInfo.setPost((String)result.get("post"));
            zoneInfo.setRemark((String)result.get("remark"));
            zoneInfo.setPassword((String)result.get("password"));
            zoneInfo.setContact((String)result.get("contact"));
            zoneInfo.setEmail((String)result.get("email"));
            zoneInfo.setAddress((String)result.get("address"));
            zoneInfo.setTelephone((String)result.get("telephone"));
            zoneInfo.setMobile((String)result.get("mobile"));
        }
        return zoneInfo;
    }

    public ZoneInfo getZoneByDefPolForRestIf(String mbps, String pps, String newConn, String currConn, String httpQps) {
        String sql = "SELECT zone.* FROM t_atic_zone_info zone,(SELECT DISTINCT zone_id FROM t_vsm_zone_service,(SELECT udp.service_id FROM t_vsm_zone_udpflood udp ,t_vsm_zone_tcpflood tcp, t_vsm_zone_httpflood http WHERE udp.service_id = tcp.service_id AND tcp.service_id = http.service_id ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        int index = 0;
        if (null == mbps || "null".equals(mbps)) {
            sql = sql + "AND (udp.alert_speed IS NULL) ";
        } else {
            sql = sql + "AND udp.alert_speed=? ";
            param.put(index++, mbps.trim());
        }
        if (null == pps || "null".equals(pps)) {
            sql = sql + "AND (tcp.synflood_alert_rate IS NULL) ";
        } else {
            sql = sql + "AND tcp.synflood_alert_rate=? ";
            param.put(index++, pps.trim());
        }
        if (null == newConn || "null".equals(newConn)) {
            sql = sql + "AND (tcp.tcp_new_srctip_rate IS NULL) ";
        } else {
            sql = sql + "AND tcp.tcp_new_srctip_rate=? ";
            param.put(index++, newConn.trim());
        }
        if (null == currConn || "null".equals(currConn)) {
            sql = sql + "AND (tcp.tcp_srctip_num IS NULL) ";
        } else {
            sql = sql + "AND tcp.tcp_srctip_num=? ";
            param.put(index++, currConn.trim());
        }
        if (null == httpQps || "null".equals(httpQps)) {
            sql = sql + "AND (http.http_dest_qps_alert_rate IS NULL) ";
        } else {
            sql = sql + "AND http.http_dest_qps_alert_rate=? ";
            param.put(index++, httpQps.trim());
        }
        sql = sql + ") AS serviceIdTemp WHERE t_vsm_zone_service.pkid = serviceIdTemp.service_id) AS zoneIdTemp WHERE zone.zone_id=zoneIdTemp.zone_id;";
        ZoneInfo zoneInfo = this.getZoneInfoForRestIf(sql, param);
        return zoneInfo;
    }
}

