/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.dao;

import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.zone.model.ZoneIpInfo;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ZoneIpDao
extends CommonDaoImpl {
    public List<ZoneIpInfo> findIpByZoneId(Long zoneId) {
        if (zoneId == null) {
            return new ArrayList<ZoneIpInfo>();
        }
        String hql = "from ZoneIpInfo where zoneId = ?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneId.toString());
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<ZoneIpInfo>();
        }
        return result;
    }

    public List<ZoneIpInfo> findIpNotThisZoneId(Long zoneId) {
        String zoneIdString = "";
        zoneIdString = zoneId == null ? "-1" : zoneId.toString();
        String hql = "from ZoneIpInfo where zoneId <> ?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneIdString);
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<ZoneIpInfo>();
        }
        return result;
    }

    public void deleteIpByZoneId(Long zoneId) {
        String hql = "delete from ZoneIpInfo where zoneId = ? ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId});
    }

    public void deleteIpByIp(Long zoneId, String ip, int mask) {
        String hql = "delete from ZoneIpInfo where zoneId = ? and zoneIp = ? and mask = ? ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId, ip, mask});
    }

    public void deleteIpByIp(String ip) {
        String hql = "delete from ZoneIpInfo where zoneIp = ? ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{ip});
    }

    public List<ZoneIpInfo> findExistZoneIpInfobyIp(String startIp, String endIp) {
        String covertStartIp = IPUtil4Atic.convert2CompleteIp((String)startIp);
        String covertEndIp = IPUtil4Atic.convert2CompleteIp((String)endIp);
        String hql = "from ZoneIpInfo where startIp<=? and endIp>=? and LENGTH(startIp)=?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, covertEndIp);
        param.put(1, covertStartIp);
        param.put(2, String.valueOf(covertStartIp.length()));
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<ZoneIpInfo>();
        }
        return result;
    }

    public List<ZoneIpInfo> findIpbyStartIpAndEndIpExceptZoneId(Long zoneId, String startIp, String endIp) {
        String covertStartIp = IPUtil4Atic.convert2CompleteIp((String)startIp);
        String covertEndIp = IPUtil4Atic.convert2CompleteIp((String)endIp);
        String zoneIdString = "-1";
        if (zoneId != null) {
            zoneIdString = zoneId.toString();
        }
        String hql = "from ZoneIpInfo where zoneId<>? and startIp<=? and endIp>=? and LENGTH(startIp)=?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneIdString);
        param.put(1, covertEndIp);
        param.put(2, covertStartIp);
        param.put(3, String.valueOf(covertStartIp.length()));
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<ZoneIpInfo>();
        }
        return result;
    }

    public boolean isExistsIp(String startIp, String endIp) {
        return !this.findExistZoneIpInfobyIp(startIp, endIp).isEmpty();
    }

    public long getZoneIdByIp(String zoneIp) {
        String covertZoneIp = IPUtil4Atic.convert2CompleteIp((String)zoneIp);
        String hql = "from ZoneIpInfo where startIp<=? and endIp>=? and LENGTH(startIp)=?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, covertZoneIp);
        param.put(1, covertZoneIp);
        param.put(2, String.valueOf(covertZoneIp.length()));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return 1L;
        }
        return ((ZoneIpInfo)result.get(0)).getZoneId();
    }

    public void delZoneIpByIpAndZoneId(String ip, long zoneId) {
        String hql = "delete from ZoneIpInfo where zoneIp = ? and zoneId = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{ip, zoneId});
    }

    public void deleteZoneIpForm(ZoneIpForm zoneIpForm) {
        String hql = "delete from ZoneIpInfo where id = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneIpForm.getId()});
    }

    public List<ZoneIpInfo> findIpbyStartIpAndEndIpAndZoneId(Long zoneId, String startIp, String endIp) {
        String covertStartIp = IPUtil4Atic.convert2CompleteIp((String)startIp);
        String covertEndIp = IPUtil4Atic.convert2CompleteIp((String)endIp);
        String zoneIdString = "-1";
        if (zoneId != null) {
            zoneIdString = zoneId.toString();
        }
        String hql = "from ZoneIpInfo where zoneId = ? and startIp<=? and endIp>=? and LENGTH(startIp)=?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneIdString);
        param.put(1, covertEndIp);
        param.put(2, covertStartIp);
        param.put(3, String.valueOf(covertStartIp.length()));
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<ZoneIpInfo>();
        }
        return result;
    }
}

