/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.dao;

import com.hs.atic.zone.dao.BaseDao;
import com.hs.atic.zone.model.ZoneListIpInfo;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;

public class ZoneListIpDao
extends BaseDao<ZoneListIpInfo, Long> {
    public ZoneListIpDao() {
        super(ZoneListIpInfo.class);
    }

    public void deleteIpByZoneId(Long zoneId) {
        String hql = "delete from ZoneListIpInfo where zoneId = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId});
    }

    public void deleteIpByPkIds(List<Long> pkidList) {
        String hql = "delete from ZoneListIpInfo where pkid in (:ids)";
        InnerClassDelete innerClass = new InnerClassDelete(hql, pkidList);
        super.getHibernateTemplate().execute((HibernateCallback)innerClass);
    }

    public List<ZoneListIpInfo> getByZoneId(Long zoneId) {
        String hql = "from ZoneListIpInfo where zoneId = ?";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<Long> getPkIdsByZoneId(Long zoneId) {
        String hql = "select id from ZoneListIpInfo where zoneId = ?";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<ZoneListIpInfo> getZoneIpsForDeviceIpList(Long zoneId) {
        String hql = "from ZoneListIpInfo where zoneId = ? and ipType = 0  and pkid not in(select ipId from ZoneIpStatusInfo) ";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<ZoneListIpInfo> getByZoneIdAndState(Long zoneId) {
        String hql = "from ZoneListIpInfo where zoneId = ? and deployState = true";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<ZoneListIpInfo> getByZoneIdAndFlag(Long zoneId) {
        String hql = "from ZoneListIpInfo where zoneId = ? and deployState = true and deleteFlag = 0";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<ZoneListIpInfo> getByZoneIdAndIpType(Long zoneId) {
        String hql = "from ZoneListIpInfo where zoneId = ? and ipType = 0 and deleteFlag = 0";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<ZoneListIpInfo> getByExcludeIpAndDeleteFlag(Long zoneId) {
        String hql = "from ZoneListIpInfo where zoneId = ? and ipType = 1 and deleteFlag = 1";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<ZoneListIpInfo> getExcludeByZoneId(Long zoneId) {
        String hql = "from ZoneListIpInfo where zoneId = ? and ipType = 1 ";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<ZoneListIpInfo> getIpInitDataByZoneId(Long zoneId) {
        String hql = "from ZoneListIpInfo where zoneId = ? and deployState = false and deleteFlag = 0";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<ZoneListIpInfo> getIpInitUndoDataByZoneId(Long zoneId) {
        String hql = "from ZoneListIpInfo where zoneId = ? and deployState = true and deleteFlag = 1";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<ZoneListIpInfo> getIpUndoDataByZoneId(Long zoneId) {
        String hql = "from ZoneListIpInfo where zoneId = ? and deleteFlag = 1";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<ZoneListIpInfo> getByZoneIdAndDeleteFlag(Long zoneId) {
        String hql = "from ZoneListIpInfo where zoneId = ? and deleteFlag = 0";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public ZoneListIpInfo getByIpAndDeleteFlag(String zoneIp) {
        String hql = "from ZoneListIpInfo where zoneIp = ? and deleteFlag = 0  and ipType = 0";
        List find = this.getHibernateTemplate().find(hql, new Object[]{zoneIp});
        if (null != find && !find.isEmpty()) {
            return (ZoneListIpInfo)find.get(0);
        }
        return null;
    }

    public ZoneListIpInfo getByIpAndMask(String zoneIp, String mask) {
        String hql = "from ZoneListIpInfo where zoneIp = ? and intMask = ? and deleteFlag = 0  and ipType = 0";
        List result = this.getHibernateTemplate().find(hql, new Object[]{zoneIp, Integer.parseInt(mask)});
        if (result.isEmpty()) {
            return null;
        }
        return (ZoneListIpInfo)result.get(0);
    }

    public List<ZoneListIpInfo> findExistSigIp(String zoneIp, boolean isIpv4) {
        if (isIpv4) {
            String hql = "from ZoneListIpInfo where zoneIp = ? and ipType = ? and (intMask = ? or stringMask = ?)";
            return this.getHibernateTemplate().find(hql, new Object[]{zoneIp, 0, 32, "255.255.255.255"});
        }
        String hql = "from ZoneListIpInfo where zoneIp = ? and ipType = ? and intMask = ?";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneIp, 0, 128});
    }

    public List<ZoneListIpInfo> findExistByIpMask(String zoneIp, boolean isIpv4, int mask) {
        if (isIpv4) {
            String maskStr = IPUtil4Atic.mask2ipMask((String)("" + mask));
            String hql = "from ZoneListIpInfo where zoneIp = ? and ipType = ? and (intMask = ? or stringMask = ?)";
            return this.getHibernateTemplate().find(hql, new Object[]{zoneIp, 0, mask, maskStr});
        }
        String hql = "from ZoneListIpInfo where zoneIp = ? and ipType = ? and intMask = ?";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneIp, 0, mask});
    }

    public List<ZoneListIpInfo> findExistByIpMaskWithoutSourceZoneId(String zoneIp, boolean isIpv4, int mask, String sourceZoneId) {
        if (isIpv4) {
            String maskStr = IPUtil4Atic.mask2ipMask((String)("" + mask));
            String hql = "from ZoneListIpInfo where zoneIp = ? and ipType = ? and (intMask = ? or stringMask = ?) and zoneId != ?";
            return this.getHibernateTemplate().find(hql, new Object[]{zoneIp, 0, mask, maskStr, sourceZoneId});
        }
        String hql = "from ZoneListIpInfo where zoneIp = ? and ipType = ? and intMask = ? and zoneId != ?";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneIp, 0, mask, sourceZoneId});
    }

    public void delZoneListIpByIp(String zoneIp) {
        String hql = "delete from ZoneListIpInfo where zoneIp = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneIp});
    }

    public void delZoneListIpByIp(String startIp, String endIp, Long zoneId) {
        String hql = "delete from ZoneListIpInfo where startIp = ? and endIp = ? and zoneId = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{startIp, endIp, zoneId});
    }

    public void updateDeployStateByZoneId(Long zoneId) {
        String hql = "update ZoneListIpInfo  set deployState = false  where zoneId = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId});
    }

    public void updateDeployStateById(Long pkid, boolean deployState) {
        String hql = "update ZoneListIpInfo  set deployState = ?  where id = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deployState, pkid});
    }

    public void updateFlagByRestful(String zoneIp) {
        String hql = "update ZoneListIpInfo  set deleteFlag = 1  where zoneIp = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneIp});
    }

    public void updateFlagByRestful(String zoneIp, int flag) {
        String hql = "update ZoneListIpInfo  set deleteFlag = ?  where zoneIp = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{flag, zoneIp});
    }

    public void updateFlagByRestful(String zoneIp, int flag, long zoneId) {
        String hql = "update ZoneListIpInfo  set deleteFlag = ? where zoneIp = ? and zoneId = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{flag, zoneIp, zoneId});
    }

    public void updateFlagByRestful(long id, int flag) {
        String hql = "update ZoneListIpInfo  set deleteFlag = ?  where id = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{flag, id});
    }

    public void updateFlagByRestful(Long zoneId) {
        String hql = "update ZoneListIpInfo  set deleteFlag = 1  where zoneId = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId});
    }

    public void saveOrUpdate(ZoneListIpInfo info) {
        this.getHibernateTemplate().saveOrUpdate((Object)info);
    }

    public void deleteAll(List<ZoneListIpInfo> infos) {
        this.getHibernateTemplate().deleteAll(infos);
    }

    public void delZoneListIpByIpAndZoneId(String zoneIp, long zoneId) {
        String hql = "delete from ZoneListIpInfo where zoneIp = ? and zoneId = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneIp, zoneId});
    }

    public void deleteZoneListIp(long zoneListIpId) {
        String hql2 = "delete from ZoneListIpInfo where id = ?";
        this.getHibernateTemplate().bulkUpdate(hql2, new Object[]{zoneListIpId});
    }

    private static class InnerClassDelete
    implements HibernateCallback {
        private String hql;
        private List<Long> ids;

        public InnerClassDelete(String hql, List<Long> ids) {
            this.hql = hql;
            this.ids = ids;
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery(this.hql);
            q.setParameterList("ids", this.ids);
            return q.executeUpdate();
        }
    }
}

