/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.dao;

import com.hs.atic.zone.model.ZonePortMapStatusInfo;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import java.util.ArrayList;
import java.util.List;

public class ZoneListPortMapStateDao
extends CommonDaoImpl {
    public void deleteAllByZoneId(Long zoneId) {
        String hql = "delete from ZonePortMapStatusInfo where zoneId = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId});
    }

    public List<ZonePortMapStatusInfo> getByZoneId(Long zoneId) {
        String hql = "from ZonePortMapStatusInfo where zoneId = ?";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<ZonePortMapStatusInfo> getPortMapUndeployDataByZoneId(Long zoneId) {
        String hql = "from ZonePortMapStatusInfo where zoneId = ? and deployState = false";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId});
    }

    public List<ZonePortMapStatusInfo> findByIdAndDeviceId(Long portMapId, Long deviceId) {
        if (null == portMapId || null == deviceId) {
            return new ArrayList<ZonePortMapStatusInfo>();
        }
        String hql = "from ZonePortMapStatusInfo where portMapId = ? and deviceId = ?";
        List result = this.findByHql(hql, new Object[]{portMapId, deviceId});
        if (result == null) {
            return new ArrayList<ZonePortMapStatusInfo>();
        }
        return result;
    }

    public void updateDeployStateByZoneId(Long zoneId) {
        String hql = "update ZonePortMapStatusInfo  set deployState = false  where zoneId = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{zoneId});
    }

    public void updateDeployStateById(Long pkid, boolean deployState) {
        String hql = "update ZonePortMapStatusInfo  set deployState = ?  where id = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deployState, pkid});
    }

    public void deleteById(Long pkid) {
        String hql = "delete from ZonePortMapStatusInfo where id = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{pkid});
    }

    public void deleteByDeviceId(Long deviceId) {
        String hql = "delete from ZonePortMapStatusInfo where deviceId = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceId});
    }

    public void deleteIpByPortMapIds(List<Long> protMapIdList) {
        String hql = "delete from ZonePortMapStatusInfo where portMapId in (:ids)";
        this.currentSession().createQuery(hql).setParameterList("ids", protMapIdList).executeUpdate();
    }

    public void deleteIpByPkIdsAndDeviceId(List<Long> pkidList, Long deviceId) {
        String hql = "delete from ZonePortMapStatusInfo where deviceId = :deviceId and portMapId in (:ids)";
        this.currentSession().createQuery(hql).setParameter("deviceId", (Object)deviceId).setParameterList("ids", pkidList).executeUpdate();
    }
}

