/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.service.impl;

import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.zone.service.ICreateExportXmlFormService;
import com.hs.atic.sdk.zone.service.IZoneImportAndExportXmlService;
import com.hs.atic.sdk.zone.util.ProgressManage;
import com.hs.atic.sdk.zone.util.ProgressState;
import com.hs.atic.zone.util.ZoneExportCreateUtil;
import com.hs.atic.zone.util.ZoneImportParserUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.dao.FilterDao;
import com.hs.vsm.secservice.ddos.model.FilterInfo;
import com.hs.vsm.secservice.sdk.module.ddos.form.ExportZoneConditionForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyIOForm;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZoneImportAndExportXmlServiceImpl
implements IZoneImportAndExportXmlService {
    Map<String, AticDevice> deviceMap = new HashMap<String, AticDevice>();
    Map<Long, String> exportDeviceMap = new HashMap<Long, String>();
    Map<String, String> exportDeviceBasicMap = new HashMap<String, String>();
    Map<String, Long> filterMap = new HashMap<String, Long>();
    Map<Long, String> exportFilterMap = new HashMap<Long, String>();
    private final Log lOG = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private FilterDao filterDao;
    private IAticDeviceService aticDeviceService;
    private ICreateExportXmlFormService createExportXmlFormService;
    private ILicenseOutboundService licenseOutboundService;

    public void initImportParseParams() {
        List deviceist = null;
        List<FilterInfo> filterList = null;
        deviceist = this.aticDeviceService.getAllDevice();
        for (AticDevice aticDevice : deviceist) {
            this.deviceMap.put(aticDevice.getIpAddress(), aticDevice);
            this.lOG.info((Object)("deviceMap aticDevice IpAddress: " + this.getcleanedMessage(aticDevice.getIpAddress())));
        }
        filterList = this.filterDao.getAllfilterByName();
        for (FilterInfo filterInfo : filterList) {
            this.filterMap.put(filterInfo.getFilterName(), filterInfo.getPkid());
            this.lOG.info((Object)("filterMap filterInfo FilterName: " + filterInfo.getFilterName()));
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public void initExportParseParams(List<ZonePolicyApplyForm> formList) {
        if (null != formList && !formList.isEmpty()) {
            for (ZonePolicyApplyForm zonePolicyApplyForm : formList) {
                List<Long> outboundfilterIdList;
                List<ZoneDeviceForm> zoneDeviceForms = zonePolicyApplyForm.getZoneDeviceForms();
                ArrayList<Long> allFilterIdList = new ArrayList<Long>();
                List<Long> filterIdList = zonePolicyApplyForm.getFilterIdList();
                if (null != filterIdList && !filterIdList.isEmpty()) {
                    allFilterIdList.addAll(filterIdList);
                }
                if (null != (outboundfilterIdList = zonePolicyApplyForm.getOutboundFilterIdList()) && !outboundfilterIdList.isEmpty()) {
                    allFilterIdList.addAll(outboundfilterIdList);
                }
                if (null != zoneDeviceForms && !zoneDeviceForms.isEmpty()) {
                    for (ZoneDeviceForm zoneDeviceForm : zoneDeviceForms) {
                        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(zoneDeviceForm.getDeviceId().longValue());
                        this.exportDeviceMap.put(aticDevice.getMoId(), aticDevice.getIpAddress());
                        this.exportDeviceBasicMap.put(aticDevice.getName(), aticDevice.getIpAddress());
                        this.lOG.info((Object)("exportDeviceMap aticDevice MoId: " + aticDevice.getMoId() + ";IpAddress:" + this.getcleanedMessage(aticDevice.getIpAddress())));
                        this.lOG.info((Object)("exportDeviceBasicMap aticDevice name: " + aticDevice.getName() + ";IpAddress" + this.getcleanedMessage(aticDevice.getIpAddress())));
                    }
                }
                if (allFilterIdList.isEmpty()) continue;
                for (Long pkId : allFilterIdList) {
                    FilterInfo filterInfo = this.filterDao.get(pkId);
                    if (null == filterInfo) continue;
                    this.exportFilterMap.put(pkId, filterInfo.getFilterName());
                    this.lOG.info((Object)("exportFilterMap filterInfo pkId: " + pkId + ";FilterName" + filterInfo.getFilterName()));
                }
            }
        }
    }

    @Override
    public ZonePolicyIOForm importZoneXml(String filePath) {
        this.lOG.info((Object)"importZoneXml start filepath: ");
        this.initImportParseParams();
        ZonePolicyIOForm form = ZoneImportParserUtil.parseZoneImport(filePath);
        this.lOG.info((Object)"importZoneXml end");
        return form;
    }

    @Override
    public void exportZoneXml(ZonePolicyIOForm policyForm, ExportZoneConditionForm conditionForm, Long progressBarId, Integer startNum, Integer endNum) {
        ProgressState progressState = ProgressManage.getInstance().createProgress(5, progressBarId);
        progressState.next();
        this.lOG.info((Object)"exportZoneXml start ");
        ZonePolicyIOForm form = new ZonePolicyIOForm();
        this.lOG.info((Object)"exportZoneXml start by zone");
        List<ZonePolicyApplyForm> list = this.createExportXmlFormService.getAllZoneByZoneId(conditionForm.getZoneIds(), conditionForm.getDeviceIds());
        Collections.sort(list);
        if (null != startNum && null != endNum) {
            list = list.subList(startNum - 1, endNum);
        }
        form.setZoneFormList(list);
        progressState.next();
        form.setSystemVersion(policyForm.getSystemVersion());
        form.setDimension(policyForm.getDimension());
        form.setTime(policyForm.getTime());
        this.initExportParseParams(form.getZoneFormList());
        ZoneExportCreateUtil.createXml(form, this.exportDeviceMap, this.exportFilterMap, conditionForm, progressState, this.licenseOutboundService.isSupportOutbound());
        this.lOG.info((Object)"exportZoneXml end");
    }

    @Override
    public String getZoneProgressResult(Long progressBarId) {
        ProgressState progressState = ProgressManage.getInstance().getProgressState(progressBarId);
        int progress = 0;
        if (progressState != null) {
            progress = progressState.getProgress();
        }
        return String.valueOf(progress);
    }

    public FilterDao getFilterDao() {
        return this.filterDao;
    }

    public void setFilterDao(FilterDao filterDao) {
        this.filterDao = filterDao;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public Map<String, AticDevice> getDeviceMap() {
        return this.deviceMap;
    }

    public void setDeviceMap(Map<String, AticDevice> deviceMap) {
        this.deviceMap = deviceMap;
    }

    public Map<String, Long> getFilterMap() {
        return this.filterMap;
    }

    public void setFilterMap(Map<String, Long> filterMap) {
        this.filterMap = filterMap;
    }

    public Map<Long, String> getExportDeviceMap() {
        return this.exportDeviceMap;
    }

    public void setExportDeviceMap(Map<Long, String> exportDeviceMap) {
        this.exportDeviceMap = exportDeviceMap;
    }

    public Map<String, String> getExportDeviceBasicMap() {
        return this.exportDeviceBasicMap;
    }

    public void setExportDeviceBasicMap(Map<String, String> exportDeviceBasicMap) {
        this.exportDeviceBasicMap = exportDeviceBasicMap;
    }

    public Map<Long, String> getExportFilterMap() {
        return this.exportFilterMap;
    }

    public void setExportFilterMap(Map<Long, String> exportFilterMap) {
        this.exportFilterMap = exportFilterMap;
    }

    public ICreateExportXmlFormService getCreateExportXmlFormService() {
        return this.createExportXmlFormService;
    }

    public void setCreateExportXmlFormService(ICreateExportXmlFormService createExportXmlFormService) {
        this.createExportXmlFormService = createExportXmlFormService;
    }

    public ILicenseOutboundService getLicenseOutboundService() {
        return this.licenseOutboundService;
    }

    public void setLicenseOutboundService(ILicenseOutboundService licenseOutboundService) {
        this.licenseOutboundService = licenseOutboundService;
    }
}

