/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.util;

import com.hs.atic.zone.dao.ZoneDao;
import com.hs.atic.zone.dao.ZoneIpDao;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.text.MessageFormat;
import org.springframework.beans.factory.InitializingBean;

public class InitDataBase
implements InitializingBean {
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ZoneIpDao zoneIpDao;
    private ZoneDao zoneDao;

    public ZoneDao getZoneDao() {
        return this.zoneDao;
    }

    public void setZoneDao(ZoneDao zoneDao) {
        this.zoneDao = zoneDao;
    }

    public ZoneIpDao getZoneIpDao() {
        return this.zoneIpDao;
    }

    public void setZoneIpDao(ZoneIpDao zoneIpDao) {
        this.zoneIpDao = zoneIpDao;
    }

    public void afterPropertiesSet() {
        this.insertTableIndex();
        this.insertZoneInfoTableIndex();
    }

    public void insertTableIndex() {
        String insertTableIndexHQL = "create index {0}  on {1} ( {2} )";
        String strIPAddrSQL = null;
        try {
            strIPAddrSQL = MessageFormat.format("create index {0}  on {1} ( {2} )", "zone_id_inx", "t_atic_zone_ip", "zone_id");
            this.zoneIpDao.updateBySql(strIPAddrSQL);
            this.logger.info((Object)strIPAddrSQL);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("InsertTableIndex Error " + strIPAddrSQL));
        }
    }

    public void insertZoneInfoTableIndex() {
        String insertTableIndexHQL = "create index {0}  on {1} ( {2} )";
        String strIPAddrSQL = null;
        try {
            strIPAddrSQL = MessageFormat.format("create index {0}  on {1} ( {2} )", "zone_id_index", "t_atic_zone_info", "zone_id");
            this.zoneDao.updateBySql(strIPAddrSQL);
            this.logger.info((Object)strIPAddrSQL);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("insertZoneInfoTableIndex Error " + strIPAddrSQL));
        }
    }
}

