/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.util;

import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.bis.model.FaultSeverityRule;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneListIpForm;
import com.hs.atic.sdk.zone.form.ZonePortMapForm;
import com.hs.atic.sdk.zone.util.ProgressState;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.DnsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ExportZoneConditionForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpKeyDetectUriForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpsDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.IcmpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.OtherDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.SipDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TcpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.TopNStudyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.UdpDefendPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlackWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneIpLocationForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyIOForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneWhiteForm;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public final class ZoneExportCreateUtil {
    private static ZoneExportCreateUtil zoneExportCreateUtils = null;
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final String POLICY_PROTOCOL_TCP = "TCP";
    private static final String POLICY_PROTOCOL_UDP = "UDP";
    private static final String POLICY_PROTOCOL_ICMP = "ICMP";
    private static final String POLICY_PROTOCOL_OTHER = "Other";
    private static final String POLICY_PROTOCOL_DNS = "DNS";
    private static final String POLICY_PROTOCOL_SIP = "SIP";
    private static final String POLICY_PROTOCOL_HTTP = "HTTP";
    private static final String POLICY_PROTOCOL_HTTPS = "HTTPS";
    private static final String POLICY_PROTOCOL_TOP_N_STUDY = "Top N Study";
    private static final String POLICY_PROTOCOL_TCP_DNS = "TCP_DNS";
    private static final String POLICY_PROTOCOL_UDP_DNS = "UDP_DNS";
    private static final String POLICY_PROTOCOL_DEFAULT = "DEFAULT";
    private static final String CREATE = "create";
    private static final String CREATE_SET_TRXT = "setText";
    private static final String TRUE = "1";
    private static final String FALSE = "0";
    private static final String TRUE_BOOLEAN = "true";
    private static final String FALSE_BOOLEAN = "false";

    private ZoneExportCreateUtil() {
    }

    public static ZoneExportCreateUtil getInstance() {
        if (null == zoneExportCreateUtils) {
            try {
                zoneExportCreateUtils = (ZoneExportCreateUtil)ZoneExportCreateUtil.class.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return zoneExportCreateUtils;
    }

    public static void createXml(ZonePolicyIOForm form, Map<Long, String> exportDeviceMap, Map<Long, String> filterMap, ExportZoneConditionForm conditionForm, ProgressState progressState, boolean isSupportOutbound) {
        if (null == form) {
            form = new ZonePolicyIOForm();
        }
        try {
            boolean tag1;
            String exportSelectedContent = conditionForm.getExportSelectedContent();
            Document document = DocumentHelper.createDocument();
            Element root = document.addElement("root");
            Element systemVersion = root.addElement("system-version");
            systemVersion.setText(ZoneExportCreateUtil.dealNull(form.getSystemVersion()));
            Element dimension = root.addElement("dimension");
            dimension.setText(ZoneExportCreateUtil.dealNull(form.getDimension()));
            Element time = root.addElement("time");
            time.setText(ZoneExportCreateUtil.dealNull(form.getTime()));
            String selected = conditionForm.getExportSelectedContent();
            if ("zone".equals(form.getDimension())) {
                Element needIp = root.addElement("need-ip");
                Element needLocation = root.addElement("need-location");
                Element needMode = root.addElement("need-mode");
                Element needFilter = root.addElement("need-filter");
                Element needPolicy = root.addElement("need-policy");
                Element needBlackPolicy = root.addElement("need-black-policy");
                Element needWhitePolicy = root.addElement("need-white-policy");
                if (selected.contains("ipAddress")) {
                    needIp.setText(TRUE_BOOLEAN);
                } else {
                    needIp.setText(FALSE_BOOLEAN);
                }
                if (selected.contains("blockedLocation")) {
                    needLocation.setText(TRUE_BOOLEAN);
                } else {
                    needLocation.setText(FALSE_BOOLEAN);
                }
                if (selected.contains("defenseMode")) {
                    needMode.setText(TRUE_BOOLEAN);
                } else {
                    needMode.setText(FALSE_BOOLEAN);
                }
                if (selected.contains("filter")) {
                    needFilter.setText(TRUE_BOOLEAN);
                } else {
                    needFilter.setText(FALSE_BOOLEAN);
                }
                if (selected.contains("defensePolicy")) {
                    needPolicy.setText(TRUE_BOOLEAN);
                } else {
                    needPolicy.setText(FALSE_BOOLEAN);
                }
                if (selected.contains("blackListPolicy")) {
                    needBlackPolicy.setText(TRUE_BOOLEAN);
                } else {
                    needBlackPolicy.setText(FALSE_BOOLEAN);
                }
                if (selected.contains("whiteListPolicy")) {
                    needWhitePolicy.setText(TRUE_BOOLEAN);
                } else {
                    needWhitePolicy.setText(FALSE_BOOLEAN);
                }
            } else {
                Element needLocation = root.addElement("need-location");
                Element needFilter = root.addElement("need-filter");
                Element needPolicy = root.addElement("need-policy");
                if (selected.contains("ipLocation")) {
                    needLocation.setText(TRUE_BOOLEAN);
                } else {
                    needLocation.setText(FALSE_BOOLEAN);
                }
                if (selected.contains("filter")) {
                    needFilter.setText(TRUE_BOOLEAN);
                } else {
                    needFilter.setText(FALSE_BOOLEAN);
                }
                if (selected.contains("defensePolicy")) {
                    needPolicy.setText(TRUE_BOOLEAN);
                } else {
                    needPolicy.setText(FALSE_BOOLEAN);
                }
            }
            progressState.next();
            Element zoneList = root.addElement("zone-list");
            List<ZonePolicyApplyForm> zoneFormList = form.getZoneFormList();
            boolean tag = null == exportSelectedContent ? false : exportSelectedContent.contains("defensePolicy");
            boolean bl = tag1 = "device".equals(conditionForm.getDimension()) ? tag : true;
            if (null != zoneFormList && !zoneFormList.isEmpty() && tag1) {
                for (ZonePolicyApplyForm zonePolicyApplyForm : zoneFormList) {
                    Element zone = zoneList.addElement("zone");
                    Element zoneInfo = zone.addElement("zone-info");
                    ZoneExportCreateUtil.dealZone(zone, zoneInfo, zonePolicyApplyForm, exportDeviceMap, filterMap, conditionForm, isSupportOutbound);
                }
            } else {
                ZonePolicyApplyForm zonePolicyApplyForm;
                Element zone = zoneList.addElement("zone");
                zonePolicyApplyForm = new ZonePolicyApplyForm();
                Element zoneInfo = zone.addElement("zone-info");
                ZoneExportCreateUtil.dealZone(zone, zoneInfo, zonePolicyApplyForm, exportDeviceMap, filterMap, conditionForm, isSupportOutbound);
            }
            progressState.next();
            ZoneExportCreateUtil.outPutXml(document, conditionForm.getExportFilePath());
            progressState.next();
        }
        catch (RuntimeException e) {
            log.error((Object)"Generate XML file node failure :", (Throwable)e);
            throw new LegoCheckedException(571984L, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outPutXml(Document doc, String exportFilePath) {
        XMLWriter writer = null;
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        File file = new File(exportFilePath);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"File found failure :");
        }
        try {
            writer = new XMLWriter((OutputStream)fos, format);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"create XMLWriter is failure :", (Throwable)e);
        }
        try {
            if (null != writer) {
                writer.write(doc);
            }
        }
        catch (IOException e) {
            log.error((Object)"write out XML file is failure :", (Throwable)e);
        }
        finally {
            try {
                if (null != writer) {
                    writer.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Close writer is error", (Throwable)e);
            }
            ZoneExportCreateUtil.closeFileOutput(fos);
        }
    }

    private static void closeFileOutput(FileOutputStream fileOutput) {
        try {
            if (null != fileOutput) {
                fileOutput.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"Close FileOutputStream is error", (Throwable)e);
        }
    }

    private static String dealNull(Object str) {
        return null != str ? str.toString() : "";
    }

    private static String dealBoolean(Object str) {
        return TRUE_BOOLEAN.equals(str + "") ? TRUE : FALSE;
    }

    private static void createTcp(Element policylist, ZoneServiceForm zoneServiceForm, String pro, String tag) {
        Element policyTcp = policylist.addElement("policy");
        Element protocol = policyTcp.addElement("protocol");
        Element blockEnable = policyTcp.addElement("block-enable");
        Element trafficLimitingEnable = policyTcp.addElement("traffic-limiting-enable");
        Element tcpTrafficLimitingEnable = policyTcp.addElement("tcp-traffic-limiting-enable");
        Element tcpTrafficLimitingThreshold = policyTcp.addElement("tcp-traffic-limiting-threshold");
        Element tcpFragmentTrafficLimitingEnable = policyTcp.addElement("tcp-fragment-traffic-limiting-enable");
        Element trafficLimitingThreshold = policyTcp.addElement("tcp-fragment-traffic-limiting-threshold");
        Element tcpNewDestSessionLimitingEnable = policyTcp.addElement("tcp-new-dest-session-limiting-enable");
        Element tcpNewDestSessionLimitingThreshold = policyTcp.addElement("tcp-new-dest-session-limiting-threshold");
        Element defenseEnable = policyTcp.addElement("defense-enable");
        Element tcpDefenseEnable = policyTcp.addElement("tcp-abnormal-defense-enable");
        Element tcpDefenseThreshold = policyTcp.addElement("tcp-abnormal-defense-threshold");
        Element tcpBasicDefenseEnable = policyTcp.addElement("tcp-basic-defense-enable");
        Element synFloodAttackDefenseEnable = policyTcp.addElement("syn-flood-attack-defense-enable");
        Element synFloodAttackDefenseFirstPacketCheckEnable = policyTcp.addElement("syn-flood-attack-defense-first-packet-check-enable");
        Element synFloodAttackDefenseFirstPacketCheckInterval = policyTcp.addElement("syn-flood-attack-defense-first-packet-check-interval");
        Element synFloodAttackDefenseThreshold = policyTcp.addElement("syn-flood-attack-defense-threshold");
        Element synflooddefendmodeEnable = policyTcp.addElement("syn-flood-attack-defense-auth-enable");
        Element synfloodMode = policyTcp.addElement("syn-flood-attack-defense-auth-mode");
        Element synRationLimiteEnable = policyTcp.addElement("source-ip-syn-ratio-anomaly-limiting-enable");
        Element synRationLimiteThreshold = policyTcp.addElement("source-ip-syn-ratio-anomaly-limiting-threshold");
        Element synRationLimitecycle = policyTcp.addElement("source-ip-syn-ratio-anomaly-limiting-cycle");
        Element synRationLimitePacketsThreshold = policyTcp.addElement("source-ip-syn-ratio-anomaly-limiting-packets-threshold");
        Element synRationLimitePacketscycle = policyTcp.addElement("source-ip-syn-ratio-anomaly-limiting-packets-cycle");
        Element synAckFloodEnable = policyTcp.addElement("synack-flood-attack-defense-enable");
        Element synAckFloodAlertRate = policyTcp.addElement("synack-flood-attack-defense-threshold");
        Element synAckSourceEnable = policyTcp.addElement("synack-flood-attack-defense-source-enable");
        Element synAckFirstPacketCheckEnable = policyTcp.addElement("synack-flood-attack-defense-first-packet-check-enable");
        Element synAckLimit = policyTcp.addElement("synack-flood-attack-defense-first-packet-check-interval");
        Element ackDefenseEnable = policyTcp.addElement("ack-flood-attack-defense-enable");
        Element ackDefenseMode = policyTcp.addElement("ack-flood-attack-defense-mode");
        Element ackDefenseThreshold = policyTcp.addElement("ack-flood-attack-defense-threshold");
        Element tcpFragmentAttackDefenseEnable = policyTcp.addElement("tcp-fragment-attack-defense-enable");
        Element tcpFragmentAattackDefenseTthreshold = policyTcp.addElement("tcp-fragment-attack-defense-threshold");
        Element finDefenseEnable = policyTcp.addElement("fin-flood-attack-defense-enable");
        Element finDefenseThreshold = policyTcp.addElement("fin-flood-attack-defense-threshold");
        Element tcpFirestPacketCheck = policyTcp.addElement("tcp-first-packet-check-enable");
        Element tcpFirestPacketCheckInterval = policyTcp.addElement("tcp-first-packet-check-interval");
        Element sourceIpLimitingEnable = policyTcp.addElement("source-ip-tcp-ratio-anomaly-limiting-enable");
        Element sourceIpLimitingThreshold = policyTcp.addElement("source-ip-tcp-ratio-anomaly-limiting-threshold");
        Element tcpConnectionDefenseEnable = policyTcp.addElement("tcp-connection-flood-attack-defense-enable");
        Element destinationIpAddressThreshold = policyTcp.addElement("concurrent-connection-check-by-destination-ip-address-threshold");
        Element newDestinationIpAddressThreshold = policyTcp.addElement("new-connection-rate-check-by-destination-ip-address-threshold");
        Element newSourceIpAddressEnable = policyTcp.addElement("new-connection-rate-check-by-source-ip-address-enable");
        Element newSourceIpAddressThreshold = policyTcp.addElement("new-connection-rate-check-by-source-ip-address-threshold");
        Element newSourceIpAddressCheckCycle = policyTcp.addElement("new-connection-rate-check-by-source-ip-address-check-cycle");
        Element sourceIpAddressEnable = policyTcp.addElement("connection-number-check-for-source-ip-address-enable");
        Element sourceIpAddressThreshold = policyTcp.addElement("connection-number-check-for-source-ip-address-threshold");
        Element abnormalSessionCheckEnable = policyTcp.addElement("abnormal-session-check-enable");
        Element abnormalSessionCheckThreshold = policyTcp.addElement("abnormal-session-check-threshold");
        Element abnormalSessionCheckCheckCycle = policyTcp.addElement("abnormal-session-check-check-cycle");
        Element connectionCheckEnable = policyTcp.addElement("null-connection-check-enable");
        Element connectionCheckMinimumPacketsPerConnection = policyTcp.addElement("null-connection-check-minimum-packets-per-connection");
        Element connectionCheckCheckCycle = policyTcp.addElement("null-connection-check-check-cycle");
        Element retransmissionSessionCheckEnable = policyTcp.addElement("retransmission-session-check-enable");
        Element packetNumberThreshold = policyTcp.addElement("retransmission-session-check-retransmission-packet-number-threshold");
        Element sockstressEnable = policyTcp.addElement("sockstress-enable");
        Element windowSizeThreshold = policyTcp.addElement("sockstress-tcp-window-size-threshold");
        Element sessionCheckEnable = policyTcp.addElement("session-check-enable");
        Element sessionConnRate = policyTcp.addElement("session-conn-rate");
        Element sessionCheckDuration = policyTcp.addElement("session-check-duration");
        Element ackCheckEnable = policyTcp.addElement("ack-check-enable");
        Element ackMinPacketsNum = policyTcp.addElement("ack-min-packets-num");
        Element bigPacketLength = policyTcp.addElement("big-packet-length");
        Element bigPacketRatio = policyTcp.addElement("big-packet-ratio");
        Element synCheckEnable = policyTcp.addElement("syn-check-enable");
        Element synPacketsNum = policyTcp.addElement("syn-packets-num");
        Element synratioLimitPackets = policyTcp.addElement("syn-ratio-Limit-packets");
        Element synBlackListEnable = policyTcp.addElement("syn-blackList-enable");
        Element synExceptionTimes = policyTcp.addElement("syn-exception-times");
        Element synTotalCheckTimes = policyTcp.addElement("syn-total-check-times");
        protocol.setText(pro);
        TcpDefendPolicyForm tcpDefendPolicyForm = null;
        if (null != zoneServiceForm && !CREATE.equals(tag)) {
            tcpDefendPolicyForm = zoneServiceForm.getTcpDefendPolicyForm();
        }
        blockEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpBlock()));
        trafficLimitingEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpLimitEnable()));
        tcpTrafficLimitingEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpLimitSubEnable()));
        tcpTrafficLimitingThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getMaxSpeed()));
        tcpFragmentTrafficLimitingEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpFragLimitEnable()));
        trafficLimitingThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getFragMaxSpeed()));
        tcpNewDestSessionLimitingEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpNewDestSessionLimitEnable()));
        tcpNewDestSessionLimitingThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getTcpNewDestSessionLimit()));
        defenseEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpDefendEnable()));
        tcpDefenseEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpAbnormalEnable()));
        tcpDefenseThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getTcpAbnormalAlertRate()));
        tcpBasicDefenseEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpBasicEnable()));
        synFloodAttackDefenseEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSynfloodEnable()));
        synFloodAttackDefenseFirstPacketCheckEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSynFirstPacketCheckEnable()));
        synFloodAttackDefenseFirstPacketCheckInterval.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealFirstPacketInterval(tcpDefendPolicyForm.getFirstPacketCheckLowerLimit(), tcpDefendPolicyForm.getFirstPacketCheckUpperLimit()));
        synFloodAttackDefenseThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynfloodAlertRate()));
        synflooddefendmodeEnable.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSynFloodDefendModeEnable()));
        synfloodMode.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynfloodMode()));
        synRationLimiteEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSynratioEnable()));
        synRationLimiteThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynratioLimitRate()));
        synRationLimitecycle.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynratioDuration()));
        synRationLimitePacketsThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynMaxPackets()));
        synRationLimitePacketscycle.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynMaxPacketsDuration()));
        synAckFloodEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSynAckFloodEnable()));
        synAckFloodAlertRate.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynAckFloodAlertRate()));
        synAckSourceEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSynAckSourceEnable()));
        synAckFirstPacketCheckEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSynAckFirstPacketCheckEnable()));
        synAckLimit.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealFirstPacketInterval(tcpDefendPolicyForm.getSynAckLowerLimit(), tcpDefendPolicyForm.getSynAckUpperLimit()));
        ackDefenseEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getAckFloodEnable()));
        ackDefenseMode.setText(null == tcpDefendPolicyForm ? Constant.ACK_FLOODMODE_BASIC.toString() : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getAckFloodMode()));
        ackDefenseThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getAckFloodAlertRate()));
        tcpFragmentAttackDefenseEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpFragEnable()));
        tcpFragmentAattackDefenseTthreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getTcpFragAlertRate()));
        finDefenseEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getFinRstFloodEnable()));
        finDefenseThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getFinRstFloodAlertRate()));
        tcpFirestPacketCheck.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpEnable()));
        tcpFirestPacketCheckInterval.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealFirstPacketInterval(tcpDefendPolicyForm.getTcpLowerLimit(), tcpDefendPolicyForm.getTcpUpperLimit()));
        sourceIpLimitingEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpratioEnable()));
        sourceIpLimitingThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getTcpratioLimitRate()));
        tcpConnectionDefenseEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpConnEnable()));
        destinationIpAddressThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getTcpDesttipNum()));
        newDestinationIpAddressThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getTcpNewDestipRate()));
        newSourceIpAddressEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpNewSrctipEnable()));
        newSourceIpAddressThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getTcpNewSrctipRate()));
        newSourceIpAddressCheckCycle.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getTcpNewSrctipInterval()));
        sourceIpAddressEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpSrctipEnable()));
        sourceIpAddressThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getTcpSrctipNum()));
        abnormalSessionCheckEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getIllegalSessionEnable()));
        abnormalSessionCheckThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getIllegalConnCount()));
        abnormalSessionCheckCheckCycle.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getIllegalConnCountInterval()));
        connectionCheckEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getIllegalMinConnNumEnable()));
        connectionCheckMinimumPacketsPerConnection.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getIllegalConnNum()));
        connectionCheckCheckCycle.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getIllegalConnNumInterval()));
        retransmissionSessionCheckEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSackCheckEnable()));
        packetNumberThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSackCheckMaxNumber()));
        sockstressEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getWindowSizeCheckEnable()));
        windowSizeThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getWindowSize()));
        sessionCheckEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSessionCheckEnable()));
        sessionConnRate.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSessionConnRate()));
        sessionCheckDuration.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSessionCheckDuration()));
        ackCheckEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getAckCheckEnable()));
        ackMinPacketsNum.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getAckMinPacketsNum()));
        bigPacketLength.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getBigPacketLength()));
        bigPacketRatio.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getBigPacketRatio()));
        synCheckEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSynCheckEnable()));
        synratioLimitPackets.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynratioLimitPackets()));
        packetNumberThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSackCheckMaxNumber()));
        synBlackListEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSynBlackListEnable()));
        synExceptionTimes.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynExceptionTimes()));
        synTotalCheckTimes.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynTotalCheckTimes()));
        synCheckEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSynCheckEnable()));
        synPacketsNum.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynPacketsNum()));
    }

    private static void createUdp(Element policylist, ZoneServiceForm zoneServiceForm) {
        Element policyTcp = policylist.addElement("policy");
        Element protocol = policyTcp.addElement("protocol");
        Element blockEnable = policyTcp.addElement("block-enable");
        Element trafficLimitingEnable = policyTcp.addElement("traffic-limiting-enable");
        Element udpTtrafficLimitingEnable = policyTcp.addElement("udp-traffic-limiting-enable");
        Element udpTrafficLimitingThreshold = policyTcp.addElement("udp-traffic-limiting-threshold");
        Element udpFragmentRateLimitingEnable = policyTcp.addElement("udp-fragment-rate-limiting-enable");
        Element udpFragmentRateLimitingThreshold = policyTcp.addElement("udp-fragment-rate-limiting-threshold");
        Element udpNewDestSessionLimitingEnable = policyTcp.addElement("udp-new-dest-session-limiting-enable");
        Element udpNewDestSessionLimitingThreshold = policyTcp.addElement("udp-new-dest-session-limiting-threshold");
        Element defenseEnable = policyTcp.addElement("defense-enable");
        Element udpAbnormalDefenseEnable = policyTcp.addElement("udp-abnormal-defense-enable");
        Element udpAbnormalDefenseThreshold = policyTcp.addElement("udp-abnormal-defense-threshold");
        Element udpFloodFingerprintDefenseEnable = policyTcp.addElement("udp-flood-fingerprint-defense-enable");
        Element udpFloodFingerprintDefenseThreshold = policyTcp.addElement("udp-flood-fingerprint-defense-threshold");
        Element udpFragmentAttackDefenseEnable = policyTcp.addElement("udp-fragment-attack-defense-enable");
        Element udpFragmentAttackDefenseThreshold = policyTcp.addElement("udp-fragment-attack-defense-threshold");
        Element packetLengthLearning = policyTcp.addElement("fingerprint-learning-parameter-packet-length-learning");
        Element parameterLearningMode = policyTcp.addElement("fingerprint-learning-parameter-learning-mode");
        Element parameterOffset = policyTcp.addElement("fingerprint-learning-parameter-offset");
        Element parameterFingerprintLength = policyTcp.addElement("fingerprint-learning-parameter-fingerprint-length");
        protocol.setText(POLICY_PROTOCOL_UDP);
        UdpDefendPolicyForm udpDefendPolicyForm = null;
        if (null != zoneServiceForm) {
            udpDefendPolicyForm = zoneServiceForm.getUdpDefendPolicyForm();
        }
        blockEnable.setText(null == udpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(udpDefendPolicyForm.getUdpBlock()));
        trafficLimitingEnable.setText(null == udpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(udpDefendPolicyForm.getUdpLimitEnable()));
        udpTtrafficLimitingEnable.setText(null == udpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(udpDefendPolicyForm.getUdpMaxSpeedEnable()));
        udpTrafficLimitingThreshold.setText(null == udpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(udpDefendPolicyForm.getUdpMaxSpeed()));
        udpFragmentRateLimitingEnable.setText(null == udpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(udpDefendPolicyForm.getUdpFragMaxSpeedEnable()));
        udpFragmentRateLimitingThreshold.setText(null == udpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(udpDefendPolicyForm.getUdpFragMaxSpeed()));
        udpNewDestSessionLimitingEnable.setText(null == udpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(udpDefendPolicyForm.getUdpNewDestSessionLimitEnable()));
        udpNewDestSessionLimitingThreshold.setText(null == udpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(udpDefendPolicyForm.getUdpNewDestSessionLimit()));
        defenseEnable.setText(null == udpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(udpDefendPolicyForm.getUdpDefendEnable()));
        udpAbnormalDefenseEnable.setText(null == udpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(udpDefendPolicyForm.getUdpAbnormalEnable()));
        udpAbnormalDefenseThreshold.setText(null == udpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(udpDefendPolicyForm.getUdpAbnormalAlertRate()));
        udpFloodFingerprintDefenseEnable.setText(null == udpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(udpDefendPolicyForm.getAlertSpeedEnable()));
        udpFloodFingerprintDefenseThreshold.setText(null == udpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(udpDefendPolicyForm.getAlertSpeed()));
        udpFragmentAttackDefenseEnable.setText(null == udpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(udpDefendPolicyForm.getFragAlertSpeedEnable()));
        udpFragmentAttackDefenseThreshold.setText(null == udpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(udpDefendPolicyForm.getFragAlertSpeed()));
        packetLengthLearning.setText(null == udpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(udpDefendPolicyForm.getPacketLengthLearn()));
        parameterLearningMode.setText(null == udpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(udpDefendPolicyForm.getLearnMode()));
        parameterOffset.setText(null == udpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(udpDefendPolicyForm.getUdpOffset()));
        parameterFingerprintLength.setText(null == udpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(udpDefendPolicyForm.getFingerprintLength()));
    }

    private static void createIcmp(Element policylist, ZoneServiceForm zoneServiceForm) {
        Element policyTcp = policylist.addElement("policy");
        Element protocol = policyTcp.addElement("protocol");
        Element blockEnable = policyTcp.addElement("block-enable");
        Element trafficLimitingEnable = policyTcp.addElement("traffic-limiting-enable");
        Element trafficLimitingSubEnable = policyTcp.addElement("traffic-limiting-sub-enable");
        Element trafficLimitingThreshold = policyTcp.addElement("traffic-limiting-threshold");
        Element icmpNewDestSessionLimitingEnable = policyTcp.addElement("icmp-new-dest-session-limiting-enable");
        Element icmpNewDestSessionLimitingThreshold = policyTcp.addElement("icmp-new-dest-session-limiting-threshold");
        protocol.setText(POLICY_PROTOCOL_ICMP);
        IcmpDefendPolicyForm icmpDefendPolicyForm = null;
        if (null != zoneServiceForm) {
            icmpDefendPolicyForm = zoneServiceForm.getIcmpDefendPolicyForm();
        }
        blockEnable.setText(null == icmpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(icmpDefendPolicyForm.getIcmpBlockEnable()));
        trafficLimitingEnable.setText(null == icmpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(icmpDefendPolicyForm.getIcmpMaxSpeedEnable()));
        trafficLimitingSubEnable.setText(null == icmpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(icmpDefendPolicyForm.getIcmpLimitSubEnable()));
        trafficLimitingThreshold.setText(null == icmpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(icmpDefendPolicyForm.getIcmpMaxSpeed()));
        icmpNewDestSessionLimitingEnable.setText(null == icmpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(icmpDefendPolicyForm.getIcmpNewDestSessionLimitEnable()));
        icmpNewDestSessionLimitingThreshold.setText(null == icmpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(icmpDefendPolicyForm.getIcmpNewDestSessionLimit()));
    }

    private static void createOther(Element policylist, ZoneServiceForm zoneServiceForm) {
        Element policyTcp = policylist.addElement("policy");
        Element protocol = policyTcp.addElement("protocol");
        Element blockEnable = policyTcp.addElement("block-enable");
        Element trafficLimitingEnable = policyTcp.addElement("traffic-limiting-enable");
        Element trafficLimitingSubEnable = policyTcp.addElement("traffic-limiting-sub-enable");
        Element trafficLimitingThreshold = policyTcp.addElement("traffic-limiting-threshold");
        Element otherNewDestSessionLimitingEnable = policyTcp.addElement("other-new-dest-session-limiting-enable");
        Element otherNewDestSessionLimitingThreshold = policyTcp.addElement("other-new-dest-session-limiting-threshold");
        Element defenseEnable = policyTcp.addElement("defense-enable");
        Element defenseThreshold = policyTcp.addElement("defense-threshold");
        protocol.setText(POLICY_PROTOCOL_OTHER);
        OtherDefendPolicyForm otherDefendPolicyForm = null;
        if (null != zoneServiceForm) {
            otherDefendPolicyForm = zoneServiceForm.getOtherDefendPolicyForm();
        }
        blockEnable.setText(null == otherDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(otherDefendPolicyForm.getOtherBlock()));
        trafficLimitingEnable.setText(null == otherDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(otherDefendPolicyForm.getOtherDefendEnable()));
        trafficLimitingSubEnable.setText(null == otherDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(otherDefendPolicyForm.getOtherLimitSubEnable()));
        trafficLimitingThreshold.setText(null == otherDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(otherDefendPolicyForm.getOtherAlertRate()));
        defenseEnable.setText(null == otherDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(otherDefendPolicyForm.getOtherDefenseEnable()));
        defenseThreshold.setText(null == otherDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(otherDefendPolicyForm.getFingerAlert()));
        otherNewDestSessionLimitingEnable.setText(null == otherDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(otherDefendPolicyForm.getOtherNewDestSessionLimitEnable()));
        otherNewDestSessionLimitingThreshold.setText(null == otherDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(otherDefendPolicyForm.getOtherNewDestSessionLimit()));
    }

    private static void createDns(Element policylist, ZoneServiceForm zoneServiceForm, String pro, String tag) {
        Element policyTcp = policylist.addElement("policy");
        Element protocol = policyTcp.addElement("protocol");
        Element blockEnable = null;
        if (POLICY_PROTOCOL_UDP_DNS.equals(pro)) {
            blockEnable = policyTcp.addElement("block-enable");
        }
        Element sourceRateLimitingEnable = policyTcp.addElement("source-rate-limiting-enable");
        Element requestSourceIpAddressEnable = policyTcp.addElement("rate-limiting-on-request-packets-of-source-ip-address-enable");
        Element requestSourceIpAddressThreshold = policyTcp.addElement("rate-limiting-on-request-packets-of-source-ip-address-threshold");
        Element replytSourceIpAddressEnable = policyTcp.addElement("rate-limiting-on-reply-packets-of-source-ip-address-enable");
        Element replySourceIpAddressThreshold = policyTcp.addElement("rate-limiting-on-reply-packets-of-source-ip-address-threshold");
        Element defenseEnable = policyTcp.addElement("defense-enable");
        Element cacheServerEnable = policyTcp.addElement("unique-configuration-item-of-the-cache-server-enable");
        Element cacheServerRFADefenseEnable = policyTcp.addElement("cache-server-dns-request-flood-attack-defense-enable");
        Element cacheServerRFADefenseMode = policyTcp.addElement("cache-server-dns-request-flood-attack-defense-mode");
        Element cacheServerRFADefenseThreshold = policyTcp.addElement("cache-server-dns-request-flood-attack-defense-threshold");
        Element authorizationServerEnable = policyTcp.addElement("unique-configuration-item-of-the-authorization-server-enable");
        Element authDefenseEnable = policyTcp.addElement("authorization-server-dns-request-flood-attack-defense-enable");
        Element authDefenseMode = policyTcp.addElement("authorization-server-dns-request-flood-attack-defense-mode");
        Element authDefenseThreshold = policyTcp.addElement("authorization-server-dns-request-flood-attack-defense-threshold");
        Element replyRFADefenseEnable = policyTcp.addElement("dns-reply-flood-attack-defense-enable");
        Element replyRFADefenseThreshold = policyTcp.addElement("dns-reply-flood-attack-defense-threshold");
        Element nxdomainEnable = policyTcp.addElement("detection-of-the-requests-for-nxdomain-enable");
        Element nxdomain = policyTcp.addElement("proportion-taken-by-the-requests-for-nxdomain");
        Element malformedEnable = policyTcp.addElement("packet-malformed-enable");
        Element malformedThreshold = policyTcp.addElement("packet-malformed-threshold");
        Element limitingEnable = policyTcp.addElement("dns-request-packet-length-limiting-enable");
        Element limitingThreshold = policyTcp.addElement("dns-request-packet-length-limiting-threshold");
        Element replyLimitingEnable = policyTcp.addElement("dns-reply-packet-length-limiting-enable");
        Element replyLimitingThreshold = policyTcp.addElement("dns-reply-packet-length-limiting-threshold");
        Element dnsFirestPacketCheck = policyTcp.addElement("dns-first-packet-check-enable");
        Element dnsFirestPacketCheckInterval = policyTcp.addElement("dns-first-packet-check-interval");
        protocol.setText(pro);
        DnsDefendPolicyForm dnsDefendPolicyForm = null;
        if (null != zoneServiceForm && !CREATE.equals(tag)) {
            dnsDefendPolicyForm = zoneServiceForm.getDnsDefendPolicyForm();
        }
        if (null != blockEnable) {
            blockEnable.setText(null == dnsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(dnsDefendPolicyForm.getDnsBlock()));
        }
        sourceRateLimitingEnable.setText(null == dnsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(dnsDefendPolicyForm.getLimitEnable()));
        requestSourceIpAddressEnable.setText(null == dnsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(dnsDefendPolicyForm.getSrcipReqLimitEnable()));
        requestSourceIpAddressThreshold.setText(null == dnsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(dnsDefendPolicyForm.getSrcipReqAlertRate()));
        replytSourceIpAddressEnable.setText(null == dnsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(dnsDefendPolicyForm.getSrcipRespLimitEnable()));
        replySourceIpAddressThreshold.setText(null == dnsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(dnsDefendPolicyForm.getSrcipRespAlertRate()));
        defenseEnable.setText(null == dnsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(dnsDefendPolicyForm.getDnsDefendEnable()));
        String cacheEnable = null == dnsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(dnsDefendPolicyForm.getDnsCacheServerEnable());
        cacheServerEnable.setText(cacheEnable);
        if (!FALSE.equals(cacheEnable)) {
            cacheServerRFADefenseEnable.setText(null == dnsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(dnsDefendPolicyForm.getDnsFloodEnable()));
            cacheServerRFADefenseMode.setText(null == dnsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(dnsDefendPolicyForm.getDefendMode()));
            cacheServerRFADefenseThreshold.setText(null == dnsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(dnsDefendPolicyForm.getAlertRate()));
        } else {
            cacheServerRFADefenseEnable.setText(FALSE);
            cacheServerRFADefenseMode.setText("");
            cacheServerRFADefenseThreshold.setText("");
        }
        String str = null == dnsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(dnsDefendPolicyForm.getDnsAuthServerEnable());
        authorizationServerEnable.setText(str);
        if (!FALSE.equals(str)) {
            authDefenseEnable.setText(null == dnsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(dnsDefendPolicyForm.getDnsFloodEnable()));
            authDefenseMode.setText(null == dnsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(dnsDefendPolicyForm.getDefendMode()));
            authDefenseThreshold.setText(null == dnsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(dnsDefendPolicyForm.getAlertRate()));
        } else {
            authDefenseEnable.setText(FALSE);
            authDefenseMode.setText("");
            authDefenseThreshold.setText("");
        }
        replyRFADefenseEnable.setText(null == dnsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(dnsDefendPolicyForm.getReplyFloodEnable()));
        replyRFADefenseThreshold.setText(null == dnsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(dnsDefendPolicyForm.getReplyFloodAlertRate()));
        nxdomainEnable.setText(null == dnsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(dnsDefendPolicyForm.getNoSuchNameCheckEnable()));
        nxdomain.setText(null == dnsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(dnsDefendPolicyForm.getNoSuchNameCheckAlertRatio()));
        malformedEnable.setText(null == dnsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(dnsDefendPolicyForm.getFormatCheckEnable()));
        malformedThreshold.setText(null == dnsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(dnsDefendPolicyForm.getFormatCheckRatio()));
        limitingEnable.setText(null == dnsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(dnsDefendPolicyForm.getDnsRequestMessageLenLimitEnable()));
        limitingThreshold.setText(null == dnsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(dnsDefendPolicyForm.getDnsRequestMessageLen()));
        replyLimitingEnable.setText(null == dnsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(dnsDefendPolicyForm.getDnsReponseMessageLenLimitEnable()));
        replyLimitingThreshold.setText(null == dnsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(dnsDefendPolicyForm.getDnsResponseMessageLen()));
        dnsFirestPacketCheck.setText(null == dnsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(dnsDefendPolicyForm.getDnsEnable()));
        dnsFirestPacketCheckInterval.setText(null == dnsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealFirstPacketInterval(dnsDefendPolicyForm.getDnsLowerLimit(), dnsDefendPolicyForm.getDnsUpperLimit()));
    }

    private static void createSip(Element policylist, ZoneServiceForm zoneServiceForm) {
        Element policyTcp = policylist.addElement("policy");
        Element protocol = policyTcp.addElement("protocol");
        Element blockEnable = policyTcp.addElement("block-enable");
        Element trafficLimitingEnable = policyTcp.addElement("traffic-limiting-enable");
        Element trafficLimitingThreshold = policyTcp.addElement("traffic-limiting-threshold");
        Element defenseEnable = policyTcp.addElement("defense-enable");
        Element sourceDetectionEnable = policyTcp.addElement("source-detection-enable");
        Element sourceDetectionThreshold = policyTcp.addElement("source-detection-threshold");
        Element sourceIpAddressEnable = policyTcp.addElement("rate-limiting-of-source-ip-address-enable");
        Element sourceIpAddressThreshold = policyTcp.addElement("rate-limiting-of-source-ip-address-threshold");
        protocol.setText(POLICY_PROTOCOL_SIP);
        SipDefendPolicyForm sipDefendPolicyForm = null;
        if (null != zoneServiceForm) {
            sipDefendPolicyForm = zoneServiceForm.getSipDefendPolicyForm();
        }
        blockEnable.setText(null == sipDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(sipDefendPolicyForm.getSipBlock()));
        trafficLimitingEnable.setText(null == sipDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(sipDefendPolicyForm.getLimitEnable()));
        trafficLimitingThreshold.setText(null == sipDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(sipDefendPolicyForm.getLimitRate()));
        defenseEnable.setText(null == sipDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(sipDefendPolicyForm.getSipDefendEnable()));
        sourceDetectionEnable.setText(null == sipDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(sipDefendPolicyForm.getSipSrcDetectEnable()));
        sourceDetectionThreshold.setText(null == sipDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(sipDefendPolicyForm.getSipAlertRate()));
        sourceIpAddressEnable.setText(null == sipDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(sipDefendPolicyForm.getSipSrcOtherLimitEnable()));
        sourceIpAddressThreshold.setText(null == sipDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(sipDefendPolicyForm.getSipSrcOtherAlertRate()));
    }

    private static void createHttp(Element policylist, ZoneServiceForm zoneServiceForm) {
        Element policyTcp = policylist.addElement("policy");
        Element protocol = policyTcp.addElement("protocol");
        Element blockEnable = policyTcp.addElement("block-enable");
        Element trafficLimitingEnable = policyTcp.addElement("traffic-limiting-enable");
        Element trafficLimitingThreshold = policyTcp.addElement("traffic-limiting-threshold");
        Element defenseEnable = policyTcp.addElement("defense-enable");
        Element requestThreshold = policyTcp.addElement("statistics-based-on-destination-ip-address-request-threshold");
        Element sourceIpAddressEnable = policyTcp.addElement("statistics-based-on-source-ip-address-enable");
        Element sourceIpAddressThreshold = policyTcp.addElement("statistics-based-on-source-ip-address-threshold");
        Element sourceIpAddressRequestThreshold = policyTcp.addElement("statistics-based-on-source-ip-address-request-threshold");
        Element sourceDefenseEnable = policyTcp.addElement("http-source-authentication-defense-enable");
        Element sourceDefenseMode = policyTcp.addElement("http-source-authentication-defense-mode");
        Element srcDefenseEnable = policyTcp.addElement("http-source-authentication-defense-verification-code-caption-enable");
        Element sourceDefenseSettings = policyTcp.addElement("http-source-authentication-defense-verification-code-caption-settings");
        Element sourceDefenseDetectionEnable = policyTcp.addElement("http-source-authentication-defense-proxy-detection-enable");
        Element sourceDefenseHeaderEnable = policyTcp.addElement("http-source-authentication-defense-proxy-header-enable");
        Element sourceDefenseHeader = policyTcp.addElement("http-source-authentication-defense-proxy-header");
        Element sourceDefenseTerminationEnable = policyTcp.addElement("http-source-authentication-defense-termination-enable");
        Element sourceDefenseTerminationMaxNumAttempt = policyTcp.addElement("http-source-authentication-defense-termination-maxnum-attempt");
        Element sourceDefenseTerminationAttemptTime = policyTcp.addElement("http-source-authentication-defense-termination-attempt-time");
        Element sourceDefenseSynEnable = policyTcp.addElement("http-source-authentication-defense-syn-rate-limiting-enable");
        Element sourceDefenseSynThreshold = policyTcp.addElement("http-source-authentication-defense-syn-rate-limiting-threshold");
        Element sourceDefenseAckEnable = policyTcp.addElement("http-source-authentication-defense-ack-rate-limiting-enable");
        Element sourceDefenseAckThreshold = policyTcp.addElement("http-source-authentication-defense-ack-rate-limiting-threshold");
        Element firstPacketCheckEnable = policyTcp.addElement("http-first-packet-check-enable");
        Element firstPacketCheckInterval = policyTcp.addElement("http-first-packet-check-interval");
        Element learningEnable = policyTcp.addElement("http-fingerprint-learning-enable");
        Element learningCycle = policyTcp.addElement("http-fingerprint-learning-cycle");
        Element learningMatchingCounts = policyTcp.addElement("http-fingerprint-learning-matching-counts");
        Element slowAttackDefenseEnable = policyTcp.addElement("http-slow-attack-defense-enable");
        Element concurrentConnectionNumber = policyTcp.addElement("http-slow-attack-defense-concurrent-connection-number");
        Element totalPacketLength = policyTcp.addElement("http-slow-attack-defense-total-packet-length");
        Element checkPacketNumber = policyTcp.addElement("http-slow-attack-defense-check-packet-number");
        Element payloadLength = policyTcp.addElement("http-slow-attack-defense-payload-length");
        Element monitoringDetectionThreshold = policyTcp.addElement("destination-ip-based-uri-behavior-monitoring-detection-threshold");
        Element monitoringEnable = policyTcp.addElement("source-ip-based-uri-behavior-monitoring-enable");
        Element monitoringDefenseThreshold = policyTcp.addElement("source-ip-based-uri-behavior-monitoring-defense-threshold");
        Element closelyMonitoredUriList = policyTcp.addElement("closely-monitored-uri-list");
        protocol.setText(POLICY_PROTOCOL_HTTP);
        HttpDefendPolicyForm httpDefendPolicyForm = null;
        if (null != zoneServiceForm) {
            httpDefendPolicyForm = zoneServiceForm.getHttpDefendPolicyForm();
        }
        List<HttpKeyDetectUriForm> httpKeyDetectUriFormList = null;
        if (null != httpDefendPolicyForm) {
            httpKeyDetectUriFormList = httpDefendPolicyForm.getKeyDetectUriForms();
        }
        if (null != httpKeyDetectUriFormList && !httpKeyDetectUriFormList.isEmpty()) {
            for (HttpKeyDetectUriForm httpKeyDetectUriForm : httpKeyDetectUriFormList) {
                Element closelyMonitoredUri = closelyMonitoredUriList.addElement("closely-monitored-uri");
                Element monitoredUri = closelyMonitoredUri.addElement("monitored-uri");
                Element uriMatchMode = closelyMonitoredUri.addElement("uri-match-mode");
                monitoredUri.setText(null == httpKeyDetectUriForm ? "" : ZoneExportCreateUtil.dealNull(httpKeyDetectUriForm.getHttpUri()));
                uriMatchMode.setText(null == httpKeyDetectUriForm ? "" : ZoneExportCreateUtil.dealNull(httpKeyDetectUriForm.getMatchMode()));
            }
        } else {
            Element closelyMonitoredUri = closelyMonitoredUriList.addElement("closely-monitored-uri");
            Element monitoredUri = closelyMonitoredUri.addElement("monitored-uri");
            Element uriMatchMode = closelyMonitoredUri.addElement("uri-match-mode");
            monitoredUri.setText("");
            uriMatchMode.setText("");
        }
        blockEnable.setText(null == httpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpDefendPolicyForm.getHttpBlock()));
        trafficLimitingEnable.setText(null == httpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpDefendPolicyForm.getLimitEnable()));
        trafficLimitingThreshold.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getLimitRate()));
        defenseEnable.setText(null == httpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpDefendPolicyForm.getHttpDefendEnable()));
        requestThreshold.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getHttpDestQpsAlertRate()));
        sourceIpAddressEnable.setText(null == httpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpDefendPolicyForm.getHttpSrcStaticEnable()));
        sourceIpAddressThreshold.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getHttpSrcStaticRate()));
        sourceIpAddressRequestThreshold.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getHttpSrcQpsRate()));
        sourceDefenseEnable.setText(null == httpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpDefendPolicyForm.getHttpSourceAuthEnable()));
        sourceDefenseMode.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getDefendMode()));
        srcDefenseEnable.setText(null == httpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpDefendPolicyForm.getHttpWebDetectEnable()));
        sourceDefenseSettings.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getWebTitle()));
        sourceDefenseDetectionEnable.setText(null == httpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpDefendPolicyForm.getHttpProxyEnable()));
        sourceDefenseHeaderEnable.setText(null == httpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpDefendPolicyForm.getHttpProxyHeaderEnable()));
        sourceDefenseHeader.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getHttpProxyHeader()));
        sourceDefenseTerminationEnable.setText(null == httpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpDefendPolicyForm.getDetectUriEnable()));
        sourceDefenseTerminationMaxNumAttempt.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getMaxTimes()));
        sourceDefenseTerminationAttemptTime.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getTimeout()));
        sourceDefenseSynEnable.setText(null == httpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpDefendPolicyForm.getHttpAfterAuthSynEnable()));
        sourceDefenseSynThreshold.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getAfterAuthSynRate()));
        sourceDefenseAckEnable.setText(null == httpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpDefendPolicyForm.getHttpAfterAuthAckEnable()));
        sourceDefenseAckThreshold.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getAfterAuthAckRate()));
        firstPacketCheckEnable.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealBoolean(httpDefendPolicyForm.getHttpFirstPacketEnable()));
        firstPacketCheckInterval.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealFirstPacketInterval(httpDefendPolicyForm.getHttpLowerLimit(), httpDefendPolicyForm.getHttpUpperLimit()));
        learningEnable.setText(null == httpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpDefendPolicyForm.getFingerLearnEnable()));
        learningCycle.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getLearnPeriod()));
        learningMatchingCounts.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getMatchTimes()));
        slowAttackDefenseEnable.setText(null == httpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpDefendPolicyForm.getHttpSlowAttackEnable()));
        concurrentConnectionNumber.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getHttpSlowConnNum()));
        totalPacketLength.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getHttpSlowContentLength()));
        checkPacketNumber.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getHttpSlowCheckPacketNum()));
        payloadLength.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getHttpSlowPayloadLength()));
        monitoringDetectionThreshold.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getHttpDetectNumber()));
        monitoringEnable.setText(null == httpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpDefendPolicyForm.getHttpUriEnable()));
        monitoringDefenseThreshold.setText(null == httpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpDefendPolicyForm.getIllegalRatioNumber()));
    }

    private static void createHttps(Element policylist, ZoneServiceForm zoneServiceForm) {
        Element policyTcp = policylist.addElement("policy");
        Element protocol = policyTcp.addElement("protocol");
        Element blockEnable = policyTcp.addElement("block-enable");
        Element trafficLimitingEnable = policyTcp.addElement("traffic-limiting-enable");
        Element trafficLimitingThreshold = policyTcp.addElement("traffic-limiting-threshold");
        Element defenseEnable = policyTcp.addElement("defense-enable");
        Element sourceDefenseEnable = policyTcp.addElement("https-source-authentication-defense-enable");
        Element packetThreshold = policyTcp.addElement("statistics-based-on-destination-ip-address-packet-threshold");
        Element srcIpAddEnable = policyTcp.addElement("statistics-based-on-source-ip-address-enable");
        Element sourceIpAddressThreshold = policyTcp.addElement("statistics-based-on-source-ip-address-threshold");
        Element sslDefenseEnable = policyTcp.addElement("ssl-defense-enable");
        Element maximumRenegotiationTimes = policyTcp.addElement("ssl-defense-maximum-renegotiation-times");
        Element renegotiationInterval = policyTcp.addElement("ssl-defense-renegotiation-interval");
        Element abnormalSessions = policyTcp.addElement("ssl-defense-maximum-number-of-abnormal-sessions");
        Element checkInterva = policyTcp.addElement("ssl-defense-abnormal-session-check-interva");
        Element httpsNegoCheckEnable = policyTcp.addElement("ssl-defense-renegotiation-times-check-enable");
        Element httpsSessionCheckEnable = policyTcp.addElement("ssl-defense-session-check-enable");
        Element httpsDecryptEnable = policyTcp.addElement("ssl-decrypt-defense-httpsdecryptenable");
        Element httpsDecryptAlertRate = policyTcp.addElement("ssl-decrypt-defense-httpsdecryptalertrate");
        Element serverCodeEnable = policyTcp.addElement("ssl-decrypt-defense-servercodeenable");
        Element serverCodePeriod = policyTcp.addElement("ssl-decrypt-defense-servercodeperiod");
        Element serverCodeTimes = policyTcp.addElement("ssl-decrypt-defense-servercodetimes");
        Element httpsFingerLearnEnable = policyTcp.addElement("ssl-decrypt-defense-httpsfingerlearnenable");
        Element learnPeriod = policyTcp.addElement("ssl-decrypt-defense-learnperiod");
        Element matchTimes = policyTcp.addElement("ssl-decrypt-defense-matchtimes");
        protocol.setText(POLICY_PROTOCOL_HTTPS);
        HttpsDefendPolicyForm httpsDefendPolicyForm = null;
        if (null != zoneServiceForm) {
            httpsDefendPolicyForm = zoneServiceForm.getHttpsDefendPolicyForm();
        }
        blockEnable.setText(null == httpsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpsDefendPolicyForm.getHttpsBlock()));
        trafficLimitingEnable.setText(null == httpsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpsDefendPolicyForm.getLimitEnable()));
        trafficLimitingThreshold.setText(null == httpsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpsDefendPolicyForm.getLimitRate()));
        defenseEnable.setText(null == httpsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpsDefendPolicyForm.getHttpsDefendEnable()));
        sourceDefenseEnable.setText(null == httpsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpsDefendPolicyForm.getHttpsSrcEnable()));
        packetThreshold.setText(null == httpsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpsDefendPolicyForm.getHttpsAlertRate()));
        srcIpAddEnable.setText(null == httpsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpsDefendPolicyForm.getHttpsSrcStaticEnable()));
        sourceIpAddressThreshold.setText(null == httpsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpsDefendPolicyForm.getHttpsSrcStaticRate()));
        sslDefenseEnable.setText(null == httpsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpsDefendPolicyForm.getHttpsSslEnable()));
        maximumRenegotiationTimes.setText(null == httpsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpsDefendPolicyForm.getHttpsNegonum()));
        renegotiationInterval.setText(null == httpsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpsDefendPolicyForm.getHttpsNegointerval()));
        abnormalSessions.setText(null == httpsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpsDefendPolicyForm.getHttpsIllegalnum()));
        checkInterva.setText(null == httpsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpsDefendPolicyForm.getHttpsIllegalinterval()));
        httpsNegoCheckEnable.setText(null == httpsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpsDefendPolicyForm.getHttpsNegoCheckEnable()));
        httpsSessionCheckEnable.setText(null == httpsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpsDefendPolicyForm.getHttpsSessionCheckEnable()));
        httpsDecryptEnable.setText(null == httpsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpsDefendPolicyForm.getHttpsDecryptEnable()));
        httpsDecryptAlertRate.setText(null == httpsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpsDefendPolicyForm.getHttpsDecryptAlertRate()));
        serverCodeEnable.setText(null == httpsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpsDefendPolicyForm.getServerCodeEnable()));
        serverCodePeriod.setText(null == httpsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpsDefendPolicyForm.getServerCodePeriod()));
        serverCodeTimes.setText(null == httpsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpsDefendPolicyForm.getServerCodeTimes()));
        httpsFingerLearnEnable.setText(null == httpsDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(httpsDefendPolicyForm.getHttpsFingerLearnEnable()));
        learnPeriod.setText(null == httpsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpsDefendPolicyForm.getLearnPeriod()));
        matchTimes.setText(null == httpsDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(httpsDefendPolicyForm.getMatchTimes()));
    }

    private static void createTopNStudy(Element policylist, ZoneServiceForm zoneServiceForm) {
        Element policyTcp = policylist.addElement("policy");
        Element protocol = policyTcp.addElement("protocol");
        Element hostEnable = policyTcp.addElement("http-host-enable");
        Element hostSamplingRatio = policyTcp.addElement("http-host-sampling-ratio");
        Element uriEnable = policyTcp.addElement("http-uri-enable");
        Element defenseEnable = policyTcp.addElement("http-uri-sampling-ratio");
        Element uriSamplingRatio = policyTcp.addElement("top-n-http-source-ip-addresses-enable");
        Element samplingRatio = policyTcp.addElement("top-n-http-source-ip-addresses-sampling-ratio");
        Element domainNamesEnable = policyTcp.addElement("top-n-requested-domain-names-enable");
        Element dynamicCacheEnable = policyTcp.addElement("top-n-requested-domain-names-dynamic-cache-enable");
        Element dynamicCacheValue = policyTcp.addElement("top-n-requested-domain-names-dynamic-cache-value");
        Element requestedSamplingRatio = policyTcp.addElement("top-n-requested-domain-names-sampling-ratio");
        Element ipAddressesEnable = policyTcp.addElement("top-n-dns-request-source-ip-addresses-enable");
        Element ipAddressesSamplingRatio = policyTcp.addElement("top-n-dns-request-source-ip-addresses-sampling-ratio");
        Element responseIpAddressesEnable = policyTcp.addElement("top-n-dns-response-source-ip-addresses-enable");
        Element responseIpAddressesSamplingRatio = policyTcp.addElement("top-n-dns-response-source-ip-addresses-sampling-ratio");
        Element httpsIpAddressesEnable = policyTcp.addElement("top-n-https-source-ip-addresses-enable");
        Element httpsIpAddressesSamplingRatio = policyTcp.addElement("top-n-https-source-ip-addresses-sampling-ratio");
        Element tcpIpAddressesEnable = policyTcp.addElement("top-n-tcp-source-ip-addresses-enable");
        Element tcpIpAddressesSamplingRatio = policyTcp.addElement("top-n-tcp-source-ip-addresses-sampling-ratio");
        protocol.setText(POLICY_PROTOCOL_TOP_N_STUDY);
        TopNStudyForm topNStudyForm = null;
        if (null != zoneServiceForm) {
            topNStudyForm = zoneServiceForm.getTopNStudyForm();
        }
        hostEnable.setText(null == topNStudyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(topNStudyForm.getHttpHostEnable()));
        hostSamplingRatio.setText(null == topNStudyForm ? "" : ZoneExportCreateUtil.dealNull(topNStudyForm.getHttpHostSimple()));
        uriEnable.setText(null == topNStudyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(topNStudyForm.getHttpUriEnable()));
        defenseEnable.setText(null == topNStudyForm ? "" : ZoneExportCreateUtil.dealNull(topNStudyForm.getHttpUriSimple()));
        uriSamplingRatio.setText(null == topNStudyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(topNStudyForm.getHttpSrcIpEnable()));
        samplingRatio.setText(null == topNStudyForm ? "" : ZoneExportCreateUtil.dealNull(topNStudyForm.getHttpSrcIpSimple()));
        domainNamesEnable.setText(null == topNStudyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(topNStudyForm.getDnsQueryDomainEnable()));
        dynamicCacheEnable.setText(null == topNStudyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(topNStudyForm.getTopnCacheEnable()));
        dynamicCacheValue.setText(null == topNStudyForm ? "" : ZoneExportCreateUtil.dealNull(topNStudyForm.getTopnCacheNum()));
        requestedSamplingRatio.setText(null == topNStudyForm ? "" : ZoneExportCreateUtil.dealNull(topNStudyForm.getDnsQueryDomainSimple()));
        ipAddressesEnable.setText(null == topNStudyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(topNStudyForm.getDnsQuerySrcIpEnable()));
        ipAddressesSamplingRatio.setText(null == topNStudyForm ? "" : ZoneExportCreateUtil.dealNull(topNStudyForm.getDnsQuerySrcIpSimple()));
        responseIpAddressesEnable.setText(null == topNStudyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(topNStudyForm.getDnsReqSrcIpEnable()));
        responseIpAddressesSamplingRatio.setText(null == topNStudyForm ? "" : ZoneExportCreateUtil.dealNull(topNStudyForm.getDnsReqSrcIpSimple()));
        httpsIpAddressesEnable.setText(null == topNStudyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(topNStudyForm.getHttpsEnable()));
        httpsIpAddressesSamplingRatio.setText(null == topNStudyForm ? "" : ZoneExportCreateUtil.dealNull(topNStudyForm.getHttpsSimple()));
        tcpIpAddressesEnable.setText(null == topNStudyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(topNStudyForm.getTcpNewConnEnable()));
        tcpIpAddressesSamplingRatio.setText(null == topNStudyForm ? "" : ZoneExportCreateUtil.dealNull(topNStudyForm.getTcpNewConnSimple()));
    }

    private static String dealFirstPacketInterval(Object str1, Object str2) {
        return null == str1 || null == str2 ? "" : str1 + "-" + str2;
    }

    private static void dealTcpAddTcpDns(Element policylist, ZoneServiceForm zoneServiceForm, String pro) {
        String protocol = "";
        if (null != zoneServiceForm) {
            protocol = zoneServiceForm.getProtocol();
        }
        if (POLICY_PROTOCOL_TCP_DNS.equals(pro)) {
            if (POLICY_PROTOCOL_TCP_DNS.equals(protocol)) {
                ZoneExportCreateUtil.createTcp(policylist, zoneServiceForm, POLICY_PROTOCOL_TCP_DNS, CREATE_SET_TRXT);
            } else {
                ZoneExportCreateUtil.createTcp(policylist, zoneServiceForm, POLICY_PROTOCOL_TCP_DNS, CREATE);
            }
        } else if (POLICY_PROTOCOL_TCP.equals(protocol) || POLICY_PROTOCOL_DEFAULT.equals(protocol) || POLICY_PROTOCOL_HTTP.equals(protocol) || POLICY_PROTOCOL_HTTPS.equals(protocol)) {
            ZoneExportCreateUtil.createTcp(policylist, zoneServiceForm, POLICY_PROTOCOL_TCP, CREATE_SET_TRXT);
        } else {
            ZoneExportCreateUtil.createTcp(policylist, zoneServiceForm, POLICY_PROTOCOL_TCP, CREATE);
        }
    }

    private static void dealDnsAddUdpDns(Element policylist, ZoneServiceForm zoneServiceForm, String pro) {
        String protocol = "";
        if (null != zoneServiceForm) {
            protocol = zoneServiceForm.getProtocol();
        }
        if (POLICY_PROTOCOL_UDP_DNS.equals(pro)) {
            if (POLICY_PROTOCOL_UDP_DNS.equals(protocol)) {
                ZoneExportCreateUtil.createDns(policylist, zoneServiceForm, POLICY_PROTOCOL_UDP_DNS, CREATE_SET_TRXT);
            } else {
                ZoneExportCreateUtil.createDns(policylist, zoneServiceForm, POLICY_PROTOCOL_UDP_DNS, CREATE);
            }
        } else if (POLICY_PROTOCOL_UDP.equals(protocol) || POLICY_PROTOCOL_DEFAULT.equals(protocol)) {
            ZoneExportCreateUtil.createDns(policylist, zoneServiceForm, POLICY_PROTOCOL_DNS, CREATE_SET_TRXT);
        } else {
            ZoneExportCreateUtil.createDns(policylist, zoneServiceForm, POLICY_PROTOCOL_DNS, CREATE);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void dealZone(Element zone, Element zoneInfo, ZonePolicyApplyForm zonePolicyApplyForm, Map<Long, String> exportDeviceMap, Map<Long, String> filterMap, ExportZoneConditionForm conditionForm, boolean isSupportOutbound) {
        void var39_50;
        String exportSelectedContent;
        ZoneInfoForm zoneInfoForm = null;
        if (null != zonePolicyApplyForm) {
            zoneInfoForm = zonePolicyApplyForm.getZoneInfoForm();
        }
        if (null == (exportSelectedContent = conditionForm.getExportSelectedContent())) {
            exportSelectedContent = "";
        }
        boolean tag = !"device".equals(conditionForm.getDimension());
        Element zoneId = zoneInfo.addElement("zone-id");
        Element zoneInfoAccount = zoneInfo.addElement("account");
        Element zoneInfoType = zoneInfo.addElement("type");
        Element zoneInfoName = zoneInfo.addElement("name");
        Element zoneInfoContact = zoneInfo.addElement("contact");
        Element zoneInfoPhone = zoneInfo.addElement("phone");
        Element zoneInfoMobilePhone = zoneInfo.addElement("mobile-phone");
        Element zoneInfoIndustry = zoneInfo.addElement("industry");
        Element zoneInfoPostCode = zoneInfo.addElement("post-code");
        Element zoneInfoEmail = zoneInfo.addElement("email");
        Element zoneInfoAddress = zoneInfo.addElement("address");
        Element zoneInfoDescription = zoneInfo.addElement("description");
        zoneInfoAccount.setText(null == zoneInfoForm ? "" : ZoneExportCreateUtil.dealNull(zoneInfoForm.getZoneName()));
        zoneInfoType.setText(null == zoneInfoForm ? "" : ZoneExportCreateUtil.dealNull(zoneInfoForm.getZoneType()));
        zoneInfoName.setText(null == zoneInfoForm ? "" : ZoneExportCreateUtil.dealNull(zoneInfoForm.getZoneDesc()));
        zoneInfoContact.setText(null == zoneInfoForm ? "" : ZoneExportCreateUtil.dealNull(zoneInfoForm.getContact()));
        zoneInfoPhone.setText(null == zoneInfoForm ? "" : ZoneExportCreateUtil.dealNull(zoneInfoForm.getTelephone()));
        zoneInfoMobilePhone.setText(null == zoneInfoForm ? "" : ZoneExportCreateUtil.dealNull(zoneInfoForm.getMobile()));
        zoneInfoIndustry.setText(null == zoneInfoForm ? "" : ZoneExportCreateUtil.dealNull(zoneInfoForm.getIndustry()));
        zoneInfoPostCode.setText(null == zoneInfoForm ? "" : ZoneExportCreateUtil.dealNull(zoneInfoForm.getPost()));
        zoneInfoEmail.setText(null == zoneInfoForm ? "" : ZoneExportCreateUtil.dealNull(zoneInfoForm.getEmail()));
        zoneInfoAddress.setText(null == zoneInfoForm ? "" : ZoneExportCreateUtil.dealNull(zoneInfoForm.getAddress()));
        zoneInfoDescription.setText(null == zoneInfoForm ? "" : ZoneExportCreateUtil.dealNull(zoneInfoForm.getRemark()));
        zoneId.setText(null == zoneInfoForm ? "" : ZoneExportCreateUtil.dealNull(zoneInfoForm.getZoneId()));
        if (null != zonePolicyApplyForm) {
            ZoneExportCreateUtil.exportFaultSeverrityRule(zone, zonePolicyApplyForm.getFaultSeverityRuleForm(), true);
        }
        Element zoneIpList = zone.addElement("zone-ip-list");
        List<ZoneListIpForm> zoneListIpFormList = null;
        if (null != zoneInfoForm) {
            zoneListIpFormList = zoneInfoForm.getZoneListIpFormList();
        }
        if (!(null == zoneListIpFormList || zoneListIpFormList.isEmpty() || tag && !exportSelectedContent.contains("ipAddress"))) {
            for (ZoneListIpForm zoneListIpForm : zoneListIpFormList) {
                Element zoneip = zoneIpList.addElement("zone-ip");
                ZoneExportCreateUtil.dealZoneIpList(zoneip, zoneListIpForm);
            }
        } else {
            ZoneListIpForm zoneListIpForm = new ZoneListIpForm();
            Element zoneip = zoneIpList.addElement("zone-ip");
            ZoneExportCreateUtil.dealZoneIpList(zoneip, zoneListIpForm);
        }
        Element zonePortMapList = zone.addElement("zone-port-map-list");
        List<ZonePortMapForm> zonePortMapFormList = null;
        if (null != zoneInfoForm) {
            zonePortMapFormList = zoneInfoForm.getZonePortMapFormList();
        }
        if (!(null == zonePortMapFormList || zonePortMapFormList.isEmpty() || tag && !exportSelectedContent.contains("ipAddress"))) {
            for (ZonePortMapForm zonePortMapForm : zonePortMapFormList) {
                if (null != zonePortMapForm.getDeleteFlag() && zonePortMapForm.getDeleteFlag() == 1) continue;
                Element zonePortMap = zonePortMapList.addElement("zone-port-map");
                ZoneExportCreateUtil.dealZonePortMapList(zonePortMap, zonePortMapForm);
            }
        } else {
            ZonePortMapForm zonePortMapForm = new ZonePortMapForm();
            Element zonePortMap = zonePortMapList.addElement("zone-port-map");
            ZoneExportCreateUtil.dealZonePortMapList(zonePortMap, zonePortMapForm);
        }
        Element zoneDeviceList = zone.addElement("zone-device-list");
        List<ZoneDeviceForm> zoneDeviceForms = null;
        List<Long> devicesId = conditionForm.getDeviceIds();
        if (null != zonePolicyApplyForm) {
            zoneDeviceForms = zonePolicyApplyForm.getZoneDeviceForms();
        }
        if (null != zoneDeviceForms && !zoneDeviceForms.isEmpty()) {
            int count = 0;
            for (ZoneDeviceForm zoneDeviceForm : zoneDeviceForms) {
                if (!devicesId.contains(zoneDeviceForm.getDeviceId())) continue;
                Element zoneDevice = zoneDeviceList.addElement("zone-device");
                Element deviceIp2 = zoneDevice.addElement("device-ip");
                Element vpnName = zoneDevice.addElement("vpn-name");
                String ipAddress = exportDeviceMap.get(zoneDeviceForm.getDeviceId());
                deviceIp2.setText(ZoneExportCreateUtil.dealNull(ipAddress));
                vpnName.setText(ZoneExportCreateUtil.dealNull(zoneDeviceForm.getVpnName()));
                ++count;
            }
            if (count == 0) {
                Element zoneDevice = zoneDeviceList.addElement("zone-device");
                Element deviceIp2 = zoneDevice.addElement("device-ip");
                Element vpnName = zoneDevice.addElement("vpn-name");
                deviceIp2.setText("");
                vpnName.setText("");
            }
        } else {
            Element zoneDevice = zoneDeviceList.addElement("zone-device");
            Element deviceIp2 = zoneDevice.addElement("device-ip");
            Element vpnName = zoneDevice.addElement("vpn-name");
            deviceIp2.setText("");
            vpnName.setText("");
        }
        Element defenseMode = zone.addElement("defense-mode-info");
        if (!tag || exportSelectedContent.contains("defenseMode")) {
            ZoneExportCreateUtil.dealDefenseModeInfo(defenseMode, zonePolicyApplyForm);
        } else {
            ZoneExportCreateUtil.dealDefenseModeInfo(defenseMode, null);
        }
        Element filterList2 = zone.addElement("filter-list");
        List<Long> filterIdList = null;
        if (null != zonePolicyApplyForm) {
            filterIdList = zonePolicyApplyForm.getFilterIdList();
        }
        if (!(null == filterIdList || filterIdList.isEmpty() || tag && !exportSelectedContent.contains("filter"))) {
            for (Long filterId : filterIdList) {
                Element filterName2 = filterList2.addElement("filter-name");
                String filterName = filterMap.get(filterId);
                filterName2.setText(ZoneExportCreateUtil.dealNull(filterName));
            }
        } else {
            Element filterName2 = filterList2.addElement("filter-name");
            filterName2.setText("");
        }
        Element blockedLocationList = zone.addElement("location-policy-list");
        List<ZoneIpLocationForm> zoneIpLocationList = null;
        if (null != zonePolicyApplyForm) {
            zoneIpLocationList = zonePolicyApplyForm.getZoneIpLocationList();
        }
        if (!(null == zoneIpLocationList || zoneIpLocationList.isEmpty() || tag && !exportSelectedContent.contains("blockedLocation"))) {
            for (ZoneIpLocationForm zoneIpLocationForm : zoneIpLocationList) {
                Element locationPolicy = blockedLocationList.addElement("location-policy");
                Element locationName = locationPolicy.addElement("location-name");
                Element locationAction = locationPolicy.addElement("location-action");
                Element element = locationPolicy.addElement("location-limit");
                locationName.setText(ZoneExportCreateUtil.dealNull(zoneIpLocationForm.getLocationNameEn()));
                locationAction.setText(ZoneExportCreateUtil.dealNull(zoneIpLocationForm.getLocationAction()));
                element.setText(ZoneExportCreateUtil.dealNull(zoneIpLocationForm.getLocationLimit()));
            }
        } else {
            Element locationPolicy = blockedLocationList.addElement("location-policy");
            Element locationName = locationPolicy.addElement("location-name");
            Element locationAction = locationPolicy.addElement("location-action");
            Element locationLimit = locationPolicy.addElement("location-limit");
            locationName.setText("");
            locationAction.setText("");
            locationLimit.setText("");
        }
        Element defensePolicyList = zone.addElement("defense-policy-list");
        List<Object> allZoneServices = new ArrayList();
        if (null != zonePolicyApplyForm) {
            allZoneServices = zonePolicyApplyForm.getZoneServices();
        }
        ArrayList<ZoneServiceForm> inboundZoneServices = new ArrayList<ZoneServiceForm>();
        ArrayList<ZoneServiceForm> outboundZoneServices = new ArrayList<ZoneServiceForm>();
        if (null != allZoneServices && !allZoneServices.isEmpty()) {
            for (ZoneServiceForm zoneServiceForm : allZoneServices) {
                if (1 == zoneServiceForm.getDirection()) {
                    inboundZoneServices.add(zoneServiceForm);
                }
                if (2 != zoneServiceForm.getDirection()) continue;
                outboundZoneServices.add(zoneServiceForm);
            }
        }
        if (!(inboundZoneServices.isEmpty() || tag && !exportSelectedContent.contains("defensePolicy"))) {
            for (ZoneServiceForm zoneServiceForm : inboundZoneServices) {
                ZoneExportCreateUtil.dealZoneBasicInfo(defensePolicyList, zoneServiceForm, exportDeviceMap);
            }
        } else {
            ZoneExportCreateUtil.dealZoneBasicInfo(defensePolicyList, null, exportDeviceMap);
        }
        if (null != zoneInfoForm && null != zoneInfoForm.getZoneType() && Constant.ZONE_TYPE_OF_DEFAULT.equals(zoneInfoForm.getZoneType())) {
            return;
        }
        if (isSupportOutbound) {
            Element outbound = zone.addElement("outbound");
            if (null != zonePolicyApplyForm) {
                ZoneExportCreateUtil.exportFaultSeverrityRule(outbound, zonePolicyApplyForm.getOutboundFaultSeverityRuleForm(), false);
            }
            Element element = outbound.addElement("defense-mode-info");
            if (!tag || exportSelectedContent.contains("defenseMode")) {
                ZoneExportCreateUtil.dealOutboundDefenseModeInfo(element, zonePolicyApplyForm);
            } else {
                ZoneExportCreateUtil.dealOutboundDefenseModeInfo(element, null);
            }
            ZoneExportCreateUtil.dealOutboundFilterList(outbound, zonePolicyApplyForm, tag, exportSelectedContent, filterMap);
            Element outboundDefensePolicyList = outbound.addElement("defense-policy-list");
            if (!(outboundZoneServices.isEmpty() || tag && !exportSelectedContent.contains("defensePolicy"))) {
                for (ZoneServiceForm zoneServiceForm : outboundZoneServices) {
                    ZoneExportCreateUtil.dealZoneOutboundBasicInfo(outboundDefensePolicyList, zoneServiceForm, exportDeviceMap);
                }
            } else {
                ZoneExportCreateUtil.dealZoneOutboundBasicInfo(outboundDefensePolicyList, null, exportDeviceMap);
            }
        }
        Element blackList = zone.addElement("black-policy-list");
        Object var39_48 = null;
        if (null != zonePolicyApplyForm) {
            List<ZoneBlackWhiteForm> list = zonePolicyApplyForm.getZoneBlackWhiteFormList();
        }
        if (!(null == var39_50 || var39_50.isEmpty() || tag && !exportSelectedContent.contains("blackListPolicy"))) {
            for (ZoneBlackWhiteForm zoneBlackWhiteForm : var39_50) {
                Element blackListElement = blackList.addElement("black-list");
                Element blackListIp = blackListElement.addElement("black-list-ip");
                Element blackListMask = blackListElement.addElement("black-list-mask");
                blackListIp.setText(ZoneExportCreateUtil.dealNull(zoneBlackWhiteForm.getIpAddress()));
                blackListMask.setText(ZoneExportCreateUtil.dealNull(zoneBlackWhiteForm.getMask()));
            }
        } else {
            Element blackListElement = blackList.addElement("black-list");
            Element blackListIp = blackListElement.addElement("black-list-ip");
            Element blackListMask = blackListElement.addElement("black-list-mask");
            blackListIp.setText("");
            blackListMask.setText("");
        }
        Element whiteList = zone.addElement("white-policy-list");
        List<ZoneWhiteForm> zoneWhiteFormList = null;
        if (null != zonePolicyApplyForm) {
            zoneWhiteFormList = zonePolicyApplyForm.getZoneWhiteFormList();
        }
        if (!(null == zoneWhiteFormList || zoneWhiteFormList.isEmpty() || tag && !exportSelectedContent.contains("whiteListPolicy"))) {
            for (ZoneWhiteForm zoneWhiteForm : zoneWhiteFormList) {
                Element whiteListElement = whiteList.addElement("white-list");
                Element whiteListIp = whiteListElement.addElement("white-list-ip");
                Element whiteListMask = whiteListElement.addElement("white-list-mask");
                whiteListIp.setText(ZoneExportCreateUtil.dealNull(zoneWhiteForm.getIpAddress()));
                whiteListMask.setText(ZoneExportCreateUtil.dealNull(zoneWhiteForm.getMask()));
            }
        } else {
            Element whiteListElement = whiteList.addElement("white-list");
            Element whiteListIp = whiteListElement.addElement("white-list-ip");
            Element whiteListMask = whiteListElement.addElement("white-list-mask");
            whiteListIp.setText("");
            whiteListMask.setText("");
        }
    }

    private static void dealZoneOutboundBasicInfo(Element defensePolicyList, ZoneServiceForm zoneServiceForm, Map<Long, String> exportDeviceMap) {
        Element defensePolicy = defensePolicyList.addElement("defense-policy");
        Element basicInfo = defensePolicy.addElement("basic-info");
        Element basicInfoName = basicInfo.addElement("name");
        Element basicInfodeviceIp = basicInfo.addElement("device-ip");
        Element basicInfoprotocol = basicInfo.addElement("protocol");
        basicInfoName.setText(null == zoneServiceForm ? "" : ZoneExportCreateUtil.dealNull(zoneServiceForm.getServiceName()));
        basicInfodeviceIp.setText(null == zoneServiceForm ? "" : ZoneExportCreateUtil.dealNull(exportDeviceMap.get(zoneServiceForm.getDeviceId())));
        basicInfoprotocol.setText(null == zoneServiceForm ? "" : ZoneExportCreateUtil.dealNull(zoneServiceForm.getProtocol()));
        Element policylist = defensePolicy.addElement("policy-list");
        ZoneExportCreateUtil.createTcp4Outbound(policylist, zoneServiceForm);
        ZoneExportCreateUtil.createUdp4Outbound(policylist, zoneServiceForm);
        ZoneExportCreateUtil.createIcmp4Outbound(policylist, zoneServiceForm);
    }

    private static void createTcp4Outbound(Element policylist, ZoneServiceForm zoneServiceForm) {
        Element policyTcp = policylist.addElement("policy");
        Element protocol = policyTcp.addElement("protocol");
        Element synFloodAttackDefenseEnable = policyTcp.addElement("syn-flood-attack-defense-enable");
        Element synFloodAttackDefenseThreshold = policyTcp.addElement("syn-flood-attack-defense-threshold");
        Element synFloodAttackDefenseInterval = policyTcp.addElement("syn-flood-attack-defense-interval");
        Element tcpFragmentAttackDefenseEnable = policyTcp.addElement("tcp-fragment-attack-defense-enable");
        Element tcpFragmentAattackDefenseTthreshold = policyTcp.addElement("tcp-fragment-attack-defense-threshold");
        protocol.setText(POLICY_PROTOCOL_TCP);
        TcpDefendPolicyForm tcpDefendPolicyForm = null;
        if (null != zoneServiceForm) {
            tcpDefendPolicyForm = zoneServiceForm.getTcpDefendPolicyForm();
        }
        synFloodAttackDefenseEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSynfloodEnable()));
        synFloodAttackDefenseThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynfloodAlertRate()));
        synFloodAttackDefenseInterval.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealFirstPacketInterval(tcpDefendPolicyForm.getFirstPacketCheckLowerLimit(), tcpDefendPolicyForm.getFirstPacketCheckUpperLimit()));
        tcpFragmentAttackDefenseEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpFragEnable()));
        tcpFragmentAattackDefenseTthreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getTcpFragAlertRate()));
    }

    private static void createIcmp4Outbound(Element policylist, ZoneServiceForm zoneServiceForm) {
        Element policyTcp = policylist.addElement("policy");
        Element protocol = policyTcp.addElement("protocol");
        Element trafficLimitingEnable = policyTcp.addElement("traffic-limiting-enable");
        Element trafficLimitingThreshold = policyTcp.addElement("traffic-limiting-threshold");
        protocol.setText(POLICY_PROTOCOL_ICMP);
        IcmpDefendPolicyForm icmpDefendPolicyForm = null;
        if (null != zoneServiceForm) {
            icmpDefendPolicyForm = zoneServiceForm.getIcmpDefendPolicyForm();
        }
        trafficLimitingEnable.setText(null == icmpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(icmpDefendPolicyForm.getIcmpLimitSubEnable()));
        trafficLimitingThreshold.setText(null == icmpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(icmpDefendPolicyForm.getIcmpMaxSpeed()));
    }

    private static void createUdp4Outbound(Element policylist, ZoneServiceForm zoneServiceForm) {
        Element policyTcp = policylist.addElement("policy");
        Element protocol = policyTcp.addElement("protocol");
        Element udpTtrafficLimitingEnable = policyTcp.addElement("udp-traffic-limiting-enable");
        Element udpTrafficLimitingThreshold = policyTcp.addElement("udp-traffic-limiting-threshold");
        Element udpFragmentRateLimitingEnable = policyTcp.addElement("udp-fragment-rate-limiting-enable");
        Element udpFragmentRateLimitingThreshold = policyTcp.addElement("udp-fragment-rate-limiting-threshold");
        protocol.setText(POLICY_PROTOCOL_UDP);
        UdpDefendPolicyForm udpDefendPolicyForm = null;
        if (null != zoneServiceForm) {
            udpDefendPolicyForm = zoneServiceForm.getUdpDefendPolicyForm();
        }
        udpTtrafficLimitingEnable.setText(null == udpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(udpDefendPolicyForm.getUdpMaxSpeedEnable()));
        udpTrafficLimitingThreshold.setText(null == udpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(udpDefendPolicyForm.getUdpMaxSpeed()));
        udpFragmentRateLimitingEnable.setText(null == udpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(udpDefendPolicyForm.getUdpFragMaxSpeedEnable()));
        udpFragmentRateLimitingThreshold.setText(null == udpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(udpDefendPolicyForm.getUdpFragMaxSpeed()));
    }

    private static void dealOutboundFilterList(Element outbound, ZonePolicyApplyForm zonePolicyApplyForm, Boolean tag, String exportSelectedContent, Map<Long, String> filterMap) {
        Element outboundFilterList = outbound.addElement("filter-list");
        List<Long> outboundFilterIdList = null;
        if (null != zonePolicyApplyForm) {
            outboundFilterIdList = zonePolicyApplyForm.getOutboundFilterIdList();
        }
        if (!(null == outboundFilterIdList || outboundFilterIdList.isEmpty() || tag.booleanValue() && !exportSelectedContent.contains("filter"))) {
            for (Long filterId : outboundFilterIdList) {
                Element outboundFilterName = outboundFilterList.addElement("filter-name");
                String outboundFilterNameStr = filterMap.get(filterId);
                outboundFilterName.setText(ZoneExportCreateUtil.dealNull(outboundFilterNameStr));
            }
        } else {
            Element outboundFilterName = outboundFilterList.addElement("filter-name");
            outboundFilterName.setText("");
        }
    }

    private static void dealOutboundDefenseModeInfo(Element defenseModeInfo, ZonePolicyApplyForm zonePolicyApplyForm) {
        Element filterDropThreshold = defenseModeInfo.addElement("filter_drop_thershold");
        Element flowspecAction = defenseModeInfo.addElement("flowspec_action");
        Element flowspecLimitThreshold = defenseModeInfo.addElement("flowspec_limit_threshold");
        Element flowspecRedirect = defenseModeInfo.addElement("flowspec_redirect");
        filterDropThreshold.setText(null == zonePolicyApplyForm ? "" : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getOutBoundFilterDropThreshold()));
        flowspecAction.setText(null == zonePolicyApplyForm ? "" : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getOutBoundFilterAction()));
        flowspecLimitThreshold.setText(null == zonePolicyApplyForm ? FALSE : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getOutBoundFilterLimit()));
        flowspecRedirect.setText(null == zonePolicyApplyForm ? "" : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getOutBoundNextHop()));
    }

    private static void exportFaultSeverrityRule(Element zone, FaultSeverityRuleForm faultSeverityRuleForm, boolean isInbound) {
        Element faultSeverityRuleList = zone.addElement("fault-severity-rule-list");
        ArrayList<FaultSeverityRule> list = new ArrayList<FaultSeverityRule>();
        if (null != faultSeverityRuleForm) {
            list.add(faultSeverityRuleForm.getCriticalRule());
            list.add(faultSeverityRuleForm.getMajorRule());
            list.add(faultSeverityRuleForm.getMinorRule());
            list.add(faultSeverityRuleForm.getWarningRule());
        } else {
            list.add(new FaultSeverityRule());
            list.add(new FaultSeverityRule());
            list.add(new FaultSeverityRule());
            list.add(new FaultSeverityRule());
        }
        for (FaultSeverityRule rule : list) {
            Element faultSeverityRule = faultSeverityRuleList.addElement("fault-severity-rule");
            Element severity = faultSeverityRule.addElement("severity");
            Element inTrafficMbpsStatus = faultSeverityRule.addElement("in-traffic-mbps-status");
            Element inTrafficMbps = faultSeverityRule.addElement("in-traffic-mbps");
            Element inTrafficppsStatus = faultSeverityRule.addElement("in-traffic-pps-status");
            Element inTrafficpps = faultSeverityRule.addElement("in-traffic-pps");
            if (isInbound) {
                Element currentConnStatus = faultSeverityRule.addElement("current-conn-status");
                Element currentConn = faultSeverityRule.addElement("current-conn");
                Element newConnStatus = faultSeverityRule.addElement("new-conn-status");
                Element newConn = faultSeverityRule.addElement("new-conn");
                currentConnStatus.setText(null == rule ? "" : ZoneExportCreateUtil.dealNull(rule.getCurrentConnStatus()));
                currentConn.setText(null == rule ? "" : ZoneExportCreateUtil.dealNull(rule.getCurrentConn()));
                newConnStatus.setText(null == rule ? "" : ZoneExportCreateUtil.dealNull(rule.getNewConnStatus()));
                newConn.setText(null == rule ? "" : ZoneExportCreateUtil.dealNull(rule.getNewConn()));
            }
            Element durationStatus = faultSeverityRule.addElement("duration-status");
            Element duration = faultSeverityRule.addElement("duration");
            Element diversionAction = faultSeverityRule.addElement("diversion-action");
            severity.setText(null == rule ? "" : ZoneExportCreateUtil.dealNull(rule.getSeverity()));
            inTrafficppsStatus.setText(null == rule ? "" : ZoneExportCreateUtil.dealNull(rule.getInTrafficppsStatus()));
            inTrafficpps.setText(null == rule ? "" : ZoneExportCreateUtil.dealNull(rule.getInTrafficpps()));
            inTrafficMbpsStatus.setText(null == rule ? "" : ZoneExportCreateUtil.dealNull(rule.getInTrafficMbpsStatus()));
            inTrafficMbps.setText(null == rule ? "" : ZoneExportCreateUtil.dealNull(rule.getInTrafficMbps()));
            durationStatus.setText(null == rule ? "" : ZoneExportCreateUtil.dealNull(rule.getDurationStatus()));
            duration.setText(null == rule ? "" : ZoneExportCreateUtil.dealNull(rule.getDuration()));
            diversionAction.setText(null == rule ? "" : ZoneExportCreateUtil.dealNull(rule.getDiversionAction()));
        }
    }

    private static void dealZoneIpList(Element zoneip, ZoneListIpForm zoneListIpForm) {
        Element ipType = zoneip.addElement("ip-type");
        Element maskType = zoneip.addElement("mask-type");
        Element ipAddress3 = zoneip.addElement("ip-address");
        Element subnetMask = zoneip.addElement("subnet-mask");
        Element startIp = zoneip.addElement("start-ip");
        Element endIp = zoneip.addElement("end-ip");
        ipType.setText(null == zoneListIpForm ? "" : ZoneExportCreateUtil.dealNull(zoneListIpForm.getIpType()));
        maskType.setText(null == zoneListIpForm ? "" : ZoneExportCreateUtil.dealNull(zoneListIpForm.getMaskType()));
        ipAddress3.setText(null == zoneListIpForm ? "" : ZoneExportCreateUtil.dealNull(zoneListIpForm.getZoneIp()));
        subnetMask.setText(null == zoneListIpForm ? "" : ZoneExportCreateUtil.dealNull(zoneListIpForm.getIntMask()));
        startIp.setText(null == zoneListIpForm ? "" : ZoneExportCreateUtil.dealNull(zoneListIpForm.getStartIp()));
        endIp.setText(null == zoneListIpForm ? "" : ZoneExportCreateUtil.dealNull(zoneListIpForm.getEndIp()));
    }

    private static void dealZonePortMapList(Element zonePortMap, ZonePortMapForm zonePortMapForm) {
        Element ipAddress = zonePortMap.addElement("ip-address");
        ipAddress.setText(null == zonePortMapForm ? "" : ZoneExportCreateUtil.dealNull(zonePortMapForm.getIpAddress()));
        Element ipPort = zonePortMap.addElement("ip-port");
        ipPort.setText(null == zonePortMapForm ? "" : ZoneExportCreateUtil.dealNull(zonePortMapForm.getIpPort()));
        Element protocol = zonePortMap.addElement("protocol");
        protocol.setText(null == zonePortMapForm ? "" : ZoneExportCreateUtil.dealNull(zonePortMapForm.getProtocol()));
    }

    private static void dealDefenseModeInfo(Element defenseModeInfo, ZonePolicyApplyForm zonePolicyApplyForm) {
        Element trafficDiversionMode = defenseModeInfo.addElement("traffic-diversion-mode");
        Element defenseMode = defenseModeInfo.addElement("defense-mode");
        Element dynamicBlacklistMode = defenseModeInfo.addElement("dynamic-blacklist-mode");
        Element blackholeMode = defenseModeInfo.addElement("blackhole-mode");
        Element blackholeNotify = defenseModeInfo.addElement("blackhole-notify-enable");
        Element cleaningBandwidthEnable = defenseModeInfo.addElement("cleaning-bandwidth-enable");
        Element cleaningBandwidthThreshold = defenseModeInfo.addElement("cleaning-bandwidth-threshold");
        Element singleIpAddressEnable = defenseModeInfo.addElement("traffic-limiting-for-single-ip-address-enable");
        Element singleIpAddressThreshold = defenseModeInfo.addElement("traffic-limiting-for-single-ip-address-threshold");
        Element antiMalwareDos = defenseModeInfo.addElement("anti-malware-dos");
        Element antiDomainAudit = defenseModeInfo.addElement("anti-domain-audit");
        Element ipReputationEnable = defenseModeInfo.addElement("ipreputation_enable");
        Element ipReputationAlarmThreshold = defenseModeInfo.addElement("ipreputation_alarm_thershold");
        Element newDestSessionLimitEnable = defenseModeInfo.addElement("new_dest_session_limit_enable");
        Element newDestSessionLimitThreshold = defenseModeInfo.addElement("new_dest_session_limit_threshold");
        Element filterDropThreshold = defenseModeInfo.addElement("filter_drop_thershold");
        Element blackholeEnable = defenseModeInfo.addElement("blackhole_enable");
        Element blackholeThreshold = defenseModeInfo.addElement("blackhole_threshold");
        Element blackholeType = defenseModeInfo.addElement("blackhole_type");
        Element globalFilterEnable = defenseModeInfo.addElement("globalfilter_enable");
        trafficDiversionMode.setText(null == zonePolicyApplyForm ? "" : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getDivertMode()));
        defenseMode.setText(null == zonePolicyApplyForm ? "" : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getDefendMode()));
        dynamicBlacklistMode.setText(null == zonePolicyApplyForm ? "" : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getDynamicBlackMode()));
        blackholeMode.setText(null == zonePolicyApplyForm ? "" : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getBlackholeMode()));
        blackholeNotify.setText(null == zonePolicyApplyForm ? "" : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getBlackholeNotifyEnable()));
        cleaningBandwidthEnable.setText(null == zonePolicyApplyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(zonePolicyApplyForm.getZoneLimitEnable()));
        cleaningBandwidthThreshold.setText(null == zonePolicyApplyForm ? "" : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getZoneLimitRate()));
        singleIpAddressEnable.setText(null == zonePolicyApplyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(zonePolicyApplyForm.getIpLimitEnable()));
        singleIpAddressThreshold.setText(null == zonePolicyApplyForm ? "" : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getIpLimit()));
        globalFilterEnable.setText(null == zonePolicyApplyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(zonePolicyApplyForm.getGlobalFilterEnable()));
        antiMalwareDos.setText(null == zonePolicyApplyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(zonePolicyApplyForm.getDosEnable()));
        ipReputationEnable.setText(null == zonePolicyApplyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(zonePolicyApplyForm.getIpReputationEnable()));
        ipReputationAlarmThreshold.setText(null == zonePolicyApplyForm ? "" : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getIpReputationAlarmThreshold()));
        newDestSessionLimitEnable.setText(null == zonePolicyApplyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(zonePolicyApplyForm.getNewDestSessionLimitEnable()));
        newDestSessionLimitThreshold.setText(null == zonePolicyApplyForm ? "" : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getDestSessionLimit()));
        filterDropThreshold.setText(null == zonePolicyApplyForm ? "" : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getFilterDropThreshold()));
        blackholeEnable.setText(null == zonePolicyApplyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(zonePolicyApplyForm.getBlackholeEnable()));
        blackholeThreshold.setText(null == zonePolicyApplyForm ? "" : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getBlackholeThreshold()));
        blackholeType.setText(null == zonePolicyApplyForm ? "" : ZoneExportCreateUtil.dealNull(zonePolicyApplyForm.getBlackholeType()));
        antiDomainAudit.setText(null == zonePolicyApplyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(zonePolicyApplyForm.getAuditEnable()));
    }

    private static void dealZoneBasicInfo(Element defensePolicyList, ZoneServiceForm zoneServiceForm, Map<Long, String> exportDeviceMap) {
        Element defensePolicy = defensePolicyList.addElement("defense-policy");
        Element basicInfo = defensePolicy.addElement("basic-info");
        Element basicInfoName = basicInfo.addElement("name");
        Element basicInfodeviceIp = basicInfo.addElement("device-ip");
        Element basicInfoprotocol = basicInfo.addElement("protocol");
        Element basicInfoProtocolId = basicInfo.addElement("protocol-id");
        Element basicInfoIpAddressList = basicInfo.addElement("ip-address-list");
        Element basicInfoPortType = basicInfo.addElement("port-type");
        Element basicInfoDestinationPortList = basicInfo.addElement("destination-port-list");
        Element basicInfoDescription = basicInfo.addElement("description");
        basicInfoName.setText(null == zoneServiceForm ? "" : ZoneExportCreateUtil.dealNull(zoneServiceForm.getServiceName()));
        basicInfodeviceIp.setText(null == zoneServiceForm ? "" : ZoneExportCreateUtil.dealNull(exportDeviceMap.get(zoneServiceForm.getDeviceId())));
        basicInfoprotocol.setText(null == zoneServiceForm ? "" : ZoneExportCreateUtil.dealNull(zoneServiceForm.getProtocol()));
        basicInfoProtocolId.setText(null == zoneServiceForm ? "" : ZoneExportCreateUtil.dealNull(zoneServiceForm.getProtocolNum()));
        basicInfoIpAddressList.setText(null == zoneServiceForm ? "" : ZoneExportCreateUtil.dealNull(zoneServiceForm.getIpList()));
        basicInfoPortType.setText(null == zoneServiceForm ? "" : ZoneExportCreateUtil.dealNull(zoneServiceForm.getPortType()));
        basicInfoDestinationPortList.setText(null == zoneServiceForm ? "" : ZoneExportCreateUtil.dealNull(zoneServiceForm.getPortList()));
        basicInfoDescription.setText(null == zoneServiceForm ? "" : ZoneExportCreateUtil.dealNull(zoneServiceForm.getDescription()));
        Element policylist = defensePolicy.addElement("policy-list");
        String protocol = "";
        if (null != zoneServiceForm) {
            protocol = zoneServiceForm.getProtocol();
        }
        if (POLICY_PROTOCOL_TCP.equals(protocol)) {
            ZoneExportCreateUtil.dealPortBiz(policylist, zoneServiceForm);
        } else if (POLICY_PROTOCOL_DEFAULT.equals(protocol)) {
            ZoneExportCreateUtil.dealTcpAddTcpDns(policylist, zoneServiceForm, POLICY_PROTOCOL_TCP);
            ZoneExportCreateUtil.createUdp(policylist, zoneServiceForm);
            ZoneExportCreateUtil.createIcmp(policylist, zoneServiceForm);
            ZoneExportCreateUtil.createOther(policylist, zoneServiceForm);
            ZoneExportCreateUtil.dealDnsAddUdpDns(policylist, zoneServiceForm, POLICY_PROTOCOL_UDP);
            ZoneExportCreateUtil.createSip(policylist, zoneServiceForm);
            ZoneExportCreateUtil.createHttp(policylist, zoneServiceForm);
            ZoneExportCreateUtil.createHttps(policylist, zoneServiceForm);
            ZoneExportCreateUtil.createTopNStudy(policylist, zoneServiceForm);
            ZoneExportCreateUtil.dealTcpAddTcpDns(policylist, zoneServiceForm, POLICY_PROTOCOL_TCP_DNS);
            ZoneExportCreateUtil.dealDnsAddUdpDns(policylist, zoneServiceForm, POLICY_PROTOCOL_UDP_DNS);
        }
    }

    private static void dealPortBiz(Element policylist, ZoneServiceForm zoneServiceForm) {
        Element policyTcp = policylist.addElement("policy");
        Element protocol = policyTcp.addElement("protocol");
        Element sourceLimiteEnable = policyTcp.addElement("source-ip-limiting-enable");
        Element sourceLimitBandwidthEnable = policyTcp.addElement("source-ip-band-width-limiting-enable");
        Element sourceLimitBandwidthThreshold = policyTcp.addElement("source-ip-band-width-limiting-threshold");
        Element sourceLimitPacketEnable = policyTcp.addElement("source-ip-limiting-packet-enable");
        Element sourceLimitPacketThreshold = policyTcp.addElement("source-ip-limiting-packet-threshold");
        Element sourceLimitIllegalTimes = policyTcp.addElement("source-ip-limiting-anomaly-times");
        Element sourceLimitTotalTimes = policyTcp.addElement("source-ip-limiting-total-check-times");
        Element sourceLimitInterval = policyTcp.addElement("source-ip-limiting-cycle");
        Element synRationLimiteEnable = policyTcp.addElement("source-ip-syn-ratio-anomaly-limiting-enable");
        Element synRationLimiteThreshold = policyTcp.addElement("source-ip-syn-ratio-anomaly-limiting-threshold");
        Element synratioLimitPackets = policyTcp.addElement("syn-ratio-Limit-packets");
        Element synRationLimitecycle = policyTcp.addElement("source-ip-syn-ratio-anomaly-limiting-cycle");
        Element synRationLimitePacketsThreshold = policyTcp.addElement("source-ip-syn-ratio-anomaly-limiting-packets-threshold");
        Element synRationLimitePacketscycle = policyTcp.addElement("source-ip-syn-ratio-anomaly-limiting-packets-cycle");
        Element synBlackListEnable = policyTcp.addElement("syn-blackList-enable");
        Element synExceptionTimes = policyTcp.addElement("syn-exception-times");
        Element synTotalCheckTimes = policyTcp.addElement("syn-total-check-times");
        Element tcpConnectionDefenseEnable = policyTcp.addElement("tcp-connection-flood-attack-defense-enable");
        Element newSourceIpAddressEnable = policyTcp.addElement("new-connection-rate-check-by-source-ip-address-enable");
        Element newSourceIpAddressThreshold = policyTcp.addElement("new-connection-rate-check-by-source-ip-address-threshold");
        Element newSourceIpAddressCheckCycle = policyTcp.addElement("new-connection-rate-check-by-source-ip-address-check-cycle");
        Element sourceIpAddressEnable = policyTcp.addElement("connection-number-check-for-source-ip-address-enable");
        Element sourceIpAddressThreshold = policyTcp.addElement("connection-number-check-for-source-ip-address-threshold");
        protocol.setText(POLICY_PROTOCOL_TCP);
        TcpDefendPolicyForm tcpDefendPolicyForm = zoneServiceForm.getTcpDefendPolicyForm();
        sourceLimiteEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSourceLimitEnable()));
        sourceLimitBandwidthEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSourceLimitBandwidthEnable()));
        sourceLimitBandwidthThreshold.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSourceLimitBandwidthRate()));
        sourceLimitPacketEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSourceLimitPacketsEnable()));
        sourceLimitPacketThreshold.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSourceLimitPacketsRate()));
        sourceLimitIllegalTimes.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSourceLimitIllegalTimes()));
        sourceLimitTotalTimes.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSourceLimitTotalTimes()));
        sourceLimitInterval.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSourceLimitInterval()));
        synRationLimiteEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSynratioEnable()));
        synRationLimiteThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynratioLimitRate()));
        synRationLimitecycle.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynratioDuration()));
        synRationLimitePacketsThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynMaxPackets()));
        synRationLimitePacketscycle.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynMaxPacketsDuration()));
        synratioLimitPackets.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynratioLimitPackets()));
        synBlackListEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getSynBlackListEnable()));
        synExceptionTimes.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynExceptionTimes()));
        synTotalCheckTimes.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getSynTotalCheckTimes()));
        tcpConnectionDefenseEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpConnEnable()));
        newSourceIpAddressEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpNewSrctipEnable()));
        newSourceIpAddressThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getTcpNewSrctipRate()));
        newSourceIpAddressCheckCycle.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getTcpNewSrctipInterval()));
        sourceIpAddressEnable.setText(null == tcpDefendPolicyForm ? FALSE : ZoneExportCreateUtil.dealBoolean(tcpDefendPolicyForm.getTcpSrctipEnable()));
        sourceIpAddressThreshold.setText(null == tcpDefendPolicyForm ? "" : ZoneExportCreateUtil.dealNull(tcpDefendPolicyForm.getTcpSrctipNum()));
    }
}

