/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.util;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.huawei.atic.secservice.nfa.restful.model.ZoneInfoObject;
import com.huawei.atic.secservice.nfa.restful.model.ZonePolicyObject;
import java.util.List;
import org.springframework.beans.BeanUtils;

public final class ZoneUtil {
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    private ZoneUtil() {
    }

    public static Object copyProperties(Object source, Object target) {
        if (null == source || null == target) {
            log.info((Object)"source object or taget object is null");
            return null;
        }
        BeanUtils.copyProperties((Object)source, (Object)target);
        return target;
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equals(str);
    }

    public static boolean isNullExcludeNullStr(String str) {
        return str == null || "".equals(str.trim());
    }

    public static ZoneIpForm validateIpExist(ZoneIpForm zoneIp, List<ZoneIpForm> ipExists) {
        if (ipExists == null) {
            return null;
        }
        for (ZoneIpForm ipForm : ipExists) {
            String startIpExist = IPUtil.getSubnetRange((String)ipForm.getZoneIp(), (int)ipForm.getMask())[0];
            String endIpExist = IPUtil.getSubnetRange((String)ipForm.getZoneIp(), (int)ipForm.getMask())[1];
            String startIp = IPUtil.getSubnetRange((String)zoneIp.getZoneIp(), (int)zoneIp.getMask())[0];
            String endIp = IPUtil.getSubnetRange((String)zoneIp.getZoneIp(), (int)zoneIp.getMask())[1];
            try {
                if (IPUtil.compareTo((String)endIp, (String)startIpExist) < 0 || IPUtil.compareTo((String)startIp, (String)endIpExist) > 0) continue;
                return ipForm;
            }
            catch (Exception e) {
                log.error((Object)"validateIpExist exception: ", (Throwable)e);
            }
        }
        return null;
    }

    public static long convertIpFromStr2Long(String strIp) {
        if (ZoneUtil.isNull(strIp)) {
            return 0L;
        }
        long[] ip = new long[4];
        int position1 = strIp.indexOf(".");
        int position2 = strIp.indexOf(".", position1 + 1);
        int position3 = strIp.indexOf(".", position2 + 1);
        ip[0] = Long.parseLong(strIp.substring(0, position1));
        ip[1] = Long.parseLong(strIp.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(strIp.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(strIp.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static void addNfaZoneType(ZonePolicyObject zonePolicyObject, Long zoneId) {
        IZoneService zoneService = (IZoneService)ServiceContext.getInstance().getService("zoneService", IZoneService.class);
        ZoneInfoForm zoneInfoForm = zoneService.getById(zoneId);
        if (zoneInfoForm.getZoneType().intValue() == Constant.ZONE_TYPE_OF_DEFAULT.intValue()) {
            zonePolicyObject.setZoneId(1L);
        } else {
            zonePolicyObject.setZoneId(zoneId.longValue());
        }
    }

    public static void modifyNfaZoneType(ZoneInfoObject zoneInfoObject, Long zoneId) {
        IZoneService zoneService = (IZoneService)ServiceContext.getInstance().getService("zoneService", IZoneService.class);
        ZoneInfoForm zoneInfoForm = zoneService.getById(zoneId);
        if (zoneInfoForm.getZoneType().intValue() == Constant.ZONE_TYPE_OF_DEFAULT.intValue()) {
            zoneInfoObject.setZoneId(1L);
        } else {
            zoneInfoObject.setZoneId(zoneId.longValue());
        }
    }
}

