/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.dao;

import com.hs.vsm.secservice.ddos.model.BlackWhiteListInfo;
import com.hs.vsm.secservice.sdk.common.dao.BaseDao;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlackWhiteForm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BlackWhiteListDao
extends BaseDao<BlackWhiteListInfo, Long> {
    public BlackWhiteListDao() {
        super(BlackWhiteListInfo.class);
    }

    public BlackWhiteListInfo queryBlackWhiteByForm(ZoneBlackWhiteForm blackWhiteForm) {
        String hql = "from BlackWhiteListInfo where zoneId = ? and ipAddress = ? and mask = ? and blackWhiteType = ? ";
        HashMap<Integer, Object> param = new HashMap<Integer, Object>();
        param.put(0, blackWhiteForm.getZoneId());
        param.put(1, blackWhiteForm.getIpAddress());
        param.put(2, blackWhiteForm.getMask());
        param.put(3, blackWhiteForm.getBlackWhiteType());
        List list = this.queryByHql(hql, param);
        if (list != null && !list.isEmpty()) {
            return (BlackWhiteListInfo)list.get(0);
        }
        return null;
    }

    public void deleteAllByZoneId(Long zoneId) {
        String hql = "delete from BlackWhiteListInfo where zoneId = ? ";
        HashMap<Integer, Long> param = new HashMap<Integer, Long>();
        param.put(0, zoneId);
        this.executeHql(hql, param);
    }

    public void deleteByZoneIdAndDeleteFlag(Long zoneId, int deleteFlag) {
        String hql = "delete from BlackWhiteListInfo where zoneId = ? and deleteFlag = ?";
        HashMap<Integer, Number> param = new HashMap<Integer, Number>();
        param.put(0, zoneId);
        param.put(1, deleteFlag);
        this.executeHql(hql, param);
    }

    public void deleteBlackWhiteByForm(ZoneBlackWhiteForm blackWhiteForm) {
        String hql = "delete from BlackWhiteListInfo where zoneId = ? and ipAddress = ? and mask = ? ";
        HashMap<Integer, Object> param = new HashMap<Integer, Object>();
        param.put(0, blackWhiteForm.getZoneId());
        param.put(1, blackWhiteForm.getIpAddress());
        param.put(2, blackWhiteForm.getMask());
        this.executeHql(hql, param);
    }

    public void updateAllByZoneId(Long zoneId, int deleteFlag) {
        String hql = "update BlackWhiteListInfo set deleteFlag = ? where zoneId = ? ";
        HashMap<Integer, Number> param = new HashMap<Integer, Number>();
        param.put(0, deleteFlag);
        param.put(1, zoneId);
        this.executeHql(hql, param);
    }

    public void deleteAllZoneBlackWhiteList(Long zoneId, Integer blackWhiteType) {
        String hql = "delete from BlackWhiteListInfo where zoneId = ? and blackWhiteType = ? ";
        HashMap<Integer, Number> param = new HashMap<Integer, Number>();
        param.put(0, zoneId);
        param.put(1, blackWhiteType);
        this.executeHql(hql, param);
    }

    public List<BlackWhiteListInfo> queryBlackWhiteListByZoneId(Long zoneId, Integer blackWhiteType) {
        String hql = "from BlackWhiteListInfo where zoneId = ? and blackWhiteType = ? ";
        HashMap<Integer, Number> param = new HashMap<Integer, Number>();
        param.put(0, zoneId);
        param.put(1, blackWhiteType);
        List list = this.queryByHql(hql, param);
        if (list == null) {
            return new ArrayList<BlackWhiteListInfo>();
        }
        return list;
    }

    public List<BlackWhiteListInfo> getBlackWhiteListByZoneId(Long zoneId) {
        String hql = "from BlackWhiteListInfo where zoneId = ?";
        HashMap<Integer, Long> param = new HashMap<Integer, Long>();
        param.put(0, zoneId);
        List list = this.queryByHql(hql, param);
        if (list == null) {
            return new ArrayList<BlackWhiteListInfo>();
        }
        return list;
    }

    public int getBlackWhiteListNumberByZoneId(Long zoneId) {
        String hql = "select count(*) from BlackWhiteListInfo where zoneId = ? ";
        int count = this.getRowCountByHsql(hql, new Long[]{zoneId});
        return count;
    }

    public List<BlackWhiteListInfo> getBlackWhiteListByZoneIdAndType(Long zoneId, Integer blackWhiteType) {
        String hql = "from BlackWhiteListInfo where zoneId = ? and blackWhiteType = ? ";
        HashMap<Integer, Number> param = new HashMap<Integer, Number>();
        param.put(0, zoneId);
        param.put(1, blackWhiteType);
        List list = this.queryByHql(hql, param);
        if (list == null) {
            return new ArrayList<BlackWhiteListInfo>();
        }
        return list;
    }

    public List<BlackWhiteListInfo> queryPrefixBlackWhiteListByZoneId(Long zoneId, Integer blackWhiteType) {
        String hql = "from BlackWhiteListInfo where zoneId = ? and blackWhiteType = ? and deleteFlag=0 ";
        HashMap<Integer, Number> param = new HashMap<Integer, Number>();
        param.put(0, zoneId);
        param.put(1, blackWhiteType);
        List list = this.queryByHql(hql, param);
        if (list == null) {
            return new ArrayList<BlackWhiteListInfo>();
        }
        return list;
    }
}

