/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.dao;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.secservice.ddos.model.FilterInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class FilterDao
extends CommonDaoImpl {
    public FilterInfo get(long pkid) {
        String hql = "from FilterInfo where pkid = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(pkid));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (FilterInfo)result.get(0);
    }

    public List<FilterInfo> queryByFilterIds(String filterIds) {
        if (filterIds == null) {
            return new ArrayList<FilterInfo>();
        }
        String[] filters = filterIds.split(",");
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        StringBuffer hql = new StringBuffer();
        hql.append("from FilterInfo where pkid in ( ");
        for (int i = 0; i < filters.length; ++i) {
            queryMap.put(i, filters[i]);
            if (0 == i) {
                hql.append('?');
                continue;
            }
            hql.append(",? ");
        }
        hql.append(')');
        List result = this.findByHql(hql.toString(), queryMap);
        if (result == null) {
            return new ArrayList<FilterInfo>();
        }
        return result;
    }

    public Boolean filterNameExsit(Long pkid, String filterName) {
        String hql = "from FilterInfo where pkid <> ? and LOWER(filterName) = ?";
        String idString = pkid == null ? "-1" : pkid.toString();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, idString);
        param.put(1, filterName.toLowerCase(Locale.getDefault()));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return false;
        }
        return true;
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from FilterInfo where (1=1) ";
        String hql4Count = "select count(*) as rowCount ";
        int index = 0;
        String filterName = conditionMap.get("filterName");
        if (!AticUtil.isNull((String)filterName)) {
            hql = hql + " and lower(filterName) like ? ";
            queryMap.put(index, "%" + filterName.trim().toLowerCase(Locale.ENGLISH) + "%");
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public List<Integer> queryAllFilterId() {
        String hql = "select filterId from FilterInfo";
        List result = this.findByHql(hql);
        if (result == null || result.isEmpty()) {
            return new ArrayList<Integer>();
        }
        return result;
    }

    public FilterInfo queryByUnderFilterId(Long underFilterId) {
        String hql = "from FilterInfo where filter_Id = ? ";
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, underFilterId.toString());
        List list = this.findByHql(hql, queryMap);
        FilterInfo filterInfo = null;
        if (list != null && !list.isEmpty()) {
            filterInfo = (FilterInfo)list.get(0);
        }
        return filterInfo;
    }

    public List<FilterInfo> getAllfilterByName() {
        String hql = "from FilterInfo";
        List result = this.findByHql(hql);
        if (result != null) {
            return result;
        }
        return new ArrayList<FilterInfo>();
    }

    public FilterInfo queryByName(String filterName) {
        String hql = "from FilterInfo where filterName = ?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, filterName);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (FilterInfo)result.get(0);
    }

    public List<FilterInfo> queryGloFilter() {
        String hql = "from FilterInfo where filterMode = 0";
        List result = this.findByHql(hql);
        if (result != null) {
            return result;
        }
        return new ArrayList<FilterInfo>();
    }
}

