/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.dao;

import com.hs.vsm.secservice.ddos.model.NPFilterDeviceInfo;
import com.hs.vsm.secservice.sdk.common.dao.BaseDao;
import java.util.ArrayList;
import java.util.List;

public class NPFilterDeviceInfoDao
extends BaseDao<NPFilterDeviceInfo, Long> {
    public NPFilterDeviceInfoDao() {
        super(NPFilterDeviceInfo.class);
    }

    public List<NPFilterDeviceInfo> getByFilterId(Long filterId) {
        String hql = "from NPFilterDeviceInfo where filterId=?";
        List npFilterDeviceList = this.findByHql(hql, filterId);
        if (null != npFilterDeviceList && !npFilterDeviceList.isEmpty()) {
            return npFilterDeviceList;
        }
        return new ArrayList<NPFilterDeviceInfo>();
    }

    public NPFilterDeviceInfo getInfoByFilterIdAndDeviceId(Long filterId, Long deviceId) {
        String hql = "from NPFilterDeviceInfo where filterId = ? and deviceId = ?";
        Object[] objArr = new Object[]{filterId, deviceId};
        List npFilterDeviceInfoList = this.getHibernateTemplate().find(hql, objArr);
        if (npFilterDeviceInfoList != null && !npFilterDeviceInfoList.isEmpty()) {
            return (NPFilterDeviceInfo)npFilterDeviceInfoList.get(0);
        }
        return null;
    }

    public void deleteByFilterIdAndDeviceId(Long filterId, Long deviceId) {
        String hql = "delete from NPFilterDeviceInfo where filterId = ? and deviceId = ?";
        Object[] objArr = new Object[]{filterId, deviceId};
        this.getHibernateTemplate().bulkUpdate(hql, objArr);
    }

    public void deleteByDeviceId(Long deviceId) {
        String hql = "delete from NPFilterDeviceInfo where deviceId = ?";
        Object[] objArr = new Object[]{deviceId};
        this.getHibernateTemplate().bulkUpdate(hql, objArr);
    }

    public void deleteByFilterId(Long filterId) {
        String hql = "delete from NPFilterDeviceInfo where filterId = ?";
        Object[] objArr = new Object[]{filterId};
        this.getHibernateTemplate().bulkUpdate(hql, objArr);
    }

    public List<NPFilterDeviceInfo> queryNpFilterByDeviceId(Long deviceId) {
        String hql = "from NPFilterDeviceInfo where deviceId = ?";
        List npFilterDeviceInfoList = this.findByHql(hql, deviceId);
        if (null != npFilterDeviceInfoList && !npFilterDeviceInfoList.isEmpty()) {
            return npFilterDeviceInfoList;
        }
        return new ArrayList<NPFilterDeviceInfo>();
    }

    public List<NPFilterDeviceInfo> queryNpFilterByDeviceIdNotFilterId(Long deviceId, Long filterId) {
        String hql = "from NPFilterDeviceInfo where deviceId = ? ";
        Object[] objArr = null;
        if (null == filterId) {
            objArr = new Object[]{deviceId};
        } else {
            hql = hql + " and filterId <> ?";
            objArr = new Object[]{deviceId, filterId};
        }
        List npFilterDeviceInfoList = this.findByHql(hql, objArr);
        if (null != npFilterDeviceInfoList && !npFilterDeviceInfoList.isEmpty()) {
            return npFilterDeviceInfoList;
        }
        return new ArrayList<NPFilterDeviceInfo>();
    }
}

