/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.dao;

import com.hs.vsm.secservice.ddos.model.NPFilterDeviceStatusInfo;
import com.hs.vsm.secservice.sdk.common.dao.BaseDao;
import java.util.HashMap;
import java.util.List;

public class NPFilterDeviceStatusDao
extends BaseDao<NPFilterDeviceStatusInfo, Long> {
    public NPFilterDeviceStatusDao() {
        super(NPFilterDeviceStatusInfo.class);
    }

    public boolean saveNpFilterDeviceStatus(NPFilterDeviceStatusInfo npFilterDeviceStatusInfo) {
        this.createOrUpdate(npFilterDeviceStatusInfo);
        return true;
    }

    public List<NPFilterDeviceStatusInfo> getDeployedByFilterId(Long filterId) {
        String hql = "from NPFilterDeviceStatusInfo where filterId = ? and deployState = 'SUCCESS'";
        return this.getHibernateTemplate().find(hql, new Object[]{filterId});
    }

    public List<NPFilterDeviceStatusInfo> getInfoByFilterId(Long filterId) {
        String hql = "from NPFilterDeviceStatusInfo where filterId = ?";
        return this.getHibernateTemplate().find(hql, new Object[]{filterId});
    }

    public NPFilterDeviceStatusInfo getInfoByFilterIdAndDeviceId(Long filterId, Long deviceId) {
        String hql = "from NPFilterDeviceStatusInfo where filterId = ? and deviceId = ?";
        Object[] objArr = new Object[]{filterId, deviceId};
        List npFilterDeviceStatusInfoList = this.getHibernateTemplate().find(hql, objArr);
        if (npFilterDeviceStatusInfoList != null && !npFilterDeviceStatusInfoList.isEmpty()) {
            return (NPFilterDeviceStatusInfo)npFilterDeviceStatusInfoList.get(0);
        }
        return null;
    }

    public void deleteByDeviceId(Long deviceId) {
        String hql = "delete from NPFilterDeviceStatusInfo where deviceId = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceId});
    }

    public void deleteByFilterId(Long filterId) {
        String hql = "delete from NPFilterDeviceStatusInfo where filterId = ?";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{filterId});
    }

    public void deleteByFilterIdAndDeviceId(Long filterId, Long deviceId) {
        String hql = "delete from NPFilterDeviceStatusInfo where filterId = ? and deviceId = ?";
        Object[] objArr = new Object[]{filterId, deviceId};
        this.getHibernateTemplate().bulkUpdate(hql, objArr);
    }

    public NPFilterDeviceStatusInfo queryByDeviceFilterId(Long deviceId, Long npFilterId) {
        String hql = "from NPFilterDeviceStatusInfo where deviceId=? and filterId=?";
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        condition.put(0, deviceId);
        condition.put(1, npFilterId);
        List dsList = this.queryByHql(hql, condition);
        if (null != dsList && !dsList.isEmpty()) {
            return (NPFilterDeviceStatusInfo)dsList.get(0);
        }
        return new NPFilterDeviceStatusInfo();
    }

    public void updateDeployStatusByFilterId(Long filterId, String deployState) {
        String hql = "update NPFilterDeviceStatusInfo set deployState = ? where filterId = ?";
        Object[] objArr = new Object[]{deployState, filterId};
        this.getHibernateTemplate().bulkUpdate(hql, objArr);
    }
}

