/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.dao;

import com.hs.lego.cbb.user.sdk.service.CheckChildrenMoUtil;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.service.data.ZoneUdpBlockInfo;
import com.hs.vsm.secservice.sdk.common.dao.BaseDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.transform.Transformers;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.orm.hibernate5.HibernateCallback;

public class ZoneDeviceDeployStatusDao
extends BaseDao<ZoneDeviceDeployStatusInfo, Long> {
    public ZoneDeviceDeployStatusDao() {
        super(ZoneDeviceDeployStatusInfo.class);
    }

    public List<ZoneDeviceDeployStatusInfo> queryByZoneId(Long zoneId) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        StringBuffer hql = new StringBuffer();
        hql.append("from ").append(this.persistentClass.getSimpleName()).append(" where zoneId = ? and deployType != 2 ");
        condition.put(0, zoneId);
        List list = this.queryByHql(hql.toString(), condition);
        return list;
    }

    public List<ZoneDeviceDeployStatusInfo> queryByZoneId2(Long zoneId) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        StringBuffer hql = new StringBuffer();
        hql.append("from ").append(this.persistentClass.getSimpleName()).append(" where zoneId = ? ");
        condition.put(0, zoneId);
        List list = this.queryByHql(hql.toString(), condition);
        if (null != list && !list.isEmpty()) {
            return list;
        }
        return new ArrayList<ZoneDeviceDeployStatusInfo>();
    }

    public List<ZoneDeviceDeployStatusInfo> queryPolicyResultByZoneId(Long zoneId) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        StringBuffer hql = new StringBuffer();
        hql.append("from ").append(this.persistentClass.getSimpleName()).append(" where zoneId = ? ").append(" and deployType = 1");
        condition.put(0, zoneId);
        List list = this.queryByHql(hql.toString(), condition);
        return list;
    }

    public void deleteByDeviceId(Long deviceId) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        StringBuffer hql = new StringBuffer();
        hql.append("delete from ").append(this.persistentClass.getSimpleName()).append(" where deviceId = ? ");
        condition.put(0, deviceId);
        this.executeHql(hql.toString(), condition);
    }

    public void deleteByDeviceIdAndZoneId(Long deviceId, Long zoneId) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        StringBuffer hql = new StringBuffer();
        hql.append("delete from ").append(this.persistentClass.getSimpleName()).append(" where deviceId = ? and zoneId = ? ");
        condition.put(0, deviceId);
        condition.put(1, zoneId);
        this.executeHql(hql.toString(), condition);
    }

    public void deleteByZoneId(long zoneId) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        StringBuffer hql = new StringBuffer();
        hql.append("delete from ").append(this.persistentClass.getSimpleName()).append(" where zoneId = ? ");
        condition.put(0, zoneId);
        this.executeHql(hql.toString(), condition);
    }

    public void updateDeviceIdByZoneId(Long zoneId, Long lastTimeDeviceId, Long deviceId) {
        String hql = "update ZoneDeviceDeployStatusInfo set deviceId = ? where zoneId = ? and deviceId = ?";
        Object[] objArr = new Object[]{deviceId, zoneId, lastTimeDeviceId};
        this.getHibernateTemplate().bulkUpdate(hql, objArr);
    }

    public List<ZoneDeviceDeployStatusInfo> getByZoneIdAndDeviceId(Long zoneId, Long deviceId) {
        String hql = "from ZoneDeviceDeployStatusInfo where zoneId = ? and deviceId = ?";
        Object[] objArr = new Object[]{zoneId, deviceId};
        return this.getHibernateTemplate().find(hql, objArr);
    }

    public ZoneDeviceDeployStatusInfo getOneByZoneIdAndDeviceId(Long zoneId, Long deviceId, Integer deployType) {
        String hql = "from ZoneDeviceDeployStatusInfo where zoneId = ? and deviceId = ? and deployType = ?";
        Object[] objArr = new Object[]{zoneId, deviceId, deployType};
        List zoneDeviceDeployStatusInfoList = this.getHibernateTemplate().find(hql, objArr);
        if (zoneDeviceDeployStatusInfoList != null && !zoneDeviceDeployStatusInfoList.isEmpty()) {
            return (ZoneDeviceDeployStatusInfo)zoneDeviceDeployStatusInfoList.get(0);
        }
        return null;
    }

    public ZoneDeviceDeployStatusInfo queryByZoneDeviceStatus(Long zoneId) {
        String hql = "from ZoneDeviceDeployStatusInfo where zoneId = ?  and deployType = 2";
        Object[] objArr = new Object[]{zoneId};
        List zoneDeviceDeployStatusInfoList = this.getHibernateTemplate().find(hql, objArr);
        if (zoneDeviceDeployStatusInfoList != null && !zoneDeviceDeployStatusInfoList.isEmpty()) {
            return (ZoneDeviceDeployStatusInfo)zoneDeviceDeployStatusInfoList.get(0);
        }
        return null;
    }

    public List<ZoneDeviceDeployStatusInfo> queryByZoneId4Secutity(Long zoneId, Boolean isAdmin, Long userId) {
        HashMap<Integer, Long> condition = new HashMap<Integer, Long>();
        StringBuffer hql = new StringBuffer("select zoneStatus from ZoneDeviceDeployStatusInfo zoneStatus ");
        if (null != userId && !isAdmin.booleanValue()) {
            hql.append("," + CheckChildrenMoUtil.getInstanse().getGrantHqlObj());
        }
        hql.append(" where zoneStatus.zoneId = ? ");
        condition.put(0, zoneId);
        if (null != userId && !isAdmin.booleanValue()) {
            hql.append(" and zoneStatus.deviceId  =  " + CheckChildrenMoUtil.getInstanse().getGrantHql(userId.longValue()));
        }
        hql.append(" and (zoneStatus.deployType=1 or zoneStatus.deployType=3)");
        List list = this.queryByHql(hql.toString(), condition);
        return list;
    }

    public void deleteNfaDeployType(Long zoneId, int deployType) {
        HashMap<Integer, Number> condition = new HashMap<Integer, Number>();
        StringBuffer hql = new StringBuffer();
        hql.append("delete from ").append(this.persistentClass.getSimpleName()).append(" where deployType = ? and zoneId = ? ");
        condition.put(0, deployType);
        condition.put(1, zoneId);
        this.executeHql(hql.toString(), condition);
    }

    public List<ZoneUdpBlockInfo> queryAllZonesUDPBlock() {
        List find = (List)this.getHibernateTemplate().execute((HibernateCallback)new InnerClass());
        if (null == find || find.isEmpty()) {
            return null;
        }
        return find;
    }

    private static class InnerClass
    implements HibernateCallback {
        private InnerClass() {
        }

        public Object doInHibernate(Session session) {
            StringBuffer hql = new StringBuffer("");
            hql.append("SELECT u.zone_id AS zoneId,u.zone_name AS zoneName,u.zone_desc AS zoneDesc,GROUP_CONCAT(CONCAT(IFNULL(u.udp_block,0),'') SEPARATOR ',') AS udpBlock,").append(" group_concat(u.ip_address SEPARATOR ',') as ipAddress,").append(" GROUP_CONCAT(CONCAT(IFNULL(u.deploy_state,2),'') SEPARATOR ',') AS deployState,").append(" GROUP_CONCAT(CONCAT(CONCAT(u.ip_address,'_'),u.error_param) SEPARATOR ',') AS detail FROM").append(" (SELECT s.zone_name,s.zone_desc,d1.udp_block,t.ip_address,t2.deploy_state,t2.error_param ,s.zone_id FROM").append(" (SELECT o.zone_name,o.zone_desc,e.device_id,e.pkid,o.zone_id FROM").append(" t_atic_zone_info o,t_vsm_zone_service e WHERE o.zone_type=2 AND e.direction=1 AND o.zone_id=e.zone_id) s").append(" LEFT JOIN t_vsm_zone_udpflood d1 ON s.pkid = d1.service_id").append(" LEFT JOIN t_atic_device t ON s.device_id = t.moid").append(" LEFT JOIN t_vsm_zone_device_status t2 ON t2.zone_id=s.zone_id AND t2.device_id=s.device_id) u GROUP BY  u.zone_Id");
            return session.createNativeQuery(hql.toString()).addScalar("zoneId", (Type)LongType.INSTANCE).addScalar("zoneName", (Type)StringType.INSTANCE).addScalar("zoneDesc", (Type)StringType.INSTANCE).addScalar("udpBlock", (Type)StringType.INSTANCE).addScalar("deployState", (Type)StringType.INSTANCE).addScalar("ipAddress", (Type)StringType.INSTANCE).addScalar("detail", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(ZoneUdpBlockInfo.class)).list();
        }
    }
}

