/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.dao;

import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.secservice.ddos.model.ZoneServiceInfo;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.huawei.atic.device.model.AticDevice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ZoneServiceDao
extends CommonDaoImpl {
    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String moIds;
        boolean flag;
        StringBuffer hql = new StringBuffer();
        hql.append(" from ZoneServiceInfo policy where 1=1");
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        int index = 0;
        if (conditionMap.containsKey("zoneId")) {
            hql.append(" and policy.zoneId = ?");
            queryMap.put(index++, conditionMap.get("zoneId"));
        }
        boolean bl = flag = conditionMap.containsKey("direction") && 3 != Integer.parseInt(conditionMap.get("direction"));
        if (flag) {
            hql.append(" and policy.direction = ?");
            queryMap.put(index++, conditionMap.get("direction"));
        }
        if (conditionMap.containsKey("protocol")) {
            hql.append(" and  policy.protocol = ?");
            queryMap.put(index++, conditionMap.get("protocol"));
        }
        if (conditionMap.containsKey("portType")) {
            if (!"3".equals(conditionMap.get("portType"))) {
                hql.append(" and  policy.portType = ?");
                queryMap.put(index++, conditionMap.get("portType"));
            } else {
                hql.append(" and  policy.portType is null");
            }
        }
        if (conditionMap.containsKey("serviceName")) {
            hql.append(" and lower(policy.serviceName) like ? ");
            queryMap.put(index++, "%" + conditionMap.get("serviceName").trim().toLowerCase(Locale.ENGLISH) + "%");
        }
        if (conditionMap.containsKey("deviceId")) {
            hql.append(" and  policy.deviceId = ?");
            queryMap.put(index++, conditionMap.get("deviceId"));
        }
        if (conditionMap.containsKey("ddosType") && !(moIds = this.getMoIdByDevType(conditionMap)).equals("")) {
            hql.append(" and  policy.deviceId in (").append(moIds).append(')');
        }
        List result = this.findPage(hql.toString(), start, pageSize, queryMap);
        String hql4Count = "select count(*) as rowCount ";
        hql4Count = hql4Count + hql.toString();
        Long count = this.getTotalCount(hql4Count, queryMap);
        Paging page = new Paging();
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public long getDefServiceId(long zoneId, long devId) {
        StringBuffer hql = new StringBuffer();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        int index = 0;
        hql.append(" from ZoneServiceInfo policy where policy.zoneId = ?  and  policy.protocol = 'DEFAULT'  and  policy.deviceId = ?");
        queryMap.put(index++, String.valueOf(zoneId));
        queryMap.put(index, String.valueOf(devId));
        List result = this.findByHql(hql.toString(), queryMap);
        if (result == null || result.isEmpty()) {
            return 0L;
        }
        return ((ZoneServiceInfo)result.get(0)).getPkid();
    }

    private String getMoIdByDevType(Map<String, String> conditionMap) {
        String hql = "from AticDevice where (ddosType = 2 or ddosType = ?) ";
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, conditionMap.get("ddosType"));
        List deviceList = this.findByHql(hql, queryMap);
        StringBuffer ids = new StringBuffer();
        if (deviceList != null) {
            for (Object device : deviceList) {
                if (!(device instanceof AticDevice)) continue;
                if ("".equals(ids.toString())) {
                    ids.append(((AticDevice)device).getMoId());
                    continue;
                }
                ids.append(',').append(((AticDevice)device).getMoId());
            }
        }
        return ids.toString();
    }

    public void deleteByDeviceId(Long deviceId) {
        StringBuffer hql = new StringBuffer();
        hql.append("delete from ZoneServiceInfo where deviceId = ?");
        this.getHibernateTemplate().bulkUpdate(hql.toString(), new Object[]{deviceId});
    }

    public void delete(Long pkid) {
        StringBuffer hql = new StringBuffer();
        hql.append("delete from ZoneServiceInfo where pkid = ?");
        this.getHibernateTemplate().bulkUpdate(hql.toString(), new Object[]{pkid});
    }

    public void deleteByDeviceIdAndZoneId(Long deviceId, Long zoneId) {
        StringBuffer hql = new StringBuffer();
        hql.append("delete from ZoneServiceInfo where deviceId = ? and zoneId = ?");
        this.getHibernateTemplate().bulkUpdate(hql.toString(), new Object[]{deviceId, zoneId});
    }

    public List<ZoneServiceInfo> getZoneServiceInfoListByZoneId(long zoneId) {
        StringBuffer hql = new StringBuffer();
        hql.append(" from ZoneServiceInfo where zoneId = ?");
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, String.valueOf(zoneId));
        List result = this.findByHql(hql.toString(), queryMap);
        if (result == null) {
            return new ArrayList<ZoneServiceInfo>();
        }
        return result;
    }

    public List<ZoneServiceInfo> getZoneServiceInfoListByZoneIdAndDeviceId(long zoneId, long deviceId) {
        StringBuffer hqlBuffer = new StringBuffer();
        hqlBuffer.append(" from ZoneServiceInfo where zoneId = ? and deviceId = ?");
        Object[] idArray = new Object[]{zoneId, deviceId};
        List zoneServiceInfoReturnList = this.getHibernateTemplate().find(hqlBuffer.toString(), idArray);
        return zoneServiceInfoReturnList;
    }

    public List<ZoneServiceInfo> getZoneServiceByServiceName(String serviceName, long zoneId) {
        if (serviceName == null) {
            serviceName = "";
        }
        StringBuffer hql = new StringBuffer(" from ZoneServiceInfo where lower(serviceName) like ? and zoneId = ?");
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, "%" + serviceName.trim().toLowerCase(Locale.getDefault()) + "%");
        queryMap.put(1, String.valueOf(zoneId));
        List result = this.findByHql(hql.toString(), queryMap);
        if (result == null) {
            return new ArrayList<ZoneServiceInfo>();
        }
        return result;
    }

    public void updateDeviceIdByZoneId(Long zoneId, Long lastTimeDeviceId, Long deviceId) {
        String hql = "update ZoneServiceInfo set deviceId = ? where zoneId = ? and deviceId = ?";
        Object[] objArr = new Object[]{deviceId, zoneId, lastTimeDeviceId};
        this.getHibernateTemplate().bulkUpdate(hql, objArr);
    }

    public List<ZoneServiceInfo> getZoneAndDeviceDefaultService(Long zoneId, Long deviceId) {
        String hql = " from ZoneServiceInfo info where info.zoneId = ? and info.deviceId = ? and info.serviceType = ? ";
        Object[] objArr = new Object[]{zoneId, deviceId, 0};
        return this.getHibernateTemplate().find(hql, objArr);
    }

    public int queryDynFingerNum(Long zoneId, Long deviceId) {
        String tcpSql = "SELECT COUNT(1) FROM t_vsm_zone_tcp_fngrprnt  WHERE dev_id=? AND zone_id<>? AND match_type=2";
        String udpSql = "SELECT COUNT(1) FROM t_vsm_zone_udp_user_finger WHERE dev_id=? AND zone_id<>? AND match_type=2";
        String icmpSql = "SELECT COUNT(1) FROM t_vsm_zone_icmp_user_finger WHERE dev_id=? AND zone_id<>? AND match_type=2";
        String dnsSql = "SELECT COUNT(1) FROM t_vsm_zone_dns_user_finger  WHERE dev_id=? AND zone_id<>? AND match_type=2";
        String httpSql = "SELECT COUNT(1) FROM t_vsm_zone_http_fngrprnt  WHERE dev_id=? AND zone_id<>? AND match_type=2";
        String ipSql = "SELECT COUNT(1) FROM t_vsm_zone_ip_fngrprnt  WHERE dev_id=? AND zone_id<>? AND match_type=2";
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, String.valueOf(deviceId));
        queryMap.put(1, String.valueOf(zoneId));
        Long tcpNum = this.getTotalCount(tcpSql, queryMap);
        Long udpNum = this.getTotalCount(udpSql, queryMap);
        Long icmpNum = this.getTotalCount(icmpSql, queryMap);
        Long dnsNum = this.getTotalCount(dnsSql, queryMap);
        Long httpNum = this.getTotalCount(httpSql, queryMap);
        Long ipNum = this.getTotalCount(ipSql, queryMap);
        int totalDynNum = tcpNum.intValue() + udpNum.intValue() + icmpNum.intValue() + dnsNum.intValue() + httpNum.intValue() + ipNum.intValue();
        return totalDynNum;
    }

    public ZoneServiceInfo get(Long id) {
        String hql = "from ZoneServiceInfo where id = ? ";
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, id.toString());
        List result = this.findByHql(hql, queryMap);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (ZoneServiceInfo)result.get(0);
    }

    public List<ZoneServiceInfo> getAll() {
        String hql = "from ZoneServiceInfo ";
        List result = this.findByHql(hql);
        if (result == null) {
            return new ArrayList<ZoneServiceInfo>();
        }
        return result;
    }

    public List<ZoneServiceInfo> getByMultiId(ZoneServiceForm form) {
        List result;
        StringBuffer hql = new StringBuffer("from ZoneServiceInfo info where info.zoneId = ?");
        int index = 0;
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(index++, String.valueOf(form.getZoneId()));
        if (form.getDeviceId() != null) {
            hql.append(" and info.deviceId = ?");
            queryMap.put(index++, String.valueOf(form.getDeviceId()));
        }
        if (form.getPkid() != null) {
            hql.append(" and info.pkid <> ?");
            queryMap.put(index++, String.valueOf(form.getPkid()));
        }
        if (form.getDirection() == 1 || form.getDirection() == 2) {
            hql.append(" and info.direction = ?");
            queryMap.put(index++, String.valueOf(form.getDirection()));
        }
        if ((result = this.findByHql(hql.toString(), queryMap)) == null) {
            return new ArrayList<ZoneServiceInfo>();
        }
        return result;
    }

    public List<ZoneServiceInfo> getByMultiServiceName(ZoneServiceForm form) {
        List result;
        StringBuffer hql = new StringBuffer("from ZoneServiceInfo info where info.zoneId = ?");
        int index = 0;
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(index++, String.valueOf(form.getZoneId()));
        if (form.getDeviceId() != null) {
            hql.append(" and info.deviceId = ?");
            queryMap.put(index++, String.valueOf(form.getDeviceId()));
        }
        if (form.getServiceName() != null) {
            hql.append(" and info.serviceName <> ?");
            queryMap.put(index++, String.valueOf(form.getServiceName()));
        }
        if (form.getDirection() == 1 || form.getDirection() == 2) {
            hql.append(" and info.direction = ?");
            queryMap.put(index++, String.valueOf(form.getDirection()));
        }
        if ((result = this.findByHql(hql.toString(), queryMap)) == null) {
            return new ArrayList<ZoneServiceInfo>();
        }
        return result;
    }

    public List<ZoneServiceInfo> getByMultiIdAndServiceName(ZoneServiceForm form) {
        List result;
        StringBuffer hql = new StringBuffer(" from ZoneServiceInfo info where Lower(info.serviceName) = ? and info.zoneId = ?");
        int index = 0;
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(index++, form.getServiceName().toLowerCase(Locale.ENGLISH));
        queryMap.put(index++, String.valueOf(form.getZoneId()));
        if (form.getDeviceId() != null) {
            hql.append(" and info.deviceId = ?");
            queryMap.put(index++, String.valueOf(form.getDeviceId()));
        }
        if (form.getPkid() != null) {
            hql.append(" and info.pkid <> ?");
            queryMap.put(index++, String.valueOf(form.getPkid()));
        }
        if (form.getDirection() == 1 || form.getDirection() == 2) {
            hql.append(" and info.direction = ?");
            queryMap.put(index++, String.valueOf(form.getDirection()));
        }
        if ((result = this.findByHql(hql.toString(), queryMap)) == null) {
            return new ArrayList<ZoneServiceInfo>();
        }
        return result;
    }

    public List<ZoneServiceInfo> getByZoneIdAndDeviceId(String zoneId, String deviceId) {
        String hql = " from ZoneServiceInfo info where info.zoneId = ? and deviceId = ?";
        int index = 0;
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(index++, zoneId);
        queryMap.put(index, deviceId);
        List result = this.findByHql(hql, queryMap);
        if (result == null) {
            return new ArrayList<ZoneServiceInfo>();
        }
        return result;
    }

    public List<ZoneServiceInfo> getByZoneIdAndDeviceIdAndDirection(String zoneId, String deviceId, int direction) {
        String hql = " from ZoneServiceInfo info where info.zoneId = ? and deviceId = ? and direction = ?";
        int index = 0;
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(index++, zoneId);
        queryMap.put(index++, deviceId);
        queryMap.put(index, direction + "");
        List result = this.findByHql(hql, queryMap);
        if (result == null) {
            return new ArrayList<ZoneServiceInfo>();
        }
        return result;
    }

    public List<ZoneServiceInfo> getByDeviceId(Long deviceId) {
        String hql = " from ZoneServiceInfo info where deviceId = ?";
        int index = 0;
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(index, String.valueOf(deviceId));
        List result = this.findByHql(hql, queryMap);
        if (result == null) {
            return new ArrayList<ZoneServiceInfo>();
        }
        return result;
    }

    public List<ZoneServiceInfo> getByIdsAndprotocol(Long deviceId, Long zoneID) {
        String hql = "from ZoneServiceInfo info where info.deviceId = ? and info.zoneId = ? and info.protocol in ('TCP','HTTP','HTTPS')";
        int index = 0;
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(index++, String.valueOf(deviceId));
        queryMap.put(index, String.valueOf(zoneID));
        List result = this.findByHql(hql, queryMap);
        if (result == null) {
            return new ArrayList<ZoneServiceInfo>();
        }
        return result;
    }

    public List<ZoneServiceInfo> getByIdsAndType(Long zoneId, Long deviceId, String serviceType) {
        String hql = " from ZoneServiceInfo info where info.zoneId = ? and info.deviceId = ? and info.protocol = ? and info.direction = 1";
        int index = 0;
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(index++, String.valueOf(zoneId));
        queryMap.put(index++, String.valueOf(deviceId));
        queryMap.put(index++, serviceType);
        List result = this.findByHql(hql, queryMap);
        if (result == null) {
            return new ArrayList<ZoneServiceInfo>();
        }
        return result;
    }

    public List<ZoneServiceInfo> getByIdsAndProtocol(Long deviceId, Long zoneID, String protocol) {
        String hql = "from ZoneServiceInfo ";
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        int index = 0;
        if (this.protocolFlag(protocol)) {
            hql = hql + " where protocol =? and zoneId = ? and deviceId = ?";
            queryMap.put(index++, protocol);
            queryMap.put(index++, String.valueOf(zoneID));
            queryMap.put(index++, String.valueOf(deviceId));
        } else {
            hql = hql + " where protocol ='Other' and zoneId = ? and deviceId = ?  and protocolNum = ?";
            queryMap.put(index++, String.valueOf(zoneID));
            queryMap.put(index++, String.valueOf(deviceId));
            queryMap.put(index++, protocol);
        }
        List result = this.findByHql(hql, queryMap);
        if (result == null) {
            return new ArrayList<ZoneServiceInfo>();
        }
        return result;
    }

    private boolean protocolFlag(String protocol) {
        if ("UDP".equals(protocol)) {
            return true;
        }
        if ("TCP".equals(protocol)) {
            return true;
        }
        if ("HTTP".equals(protocol)) {
            return true;
        }
        if ("HTTPS".equals(protocol)) {
            return true;
        }
        if ("TCP_DNS".equals(protocol)) {
            return true;
        }
        if ("UDP_DNS".equals(protocol)) {
            return true;
        }
        return "SIP".equals(protocol);
    }

    public List<ZoneServiceInfo> getByZoneId(Long zoneId, List<Long> deviceIds) {
        List result;
        StringBuffer hql = new StringBuffer("from ZoneServiceInfo info where info.zoneId = ? ");
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, String.valueOf(zoneId));
        if (null != deviceIds && !deviceIds.isEmpty()) {
            Collections.sort(deviceIds);
            hql.append("and info.deviceId in (");
            for (int i = 0; i < deviceIds.size(); ++i) {
                queryMap.put(i + 1, String.valueOf(deviceIds.get(i)));
                if (0 == i) {
                    hql.append("?");
                    continue;
                }
                hql.append(",?");
            }
            hql.append(")");
        }
        if ((result = this.findByHql(hql.toString(), queryMap)) == null) {
            return new ArrayList<ZoneServiceInfo>();
        }
        return result;
    }
}

