/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.model;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class ServiceLearningInfo
implements Serializable {
    private static final long serialVersionUID = -8606518943444544975L;
    private static final int STARTUP = 1;
    private String zoneName;
    private String zoneAccount;
    private long zoneId;
    private long rate;
    private long period;
    private long deviceId;
    private int deployStatus;
    private String startTime;
    private String stopTime;
    private Boolean taskStatus;
    private Integer topObj;
    private String confirmType;
    private String deviceIp;
    private int zoneType;
    private String deviceName;

    public long calculatePeriod() {
        if (this.startTime != null && this.stopTime != null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.period = (format.parse(this.stopTime).getTime() - format.parse(this.startTime).getTime()) / 1000L;
            }
            catch (ParseException e) {
                this.period = 0L;
            }
        }
        return this.period;
    }

    public boolean isStartUp() {
        return this.deployStatus == 1;
    }

    public boolean isTimeToStart() {
        if (this.startTime != null) {
            try {
                SimpleDateFormat formats = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return formats.parse(this.startTime).getTime() - System.currentTimeMillis() <= 0L;
            }
            catch (ParseException e) {
                return false;
            }
        }
        return false;
    }

    public boolean isTimeOut() {
        if (this.stopTime != null) {
            try {
                SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return formater.parse(this.stopTime).getTime() - System.currentTimeMillis() <= 0L;
            }
            catch (ParseException e) {
                return false;
            }
        }
        return true;
    }

    public String getZoneAccount() {
        return this.zoneAccount;
    }

    public void setZoneAccount(String zoneAccount) {
        this.zoneAccount = zoneAccount;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public int getZoneType() {
        return this.zoneType;
    }

    public void setZoneType(int zoneType) {
        this.zoneType = zoneType;
    }

    public Integer getTopObj() {
        return this.topObj;
    }

    public void setTopObj(Integer topObj) {
        this.topObj = topObj;
    }

    public String getConfirmType() {
        return this.confirmType;
    }

    public void setConfirmType(String confirmType) {
        this.confirmType = confirmType;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public Boolean getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(Boolean taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(String stopTime) {
        this.stopTime = stopTime;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(long zoneId) {
        this.zoneId = zoneId;
    }

    public long getRate() {
        return this.rate;
    }

    public void setRate(long rate) {
        this.rate = rate;
    }

    public long getPierd() {
        return this.period;
    }

    public void setPierd(long periodL) {
        this.period = periodL;
    }

    public long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(long deviceId) {
        this.deviceId = deviceId;
    }

    public int getDeployStatus() {
        return this.deployStatus;
    }

    public void setDeployStatus(int deployStatus) {
        this.deployStatus = deployStatus;
    }

    public String toString() {
        return "ServiceLearningInfo [zoneId=" + this.zoneId + ", rate=" + this.rate + ", period=" + this.period + ", deviceId=" + this.deviceId + ", startTime=" + this.startTime + ", stopTime=" + this.stopTime + ", taskStatus=" + this.taskStatus + ", topObj=" + this.topObj + ", confirmType=" + this.confirmType + ", deviceIp=" + this.deviceIp + "]";
    }
}

