/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.bis.form.AttackDataForm;
import com.hs.atic.sdk.bis.service.IAticCommonUtilService;
import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.policy.beans.ManualDefendInfo;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.policy.util.PolicyUtil;
import com.hs.vsm.secservice.ddos.policy.util.XmlParserUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ManualDefendForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneFeatureStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INpFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneFeatureStatusService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class AttackDataAction
extends BaseAction {
    static Comparator<LangPair> comparator = new Comparator<LangPair>(){

        @Override
        public int compare(LangPair o1, LangPair o2) {
            return o1.getValue().toLowerCase(Locale.ENGLISH).compareTo(o2.getValue().toLowerCase(Locale.ENGLISH));
        }
    };
    private static final long serialVersionUID = 1L;
    private static final String DIRECTION_CMB_INBOUND = "0";
    private static final String DIRECTION_CMB_OUTBOUND = "1";
    private static final String NEGATIVE_ONE = "-1";
    private static final String ZERO = "0";
    private static final String ONE = "1";
    private static final String TWO = "2";
    private static final String THREE = "3";
    private static final String FOUR = "4";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private String zoneId;
    private boolean supportOutbound = false;
    private List<LangPair> directionList;
    private List<AttackDataForm> attackDatas = null;
    private List<LangPair> deviceTypeList;
    private List<LangPair> interactiveList;
    private String directionCmbValue;
    private String directionCmb;
    private String interactiveCmbValue;
    private String interactiveCmb;
    private String attackDataList;
    private String deviceTypeCmbValue;
    private String deviceTypeCmb;
    private Integer zoneDefendMode;
    private Boolean defendStateDisable = true;
    private List<LangPair> deviceNameList;
    private String deviceNameCmbValue;
    private String deviceNameCmb;
    private String deviceNameCmbCopy;
    private Boolean collectorOnline = false;
    private Boolean collectorConnected = false;
    private List<String> goodDeviceIp = new ArrayList<String>();
    private Boolean viewPage;
    private Boolean isNip;
    private int type;
    private boolean includesV1R1;
    private List<LangPair> confAttackTypes = null;

    public Boolean getDefendStateDisable() {
        return this.defendStateDisable;
    }

    public void setDefendStateDisable(Boolean defendStateDisable) {
        this.defendStateDisable = defendStateDisable;
    }

    public String getDeviceNameCmbCopy() {
        return this.deviceNameCmbCopy;
    }

    public void setDeviceNameCmbCopy(String deviceNameCmbCopy) {
        this.deviceNameCmbCopy = deviceNameCmbCopy;
    }

    public Boolean getCollectorConnected() {
        return this.collectorConnected;
    }

    public void setCollectorConnected(Boolean collectorConnected) {
        this.collectorConnected = collectorConnected;
    }

    public Boolean getViewPage() {
        return this.viewPage;
    }

    public void setViewPage(Boolean viewPage) {
        this.viewPage = viewPage;
    }

    public List<LangPair> getDeviceNameList() {
        return this.deviceNameList;
    }

    public void setDeviceNameList(List<LangPair> deviceNameList) {
        this.deviceNameList = deviceNameList;
    }

    public String getDeviceNameCmbValue() {
        return this.deviceNameCmbValue;
    }

    public void setDeviceNameCmbValue(String deviceNameCmbValue) {
        this.deviceNameCmbValue = deviceNameCmbValue;
    }

    public String getDeviceNameCmb() {
        return this.deviceNameCmb;
    }

    public void setDeviceNameCmb(String deviceNameCmb) {
        this.deviceNameCmb = deviceNameCmb;
    }

    public String getAttackDataList() {
        return this.attackDataList;
    }

    public void setAttackDataList(String attackDataList) {
        this.attackDataList = attackDataList;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public String getDeviceTypeCmbValue() {
        return this.deviceTypeCmbValue;
    }

    public void setDeviceTypeCmbValue(String deviceTypeCmbValue) {
        this.deviceTypeCmbValue = deviceTypeCmbValue;
    }

    public String getDeviceTypeCmb() {
        return this.deviceTypeCmb;
    }

    public void setDeviceTypeCmb(String deviceTypeCmb) {
        this.deviceTypeCmb = deviceTypeCmb;
    }

    public String getInteractiveCmbValue() {
        return this.interactiveCmbValue;
    }

    public void setInteractiveCmbValue(String interactiveCmbValue) {
        this.interactiveCmbValue = interactiveCmbValue;
    }

    public String getInteractiveCmb() {
        return this.interactiveCmb;
    }

    public void setInteractiveCmb(String interactiveCmb) {
        this.interactiveCmb = interactiveCmb;
    }

    public List<LangPair> getDirectionList() {
        return this.directionList;
    }

    public void setDirectionList(List<LangPair> directionList) {
        this.directionList = directionList;
    }

    public List<AttackDataForm> getAttackDatas() {
        return this.attackDatas;
    }

    public void setAttackDatas(List<AttackDataForm> attackDatas) {
        this.attackDatas = attackDatas;
    }

    public List<LangPair> getDeviceTypeList() {
        return this.deviceTypeList;
    }

    public void setDeviceTypeList(List<LangPair> deviceTypeList) {
        this.deviceTypeList = deviceTypeList;
    }

    public List<LangPair> getInteractiveList() {
        return this.interactiveList;
    }

    public void setInteractiveList(List<LangPair> interactiveList) {
        this.interactiveList = interactiveList;
    }

    public String getDirectionCmbValue() {
        return this.directionCmbValue;
    }

    public void setDirectionCmbValue(String directionCmbValue) {
        this.directionCmbValue = directionCmbValue;
    }

    public String getDirectionCmb() {
        return this.directionCmb;
    }

    public void setDirectionCmb(String directionCmb) {
        this.directionCmb = directionCmb;
    }

    public boolean getSupportOutbound() {
        return this.supportOutbound;
    }

    public void setSupportOutbound(boolean supportOutbound) {
        this.supportOutbound = supportOutbound;
    }

    private void initDirectionList() {
        LangPair com0 = new LangPair(NEGATIVE_ONE, this.getText("com.hs.vsm.secservice.ddos.attack.all"));
        this.directionList = new ArrayList<LangPair>();
        LangPair com1 = new LangPair("0", this.getText("atic.bis.inbound.direction"));
        LangPair com2 = new LangPair("1", this.getText("atic.bis.outbound.direction"));
        this.directionList.add(com0);
        this.directionList.add(com1);
        this.directionList.add(com2);
        if (null == this.directionCmb) {
            this.setDirectionCmb(NEGATIVE_ONE);
            this.setDirectionCmbValue(this.getText("com.hs.vsm.secservice.ddos.attack.all"));
        }
    }

    private void initDeviceTypeList() {
        this.deviceTypeList = new ArrayList<LangPair>();
        LangPair com0 = new LangPair("0", this.getText("com.hs.vsm.secservice.ddos.attack.deviceType.1"));
        LangPair com1 = new LangPair("1", this.getText("com.hs.vsm.secservice.ddos.attack.deviceType.2"));
        this.deviceTypeList.add(com0);
        this.deviceTypeList.add(com1);
        if (null == this.deviceTypeCmb) {
            this.setDeviceTypeCmb("0");
            this.setDeviceTypeCmbValue(this.getText("com.hs.vsm.secservice.ddos.attack.deviceType.1"));
        }
    }

    private void initInteractiveList() {
        this.interactiveList = new ArrayList<LangPair>();
        LangPair com0 = new LangPair(NEGATIVE_ONE, this.getText("com.hs.vsm.secservice.ddos.attack.all"));
        LangPair com1 = new LangPair("0", this.getText("com.hs.vsm.secservice.ddos.attack.undefense"));
        LangPair com2 = new LangPair("1", this.getText("com.hs.vsm.secservice.ddos.attack.defenseSubmit"));
        LangPair com3 = new LangPair(TWO, this.getText("com.hs.vsm.secservice.ddos.attack.defenseSuccess"));
        LangPair com4 = new LangPair(THREE, this.getText("com.hs.vsm.secservice.ddos.attack.defend.auto"));
        this.interactiveList.add(com0);
        this.interactiveList.add(com1);
        this.interactiveList.add(com2);
        this.interactiveList.add(com3);
        this.interactiveList.add(com4);
        if (null == this.interactiveCmbValue) {
            this.setInteractiveCmb(NEGATIVE_ONE);
            this.setInteractiveCmbValue(this.getText("com.hs.vsm.secservice.ddos.attack.all"));
        }
    }

    private void initDeviceNameList(List<ZoneDeviceForm> zoneDeviceForms) {
        this.deviceNameList = new ArrayList<LangPair>();
        AticDevice securityNE = null;
        String deviceName = null;
        if (0 < zoneDeviceForms.size()) {
            int j = zoneDeviceForms.size();
            for (int i = 0; i < j; ++i) {
                ZoneDeviceForm zoneDeviceForm = zoneDeviceForms.get(i);
                securityNE = ZoneReferUtil.getDevice(zoneDeviceForm.getDeviceId());
                if (Constant.DEVICE_SERVICE_TYPE_CLEAN_ADD_DETECT != AttackDataAction.getDeviceDdos(securityNE)) {
                    deviceName = securityNE.getName();
                    String detect = this.getText("com.hs.vsm.secservice.ddos.policy.device.detect");
                    String clean = this.getText("com.hs.vsm.secservice.ddos.policy.device.clean");
                    deviceName = Constant.DEVICE_SERVICE_TYPE_DETECT.equals(AttackDataAction.getDeviceDdos(securityNE)) ? deviceName + detect : deviceName + clean;
                    String ipAddress = securityNE.getIpAddress();
                    LangPair com = new LangPair(ipAddress, deviceName);
                    this.deviceNameList.add(com);
                    continue;
                }
                String name = this.getText("com.hs.vsm.secservice.ddos.policy.device.detect");
                deviceName = securityNE.getName() + name;
                String ipAddress = securityNE.getIpAddress() + "_" + Constant.DEVICE_SERVICE_TYPE_DETECT;
                LangPair com1 = new LangPair(ipAddress, deviceName);
                this.deviceNameList.add(com1);
                name = this.getText("com.hs.vsm.secservice.ddos.policy.device.clean");
                deviceName = securityNE.getName() + name;
                ipAddress = securityNE.getIpAddress() + "_" + Constant.DEVICE_SERVICE_TYPE_CLEAN;
                LangPair com2 = new LangPair(ipAddress, deviceName);
                this.deviceNameList.add(com2);
            }
        }
        Collections.sort(this.deviceNameList, comparator);
        ArrayList<LangPair> allDeviceItems = new ArrayList<LangPair>();
        LangPair com0 = new LangPair("all", this.getText("com.hs.vsm.secservice.ddos.attack.all"));
        allDeviceItems.add(com0);
        ArrayList<LangPair> tempDevices = new ArrayList<LangPair>();
        tempDevices.addAll(allDeviceItems);
        tempDevices.addAll(this.deviceNameList);
        this.deviceNameList = tempDevices;
        if (null == this.deviceNameCmb && !this.deviceNameList.isEmpty()) {
            this.setDeviceNameCmb(this.deviceNameList.get(0).getLabel());
            this.setDeviceNameCmbValue(this.deviceNameList.get(0).getValue());
        }
    }

    public static int getDeviceDdos(AticDevice firewall) {
        int ddosType = Constant.DEVICE_SERVICE_TYPE_DETECT;
        if (firewall.getDeviceType() == 1) {
            ddosType = firewall.getDdosType();
        }
        return ddosType;
    }

    private String parseZoneId() {
        if (this.zoneId.contains(",")) {
            String[] zoneids = this.zoneId.split(",");
            return zoneids[0];
        }
        return this.zoneId;
    }

    private Map<String, Object> getConditions(List<ZoneDeviceForm> zoneDeviceForms) {
        ZoneFeatureStatusForm featureStatusForm = null;
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        if (null != this.getDeviceNameCmbCopy() && this.getDeviceNameCmbCopy().contains("_")) {
            queryMap.put("deviceType", this.getDeviceNameCmbCopy().split("_")[1]);
            queryMap.put("deviceIp", "(" + this.getDeviceNameCmbCopy().split("_")[0] + ")");
        } else {
            IAticCommonUtilService aticCommonUtilService;
            String deviceIp = "";
            IZoneFeatureStatusService zoneFeatureStatusService = ZoneReferUtil.getZoneFeatureStatusService();
            if (null == this.deviceNameCmb || "all".equals(this.deviceNameCmb)) {
                queryMap.put("goodDeviceIp", this.getGoodDeviceIp());
                aticCommonUtilService = ZoneReferUtil.getAticCommonUtilService();
                for (ZoneDeviceForm zoneDeviceForm : zoneDeviceForms) {
                    AticDevice ne = ZoneReferUtil.getDevice(zoneDeviceForm.getDeviceId());
                    if (null == ne || !aticCommonUtilService.checkCollectorStatus(ne.getIpAddress())) continue;
                    featureStatusForm = zoneFeatureStatusService.getZoneFeatureByZoneIdAndDeviceId(Long.parseLong(this.zoneId), ne.getIpAddress(), "ZoneDefendModeFeature", Long.parseLong(this.zoneId));
                    if (featureStatusForm != null) {
                        if (this.interactiveCmb.equals(THREE) && Constant.DEFENDMODE_DEFEND_AUTO.equals(featureStatusForm.getDefendMode())) {
                            deviceIp = deviceIp + ne.getIpAddress() + ",";
                        }
                        if (this.interactiveCmb.equals(FOUR) && Constant.DEFENDMODE_DEFEND_UNDEFEND.equals(featureStatusForm.getDefendMode())) {
                            deviceIp = deviceIp + ne.getIpAddress() + ",";
                        }
                        if ((this.interactiveCmb.equals("0") || this.interactiveCmb.equals("1") || this.interactiveCmb.equals(TWO)) && Constant.DEFENDMODE_DEFEND_MANUAL.equals(featureStatusForm.getDefendMode())) {
                            deviceIp = deviceIp + ne.getIpAddress() + ",";
                        }
                        if (!this.interactiveCmb.equals(NEGATIVE_ONE)) continue;
                        deviceIp = deviceIp + ne.getIpAddress() + ",";
                        continue;
                    }
                    if (!this.interactiveCmb.equals(NEGATIVE_ONE) && !this.interactiveCmb.equals(THREE)) continue;
                    deviceIp = deviceIp + ne.getIpAddress() + ",";
                }
            } else {
                featureStatusForm = zoneFeatureStatusService.getZoneFeatureByZoneIdAndDeviceId(Long.parseLong(this.zoneId), this.deviceNameCmb, "ZoneDefendModeFeature", Long.parseLong(this.zoneId));
                aticCommonUtilService = ZoneReferUtil.getAticCommonUtilService();
                if (aticCommonUtilService.checkCollectorStatus(this.deviceNameCmb)) {
                    if (null != featureStatusForm) {
                        if (this.interactiveCmb.equals(THREE) && Constant.DEFENDMODE_DEFEND_AUTO.equals(featureStatusForm.getDefendMode())) {
                            deviceIp = deviceIp + this.deviceNameCmb;
                        }
                        if (this.interactiveCmb.equals(FOUR) && Constant.DEFENDMODE_DEFEND_UNDEFEND.equals(featureStatusForm.getDefendMode())) {
                            deviceIp = deviceIp + this.deviceNameCmb;
                        }
                        if ((this.interactiveCmb.equals("0") || this.interactiveCmb.equals("1") || this.interactiveCmb.equals(TWO)) && Constant.DEFENDMODE_DEFEND_MANUAL.equals(featureStatusForm.getDefendMode())) {
                            deviceIp = deviceIp + this.deviceNameCmb;
                        }
                        if (this.interactiveCmb.equals(NEGATIVE_ONE)) {
                            deviceIp = deviceIp + this.deviceNameCmb;
                        }
                    } else if (this.interactiveCmb.equals(NEGATIVE_ONE) || this.interactiveCmb.equals(THREE)) {
                        deviceIp = deviceIp + this.deviceNameCmb;
                    }
                }
            }
            StringBuffer attackDeviceIds = new StringBuffer();
            if (!deviceIp.isEmpty()) {
                String[] deviceIps = deviceIp.split(",");
                attackDeviceIds.append('(');
                for (int i = 0; i < deviceIps.length; ++i) {
                    attackDeviceIds.append(deviceIps[i] + ",");
                }
                attackDeviceIds.deleteCharAt(attackDeviceIds.length() - 1);
                attackDeviceIds.append(')');
            }
            queryMap.put("deviceIp", attackDeviceIds.toString());
        }
        if (null == this.interactiveCmb) {
            queryMap.put("interActive", NEGATIVE_ONE);
        } else {
            queryMap.put("interActive", this.interactiveCmb);
        }
        queryMap.put("start", this.start + "");
        queryMap.put("pageSize", this.pageSize + "");
        queryMap.put("zoneId", this.zoneId);
        return queryMap;
    }

    public String showAttackPoliceInfos() {
        this.logger.info((Object)"showAttackPoliceInfos is execute");
        return "success";
    }

    public String showAttackDatas() {
        this.logger.info((Object)"showAttackDatas is execute");
        ILicenseOutboundService licenseOutboundService = ZoneBisUtil.getLicenseOutboundService();
        this.supportOutbound = licenseOutboundService.isSupportOutbound();
        this.initDeviceTypeList();
        IZonePolicyApplyService policyService = ZoneReferUtil.getZonePolicyService();
        ZonePolicyApplyForm policyApplyForm = policyService.queryByZoneId(Long.valueOf(this.zoneId));
        if (policyApplyForm == null) {
            throw new LegoCheckedException(630010L);
        }
        this.initInteractiveList();
        this.initDirectionList();
        IZoneDeviceService service = ZoneReferUtil.getZoneDeviceService();
        this.zoneId = this.parseZoneId();
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        List zoneDeviceForms = service.queryZoneDeviceFormsByZoneID(Long.valueOf(this.zoneId), currentUser.getUserID(), "true".equalsIgnoreCase(currentUser.getIsAdmin()));
        this.initDeviceNameList(zoneDeviceForms);
        Integer defendMode = Constant.DEFENDMODE_DEFEND_AUTO;
        ZoneFeatureStatusForm featureStatusForm = null;
        IZoneFeatureStatusService zoneFeatureStatusService = ZoneReferUtil.getZoneFeatureStatusService();
        int index = -1;
        if (this.deviceNameCmb != null) {
            index = this.deviceNameCmb.indexOf("_");
            if (!"all".equals(this.deviceNameCmb)) {
                if (index != -1) {
                    this.deviceNameCmbCopy = this.deviceNameCmb;
                    this.deviceNameCmb = this.deviceNameCmb.substring(0, index);
                    index = -1;
                }
                if ((featureStatusForm = zoneFeatureStatusService.getZoneFeatureByZoneIdAndDeviceId(Long.parseLong(this.zoneId), this.deviceNameCmb, "ZoneDefendModeFeature", Long.parseLong(this.zoneId))) != null) {
                    defendMode = featureStatusForm.getDefendMode();
                }
            }
        }
        this.setZoneDefendMode(defendMode);
        this.logger.info((Object)("defendMode:" + defendMode));
        if (this.deviceNameCmb == null || "".equals(this.deviceNameCmb)) {
            return "success";
        }
        IAticCommonUtilService aticCommonUtilService = ZoneReferUtil.getAticCommonUtilService();
        if (index != -1) {
            this.deviceNameCmbCopy = this.deviceNameCmb;
            this.deviceNameCmb = this.deviceNameCmb.substring(0, index);
        }
        this.logger.info((Object)("deviceNameCmb : " + this.getcleanedMessage(this.deviceNameCmb)));
        if (null == this.deviceNameCmb || "all".equals(this.deviceNameCmb)) {
            this.collectorOnline = true;
            for (LangPair langPair : this.deviceNameList) {
                if ("all".equals(langPair.getLabel())) continue;
                String label = langPair.getLabel();
                String deviceIp = "";
                int underLineIndex = label.indexOf("_");
                deviceIp = underLineIndex != -1 ? label.substring(0, underLineIndex) : label;
                if (!aticCommonUtilService.checkCollectorStatus(deviceIp)) continue;
                this.collectorConnected = true;
                this.goodDeviceIp.add(deviceIp);
            }
            if (!this.collectorConnected.booleanValue()) {
                return "success";
            }
        } else {
            this.collectorConnected = true;
            this.collectorOnline = aticCommonUtilService.checkCollectorStatus(this.deviceNameCmb);
            if (!this.collectorOnline.booleanValue()) {
                return "success";
            }
        }
        Map<String, Object> map = this.getConditions(zoneDeviceForms);
        if (this.supportOutbound && "0".equals(this.directionCmb)) {
            map.put("direction", 1);
        } else if (this.supportOutbound && "1".equals(this.directionCmb)) {
            map.put("direction", 2);
        }
        Paging page = ZoneReferUtil.getAttackDataList(map);
        List attackForms = page.getData();
        ArrayList<AttackDataForm> temp = new ArrayList<AttackDataForm>();
        String deviceName = "";
        String deviceIdStr = "";
        AticDevice secNE = null;
        ArrayList<AticDevice> deviceList = new ArrayList<AticDevice>();
        ArrayList<AticDevice> deviceList2 = null;
        for (AttackDataForm attackDataForm : attackForms) {
            this.logger.info((Object)("deviceIpStr" + attackDataForm.getDeviceIp()));
            attackDataForm.setZoneIp(IPUtil4Atic.compressIP((String)attackDataForm.getZoneIp()));
            featureStatusForm = zoneFeatureStatusService.getZoneFeatureByZoneIdAndDeviceId(Long.parseLong(this.zoneId), attackDataForm.getDeviceIp(), "ZoneDefendModeFeature", Long.parseLong(this.zoneId));
            defendMode = featureStatusForm != null ? featureStatusForm.getDefendMode() : Constant.DEFENDMODE_DEFEND_AUTO;
            secNE = ZoneReferUtil.getDeviceByIp(attackDataForm.getDeviceIp());
            deviceList2 = new ArrayList<AticDevice>();
            if (secNE != null) {
                deviceName = secNE.getName();
                deviceIdStr = secNE.getMoId() + "_" + (attackDataForm.getDeviceType() == 2 ? 1 : attackDataForm.getDeviceType());
                deviceList.add(secNE);
                deviceList2.add(secNE);
            }
            attackDataForm.setDefendMode(defendMode);
            attackDataForm.setDeviceNameValue(deviceName);
            Long attackBytes = attackDataForm.getAttackBytes() / 8L;
            String attackBytesDisplay = CommonUtil.transformNumber((String)attackBytes.toString(), (String)"KB");
            attackDataForm.setAttackBytesDisplay(attackBytesDisplay);
            String reportUrl = "";
            try {
                String switchOption = "clean_less1day_pps";
                if (attackDataForm.getDeviceType() == 1) {
                    switchOption = "detect_less1day_pps";
                }
                if (CommonUtil.includesV1R1(deviceList2)) {
                    switchOption = attackDataForm.getDeviceType() == 1 ? "detect_less2day_pps" : "clean_less2day_pps";
                }
                reportUrl = "/atic/ireport/dataDrillWithNoSession.do?reportId=attackLogDetailAnalysis4AttackEvent&direction_combobox=" + attackDataForm.getDirection() + "&switchOption=" + switchOption + "&netDevice_combobox=" + deviceIdStr + "&zone_ip=" + attackDataForm.getZoneIp() + "&zone_combobox=" + attackDataForm.getZoneId() + "&startTime=" + attackDataForm.getEarlyAlertTime() + "&endTime=" + System.currentTimeMillis() / 1000L + "&dataDrillTitle=&IREPORT_WOS_CODE=";
                this.logger.info((Object)("reportUrl: " + reportUrl));
            }
            catch (Exception e) {
                this.logger.error((Object)"reportUrl error:", (Throwable)e);
            }
            attackDataForm.setReportUrl(reportUrl);
            attackDataForm.setZoneIp(IPUtil4Atic.compressIP((String)attackDataForm.getZoneIp()));
            attackDataForm.setDeviceIp(IPUtil4Atic.compressIP((String)attackDataForm.getDeviceIp()));
            temp.add(attackDataForm);
        }
        if (CommonUtil.includesV1R1(deviceList)) {
            this.includesV1R1 = true;
        }
        this.attackDatas = temp;
        this.total = page.getCount();
        this.setAttackTypeStr();
        this.deviceDefendStatusSet();
        if (!Constant.DEFENDMODE_DEFEND_MANUAL.equals(defendMode)) {
            for (AttackDataForm form : this.attackDatas) {
                form.setInterActive(2);
            }
        }
        if (null != this.deviceNameCmbCopy && !"".equals(this.deviceNameCmbCopy)) {
            this.deviceNameCmb = this.deviceNameCmbCopy;
        }
        return "success";
    }

    public void doDefence() {
        this.manualDefend();
    }

    private void doMandualDefendRmi(String inputStr, String collectorIP) {
        if (!"".equals(inputStr)) {
            ZoneReferUtil.modifyAttackDatas(inputStr, collectorIP);
        }
    }

    private void manualDefend() {
        List<ManualDefendInfo> manualDefendInfos = this.parseTransferString();
        this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.operation.name.affirmdefence", "lego.dic.module.ddosApp", "atic.public.button.confirm.Defense", true, "lego.dic.operationstatus.success", null);
        if (!manualDefendInfos.isEmpty()) {
            ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
            for (int i = 0; i < manualDefendInfos.size(); ++i) {
                BatchOperation operation = new BatchOperation();
                operation.setTargetId((long)i);
                ManualDefendInfo manualDefendInfo = manualDefendInfos.get(i);
                operation.setTargetName(manualDefendInfo.getZoneIp());
                batchOpList.add(operation);
            }
            this.batchOperationResult = this.deployManualDefendInBatch(batchOpList, manualDefendInfos);
            if (this.batchOperationResult != null) {
                this.bathResult(this.batchOperationResult);
            }
        }
    }

    private BatchOperationResult deployManualDefendInBatch(List<BatchOperation> boList, List<ManualDefendInfo> manualDefendInfos) {
        ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(Long.valueOf(this.zoneId));
        if (null == zoneInfoForm) {
            throw new LegoCheckedException(201L);
        }
        String zoneName = zoneInfoForm.getZoneDesc();
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        HashMap map = new HashMap();
        ArrayList<String> deviceIpList = new ArrayList<String>();
        ArrayList<String> collectorIpList = new ArrayList<String>();
        for (int i = 0; i < boList.size(); ++i) {
            ManualDefendInfo manualDefendInfo = manualDefendInfos.get(i);
            if (0 > this.isExistInArray(manualDefendInfo.getDeviceIp(), deviceIpList)) {
                deviceIpList.add(manualDefendInfo.getDeviceIp());
            }
            ManualDefendForm manualDefendForm = this.transferObject(manualDefendInfo);
            BatchOperation bo = boList.get(i);
            bo.setTargetId((long)i);
            bo.setTargetName(zoneName);
            bo.setOptDetail("com.hs.vsm.secservice.ddos.policy.operation.detail.affirmdefence");
            bo.setDetailParam(new String[]{manualDefendInfo.getZoneIp(), manualDefendInfo.getAttackTypeStr()});
            try {
                int index = this.isExistInArray(manualDefendInfo.getDeviceIp(), deviceIpList);
                if (i > 0 && index != -1) {
                    this.manualDefendService(manualDefendForm);
                    ((List)map.get(collectorIpList.get(index))).add(manualDefendInfo);
                    continue;
                }
                Long devId = ZoneReferUtil.getFirewallService().getMoidByIP(manualDefendInfo.getDeviceIp());
                Long collectorId = ZoneReferUtil.getICollectorDeviceService().getCollectorIdByDevId(devId);
                if (null == collectorId) {
                    this.logger.error((Object)("no collector exist,devId = " + devId));
                    throw new LegoCheckedException(570501L);
                }
                CollectorInfo collectorInfo = ZoneReferUtil.getICollectorService().getCollectorInfo(collectorId.longValue());
                if (null == collectorInfo) {
                    this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
                    throw new LegoCheckedException(570501L);
                }
                collectorIpList.add(collectorInfo.getIpAddress());
                ArrayList<ManualDefendInfo> temp = (ArrayList<ManualDefendInfo>)map.get(collectorInfo.getIpAddress());
                if (null == temp) {
                    temp = new ArrayList<ManualDefendInfo>();
                    map.put(collectorInfo.getIpAddress(), temp);
                }
                this.manualDefendService(manualDefendForm);
                temp.add(manualDefendInfo);
                map.put(collectorInfo.getIpAddress(), temp);
                continue;
            }
            catch (LegoCheckedException e) {
                ++fail;
                bo.setTargetName(zoneName + "_" + manualDefendInfo.getZoneIp());
                bo.setErrorCode(e.getErrorCode());
                this.logger.error((Object)("errorMessage=" + e.getMessage() + "\r\nObject=" + manualDefendForm.toString()));
                continue;
            }
            catch (Exception e) {
                ++fail;
                bo.setTargetName(zoneName + "_" + manualDefendInfo.getZoneIp());
                bo.setErrorCode(200L);
                this.logger.error((Object)("errorMessage=" + e.getMessage() + "\r\nObject=" + manualDefendForm.toString()));
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            this.doMandualDefendRmi(this.assembTransferInputStr((List)entry.getValue()), (String)entry.getKey());
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        return result;
    }

    private int isExistInArray(String str, List<String> strs) {
        if (null == strs || strs.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < strs.size(); ++i) {
            if (!str.equals(strs.get(i))) continue;
            return i;
        }
        return -1;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private ManualDefendForm transferObject(ManualDefendInfo manualDefendInfo) {
        if (null == manualDefendInfo) {
            return null;
        }
        ManualDefendForm manualDefendForm = new ManualDefendForm();
        String zoneName = this.getZoneName(this.zoneId);
        Long deviceId = this.getDeviceId(manualDefendInfo.getDeviceIp());
        manualDefendForm.setIp(manualDefendInfo.getZoneIp());
        manualDefendForm.setZoneName(zoneName);
        manualDefendForm.setZoneId(Long.valueOf(this.zoneId));
        ZoneServiceForm service = this.getZoneService(manualDefendInfo.getBizId());
        if (null != service) {
            this.logger.info((Object)("service in manual defend transferObject : " + this.getcleanedMessage(service.toString())));
            manualDefendForm.setServiceName(service.getServiceName());
            manualDefendForm.setServiceId(service.getPkid());
            manualDefendForm.setIsCustom(!"DEFAULT".equals(service.getProtocol()));
        }
        manualDefendForm.setDeviceId(deviceId);
        manualDefendForm.setAttackType(manualDefendInfo.getAttackType());
        manualDefendForm.setPort(manualDefendInfo.getPort());
        return manualDefendForm;
    }

    private ZoneServiceForm getZoneService(String bizId) {
        return ZoneReferUtil.getZoneServiceService().queryByZoneServiceID(Long.parseLong(bizId));
    }

    private void manualDefendService(ManualDefendForm manualDefendForm) {
        IZoneMgrNorthSerice service = ZoneReferUtil.getZoneMgrNorthSerice();
        service.manualDefend(manualDefendForm);
    }

    private List<ManualDefendInfo> parseTransferString() {
        String[] attackDatass;
        ArrayList<ManualDefendInfo> manualDefendInfos = new ArrayList<ManualDefendInfo>();
        ManualDefendInfo manualDefendInfo = null;
        String firstFlag = ",";
        String secondFlag = ";";
        String prefix = "com.hs.vsm.secservice.ddos.attack.attackType.";
        if (null != this.attackDataList && (attackDatass = this.attackDataList.split(firstFlag)).length > 0) {
            int j = attackDatass.length;
            for (int i = 0; i < j; ++i) {
                manualDefendInfo = new ManualDefendInfo();
                String attackData = attackDatass[i].trim();
                String[] attackDataAtts = attackData.split(secondFlag);
                String pkId = attackDataAtts[0].trim();
                String zoneIp = attackDataAtts[1].trim();
                String deviceIp = attackDataAtts[2].trim();
                String zoneID = attackDataAtts[3].trim();
                String attackType = attackDataAtts[4].trim();
                String bizId = attackDataAtts[5].trim();
                String port = attackDataAtts[6].trim();
                String attackTypeStr = this.getText(prefix + attackType);
                manualDefendInfo.setPkId(pkId);
                manualDefendInfo.setZoneId(zoneID);
                manualDefendInfo.setZoneIp(zoneIp);
                manualDefendInfo.setAttackType(Integer.valueOf(attackType));
                manualDefendInfo.setDeviceIp(deviceIp);
                manualDefendInfo.setAttackTypeStr(attackTypeStr);
                manualDefendInfo.setBizId(bizId);
                if (!StringUtils.isEmpty((CharSequence)port)) {
                    manualDefendInfo.setPort(Integer.valueOf(port));
                }
                manualDefendInfos.add(manualDefendInfo);
            }
        }
        return manualDefendInfos;
    }

    private String assembTransferInputStr(List<ManualDefendInfo> list) {
        StringBuilder tmp = new StringBuilder();
        if (null != list) {
            for (int i = 0; i < list.size(); ++i) {
                ManualDefendInfo manualDefndInfo = list.get(i);
                tmp.append(manualDefndInfo.getPkId());
                if (i == list.size() - 1) continue;
                tmp.append(',');
            }
        }
        return tmp.toString();
    }

    private String getZoneName(String zoneID) {
        ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(Long.valueOf(zoneID));
        if (null == zoneInfoForm) {
            return null;
        }
        return zoneInfoForm.getZoneName();
    }

    private Long getDeviceId(String deviceIp) {
        List<AticDevice> fireWalls = ZoneReferUtil.getAllDevice((User)this.getSession().getAttribute("currentUser"));
        if (null == fireWalls) {
            return null;
        }
        AticDevice fireWall = null;
        int j = fireWalls.size();
        for (int i = 0; i < j; ++i) {
            fireWall = fireWalls.get(i);
            if (!fireWall.getIpAddress().trim().equals(deviceIp)) continue;
            return fireWall.getMoId();
        }
        return null;
    }

    private void setAttackTypeStr() {
        String prefix = "com.hs.vsm.secservice.ddos.attack.attackType.";
        if (null != this.attackDatas) {
            for (AttackDataForm form : this.attackDatas) {
                String attackTypeName;
                form.setAttackTypeStr(this.getText(prefix + form.getAttackType()));
                if (form.getAttackType() < 10) {
                    ZoneServiceForm zoneServiceForm = (ZoneServiceForm)ZoneReferUtil.getZoneServiceService().query(form.getBizId());
                    if (null != zoneServiceForm) {
                        form.setAttackTypeStr(form.getAttackTypeStr() + "(" + zoneServiceForm.getServiceName() + ")");
                        continue;
                    }
                    ZoneServiceForm zoneService = null;
                    zoneService = ZoneReferUtil.getZoneMgrNorthSerice().getZoneServiceFormByProtocolAndPort(form.getZoneId(), form.getDeviceIp(), form.getProtocol(), form.getPort());
                    if (null != zoneService) {
                        form.setAttackTypeStr(this.getText("atic.attack.type.0") + "(" + zoneService.getServiceName() + ")");
                        continue;
                    }
                    form.setAttackTypeStr(this.getText("atic.attack.type.0") + "(protocol:" + ZoneReferUtil.getProtocolString(form.getProtocol()) + ",port:" + form.getPort() + ")");
                    continue;
                }
                if (form.getAttackType() >= 2000 && form.getAttackType() < 80000) {
                    attackTypeName = "";
                    if (2000 == form.getAttackType()) {
                        attackTypeName = this.getText("com.hs.vsm.secservice.ddos.attack.attackType.62");
                    } else {
                        long filterId = form.getAttackType() - 2000;
                        IFilterService filterService = ZoneReferUtil.getFilterService();
                        FilterForm filterTemp = filterService.queryFilterName(filterId);
                        attackTypeName = null != filterTemp && !PolicyUtil.isNull(filterTemp.getFilterName()) ? filterTemp.getFilterName() : this.getText("atic.analysis.common.unknownFilter") + filterId;
                    }
                    form.setAttackTypeStr(attackTypeName);
                    continue;
                }
                if (form.getAttackType() < 80000) continue;
                attackTypeName = "";
                if (80000 == form.getAttackType()) {
                    attackTypeName = this.getText("com.hs.vsm.secservice.ddos.attack.attackType.80000");
                } else {
                    long filterId = form.getAttackType() - 80000;
                    INpFilterService npfilterService = ZoneReferUtil.getNPFilterService();
                    NPFilterForm npfilterTemp = npfilterService.queryNPFilterFormByfilterId(filterId);
                    attackTypeName = null != npfilterTemp && !PolicyUtil.isNull(npfilterTemp.getFilterName()) ? npfilterTemp.getFilterName() : this.getText("com.hs.vsm.secservice.ddos.attack.attackType.80000");
                }
                form.setAttackTypeStr(attackTypeName);
            }
        }
    }

    public static String getProtocolString(int protocol, int port) {
        String protocolString = "";
        protocolString = 1 == protocol && 80 == port ? "HTTP" : (2 == protocol || 17 == protocol ? "UDP" : "TCP");
        return protocolString;
    }

    private void deviceDefendStatusSet() {
        if (null != this.attackDatas) {
            for (AttackDataForm form : this.attackDatas) {
                this.destinationZoneIpStrAdapter(form);
                if (Constant.DEVICE_SERVICE_TYPE_DETECT.equals(form.getDeviceType())) {
                    form.setInterActive(100);
                    form.setInterActiveStr("--");
                    continue;
                }
                if (Constant.DEFENDMODE_DEFEND_AUTO.equals(form.getDefendMode())) {
                    form.setInterActive(100);
                    form.setInterActiveStr(this.getText("com.hs.vsm.secservice.ddos.attack.defend.auto"));
                    continue;
                }
                if (!"all".equals(this.deviceNameCmb)) {
                    this.setDefendStateDisable(false);
                }
                if ("0".equals(String.valueOf(form.getZoneIp())) && "0".equals(String.valueOf(form.getBizId()))) {
                    this.setDestinationZoneDefendState(form);
                    continue;
                }
                if (this.confirmTypes(form.getAttackType()).booleanValue()) {
                    form.setInterActiveStr(this.getText("com.hs.vsm.secservice.ddos.attack.defendStatus." + form.getInterActive()));
                    continue;
                }
                if (this.interactive(form)) {
                    form.setInterActiveStr(this.getText("com.hs.vsm.secservice.ddos.attack.defendStatus." + form.getInterActive()));
                    continue;
                }
                this.setDestinationZoneDefendState(form);
            }
        }
    }

    private void destinationZoneIpStrAdapter(AttackDataForm form) {
        if ((null == form.getZoneIp() || "".equals(form.getZoneIp())) && "0".equals(String.valueOf(form.getBizId()))) {
            form.setZoneIp("--");
        }
    }

    private void setDestinationZoneDefendState(AttackDataForm form) {
        if (form.getInterActive() == 0) {
            form.setInterActive(100);
            form.setInterActiveStr("--");
        } else {
            form.setInterActive(100);
            form.setInterActiveStr(this.getText("com.hs.vsm.secservice.ddos.attack.defendStatus.2"));
        }
    }

    private boolean interactive(AttackDataForm form) {
        String ddosVersion = ZoneReferUtil.getDdosVersion(form.getDeviceIp());
        return Integer.valueOf(1).equals(form.getAttackStatus()) && String.valueOf(1).equals(ddosVersion) && (Integer.valueOf(35).equals(form.getAttackType()) || Integer.valueOf(37).equals(form.getAttackType()) || Integer.valueOf(38).equals(form.getAttackType()) || Integer.valueOf(39).equals(form.getAttackType()));
    }

    private Boolean confirmTypes(Integer conType) {
        if (this.confAttackTypes == null) {
            this.confAttackTypes = XmlParserUtil.createLangPairs("/conf/attack/confirmAttack.xml");
        }
        for (LangPair pair : this.confAttackTypes) {
            if (!pair.getLabel().equals(conType.toString())) continue;
            return true;
        }
        return false;
    }

    public Boolean getCollectorOnline() {
        return this.collectorOnline;
    }

    public void setCollectorOnline(Boolean collectorOnline) {
        this.collectorOnline = collectorOnline;
    }

    public Integer getZoneDefendMode() {
        return this.zoneDefendMode;
    }

    public void setZoneDefendMode(Integer zoneDefendMode) {
        this.zoneDefendMode = zoneDefendMode;
    }

    public Boolean getIsNip() {
        return this.isNip;
    }

    public void setIsNip(Boolean isNip) {
        this.isNip = isNip;
    }

    public List<String> getGoodDeviceIp() {
        return this.goodDeviceIp;
    }

    public void setGoodDeviceIp(List<String> goodDeviceIp) {
        this.goodDeviceIp = goodDeviceIp;
    }

    public boolean isIncludesV1R1() {
        return this.includesV1R1;
    }

    public void setIncludesV1R1(boolean includesV1R1) {
        this.includesV1R1 = includesV1R1;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean validateZoneId() {
        long id = 0L;
        try {
            id = Long.parseLong(this.zoneId);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return id >= 1L;
    }

    public boolean validateZoneDefendMode() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String mode = request.getParameter("zoneDefendMode");
        if (null == mode) {
            return true;
        }
        if ("".equals(mode)) {
            return false;
        }
        return "0".equals(mode) || "1".equals(mode);
    }

    public boolean validateDirectionCmb() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String direction = request.getParameter("directionCmb");
        if (null == direction) {
            return true;
        }
        if ("".equals(direction)) {
            return false;
        }
        String regex = "^(-1|0|1)$";
        return direction.matches(regex);
    }

    public boolean validateInteractiveCmb() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String interactive = request.getParameter("interactiveCmb");
        if (null == interactive) {
            return true;
        }
        if ("".equals(interactive)) {
            return false;
        }
        String regex = "^(-1|0|1|2|3)$";
        return interactive.matches(regex);
    }

    public boolean validateDeviceNameCmb() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String nameCmb = request.getParameter("deviceNameCmb");
        if (null == nameCmb) {
            return true;
        }
        if ("".equals(nameCmb) || "null".equals(nameCmb)) {
            return false;
        }
        String regex = "^[a-zA-Z_0-9\\u4e00-\u9fa5]{1}[\\w\\-\\u4e00-\\u9fa5\\.]*$";
        return nameCmb.matches(regex);
    }
}

