/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.util.FilterUtil;
import com.hs.vsm.secservice.ddos.policy.util.ZoneConstants;
import com.hs.vsm.secservice.ddos.policy.util.ZoneUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IHttpFilterService;
import com.huawei.atic.secne.common.LocaleUtil;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class FilterImportAndExportAction
extends BaseAction {
    public static final int NUMBER_HTTP_FILTER_KEYWORD = 0;
    public static final int NUMBER_ZERO = 0;
    public static final int NUMBER_ONE = 1;
    public static final int NUMBER_TWO = 2;
    public static final int NUMBER_HTTP_FILTER_CONTENT = 1;
    private static final Map<String, List<String>> MAP_DDOS = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> MAP_OTHER = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> MAP_NFA = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> MAP_ALL = new HashMap<String, List<String>>();
    private static final String SESSION_FILTER_KEY = "filterKeyList";
    private static final long serialVersionUID = -3819604924416374478L;
    private static final Long NUM_570648 = 570648L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private String filterFile;
    private String filterFileName;
    private int filterId;
    private String filterType;
    private String deviceType;
    private IFilterService filterService;
    private IHttpFilterService httpFilterService;
    private List<HttpFilterForm> httpFilterFormList = new ArrayList<HttpFilterForm>();
    private List<BatchOperation> frontOperationList = new ArrayList<BatchOperation>();
    private int totalRow = 0;
    private String[] filterKeyList;

    public void importFilter() {
        try {
            Workbook workbook = this.getWorkbook();
            this.validateFilterWorkbook(workbook);
            this.clearCahe();
            this.getImportHttpFilterFromWorkbook(workbook);
            this.saveImportHttpFilterAndGetResult();
            BatchOperationResult operationResult = this.cleanUpBatchOperationResult();
            this.bathResult(operationResult);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("import httpFilterInfo error : " + e.getErrorCode()));
            throw e;
        }
        catch (Exception e) {
            this.logger.error((Object)"import httpFilterInfo error : ", (Throwable)e);
            throw new LegoCheckedException(670723L, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Workbook getWorkbook() throws IOException, BiffException {
        int iLast;
        Workbook workbook = null;
        String ipDomainFileNameTemp = this.filterFileName.trim();
        String logoType = ipDomainFileNameTemp.substring((iLast = ipDomainFileNameTemp.lastIndexOf(".")) + 1, ipDomainFileNameTemp.length());
        if (!"xls".equalsIgnoreCase(logoType)) {
            this.responseResult(this.getText("com.hs.vsm.secservice.ddos.filter.import.fileType.remark"));
            return null;
        }
        try {
            File file = new File(this.filterFile);
            if (file.exists()) {
                if (!AticUtil.checkFileType((File)file, (String)"D0CF11E0")) {
                    this.responseResult(this.getText("com.hs.vsm.secservice.ddos.filter.import.fileType.remark"));
                    Workbook workbook2 = null;
                    return workbook2;
                }
                if (file.length() > 0x100000L) {
                    this.responseResult(this.getText("atic.ip.domain.title.import.fileTooBig"));
                    Workbook workbook3 = null;
                    return workbook3;
                }
                workbook = Workbook.getWorkbook((File)file);
            }
            Workbook workbook4 = workbook;
            return workbook4;
        }
        finally {
            this.logger.info((Object)" FilterUtil.closeInputStream(importFileInputStream)");
        }
    }

    private void validateFilterWorkbook(Workbook workbook) {
        if (workbook == null) {
            throw new LegoCheckedException(570602L);
        }
        Sheet sheet = workbook.getSheet(0);
        if (sheet.getColumns() != 2) {
            throw new LegoCheckedException(570602L);
        }
        Cell[] cell = sheet.getRow(0);
        if (cell == null || cell.length != 2) {
            throw new LegoCheckedException(570602L);
        }
        if (!ZoneConstants.FILTER_EXCEL_TABLENAME_KEYWORD_ZH.equalsIgnoreCase(cell[0].getContents().trim()) && !ZoneConstants.FILTER_EXCEL_TABLENAME_KEYWORD_EN.equalsIgnoreCase(cell[0].getContents().trim())) {
            throw new LegoCheckedException(570602L);
        }
        if (!ZoneConstants.FILTER_EXCEL_TABLENAME_CONTENT_ZH.equalsIgnoreCase(cell[1].getContents().trim()) && !ZoneConstants.FILTER_EXCEL_TABLENAME_CONTENT_EN.equalsIgnoreCase(cell[1].getContents().trim())) {
            throw new LegoCheckedException(570602L);
        }
    }

    private void clearCahe() {
        this.httpFilterFormList.clear();
        this.frontOperationList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getImportHttpFilterFromWorkbook(Workbook workbook) {
        try {
            Sheet sheet = workbook.getSheet(0);
            int j = sheet.getRows();
            for (int i = 1; i < j; ++i) {
                HttpFilterForm httpFilterForm;
                ++this.totalRow;
                Cell[] cells = FilterUtil.fillCellFilter(sheet.getRow(i));
                boolean isEmptyRow = this.checkIsEmptyRow(cells);
                if (isEmptyRow || (httpFilterForm = this.getAndCheckImportHttpFilterContent(cells, this.filterType, this.filterId)) == null) continue;
                this.httpFilterFormList.add(httpFilterForm);
            }
        }
        finally {
            ZoneUtil.closeWorkbook(workbook);
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    /*
     * WARNING - void declaration
     */
    private HttpFilterForm getAndCheckImportHttpFilterContent(Cell[] cells, String filterTypeStr, int filterID) {
        String[] httpContent;
        HttpFilterForm form;
        String[] contentBefor;
        String[] contentExist;
        Object dbList;
        String content;
        boolean isContentRange;
        boolean isContentRange2;
        boolean isContentRange1;
        boolean isFilterContent;
        String filterKey = cells[0].getContents().trim();
        List<String> list = null;
        list = this.deviceType.equals("AntiDDoS") ? MAP_DDOS.get(filterTypeStr) : (this.deviceType.equals("NFA") ? MAP_NFA.get(filterTypeStr) : MAP_ALL.get(filterTypeStr));
        boolean isContainsKey = list.contains(filterKey);
        if (!isContainsKey) {
            this.logger.info((Object)("import filterkey  failed, the error filterkey is : " + filterKey));
            this.createImportFailedBO(filterKey, 670709L);
            return null;
        }
        String filterContent = cells[1].getContents().trim();
        List<String> list2 = MAP_OTHER.get(filterKey);
        if (list2 != null && !(isFilterContent = list2.contains(filterContent))) {
            this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
            this.createImportFailedBO(filterContent, 670710L);
            return null;
        }
        if ("ttl".equals(filterKey) && !(isContentRange1 = FilterUtil.isCheckData1(filterContent))) {
            this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
            this.createImportFailedBO(filterContent, 670711L);
            return null;
        }
        if (("dscp".equals(filterKey) || "protocol".equals(filterKey) || "type".equals(filterKey)) && !(isContentRange2 = FilterUtil.isCheckData2(filterContent))) {
            this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
            this.createImportFailedBO(filterContent, 670712L);
            return null;
        }
        if ("tcp-flag".equals(filterKey) && !(isContentRange = FilterUtil.isCheckData3(filterContent))) {
            this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
            this.createImportFailedBO(filterContent, 670718L);
            return null;
        }
        if ("source-ip".equals(filterKey) || "destination-ip".equals(filterKey)) {
            String ip = null;
            String mask = null;
            String[] stringArray = filterContent.split("/");
            if (stringArray.length != 2) {
                this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                this.createImportFailedBO(filterContent, 670713L);
                return null;
            }
            ip = stringArray[0];
            mask = stringArray[1];
            if (FilterUtil.isIpv4(ip) && mask != null && !FilterUtil.isIpv4Mask(mask)) {
                this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                this.createImportFailedBO(filterContent, 670713L);
                return null;
            }
            if (FilterUtil.isIpv6(ip)) {
                if (mask != null && !FilterUtil.isIpv6Mask(mask)) {
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, 670714L);
                    return null;
                }
            } else if (!FilterUtil.isIpv4(ip) && !FilterUtil.isIpv6(ip)) {
                this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                this.createImportFailedBO(filterContent, 670714L);
                return null;
            }
            content = "";
            for (HttpFilterForm form3 : this.httpFilterFormList) {
                if ("source-ip".equals(form3.getFilterKey()) || "destination-ip".equals(form3.getFilterKey())) {
                    content = form3.getFilterContent();
                }
                String[] ipRangeIPV4 = new String[]{};
                String[] ipRangeIPV6 = new String[]{};
                if (null != content && !"".equals(content)) {
                    String[] contentExist2 = content.split("/");
                    if (contentExist2.length != 2) {
                        this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                        this.createImportFailedBO(filterContent, NUM_570648);
                        return null;
                    }
                    if (FilterUtil.isIpv4(contentExist2[0])) {
                        ipRangeIPV4 = IPUtil.getSubnetRange((String)contentExist2[0], (int)Integer.parseInt(contentExist2[1]));
                    } else if (FilterUtil.isIpv6(contentExist2[0])) {
                        ipRangeIPV6 = IPUtil.getSubnetRange((String)contentExist2[0], (int)Integer.parseInt(contentExist2[1]));
                    }
                }
                if (ipRangeIPV4.length != 0 && FilterUtil.isIpv4(ip) && IPUtil.isInIpRange((String[])ipRangeIPV4, (String)ip)) {
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, NUM_570648);
                    return null;
                }
                if (ipRangeIPV6.length == 0 || !IPUtil.isIpv6((String)ip) || !IPUtil.isInIpRange((String[])ipRangeIPV6, (String)ip)) continue;
                this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                this.createImportFailedBO(filterContent, NUM_570648);
                return null;
            }
        }
        if ("packet-length".equals(filterKey)) {
            String[] packetLength = filterContent.split("~");
            if (packetLength.length == 1) {
                this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                this.createImportFailedBO(filterContent, 670717L);
                return null;
            }
            if (packetLength.length == 2) {
                if (!FilterUtil.isPacketLengthRange(packetLength[0]) || !FilterUtil.isPacketLengthRange(packetLength[1])) {
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, 670715L);
                    return null;
                }
                if (Integer.parseInt(packetLength[0]) > Integer.parseInt(packetLength[1])) {
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, 670719L);
                    return null;
                }
            }
            if (filterID != 0) {
                dbList = this.httpFilterService.queryFilterContent("packet-length", String.valueOf(filterID));
                if (this.httpFilterFormList.isEmpty() && !dbList.isEmpty()) {
                    Iterator iterator = dbList.iterator();
                    while (iterator.hasNext()) {
                        HttpFilterForm form2 = (HttpFilterForm)iterator.next();
                        int min = 0;
                        int max = 0;
                        contentExist = form2.getFilterContent().split("~");
                        if (packetLength.length == 2) {
                            min = Integer.parseInt(contentExist[0]);
                            max = Integer.parseInt(contentExist[1]);
                        }
                        if (!FilterUtil.isRangeExist(filterContent, min, max)) continue;
                        this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                        this.createImportFailedBO(form2.getFilterKey() + ":" + form2.getFilterContent(), 670722L);
                        return null;
                    }
                }
            } else {
                for (HttpFilterForm httpFilterForm : this.httpFilterFormList) {
                    if (!"packet-length".equals(httpFilterForm.getFilterKey())) continue;
                    contentBefor = httpFilterForm.getFilterContent().split("~");
                    int min = 0;
                    int max = 0;
                    if (contentBefor.length == 1) {
                        max = min = Integer.parseInt(contentBefor[0]);
                    } else if (contentBefor.length == 2) {
                        min = Integer.parseInt(contentBefor[0]);
                        max = Integer.parseInt(contentBefor[1]);
                    }
                    if (!FilterUtil.isRangeExist(filterContent, min, max)) continue;
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, 670722L);
                    return null;
                }
            }
        }
        if ("flow-packet-count".equals(filterKey)) {
            String[] packetLength = filterContent.split("~");
            if (packetLength.length == 1) {
                this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                this.createImportFailedBO(filterContent, 670717L);
                return null;
            }
            if (packetLength.length == 2) {
                if (!FilterUtil.isFlowPacketLengthRange(packetLength[0]) || !FilterUtil.isFlowPacketLengthRange(packetLength[1])) {
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, 670809L);
                    return null;
                }
                if (Integer.parseInt(packetLength[0]) > Integer.parseInt(packetLength[1])) {
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, 670811L);
                    return null;
                }
            }
            if (filterID != 0) {
                dbList = this.httpFilterService.queryFilterContent("flow-packet-count", String.valueOf(filterID));
                if (this.httpFilterFormList.isEmpty() && !dbList.isEmpty()) {
                    Iterator iterator = dbList.iterator();
                    while (iterator.hasNext()) {
                        form = (HttpFilterForm)iterator.next();
                        int min = 0;
                        int max = 0;
                        contentExist = form.getFilterContent().split("~");
                        if (packetLength.length == 2) {
                            min = Integer.parseInt(contentExist[0]);
                            max = Integer.parseInt(contentExist[1]);
                        }
                        if (!FilterUtil.isRangeExist(filterContent, min, max)) continue;
                        this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                        this.createImportFailedBO(form.getFilterKey() + ":" + form.getFilterContent(), 670813L);
                        return null;
                    }
                }
            } else {
                for (HttpFilterForm httpFilterForm : this.httpFilterFormList) {
                    if (!"flow-packet-count".equals(httpFilterForm.getFilterKey())) continue;
                    contentBefor = httpFilterForm.getFilterContent().split("~");
                    int min = 0;
                    int max = 0;
                    if (contentBefor.length == 1) {
                        max = min = Integer.parseInt(contentBefor[0]);
                    } else if (contentBefor.length == 2) {
                        min = Integer.parseInt(contentBefor[0]);
                        max = Integer.parseInt(contentBefor[1]);
                    }
                    if (!FilterUtil.isRangeExist(filterContent, min, max)) continue;
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, 670813L);
                    return null;
                }
            }
        }
        if ("flow-bytes".equals(filterKey)) {
            String[] packetLength = filterContent.split("~");
            if (packetLength.length == 1) {
                this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                this.createImportFailedBO(filterContent, 670717L);
                return null;
            }
            if (packetLength.length == 2) {
                if (!FilterUtil.isFlowPacketLengthRange(packetLength[0]) || !FilterUtil.isFlowPacketLengthRange(packetLength[1])) {
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, 670810L);
                    return null;
                }
                if (Integer.parseInt(packetLength[0]) > Integer.parseInt(packetLength[1])) {
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, 670812L);
                    return null;
                }
            }
            if (filterID != 0) {
                dbList = this.httpFilterService.queryFilterContent("flow-bytes", String.valueOf(filterID));
                if (this.httpFilterFormList.isEmpty() && !dbList.isEmpty()) {
                    Iterator iterator = dbList.iterator();
                    while (iterator.hasNext()) {
                        form = (HttpFilterForm)iterator.next();
                        int min = 0;
                        int max = 0;
                        contentExist = form.getFilterContent().split("~");
                        if (packetLength.length == 2) {
                            min = Integer.parseInt(contentExist[0]);
                            max = Integer.parseInt(contentExist[1]);
                        }
                        if (!FilterUtil.isRangeExist(filterContent, min, max)) continue;
                        this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                        this.createImportFailedBO(form.getFilterKey() + ":" + form.getFilterContent(), 670814L);
                        return null;
                    }
                }
            } else {
                for (HttpFilterForm httpFilterForm : this.httpFilterFormList) {
                    if (!"flow-bytes".equals(httpFilterForm.getFilterKey())) continue;
                    contentBefor = httpFilterForm.getFilterContent().split("~");
                    int min = 0;
                    int max = 0;
                    if (contentBefor.length == 1) {
                        max = min = Integer.parseInt(contentBefor[0]);
                    } else if (contentBefor.length == 2) {
                        min = Integer.parseInt(contentBefor[0]);
                        max = Integer.parseInt(contentBefor[1]);
                    }
                    if (!FilterUtil.isRangeExist(filterContent, min, max)) continue;
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, 670814L);
                    return null;
                }
            }
        }
        if ("source-port".equals(filterKey) || "destination-port".equals(filterKey)) {
            void var11_41;
            String[] portLength = filterContent.split("~");
            if (portLength.length == 1) {
                filterContent = portLength[0];
                if (!FilterUtil.isPortRange(portLength[0])) {
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, 670716L);
                    return null;
                }
            } else if (portLength.length == 2) {
                if (!FilterUtil.isPortRange(portLength[0]) || !FilterUtil.isPortRange(portLength[1])) {
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, 670716L);
                    return null;
                }
                if (Integer.parseInt(portLength[0]) > Integer.parseInt(portLength[1])) {
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, 670720L);
                    return null;
                }
            }
            int startPort = 0;
            boolean bl = false;
            content = "";
            if (portLength.length == 1) {
                int n = startPort = Integer.parseInt(portLength[0]);
            } else if (portLength.length == 2) {
                startPort = Integer.parseInt(portLength[0]);
                int n = Integer.parseInt(portLength[1]);
            }
            if (filterID != 0) {
                List<HttpFilterForm> dbformList = this.httpFilterService.queryFilterContent("packet-length", String.valueOf(filterID));
                if (this.httpFilterFormList.isEmpty() && !dbformList.isEmpty()) {
                    Iterator max = dbformList.iterator();
                    while (max.hasNext()) {
                        HttpFilterForm form5 = (HttpFilterForm)max.next();
                        if (!filterKey.equals(form5.getFilterKey()) || !FilterUtil.isRangeExist(content = form5.getFilterContent(), startPort, (int)var11_41)) continue;
                        this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                        this.createImportFailedBO(form5.getFilterKey() + ":" + filterContent, 670721L);
                        return null;
                    }
                }
            }
            for (HttpFilterForm form6 : this.httpFilterFormList) {
                if (!filterKey.equals(form6.getFilterKey()) || !FilterUtil.isRangeExist(content = form6.getFilterContent(), startPort, (int)var11_41)) continue;
                this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                this.createImportFailedBO(form6.getFilterKey() + ":" + filterContent, 670721L);
                return null;
            }
        }
        if (("cookie".equals(filterKey) || "host".equals(filterKey) || "referer".equals(filterKey) || "uri".equals(filterKey) || "user-agent".equals(filterKey)) && (!"include".equals((httpContent = filterContent.split("    "))[0]) || !FilterUtil.isAnyCharacter(httpContent[1]))) {
            this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
            this.createImportFailedBO(filterContent, 670717L);
            return null;
        }
        if (!(!"caller".equals(filterKey) && !"callee".equals(filterKey) && !"domain".equals(filterKey) || "include".equals((httpContent = filterContent.split("    "))[0]) || "equal".equals(httpContent[0]) && FilterUtil.isAnyCharacter(httpContent[1]))) {
            this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
            this.createImportFailedBO(filterContent, 670717L);
            return null;
        }
        if ("fingerprint".equals(filterKey)) {
            String[] fingers = filterContent.split("        ");
            for (int i = 0; i < fingers.length; ++i) {
                String contentLength;
                String offset;
                String string = fingers[i];
                String[] fingerContentOne = string.split(" ");
                if (fingerContentOne.length <= 2) {
                    offset = fingerContentOne[0];
                    contentLength = fingerContentOne[1];
                    String tag = FilterUtil.validateContent(contentLength);
                    if ("670717".equals(tag)) {
                        this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                        this.createImportFailedBO(filterContent, 670717L);
                        return null;
                    }
                    if ("670725".equals(tag)) {
                        this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                        this.createImportFailedBO(filterContent, 670725L);
                        return null;
                    }
                    if ("670724".equals(tag)) {
                        this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                        this.createImportFailedBO(filterContent, 670724L);
                        return null;
                    }
                    if (FilterUtil.isPacketLengthRange(offset)) continue;
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, 670717L);
                    return null;
                }
                if (fingerContentOne.length == 3) {
                    offset = fingerContentOne[0];
                    contentLength = fingerContentOne[1];
                    String depth = fingerContentOne[2];
                    String tag = FilterUtil.validateContent(contentLength);
                    if ("670717".equals(tag)) {
                        this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                        this.createImportFailedBO(filterContent, 670717L);
                        return null;
                    }
                    if ("670725".equals(tag)) {
                        this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                        this.createImportFailedBO(filterContent, 670725L);
                        return null;
                    }
                    if ("670724".equals(tag)) {
                        this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                        this.createImportFailedBO(filterContent, 670724L);
                        return null;
                    }
                    if (FilterUtil.isOffsetRange(offset) && FilterUtil.isPacketLengthRange(depth)) continue;
                    this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                    this.createImportFailedBO(filterContent, 670717L);
                    return null;
                }
                this.logger.info((Object)("import filterContent  failed, the error filterContent is : " + this.getcleanedMessage(filterContent)));
                this.createImportFailedBO(filterContent, 670717L);
                return null;
            }
        }
        this.logger.info((Object)("import httpfilter to memory, httpfilterContent is : " + this.getcleanedMessage(filterContent)));
        HttpFilterForm httpFilterForm = new HttpFilterForm();
        httpFilterForm.setFilterKey(filterKey);
        httpFilterForm.setFilterContent(filterContent);
        return httpFilterForm;
    }

    private void createImportFailedBO(String targetName, long errorCode) {
        BatchOperation batchOperation = new BatchOperation();
        batchOperation.setTargetName(targetName);
        batchOperation.setErrorCode(errorCode);
        this.frontOperationList.add(batchOperation);
    }

    private void saveImportHttpFilterAndGetResult() {
        if (!this.httpFilterFormList.isEmpty()) {
            for (HttpFilterForm form : this.httpFilterFormList) {
                List<HttpFilterForm> sessionList = null;
                sessionList = this.getSessionFilterKey();
                if (sessionList == null) {
                    sessionList = new ArrayList<HttpFilterForm>();
                }
                if (this.isFormExist(sessionList, form)) {
                    this.createImportFailedBO(form.getFilterKey() + ":" + form.getFilterContent(), 670708L);
                    continue;
                }
                if (this.isTooMuch(sessionList, form.getFilterKey())) {
                    this.createImportFailedBO(form.getFilterKey() + ":" + form.getFilterContent(), 631036L);
                    continue;
                }
                sessionList.add(form);
                this.setSessionFilterKey(sessionList);
            }
        }
    }

    private List<HttpFilterForm> getSessionFilterKey() {
        String sessionId = this.getSession().getId();
        return (List)this.getSession().getAttribute(SESSION_FILTER_KEY + sessionId);
    }

    private void setSessionFilterKey(List<HttpFilterForm> list) {
        String sessionId = this.getSession().getId();
        this.getSession().setAttribute(SESSION_FILTER_KEY + sessionId, list);
    }

    private boolean isFormExist(List<HttpFilterForm> list, HttpFilterForm obj) {
        for (HttpFilterForm tmp : list) {
            if (!this.isSameForm(tmp, obj)) continue;
            return true;
        }
        return false;
    }

    private boolean isTooMuch(List<HttpFilterForm> list, String filterKey) {
        int count = 0;
        for (HttpFilterForm tmp : list) {
            if (!tmp.getFilterKey().equals(filterKey)) continue;
            ++count;
        }
        return count >= FilterUtil.getNumber(filterKey);
    }

    private boolean isSameForm(HttpFilterForm obj1, HttpFilterForm obj2) {
        return obj1.getFilterKey().equals(obj2.getFilterKey()) && obj1.getFilterContent().equals(obj2.getFilterContent());
    }

    private BatchOperationResult cleanUpBatchOperationResult() {
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        for (BatchOperation batchOperation : this.frontOperationList) {
            batchOpList.add(batchOperation);
        }
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        batchOperationResult.setResult(batchOpList);
        batchOperationResult.setFailCount(batchOpList.size());
        batchOperationResult.setTotalCount(this.totalRow);
        batchOperationResult.setSucceedCount(this.totalRow - batchOpList.size());
        return batchOperationResult;
    }

    private boolean checkIsEmptyRow(Cell[] cells) {
        String filterKey = cells[0].getContents().trim();
        String filterContent = cells[1].getContents().trim();
        return ZoneUtil.isNull(filterKey) && ZoneUtil.isNull(filterContent);
    }

    public void exportFilter() {
        try {
            String exportFilePath = this.initExportFile("httpFilterInfo");
            List<HttpFilterForm> httpFilterFormLists = this.getExportFilterContent();
            this.writeFilterContentToExportFile(httpFilterFormLists, exportFilePath);
            String[] args = null;
            args = 1 == AticInstallUtil.getInstance().getAticInstallOS() ? exportFilePath.split("/") : exportFilePath.split("\\\\");
            this.responseResult(args[args.length - 1]);
        }
        catch (WriteException e) {
            this.logger.error((Object)"export filter error : ", (Throwable)e);
            throw new LegoCheckedException(570697L, (Throwable)e);
        }
        catch (BiffException e) {
            this.logger.error((Object)"export filter error : ", (Throwable)e);
            throw new LegoCheckedException(570697L, (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"export filter error : ", (Throwable)e);
            throw new LegoCheckedException(570697L, (Throwable)e);
        }
    }

    private String initExportFile(String source) throws IOException {
        String exportFilePath = this.getExportFilePath(source);
        String templateFilePath = "";
        if ("httpFilterInfo".equals(source)) {
            templateFilePath = this.getSession().getServletContext().getRealPath("") + File.separator + "template" + File.separator + LocaleUtil.INSTANCE.getText("com.hs.vsm.secservice.ddos.filters.template.name");
            ZoneUtil.copyFile(templateFilePath, exportFilePath);
        }
        return exportFilePath;
    }

    private String getExportFilePath(String source) {
        String exportFolderPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
        boolean isCreateExportFolderSuccess = ZoneUtil.isCreateFolderSuccess(exportFolderPath);
        if (!isCreateExportFolderSuccess) {
            throw new LegoCheckedException(0L);
        }
        Long dateTime = System.currentTimeMillis();
        String exportFolderName = "";
        if (source.contains("httpFilterInfo")) {
            exportFolderName = "filterInfo_" + dateTime + ".xls";
        }
        return exportFolderPath + File.separator + exportFolderName;
    }

    private List<HttpFilterForm> getExportFilterContent() {
        ArrayList<HttpFilterForm> httpFilterList = new ArrayList();
        if (this.filterKeyList != null) {
            String[] record = null;
            for (int i = 0; i < this.filterKeyList.length; ++i) {
                HttpFilterForm form = new HttpFilterForm();
                record = this.filterKeyList[i].split("#");
                form.setFilterKey(record[0]);
                form.setFilterContent(record[1].replace("&nbsp;", " "));
                httpFilterList.add(form);
            }
            this.logger.info((Object)("export filterContent to memory, the export-filterContents : " + this.getcleanedMessage(String.valueOf(this.filterKeyList))));
        } else {
            httpFilterList = this.getSessionFilterKey();
            this.logger.info((Object)("export filterContent to memory, the export-All-filterContents : " + this.getcleanedMessage(String.valueOf(this.filterKeyList))));
        }
        return httpFilterList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFilterContentToExportFile(List<HttpFilterForm> filterFormList, String exportFilePath) throws IOException, BiffException, WriteException {
        Workbook workbook = null;
        WritableWorkbook writableWorkbook = null;
        try {
            workbook = Workbook.getWorkbook((File)new File(exportFilePath));
            writableWorkbook = Workbook.createWorkbook((File)new File(exportFilePath), (Workbook)workbook);
            WritableSheet sheet = writableWorkbook.getSheet(0);
            WritableCellFormat writableCellFormat = new WritableCellFormat();
            writableCellFormat.setWrap(true);
            int rowNum = 1;
            if (null != filterFormList && !filterFormList.isEmpty()) {
                int j = filterFormList.size();
                for (int i = 0; i < j; ++i) {
                    HttpFilterForm httpFilterForm = filterFormList.get(i);
                    sheet.addCell((WritableCell)new Label(0, rowNum, httpFilterForm.getFilterKey()));
                    sheet.addCell((WritableCell)new Label(1, rowNum, httpFilterForm.getFilterContent()));
                    ++rowNum;
                }
                this.logger.info((Object)"write filter content to export-file");
            }
            writableWorkbook.write();
        }
        catch (Throwable throwable) {
            ZoneUtil.closeWorkbook(workbook);
            ZoneUtil.closeWritableWorkbook(writableWorkbook);
            throw throwable;
        }
        ZoneUtil.closeWorkbook(workbook);
        ZoneUtil.closeWritableWorkbook(writableWorkbook);
    }

    public String getFilterFile() {
        return this.filterFile;
    }

    public void setFilterFile(String filterFile) {
        this.filterFile = filterFile;
    }

    public IFilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(IFilterService filterService) {
        this.filterService = filterService;
    }

    public IHttpFilterService getHttpFilterService() {
        return this.httpFilterService;
    }

    public void setHttpFilterService(IHttpFilterService httpFilterService) {
        this.httpFilterService = httpFilterService;
    }

    public List<HttpFilterForm> getHttpFilterFormList() {
        return this.httpFilterFormList;
    }

    public void setHttpFilterFormList(List<HttpFilterForm> httpFilterFormList) {
        this.httpFilterFormList = httpFilterFormList;
    }

    public List<BatchOperation> getFrontOperationList() {
        return this.frontOperationList;
    }

    public void setFrontOperationList(List<BatchOperation> frontOperationList) {
        this.frontOperationList = frontOperationList;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public String[] getFilterKeyList() {
        if (null != this.filterKeyList) {
            return (String[])this.filterKeyList.clone();
        }
        return new String[0];
    }

    public void setFilterKeyList(String[] filterKeyList) {
        this.filterKeyList = null != filterKeyList ? (String[])filterKeyList.clone() : null;
    }

    public int getFilterId() {
        return this.filterId;
    }

    public void setFilterId(int filterId) {
        this.filterId = filterId;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getFilterFileName() {
        return this.filterFileName;
    }

    public void setFilterFileName(String filterFileName) {
        this.filterFileName = filterFileName;
    }

    public boolean validateFilterKeyList() {
        if (null == this.filterKeyList || this.filterKeyList.length == 0) {
            return true;
        }
        String filterListRegex = "^[\\w|\\s|\u4e00-\u9fa5|=|&|;|\\-|\\\\|/|_|!|@|#|$|~|*|^|:|,|.|+|}|{]*$";
        for (String str : this.filterKeyList) {
            if (str.matches(filterListRegex)) continue;
            return false;
        }
        return true;
    }

    static {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("source-ip");
        list1.add("destination-ip");
        list1.add("packet-length");
        list1.add("ttl");
        list1.add("fingerprint");
        list1.add("protocol");
        list1.add("dscp");
        list1.add("fragment");
        MAP_DDOS.put("IP", list1);
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("source-ip");
        list2.add("destination-ip");
        list2.add("packet-length");
        list2.add("ttl");
        list2.add("fingerprint");
        list2.add("dscp");
        list2.add("fragment");
        list2.add("tcp-flag");
        list2.add("destination-port");
        list2.add("source-port");
        MAP_DDOS.put("TCP", list2);
        ArrayList<String> list3 = new ArrayList<String>();
        list3.add("source-ip");
        list3.add("destination-ip");
        list3.add("packet-length");
        list3.add("ttl");
        list3.add("fingerprint");
        list3.add("dscp");
        list3.add("fragment");
        list3.add("destination-port");
        list3.add("source-port");
        MAP_DDOS.put("UDP", list3);
        ArrayList<String> list4 = new ArrayList<String>();
        list4.add("source-ip");
        list4.add("destination-ip");
        list4.add("packet-length");
        list4.add("ttl");
        list4.add("fingerprint");
        list4.add("dscp");
        list4.add("fragment");
        MAP_DDOS.put("ICMP", list4);
        ArrayList<String> list5 = new ArrayList<String>();
        list5.add("source-ip");
        list5.add("destination-ip");
        list5.add("packet-length");
        list5.add("ttl");
        list5.add("fingerprint");
        list5.add("dscp");
        list5.add("fragment");
        list5.add("tcp-flag");
        list5.add("source-port");
        list5.add("opcode");
        list5.add("cookie");
        list5.add("host");
        list5.add("referer");
        list5.add("uri");
        list5.add("user-agent");
        MAP_DDOS.put("HTTP", list5);
        ArrayList<String> list6 = new ArrayList<String>();
        list6.add("source-ip");
        list6.add("destination-ip");
        list6.add("packet-length");
        list6.add("ttl");
        list6.add("fingerprint");
        list6.add("dscp");
        list6.add("fragment");
        list6.add("source-port");
        list6.add("domain");
        list6.add("qr");
        list6.add("type");
        MAP_DDOS.put("DNS", list6);
        ArrayList<String> list7 = new ArrayList<String>();
        list7.add("source-ip");
        list7.add("destination-ip");
        list7.add("packet-length");
        list7.add("ttl");
        list7.add("fingerprint");
        list7.add("dscp");
        list7.add("fragment");
        list7.add("source-port");
        list7.add("caller");
        list7.add("callee");
        MAP_DDOS.put("SIP", list7);
        list1 = new ArrayList();
        list1.add("protocol");
        list1.add("dscp");
        list1.add("packet-length");
        list1.add("flow-packet-count");
        list1.add("flow-bytes");
        MAP_NFA.put("IP", list1);
        list2 = new ArrayList();
        list2.add("packet-length");
        list2.add("dscp");
        list2.add("tcp-flag");
        list2.add("destination-port");
        list2.add("source-port");
        list2.add("flow-packet-count");
        list2.add("flow-bytes");
        MAP_NFA.put("TCP", list2);
        list3 = new ArrayList();
        list3.add("packet-length");
        list3.add("dscp");
        list3.add("destination-port");
        list3.add("source-port");
        list3.add("flow-packet-count");
        list3.add("flow-bytes");
        MAP_NFA.put("UDP", list3);
        list4 = new ArrayList();
        list4.add("packet-length");
        list4.add("dscp");
        list4.add("flow-packet-count");
        list4.add("flow-bytes");
        MAP_NFA.put("ICMP", list4);
        list5 = new ArrayList();
        list5.add("packet-length");
        list5.add("dscp");
        list5.add("tcp-flag");
        list5.add("source-port");
        list5.add("flow-packet-count");
        list5.add("flow-bytes");
        MAP_NFA.put("HTTP", list5);
        list6 = new ArrayList();
        list6.add("packet-length");
        list6.add("dscp");
        list6.add("source-port");
        list6.add("flow-packet-count");
        list6.add("flow-bytes");
        MAP_NFA.put("DNS", list6);
        list7 = new ArrayList();
        list7.add("packet-length");
        list7.add("dscp");
        list7.add("source-port");
        list7.add("flow-packet-count");
        list7.add("flow-bytes");
        MAP_NFA.put("SIP", list7);
        list1 = new ArrayList();
        list1.add("protocol");
        list1.add("dscp");
        list1.add("packet-length");
        MAP_ALL.put("IP", list1);
        list2 = new ArrayList();
        list2.add("packet-length");
        list2.add("dscp");
        list2.add("tcp-flag");
        list2.add("destination-port");
        list2.add("source-port");
        MAP_ALL.put("TCP", list2);
        list3 = new ArrayList();
        list3.add("packet-length");
        list3.add("dscp");
        list3.add("destination-port");
        list3.add("source-port");
        MAP_ALL.put("UDP", list3);
        list4 = new ArrayList();
        list4.add("packet-length");
        list4.add("dscp");
        MAP_ALL.put("ICMP", list4);
        list5 = new ArrayList();
        list5.add("packet-length");
        list5.add("dscp");
        list5.add("tcp-flag");
        list5.add("source-port");
        MAP_ALL.put("HTTP", list5);
        list6 = new ArrayList();
        list6.add("packet-length");
        list6.add("dscp");
        list6.add("source-port");
        MAP_ALL.put("DNS", list6);
        list7 = new ArrayList();
        list7.add("packet-length");
        list7.add("dscp");
        list7.add("source-port");
        MAP_ALL.put("SIP", list7);
        list1 = new ArrayList();
        list1.add("non");
        list1.add("first");
        list1.add("middle");
        list1.add("last");
        list1.add("donot");
        MAP_OTHER.put("fragment", list1);
        list2 = new ArrayList();
        list2.add("get");
        list2.add("post");
        list2.add("put");
        list2.add("head");
        list2.add("delete");
        list2.add("options");
        list2.add("trace");
        list2.add("connect");
        MAP_OTHER.put("opcode", list2);
        list3 = new ArrayList();
        list3.add("query");
        list3.add("reply");
        MAP_OTHER.put("qr", list3);
    }
}

