/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.sdk.bis.form.IpLocation;
import com.hs.atic.sdk.bis.service.IFoundDefaultIdService;
import com.hs.atic.sdk.bis.service.IVpnService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneListIpForm;
import com.hs.atic.sdk.zone.form.ZonePortMapForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.sdk.zone.util.ProgressManage;
import com.hs.atic.sdk.zone.util.ProgressState;
import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.util.CheckImportXml;
import com.hs.atic.zone.util.ImportZoneConstant;
import com.hs.atic.zone.util.ImportZoneData;
import com.hs.atic.zone.util.ImportZoneUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.secservice.ddos.policy.beans.ZonePolicyParamsBean;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.policy.util.ZoneUtil;
import com.hs.vsm.secservice.sdk.common.util.Locker;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlackWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneIpLocationForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyIOForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IBlackWhiteListService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class ImportZonePolicyThread
extends Thread {
    private static ReentrantLock lock = new ReentrantLock();
    private String importType;
    private boolean isEnd;
    private int totalRow = 0;
    private ProgressState progressState = null;
    private BatchOperationResult operationResult;
    private List<BatchOperation> frontOperationList = new ArrayList<BatchOperation>();
    private List<String> importFailedZoneNameList = new ArrayList<String>();
    private boolean importZoneByDeviceIsSucess = true;
    private IZonePolicyApplyService zonePolicyApplyService;
    private IZoneService zoneService;
    private IZoneServiceService zoneServiceService;
    private IAticDeviceService aticDeviceService;
    private ImportZoneData importZoneData;
    private ZonePolicyIOForm zonePolicyForm;
    private IBlackWhiteListService blackWhiteListService;
    private User currentUser;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public ImportZonePolicyThread(String importType) {
        this.importType = importType;
        this.aticDeviceService = ZoneReferUtil.getFirewallService();
        this.zoneService = ZoneReferUtil.getZoneService();
        this.zonePolicyApplyService = ZoneReferUtil.getZonePolicyService();
        this.zoneServiceService = ZoneReferUtil.getZoneServiceService();
        this.blackWhiteListService = ZoneReferUtil.getBlackWhiteListService();
    }

    public ImportZonePolicyThread(String importType, User currentUser) {
        this.importType = importType;
        this.currentUser = currentUser;
        this.aticDeviceService = ZoneReferUtil.getFirewallService();
        this.zoneService = ZoneReferUtil.getZoneService();
        this.zonePolicyApplyService = ZoneReferUtil.getZonePolicyService();
        this.zoneServiceService = ZoneReferUtil.getZoneServiceService();
        this.blackWhiteListService = ZoneReferUtil.getBlackWhiteListService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        lock.lock();
        try {
            this.logger.info((Object)("ImportZonePolicyThread int the run(),importType=" + this.importType));
            Long importZonePolicyStartTime = System.currentTimeMillis();
            this.zonePolicyForm = this.importZoneData.getZonePolicyForm();
            try {
                if (this.checkImportZoneLength()) {
                    this.initProgressBarByZone();
                    this.importZone();
                }
                IFoundDefaultIdService defaultIdService = ZoneReferUtil.getFoundDefaultIdService();
                defaultIdService.refreshUserDefBizData();
                defaultIdService.refeshDefaultBizData();
                defaultIdService.refeshDefaultZoneData();
                this.operationResult = this.parserImportOperationResult();
                if (null != this.importZoneData.getSession()) {
                    this.importZoneData.getSession().setAttribute("operationResult", (Object)this.operationResult);
                    this.progressState.next();
                }
                this.isEnd = true;
            }
            catch (Exception e) {
                if ("device".equals(this.importType)) {
                    this.importZoneByDeviceIsSucess = false;
                }
                this.logger.error((Object)"import zone error : ", (Throwable)e);
                BatchOperation batchOperation = new BatchOperation();
                batchOperation.setTargetName(this.zonePolicyForm.getDeviceName());
                batchOperation.setErrorCode(570698L);
                this.frontOperationList.clear();
                this.endProgressBar(batchOperation);
                this.operationResult = this.parserImportOperationResult();
                this.importZoneData.getSession().setAttribute("operationResult", (Object)this.operationResult);
                this.isEnd = true;
            }
            finally {
                Locker.getInstance().setImportFlag(false);
                this.logger.info((Object)("The ImportZonePolicyThread run() end times is  " + (System.currentTimeMillis() - importZonePolicyStartTime) + "ms"));
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void endProgressBar(BatchOperation batchOperation) {
        this.frontOperationList.add(batchOperation);
        int totalStep = 2;
        this.totalRow = 1;
        this.logger.info((Object)("importZone totalStep:=" + totalStep));
        this.progressState = ProgressManage.getInstance().createProgress(totalStep, this.importZoneData.getProgressBarId());
        this.logger.info((Object)("Progress bar for import policy creation.The Progress is " + this.progressState));
        this.progressState.next();
    }

    private boolean checkImportZoneLength() {
        if (this.zonePolicyForm.getZoneFormList().size() > 1000) {
            this.logger.info((Object)("Zone object over 1000,Zone'size = " + this.zonePolicyForm.getZoneFormList().size()));
            this.operationError(this.importZoneData.getImportString(), 572002L);
            return false;
        }
        return true;
    }

    private void operationError(String targetName, long errorCode) {
        BatchOperation batchOperation = new BatchOperation();
        batchOperation.setTargetName(targetName);
        batchOperation.setErrorCode(errorCode);
        this.endProgressBar(batchOperation);
    }

    private boolean needImportZone(ZonePolicyApplyForm appForm, ZoneInfoForm zoneInfoForm, boolean isCreate) {
        if (zoneInfoForm.getZoneType() == 1 && this.zonePolicyForm.isNeedPolicy() && isCreate) {
            for (ZoneDeviceForm zoneDeviceForm : appForm.getZoneDeviceForms()) {
                if (!this.zonePolicyApplyService.isDeviceRelDefaultZone(zoneDeviceForm.getDeviceId()).booleanValue()) continue;
                this.logger.info((Object)("Save the default zone object error,zone's name = " + appForm.getZoneInfoForm().getZoneName() + ". The associated device list cannot contain devices associated with the default Zone, because each device can be associated with only one default Zone."));
                ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + appForm.getZoneInfoForm().getZoneDesc(), 572014L, this.frontOperationList);
                return false;
            }
        }
        return true;
    }

    private void importZone() {
        if (ImportZoneUtil.checkIsTaskCancled(this.importZoneData)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.logger.info((Object)("importZone() start time is " + startTime));
        if ("device".equals(this.importType) && !this.zonePolicyForm.isNeedPolicy()) {
            return;
        }
        this.progressState.next();
        if (null != this.zonePolicyForm.getZoneFormList() && !this.zonePolicyForm.getZoneFormList().isEmpty()) {
            int frontSize = this.frontOperationList.size();
            for (ZonePolicyApplyForm xmlPolicyForm : this.zonePolicyForm.getZoneFormList()) {
                if (ImportZoneUtil.checkIsTaskCancled(this.importZoneData)) {
                    return;
                }
                startTime = System.currentTimeMillis();
                this.logger.info((Object)("importZone start time is " + startTime + "ms"));
                ZoneInfoForm zoneInfoForm = xmlPolicyForm.getZoneInfoForm();
                if (null == zoneInfoForm) {
                    this.logger.info((Object)"zoneInfoForm is null");
                    continue;
                }
                ZoneInfoForm dbInfoForm = this.zoneService.getZoneByName(zoneInfoForm.getZoneName());
                if (null != dbInfoForm) {
                    zoneInfoForm.setZoneId(dbInfoForm.getZoneId());
                }
                if (ImportZoneUtil.checkZoneInfoBasicInformation(zoneInfoForm, xmlPolicyForm, this.frontOperationList, this.importZoneData)) {
                    try {
                        ArrayList<ZoneDeviceForm> temDevList = new ArrayList<ZoneDeviceForm>();
                        HashSet<String> temDevIpSet = new HashSet<String>();
                        for (ZoneDeviceForm zDeviceForm : xmlPolicyForm.getZoneDeviceForms()) {
                            if (!this.checkDeviceExist(zDeviceForm, xmlPolicyForm.getZoneInfoForm().getZoneDesc())) continue;
                            if ("device".equals(this.importType)) {
                                if (!zDeviceForm.getDeviceIp().equals(this.zonePolicyForm.getDeviceIp())) continue;
                                temDevList.add(zDeviceForm);
                                break;
                            }
                            if (temDevIpSet.contains(zDeviceForm.getDeviceIp())) continue;
                            temDevIpSet.add(zDeviceForm.getDeviceIp());
                            temDevList.add(zDeviceForm);
                        }
                        xmlPolicyForm.setZoneDeviceForms(temDevList);
                        if (this.needImportZone(xmlPolicyForm, zoneInfoForm, null == dbInfoForm)) {
                            this.importZonePolicy(zoneInfoForm, xmlPolicyForm, dbInfoForm);
                        }
                    }
                    catch (LegoCheckedException e) {
                        this.progressState.next();
                    }
                }
                if (frontSize < this.frontOperationList.size()) {
                    this.importFailedZoneNameList.add(xmlPolicyForm.getZoneInfoForm().getZoneDesc());
                    frontSize = this.frontOperationList.size();
                }
                this.progressState.next();
                this.logger.info((Object)("The importzone end times is  " + (System.currentTimeMillis() - startTime) + "ms"));
            }
        }
    }

    private boolean checkVpnExist(ZoneDeviceForm zDeviceForm, String zoneName) {
        IVpnService service = ZoneReferUtil.getVpnSynchronizeService();
        if (service.isVpnExist(zDeviceForm.getDeviceId(), zDeviceForm.getVpnName())) {
            return true;
        }
        this.logger.info((Object)("There is no association with the device VPN target ATIC. The vpnName=" + zDeviceForm.getVpnName() + ",The deviceId=" + zDeviceForm.getDeviceIp()));
        ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + zoneName + "/" + zDeviceForm.getDeviceIp() + "/" + zDeviceForm.getVpnName(), 572020L, this.frontOperationList);
        return false;
    }

    private void parserZonePolicyLocation(ZonePolicyApplyForm xmlPolicyForm, ZonePolicyApplyForm dbPolicyForm, long zoneInfoId) {
        if (!this.zonePolicyForm.isNeedLocation()) {
            return;
        }
        Map<String, IpLocation> locationMap = ImportZoneUtil.ipLocationMap(this.zonePolicyForm.isNeedLocation());
        if (null != xmlPolicyForm.getZoneIpLocationList() && !xmlPolicyForm.getZoneIpLocationList().isEmpty()) {
            ArrayList<ZoneIpLocationForm> tempList = new ArrayList<ZoneIpLocationForm>();
            for (ZoneIpLocationForm zoneIpLocationForm : xmlPolicyForm.getZoneIpLocationList()) {
                if (AticUtil.isNull((String)zoneIpLocationForm.getLocationNameEn())) continue;
                tempList.add(zoneIpLocationForm);
            }
            xmlPolicyForm.setZoneIpLocationList(tempList);
            if (xmlPolicyForm.getZoneIpLocationList().size() >= 2) {
                int defalutNum = 0;
                ZoneIpLocationForm defaultForm = null;
                tempList = new ArrayList();
                HashMap<String, ZoneIpLocationForm> ipLocationMap = new HashMap<String, ZoneIpLocationForm>();
                String regex4Location = "^(?!(?i)null$)[\u4e00-\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\-|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\w|\\!|\\:|\\;|\\?|\\.|\\(|\\)|\\,|\\w/\\w|\\'|\\r|\\n]*$";
                List<String> ipLocationNameList = ImportZoneUtil.ipLocationNameList(xmlPolicyForm.getZoneIpLocationList());
                if (!ipLocationNameList.isEmpty() && !ipLocationNameList.contains("OtherLocation".toLowerCase(Locale.getDefault()))) {
                    this.logger.info((Object)("When the position strategy is not empty, the number of the location policies must be greater than or equal to 2, which must be a default name for the \u2018OtherLocation\u2019 position strategy" + this.zonePolicyForm.getZoneFormList().size()));
                    ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572032L, this.frontOperationList);
                    xmlPolicyForm.setZoneIpLocationList(new ArrayList<ZoneIpLocationForm>());
                    return;
                }
                for (ZoneIpLocationForm zoneIpLocationForm : xmlPolicyForm.getZoneIpLocationList()) {
                    if (!ImportZoneUtil.checkIsTaskCancled(this.importZoneData)) {
                        ++this.totalRow;
                        if (AticUtil.isNull((String)zoneIpLocationForm.getLocationNameEn())) continue;
                        if (!zoneIpLocationForm.getLocationNameEn().matches(regex4Location)) {
                            this.logger.info((Object)("The zoneIpLocation name is error. The name is " + zoneIpLocationForm.getLocationNameEn()));
                            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + zoneIpLocationForm.getLocationNameEn(), 572044L, this.frontOperationList);
                            continue;
                        }
                        if (zoneIpLocationForm.getLocationAction() != 1 && zoneIpLocationForm.getLocationAction() != 2 && zoneIpLocationForm.getLocationAction() != 3) {
                            this.logger.info((Object)("The zoneIpLocation action is error. The action is " + zoneIpLocationForm.getLocationAction()));
                            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + zoneIpLocationForm.getLocationNameEn(), 572033L, this.frontOperationList);
                            continue;
                        }
                        if (zoneIpLocationForm.getLocationAction() == 3 && !CheckImportXml.isRange10240(String.valueOf(zoneIpLocationForm.getLocationLimit()))) {
                            this.logger.info((Object)("The zoneIpLocation limit is error. The limit is " + zoneIpLocationForm.getLocationNameEn() + ":" + zoneIpLocationForm.getLocationLimit()));
                            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + zoneIpLocationForm.getLocationNameEn(), 572034L, this.frontOperationList);
                            continue;
                        }
                        if ("OtherLocation".equalsIgnoreCase(zoneIpLocationForm.getLocationNameEn())) {
                            ++defalutNum;
                            defaultForm = new ZoneIpLocationForm();
                            defaultForm.setLocationNameEn("OtherLocation");
                            defaultForm.setLocationAction(zoneIpLocationForm.getLocationAction());
                            defaultForm.setLocationLimit(zoneIpLocationForm.getLocationLimit());
                            defaultForm.setLocationId(ImportZoneConstant.OTHER_LOCATION_ID);
                        }
                        if (null != locationMap.get(zoneIpLocationForm.getLocationNameEn())) {
                            zoneIpLocationForm.setLocationNameZh(locationMap.get(zoneIpLocationForm.getLocationNameEn()).getLocationNameZh());
                            zoneIpLocationForm.setShortName(locationMap.get(zoneIpLocationForm.getLocationNameEn()).getShortName());
                            zoneIpLocationForm.setLocationId(locationMap.get(zoneIpLocationForm.getLocationNameEn()).getLocationId());
                            ipLocationMap.put(zoneIpLocationForm.getLocationNameEn(), zoneIpLocationForm);
                            continue;
                        }
                        if ("OtherLocation".equalsIgnoreCase(zoneIpLocationForm.getLocationNameEn())) continue;
                        this.logger.info((Object)("The location of the object associated with the object is not present on the target ATIC.The locationName=" + zoneIpLocationForm.getLocationNameEn()));
                        ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + zoneIpLocationForm.getLocationNameEn(), 572019L, this.frontOperationList);
                        continue;
                    }
                    return;
                }
                if (defalutNum != 1) {
                    this.logger.info((Object)("When the position strategy is not empty, the number of the  location policies must be greater than or equal to 2, which must be a default name for the OtherLocation\u2019 position strategy" + this.zonePolicyForm.getZoneFormList().size()));
                    ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572032L, this.frontOperationList);
                    xmlPolicyForm.setZoneIpLocationList(new ArrayList<ZoneIpLocationForm>());
                }
                if (ipLocationMap.isEmpty()) {
                    xmlPolicyForm.setZoneIpLocationList(new ArrayList<ZoneIpLocationForm>());
                } else {
                    if (null != defaultForm) {
                        defaultForm.setLocationNameZh("OtherLocation");
                        defaultForm.setShortName("Other");
                        defaultForm.setLocationId(ImportZoneConstant.OTHER_LOCATION_ID);
                        tempList.add(defaultForm);
                    } else {
                        this.logger.error((Object)"defaultForm is null");
                    }
                    if (!ipLocationMap.isEmpty()) {
                        for (Map.Entry entry : ipLocationMap.entrySet()) {
                            ZoneIpLocationForm temp = (ZoneIpLocationForm)entry.getValue();
                            if (null == temp || null == temp.getLocationNameZh() || null == temp.getLocationNameEn()) continue;
                            temp.setLocationNameEn(temp.getLocationNameEn().indexOf("/") == 0 ? temp.getLocationNameEn().replaceFirst("/", "") : temp.getLocationNameEn());
                            temp.setLocationNameZh(temp.getLocationNameZh().indexOf("/") == 0 ? temp.getLocationNameZh().replaceFirst("/", "") : temp.getLocationNameZh());
                            tempList.add(temp);
                        }
                    }
                    xmlPolicyForm.setZoneIpLocationList(tempList);
                }
            } else if (!xmlPolicyForm.getZoneIpLocationList().isEmpty() && xmlPolicyForm.getZoneIpLocationList().size() < 2) {
                this.logger.info((Object)("When the position strategy is not empty, the number of the location policies must be greater than or equal to 2, which must be a default name for the \u2018OtherLocation\u2019 position strategy" + this.zonePolicyForm.getZoneFormList().size()));
                ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572032L, this.frontOperationList);
                xmlPolicyForm.setZoneIpLocationList(new ArrayList<ZoneIpLocationForm>());
            }
        }
        if (null != xmlPolicyForm.getZoneIpLocationList() && !xmlPolicyForm.getZoneIpLocationList().isEmpty()) {
            for (ZoneIpLocationForm ipLocationForm : xmlPolicyForm.getZoneIpLocationList()) {
                ipLocationForm.setZoneId(zoneInfoId);
            }
        }
        if (null != dbPolicyForm) {
            dbPolicyForm.setZoneIpLocationList(xmlPolicyForm.getZoneIpLocationList());
        }
    }

    private void importZonePolicy(ZoneInfoForm xmlInfoForm, ZonePolicyApplyForm xmlPolicyForm, ZoneInfoForm dbInfoForm) {
        long startTime = System.currentTimeMillis();
        this.logger.info((Object)("The importZonePolicy() start time is  " + startTime + "ms"));
        String servicePort = "";
        if (null != dbInfoForm) {
            if (dbInfoForm.getZoneType().equals(xmlInfoForm.getZoneType())) {
                this.undateZoneBasicInfo(dbInfoForm, xmlInfoForm);
                this.updateZonePolicy(dbInfoForm, xmlPolicyForm, servicePort);
            } else {
                this.logger.info((Object)("The same name already exists, but the protocol is different.The zone name is " + ImportZonePolicyThread.getcleanedMessage(dbInfoForm.getZoneDesc())));
                ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572035L, this.frontOperationList);
            }
        } else {
            this.createZone(xmlPolicyForm, servicePort);
        }
        this.logger.info((Object)("The importZonePolicy() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void updateZonePolicy(ZoneInfoForm dbInfoForm, ZonePolicyApplyForm xmlPolicyForm, String servicePort) {
        Long zoneInfoId = dbInfoForm.getZoneId();
        this.logger.info((Object)("importType zoneInfoId=" + zoneInfoId));
        ZonePolicyApplyForm policyApplyForm = this.zonePolicyApplyService.queryByZoneId(zoneInfoId);
        if (null != policyApplyForm) {
            if (this.zonePolicyForm.isNeedMode()) {
                if (CheckImportXml.checkDefenseMode(xmlPolicyForm, this.frontOperationList, this.importZoneData.getZoneString())) {
                    this.saveZonePolicyUpdate(policyApplyForm, xmlPolicyForm, dbInfoForm, zoneInfoId, servicePort);
                }
            } else {
                this.saveZonePolicyUpdate(policyApplyForm, xmlPolicyForm, dbInfoForm, zoneInfoId, servicePort);
            }
        }
    }

    private void undateZoneBasicInfo(ZoneInfoForm infoForm, ZoneInfoForm zoneInfoForm) {
        long startTime = System.currentTimeMillis();
        this.logger.info((Object)("The undateZone() start time is  " + startTime + "ms"));
        if (ImportZoneUtil.checkIsTaskCancled(this.importZoneData)) {
            return;
        }
        if (this.zonePolicyForm.isNeedIp()) {
            ZoneInfoForm zInfoForm = this.zoneService.getById(infoForm.getZoneId());
            List<ZoneListIpForm> zoneListIpForms = zInfoForm.getZoneListIpFormList();
            List<ZonePortMapForm> zonePortMapForms = zInfoForm.getZonePortMapFormList();
            if (null != zoneListIpForms) {
                this.zoneService.deleteListIpAndIpState(zoneListIpForms);
            }
            if (null != zonePortMapForms) {
                this.zoneService.deletePortMapAndMapState(zonePortMapForms);
            }
            infoForm.setZoneListIpFormList(zoneInfoForm.getZoneListIpFormList());
            infoForm.setZonePortMapFormList(zoneInfoForm.getZonePortMapFormList());
        }
        infoForm.setZoneDesc(zoneInfoForm.getZoneDesc());
        infoForm.setContact(zoneInfoForm.getContact());
        infoForm.setTelephone(zoneInfoForm.getTelephone());
        infoForm.setMobile(zoneInfoForm.getMobile());
        if (!AticUtil.isNull((String)zoneInfoForm.getIndustry())) {
            infoForm.setIndustry(zoneInfoForm.getIndustry());
        } else {
            infoForm.setIndustry("Gaming");
        }
        infoForm.setAddress(zoneInfoForm.getAddress());
        infoForm.setPost(zoneInfoForm.getPost());
        infoForm.setEmail(zoneInfoForm.getEmail());
        infoForm.setRemark(zoneInfoForm.getRemark());
        this.logger.info((Object)("The undateZone() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    private void createZone(ZonePolicyApplyForm xmlPolicyForm, String servicePort) {
        long startTime = System.currentTimeMillis();
        this.logger.info((Object)("The createZone() start time is " + startTime));
        if (ImportZoneUtil.checkIsTaskCancled(this.importZoneData)) {
            return;
        }
        try {
            ZoneInfoForm nZoneInfoForm = xmlPolicyForm.getZoneInfoForm();
            nZoneInfoForm.setZoneId(null);
            if (this.zonePolicyForm.isNeedMode()) {
                if (CheckImportXml.checkDefenseMode(xmlPolicyForm, this.frontOperationList, this.importZoneData.getZoneString())) {
                    this.saveZonePolicyCreate(xmlPolicyForm, nZoneInfoForm, servicePort);
                }
            } else {
                xmlPolicyForm.setDivertMode(0);
                xmlPolicyForm.setDefendMode(0);
                xmlPolicyForm.setDynamicBlackMode(0);
                this.saveZonePolicyCreate(xmlPolicyForm, nZoneInfoForm, servicePort);
            }
        }
        catch (LegoCheckedException e) {
            Locker.getInstance().setImportFlag(false);
            this.logger.info((Object)("Save zone error,zoneInfo.name = " + xmlPolicyForm.getZoneInfoForm().getZoneName() + ", LegoCheckedException,e=" + e.getMessage()));
            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), e.getErrorCode(), this.frontOperationList);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        this.logger.info((Object)("The createZone() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    private void saveZonePolicyCreate(ZonePolicyApplyForm xmlPolicyForm, ZoneInfoForm nZoneInfoForm, String servicePort) {
        long startTime = System.currentTimeMillis();
        if (ImportZoneUtil.checkIsTaskCancled(this.importZoneData)) {
            return;
        }
        IFilterService filterService = ZoneReferUtil.getFilterService();
        Object[] params = new Object[]{null, this.logger, xmlPolicyForm.getZoneInfoForm().getZoneListIpFormList(), nZoneInfoForm, this.importZoneData.getUserId(), this.logger, xmlPolicyForm.getZoneInfoForm().getZonePortMapFormList()};
        Long zoneInfoId = ZoneUtil.saveZoneInfoAndIp(params);
        ZoneUtil.saveFaultSeverityRule(zoneInfoId, xmlPolicyForm.getFaultSeverityRuleForm());
        ZoneUtil.saveFaultSeverityRule(zoneInfoId, xmlPolicyForm.getOutboundFaultSeverityRuleForm());
        String deviceIds = "";
        Map<Object, Object> zoneDevMap = new HashMap();
        if (this.zonePolicyForm.isNeedPolicy()) {
            this.parserZoneDeviceVPN(xmlPolicyForm, zoneInfoId);
            zoneDevMap = ImportZoneUtil.getZoneDeviceMap(xmlPolicyForm.getZoneDeviceForms());
        } else {
            xmlPolicyForm.setZoneDeviceForms(new ArrayList<ZoneDeviceForm>());
        }
        this.logger.info((Object)("zoneInfoForm.deviceId : " + deviceIds));
        this.parserZonePolicyLocation(xmlPolicyForm, null, zoneInfoId);
        this.parserZonePolicyBlackList(xmlPolicyForm, null, zoneInfoId);
        this.parserZonePolicyWhiteList(xmlPolicyForm, null, zoneInfoId);
        if (this.zonePolicyForm.isNeedFilter() && this.zonePolicyForm.isNeedPolicy() && null != xmlPolicyForm.getFilterNameList() && !xmlPolicyForm.getFilterNameList().isEmpty() && !xmlPolicyForm.getZoneDeviceForms().isEmpty()) {
            if (null != xmlPolicyForm.getFilterNameList() && !xmlPolicyForm.getFilterNameList().isEmpty()) {
                this.parserZoneFilter(xmlPolicyForm, filterService, true);
            }
        } else if (this.zonePolicyForm.isNeedFilter() && this.zonePolicyForm.isNeedPolicy() && xmlPolicyForm.getZoneDeviceForms().isEmpty()) {
            this.logger.info((Object)"The protection object is not associated with the device, and the associated filter is not imported.");
            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572031L, this.frontOperationList);
            xmlPolicyForm.setFilterNameList(new ArrayList<String>());
            xmlPolicyForm.setFilterIdList(new ArrayList<Long>());
        }
        if (this.zonePolicyForm.isNeedFilter() && this.zonePolicyForm.isNeedPolicy() && null != xmlPolicyForm.getOutboundFilterNameList() && !xmlPolicyForm.getOutboundFilterNameList().isEmpty() && !xmlPolicyForm.getZoneDeviceForms().isEmpty()) {
            if (null != xmlPolicyForm.getOutboundFilterNameList() && !xmlPolicyForm.getOutboundFilterNameList().isEmpty()) {
                this.parserZoneFilter(xmlPolicyForm, filterService, false);
            }
        } else if (this.zonePolicyForm.isNeedFilter() && this.zonePolicyForm.isNeedPolicy() && xmlPolicyForm.getZoneDeviceForms().isEmpty()) {
            this.logger.info((Object)"The protection object is not associated with the device, and the associated filter is not imported.");
            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572031L, this.frontOperationList);
            xmlPolicyForm.setOutboundFilterNameList(new ArrayList<String>());
            xmlPolicyForm.setOutboundFilterIdList(new ArrayList<Long>());
        }
        xmlPolicyForm.setZoneId(zoneInfoId);
        xmlPolicyForm.setZoneInfoForm(this.zoneService.getById(zoneInfoId));
        xmlPolicyForm.setAbnormalState("NORMAL");
        xmlPolicyForm.setDeployState("UNDEPLOY");
        ZoneUtil.saveZonePolicy(xmlPolicyForm);
        this.logger.info((Object)("The saveZonePolicy() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
        if (null != xmlPolicyForm.getZoneServices() && this.zonePolicyForm.isNeedPolicy() && null != xmlPolicyForm.getZoneDeviceForms() && !xmlPolicyForm.getZoneDeviceForms().isEmpty() && !AticUtil.isNull((String)xmlPolicyForm.getZoneDeviceForms().get(0).getDeviceIp())) {
            List<ZoneServiceForm> zoneServiceFormList = xmlPolicyForm.getZoneServices();
            ImportZoneUtil.removeAllSameNameService(zoneServiceFormList, this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), this.frontOperationList);
            if (null == zoneServiceFormList || zoneServiceFormList.isEmpty()) {
                return;
            }
            for (ZoneServiceForm serviceForm : zoneServiceFormList) {
                if (ImportZoneUtil.checkIsTaskCancled(this.importZoneData)) {
                    return;
                }
                ++this.totalRow;
                Integer portListLimit = 0;
                ArrayList<String> servicePort1 = new ArrayList<String>();
                ArrayList<Integer> portListLimit1 = new ArrayList<Integer>();
                servicePort1.add(servicePort);
                portListLimit1.add(portListLimit);
                servicePort = (String)servicePort1.get(0);
                portListLimit = (Integer)portListLimit1.get(0);
                serviceForm.setZoneId(zoneInfoId);
                try {
                    if (!AticUtil.isNull((String)serviceForm.getDeviceIp())) {
                        if (null != zoneDevMap.get(serviceForm.getDeviceIp())) {
                            serviceForm.setDeviceId(((ZoneDeviceForm)zoneDevMap.get(serviceForm.getDeviceIp())).getDeviceId());
                            String[] parmas = new String[]{xmlPolicyForm.getZoneInfoForm().getZoneDesc(), this.importZoneData.getPolicyString(), this.importZoneData.getZoneString()};
                            if (!CheckImportXml.checkPolicyItem(serviceForm, xmlPolicyForm.getZoneServices(), this.frontOperationList, parmas) || !"DEFAULT".equals(serviceForm.getProtocol()) && !CheckImportXml.checkServiceProtocalAndPort(serviceForm, xmlPolicyForm, this.frontOperationList, this.importZoneData.getZoneString(), this.importZoneData.getPolicyString())) continue;
                            serviceForm.setZoneId(zoneInfoId);
                            serviceForm.setDeployState(false);
                            Object[] parameters = new Object[]{this.logger, serviceForm, portListLimit, null != serviceForm.getPortList() ? serviceForm.getPortList().split(";") : new String[]{}, servicePort, null != serviceForm.getIpList() ? serviceForm.getIpList().split(";") : new String[]{}};
                            ZoneUtil.saveZoneService(parameters, this.currentUser);
                            continue;
                        }
                        ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + serviceForm.getServiceName(), 572017L, this.frontOperationList);
                        continue;
                    }
                    serviceForm.setDeployState(false);
                    Object[] parameters = new Object[]{this.logger, serviceForm, portListLimit, serviceForm.getPortList().split(";"), servicePort, serviceForm.getIpList().split(";")};
                    ZoneUtil.saveZoneService(parameters, this.currentUser);
                }
                catch (LegoCheckedException e) {
                    this.logger.info((Object)("saveZoneService error, serviceForm.name = " + ImportZonePolicyThread.getcleanedMessage(serviceForm.getServiceName()) + ", LegoCheckedException=" + ImportZonePolicyThread.getcleanedMessage(e.getMessage())));
                    ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + serviceForm.getServiceName(), e.getErrorCode(), this.frontOperationList);
                }
            }
        } else if (this.zonePolicyForm.isNeedPolicy() && xmlPolicyForm.getZoneDeviceForms().isEmpty()) {
            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572028L, this.frontOperationList);
        }
        this.logger.info((Object)("The saveZonePolicyCreate() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    private void parserZoneDeviceVPN(ZonePolicyApplyForm xmlPolicyForm, long zoneInfoId) {
        if (!this.zonePolicyForm.isNeedPolicy()) {
            return;
        }
        if (null != xmlPolicyForm.getZoneDeviceForms() && !xmlPolicyForm.getZoneDeviceForms().isEmpty()) {
            for (ZoneDeviceForm zDeviceForm : xmlPolicyForm.getZoneDeviceForms()) {
                ++this.totalRow;
                if (!AticUtil.isNull((String)zDeviceForm.getVpnName())) {
                    if (!this.checkVpnExist(zDeviceForm, xmlPolicyForm.getZoneInfoForm().getZoneDesc())) {
                        zDeviceForm.setVpnName("");
                    }
                } else {
                    zDeviceForm.setVpnName("");
                }
                zDeviceForm.setZoneId(Long.valueOf(zoneInfoId));
            }
        }
    }

    private List<Long> getDeviceIdList(ZonePolicyApplyForm policyApplyForm) {
        ArrayList<Long> deviceIdList = new ArrayList<Long>();
        if (null != policyApplyForm && null != policyApplyForm.getZoneDeviceForms() && !policyApplyForm.getZoneDeviceForms().isEmpty()) {
            for (ZoneDeviceForm zdForm : policyApplyForm.getZoneDeviceForms()) {
                deviceIdList.add(zdForm.getDeviceId());
            }
        }
        return deviceIdList;
    }

    private void parserZoneMode(ZonePolicyApplyForm policyApplyForm, ZonePolicyApplyForm appForm) {
        if (!this.zonePolicyForm.isNeedMode()) {
            return;
        }
        policyApplyForm.setDivertMode(appForm.getDivertMode());
        policyApplyForm.setDefendMode(appForm.getDefendMode());
        policyApplyForm.setDynamicBlackMode(appForm.getDynamicBlackMode());
        policyApplyForm.setZoneLimitEnable(appForm.getZoneLimitEnable());
        policyApplyForm.setZoneLimitRate(appForm.getZoneLimitRate());
        policyApplyForm.setIpLimitEnable(appForm.getIpLimitEnable());
        policyApplyForm.setIpLimit(appForm.getIpLimit());
        policyApplyForm.setBtwEnable(appForm.getBtwEnable());
        policyApplyForm.setCncEnable(appForm.getCncEnable());
        policyApplyForm.setWebEnable(appForm.getWebEnable());
        policyApplyForm.setDosEnable(appForm.getDosEnable());
        policyApplyForm.setAuditEnable(appForm.getAuditEnable());
        policyApplyForm.setIpReputationEnable(appForm.getIpReputationEnable());
        policyApplyForm.setIpReputationAlarmThreshold(appForm.getIpReputationAlarmThreshold());
        policyApplyForm.setNewDestSessionLimitEnable(appForm.getNewDestSessionLimitEnable());
        policyApplyForm.setDestSessionLimit(appForm.getDestSessionLimit());
        policyApplyForm.setFilterDropThreshold(appForm.getFilterDropThreshold());
        policyApplyForm.setGlobalFilterEnable(appForm.getGlobalFilterEnable());
        policyApplyForm.setBlackholeEnable(appForm.getBlackholeEnable());
        policyApplyForm.setBlackholeType(appForm.getBlackholeType());
        policyApplyForm.setBlackholeThreshold(appForm.getBlackholeThreshold());
        policyApplyForm.setBlackholeMode(appForm.getBlackholeMode());
        policyApplyForm.setBlackholeNotifyEnable(appForm.getBlackholeNotifyEnable());
        policyApplyForm.setOutBoundFilterDropThreshold(appForm.getOutBoundFilterDropThreshold());
        policyApplyForm.setOutBoundFilterAction(appForm.getOutBoundFilterAction());
        policyApplyForm.setOutBoundFilterLimit(appForm.getOutBoundFilterLimit());
        policyApplyForm.setOutBoundNextHop(appForm.getOutBoundNextHop());
    }

    private void parserZoneFilter(ZonePolicyApplyForm policyApplyForm, ZonePolicyApplyForm appForm) {
        IFilterService filterService = ZoneReferUtil.getFilterService();
        if (this.zonePolicyForm.isNeedFilter() && this.zonePolicyForm.isNeedPolicy() && null != appForm.getFilterNameList() && !appForm.getFilterNameList().isEmpty() && !policyApplyForm.getZoneDeviceForms().isEmpty()) {
            if (null != appForm.getFilterNameList() && !appForm.getFilterNameList().isEmpty()) {
                this.parserZoneFilter(appForm, filterService, true);
            }
            policyApplyForm.setFilterPreferenceList(appForm.getFilterPreferenceList());
            policyApplyForm.setFilterIdList(appForm.getFilterIdList());
            policyApplyForm.setFilterNameList(appForm.getFilterNameList());
        }
        if (this.zonePolicyForm.isNeedFilter() && this.zonePolicyForm.isNeedPolicy() && null != appForm.getOutboundFilterNameList() && !appForm.getOutboundFilterNameList().isEmpty() && !policyApplyForm.getZoneDeviceForms().isEmpty()) {
            if (null != appForm.getOutboundFilterNameList() && !appForm.getOutboundFilterNameList().isEmpty()) {
                this.parserZoneFilter(appForm, filterService, false);
            }
            policyApplyForm.setOutboundFilterPreferenceList(appForm.getOutboundFilterPreferenceList());
            policyApplyForm.setOutboundFilterIdList(appForm.getOutboundFilterIdList());
            policyApplyForm.setOutboundFilterNameList(appForm.getOutboundFilterNameList());
        } else if (this.zonePolicyForm.isNeedFilter() && this.zonePolicyForm.isNeedPolicy() && policyApplyForm.getZoneDeviceForms().isEmpty()) {
            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + appForm.getZoneInfoForm().getZoneDesc(), 572031L, this.frontOperationList);
        }
    }

    private void saveZoneService(ZonePolicyApplyForm dbPolicyForm, ZonePolicyApplyForm xmlPolicyForm, long zoneInfoId, String servicePort) {
        List<Long> deviceIdList = this.getDeviceIdList(dbPolicyForm);
        Map<String, AticDevice> dbZoneDeviceMap = this.getZoneDeviceMap(dbPolicyForm);
        if (this.zonePolicyForm.isNeedPolicy() && null != dbPolicyForm.getZoneDeviceForms() && !dbPolicyForm.getZoneDeviceForms().isEmpty()) {
            List<ZoneServiceForm> dbZoneServiceList = this.zoneServiceService.queryZoneServicesByZoneId(dbPolicyForm.getZoneId(), deviceIdList);
            HashMap<String, ZoneServiceForm> dbZoneServiceMap = new HashMap<String, ZoneServiceForm>();
            if (null != dbZoneServiceList && !dbZoneServiceList.isEmpty()) {
                for (ZoneServiceForm serviceForm : dbZoneServiceList) {
                    dbZoneServiceMap.put(serviceForm.getServiceName() + "/" + serviceForm.getDeviceId(), serviceForm);
                }
            }
            if (null != xmlPolicyForm.getZoneServices() && !xmlPolicyForm.getZoneServices().isEmpty()) {
                List<ZoneServiceForm> xmlZoneServiceFormList = xmlPolicyForm.getZoneServices();
                ImportZoneUtil.removeAllSameNameService(xmlZoneServiceFormList, this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), this.frontOperationList);
                if (null == xmlZoneServiceFormList || xmlZoneServiceFormList.isEmpty()) {
                    return;
                }
                for (ZoneServiceForm xmlServiceForm : xmlZoneServiceFormList) {
                    if (ImportZoneUtil.checkIsTaskCancled(this.importZoneData)) {
                        return;
                    }
                    if (!this.validatePolicyBasicInfo(xmlServiceForm, xmlPolicyForm, ImportZoneConstant.getProtocoList())) continue;
                    ++this.totalRow;
                    try {
                        xmlServiceForm.setZoneId(zoneInfoId);
                        if ("DEFAULT".equals(xmlServiceForm.getProtocol()) && null == dbZoneDeviceMap.get(xmlServiceForm.getDeviceIp())) {
                            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + xmlServiceForm.getServiceName(), 572017L, this.frontOperationList);
                            continue;
                        }
                        if (!CheckImportXml.checkServiceProtocalAndPort(xmlServiceForm, xmlPolicyForm, this.frontOperationList, this.importZoneData.getZoneString(), this.importZoneData.getPolicyString())) continue;
                        ZonePolicyParamsBean zonePolicyParamsBean = new ZonePolicyParamsBean();
                        zonePolicyParamsBean.setDbZoneServiceMap(dbZoneServiceMap);
                        zonePolicyParamsBean.setXmlServiceForm(xmlServiceForm);
                        zonePolicyParamsBean.setXmlPolicyForm(xmlPolicyForm);
                        zonePolicyParamsBean.setServicePort(servicePort);
                        zonePolicyParamsBean.setZoneInfoId(zoneInfoId);
                        zonePolicyParamsBean.setDbZoneDeviceMap(dbZoneDeviceMap);
                        this.updateZonePolicySaveService(zonePolicyParamsBean);
                    }
                    catch (LegoCheckedException e) {}
                }
            }
        } else if (this.zonePolicyForm.isNeedPolicy() && null != dbPolicyForm.getZoneDeviceForms() && dbPolicyForm.getZoneDeviceForms().isEmpty()) {
            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572028L, this.frontOperationList);
        }
    }

    private void parserZoneDevice(ZonePolicyApplyForm dbPolicyForm, ZonePolicyApplyForm xmlPolicyForm) {
        List<ZoneDeviceForm> xmlZoneDeviceList;
        List<ZoneDeviceForm> dbZoneDeviceList = dbPolicyForm.getZoneDeviceForms();
        if (dbZoneDeviceList == null) {
            dbZoneDeviceList = new ArrayList<ZoneDeviceForm>();
        }
        if (null != (xmlZoneDeviceList = xmlPolicyForm.getZoneDeviceForms())) {
            for (ZoneDeviceForm xmlForm : xmlZoneDeviceList) {
                boolean isExisted = false;
                for (ZoneDeviceForm dbForm : dbZoneDeviceList) {
                    if (!dbForm.getDeviceIp().equals(xmlForm.getDeviceIp())) continue;
                    isExisted = true;
                    break;
                }
                if (isExisted) continue;
                dbZoneDeviceList.add(xmlForm);
            }
        }
    }

    private void saveZonePolicyUpdate(ZonePolicyApplyForm dbPolicyForm, ZonePolicyApplyForm xmlPolicyForm, ZoneInfoForm dbInfoForm, long zoneInfoId, String servicePort) {
        long startTime = System.currentTimeMillis();
        this.logger.info((Object)("The saveZonePolicyUpdate() start time is " + startTime));
        if (ImportZoneUtil.checkIsTaskCancled(this.importZoneData)) {
            return;
        }
        this.parserZoneDevice(dbPolicyForm, xmlPolicyForm);
        this.parserZoneDeviceVPN(xmlPolicyForm, zoneInfoId);
        this.parserZoneMode(dbPolicyForm, xmlPolicyForm);
        this.parserZoneFilter(dbPolicyForm, xmlPolicyForm);
        this.parserZonePolicyLocation(xmlPolicyForm, dbPolicyForm, zoneInfoId);
        this.parserZonePolicyBlackList(xmlPolicyForm, dbPolicyForm, zoneInfoId);
        this.parserZonePolicyWhiteList(xmlPolicyForm, dbPolicyForm, zoneInfoId);
        try {
            Object[] params = new Object[]{dbInfoForm.getZoneId(), this.logger, dbInfoForm.getZoneListIpFormList(), dbInfoForm, this.importZoneData.getUserId(), this.logger, dbInfoForm.getZonePortMapFormList()};
            ZoneUtil.saveZoneInfoAndIp(params);
            ZoneUtil.saveFaultSeverityRule(zoneInfoId, xmlPolicyForm.getFaultSeverityRuleForm());
            ZoneUtil.saveFaultSeverityRule(zoneInfoId, xmlPolicyForm.getOutboundFaultSeverityRuleForm());
            if (this.zonePolicyForm.isNeedFilter() || this.zonePolicyForm.isNeedLocation() || this.zonePolicyForm.isNeedMode() || this.zonePolicyForm.isNeedPolicy() || this.zonePolicyForm.isNeedBlackPolicy() || this.zonePolicyForm.isNeedWhitePolicy()) {
                ZoneUtil.saveZonePolicy(dbPolicyForm);
                this.logger.info((Object)("The saveZonePolicy() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
            }
        }
        catch (LegoCheckedException e) {
            Locker.getInstance().setImportFlag(false);
            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), e.getErrorCode(), this.frontOperationList);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        this.saveZoneService(dbPolicyForm, xmlPolicyForm, zoneInfoId, servicePort);
        this.logger.info((Object)("The saveZonePolicyUpdate() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    private void parserZonePolicyWhiteList(ZonePolicyApplyForm xmlPolicyForm, ZonePolicyApplyForm dbPolicyForm, long zoneInfoId) {
        if (!this.zonePolicyForm.isNeedWhitePolicy()) {
            return;
        }
        if (this.zonePolicyForm.isNeedWhitePolicy() && this.zonePolicyForm.isNeedPolicy() && null != xmlPolicyForm.getZoneWhiteFormList() && !xmlPolicyForm.getZoneWhiteFormList().isEmpty()) {
            int dbSize;
            List<ZoneWhiteForm> zoneWhiteFormList = xmlPolicyForm.getZoneWhiteFormList();
            int importSize = zoneWhiteFormList.size();
            if (importSize + (dbSize = this.blackWhiteListService.getTotalBlackWhiteListsByZoneId(zoneInfoId)) > 1000) {
                ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 631080L, this.frontOperationList);
                return;
            }
            ArrayList<ZoneBlackWhiteForm> zoneBlackWhiteFormList = new ArrayList<ZoneBlackWhiteForm>();
            String zoneStringAndZoneDesc = this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc();
            for (ZoneWhiteForm zoneWhiteForm : zoneWhiteFormList) {
                ZoneBlackWhiteForm zoneBlackWhiteForm = new ZoneBlackWhiteForm();
                VsmUtil.getInstance().copyProperties(zoneWhiteForm, zoneBlackWhiteForm);
                zoneBlackWhiteFormList.add(zoneBlackWhiteForm);
            }
            this.blackWhiteListService.importSaveBlackWhiteList(zoneBlackWhiteFormList, this.frontOperationList, zoneStringAndZoneDesc, zoneInfoId);
            if (null != dbPolicyForm) {
                dbPolicyForm.setZoneWhiteFormList(xmlPolicyForm.getZoneWhiteFormList());
            }
        }
    }

    private void parserZonePolicyBlackList(ZonePolicyApplyForm xmlPolicyForm, ZonePolicyApplyForm dbPolicyForm, long zoneInfoId) {
        if (!this.zonePolicyForm.isNeedBlackPolicy()) {
            return;
        }
        if (this.zonePolicyForm.isNeedBlackPolicy() && this.zonePolicyForm.isNeedPolicy() && null != xmlPolicyForm.getZoneBlackWhiteFormList() && !xmlPolicyForm.getZoneBlackWhiteFormList().isEmpty()) {
            int dbSize;
            List<ZoneBlackWhiteForm> zoneBlackWhiteFormList = xmlPolicyForm.getZoneBlackWhiteFormList();
            String zoneStringAndZoneDesc = this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc();
            int importSize = zoneBlackWhiteFormList.size();
            if (importSize + (dbSize = this.blackWhiteListService.getTotalBlackWhiteListsByZoneId(zoneInfoId)) > 1000) {
                ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 631080L, this.frontOperationList);
                return;
            }
            this.blackWhiteListService.importSaveBlackWhiteList(zoneBlackWhiteFormList, this.frontOperationList, zoneStringAndZoneDesc, zoneInfoId);
            if (null != dbPolicyForm) {
                dbPolicyForm.setZoneBlackWhiteFormList(xmlPolicyForm.getZoneBlackWhiteFormList());
            }
        }
    }

    private void parserZoneFilter(ZonePolicyApplyForm xmlPolicyForm, IFilterService filterService, boolean isInbound) {
        Long inboundPreferrenceDefault = ImportZoneConstant.FILTER_PREFERENCE_DEFAULT;
        Long outboundPreferrenceDefault = ImportZoneConstant.OUTBOUND_FILTER_PREFERENCE_DEFAULT;
        ArrayList<Long> filterIdList = new ArrayList<Long>();
        ArrayList<Long> filterPreferenceList = new ArrayList<Long>();
        ArrayList<String> temNameList = new ArrayList<String>();
        List<String> filterNameList = null;
        filterNameList = isInbound ? xmlPolicyForm.getFilterNameList() : xmlPolicyForm.getOutboundFilterNameList();
        for (String filterName : filterNameList) {
            ++this.totalRow;
            if (AticUtil.isNull((String)filterName)) continue;
            FilterForm filterForm = filterService.queryByName(filterName);
            if (null != filterForm) {
                filterForm.setFilterId(filterForm.getFilterId());
                if (isInbound) {
                    filterPreferenceList.add(inboundPreferrenceDefault);
                    inboundPreferrenceDefault = inboundPreferrenceDefault + ImportZoneConstant.FILTER_PREFERENCE_DEFAULT;
                } else {
                    filterPreferenceList.add(outboundPreferrenceDefault);
                    outboundPreferrenceDefault = outboundPreferrenceDefault + ImportZoneConstant.OUTBOUND_FILTER_PREFERENCE;
                }
                temNameList.add(filterForm.getFilterName());
                filterIdList.add(filterForm.getPkid());
                continue;
            }
            this.logger.info((Object)("The filter object associated with the protection object is not present on the ATIC.The filter name = " + filterName));
            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneName() + "/" + filterName, 572018L, this.frontOperationList);
        }
        if (isInbound) {
            xmlPolicyForm.setFilterPreferenceList(filterPreferenceList);
            xmlPolicyForm.setFilterIdList(filterIdList);
            xmlPolicyForm.setFilterNameList(temNameList);
        } else {
            xmlPolicyForm.setOutboundFilterPreferenceList(filterPreferenceList);
            xmlPolicyForm.setOutboundFilterIdList(filterIdList);
            xmlPolicyForm.setOutboundFilterNameList(temNameList);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateZonePolicySaveService(ZonePolicyParamsBean zonePolicyParamsBean) {
        dbZoneServiceMap = zonePolicyParamsBean.getDbZoneServiceMap();
        xmlServiceForm = zonePolicyParamsBean.getXmlServiceForm();
        xmlPolicyForm = zonePolicyParamsBean.getXmlPolicyForm();
        servicePort = zonePolicyParamsBean.getServicePort();
        zoneInfoId = zonePolicyParamsBean.getZoneInfoId();
        dbZoneDeviceMap = zonePolicyParamsBean.getDbZoneDeviceMap();
        startTime = System.currentTimeMillis();
        portListLimit = 0;
        this.logger.info((Object)("The updateZonePolicySaveService() start time is " + startTime));
        if (!AticUtil.isNull((String)xmlServiceForm.getDeviceIp())) {
            aticDevice = dbZoneDeviceMap.get(xmlServiceForm.getDeviceIp());
            if (null != aticDevice) {
                xmlServiceForm.setDeviceId(aticDevice.getMoId());
                xmlServiceForm.setDeviceName(aticDevice.getName());
                dbZoneServiceForm = dbZoneServiceMap.get(xmlServiceForm.getServiceName() + "/" + xmlServiceForm.getDeviceId());
                try {
                    if (null != dbZoneServiceForm) {
                        params = new String[]{xmlPolicyForm.getZoneInfoForm().getZoneDesc(), this.importZoneData.getPolicyString(), this.importZoneData.getZoneString()};
                        if (!CheckImportXml.checkPolicyItem(xmlServiceForm, xmlPolicyForm.getZoneServices(), this.frontOperationList, params)) ** GOTO lbl110
                        dbZoneServiceForm.setDeviceId(xmlServiceForm.getDeviceId());
                        dbZoneServiceForm.setDeviceName(xmlServiceForm.getDeviceName());
                        dbZoneServiceForm.setProtocol(xmlServiceForm.getProtocol());
                        dbZoneServiceForm.setPortType(xmlServiceForm.getPortType());
                        dbZoneServiceForm.setProtocolNum(xmlServiceForm.getProtocolNum());
                        dbZoneServiceForm.setIpList(xmlServiceForm.getIpList());
                        dbZoneServiceForm.setPortList(xmlServiceForm.getPortList());
                        dbZoneServiceForm.setDescription(xmlServiceForm.getDescription());
                        tcpTemPolicyForm = xmlServiceForm.getTcpDefendPolicyForm();
                        if (null != tcpTemPolicyForm) {
                            if (null != dbZoneServiceForm.getTcpDefendPolicyForm()) {
                                tcpTemPolicyForm.setId(dbZoneServiceForm.getTcpDefendPolicyForm().getId());
                                tcpTemPolicyForm.setServiceId(dbZoneServiceForm.getTcpDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setTcpDefendPolicyForm(tcpTemPolicyForm);
                        }
                        if (null != (udpTempForm = xmlServiceForm.getUdpDefendPolicyForm())) {
                            if (null != dbZoneServiceForm.getUdpDefendPolicyForm()) {
                                udpTempForm.setId(dbZoneServiceForm.getUdpDefendPolicyForm().getId());
                                udpTempForm.setServiceId(dbZoneServiceForm.getUdpDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setUdpDefendPolicyForm(udpTempForm);
                        }
                        if (null != (icmTempForm = xmlServiceForm.getIcmpDefendPolicyForm())) {
                            if (null != dbZoneServiceForm.getIcmpDefendPolicyForm()) {
                                icmTempForm.setId(dbZoneServiceForm.getIcmpDefendPolicyForm().getId());
                                icmTempForm.setServiceId(dbZoneServiceForm.getIcmpDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setIcmpDefendPolicyForm(icmTempForm);
                        }
                        if (null != (httpTempForm = xmlServiceForm.getHttpDefendPolicyForm())) {
                            if (null != dbZoneServiceForm.getHttpDefendPolicyForm()) {
                                httpTempForm.setId(dbZoneServiceForm.getHttpDefendPolicyForm().getId());
                                httpTempForm.setServiceId(dbZoneServiceForm.getHttpDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setHttpDefendPolicyForm(httpTempForm);
                        }
                        if (null != (dnsTemPolicyForm = xmlServiceForm.getDnsDefendPolicyForm())) {
                            if (null != dbZoneServiceForm.getDnsDefendPolicyForm()) {
                                dnsTemPolicyForm.setId(dbZoneServiceForm.getDnsDefendPolicyForm().getId());
                                dnsTemPolicyForm.setServiceId(dbZoneServiceForm.getDnsDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setDnsDefendPolicyForm(dnsTemPolicyForm);
                        }
                        if (null != (httpsTemPolicyForm = xmlServiceForm.getHttpsDefendPolicyForm())) {
                            if (null != dbZoneServiceForm.getHttpsDefendPolicyForm()) {
                                httpsTemPolicyForm.setId(dbZoneServiceForm.getHttpsDefendPolicyForm().getId());
                                httpsTemPolicyForm.setServiceId(dbZoneServiceForm.getHttpsDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setHttpsDefendPolicyForm(httpsTemPolicyForm);
                        }
                        if (null != (sipTemPolicyForm = xmlServiceForm.getSipDefendPolicyForm())) {
                            if (null != dbZoneServiceForm.getSipDefendPolicyForm()) {
                                sipTemPolicyForm.setId(dbZoneServiceForm.getSipDefendPolicyForm().getId());
                                sipTemPolicyForm.setServiceId(dbZoneServiceForm.getSipDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setSipDefendPolicyForm(sipTemPolicyForm);
                        }
                        if (null != (otPolicyForm = xmlServiceForm.getOtherDefendPolicyForm())) {
                            if (null != dbZoneServiceForm.getOtherDefendPolicyForm()) {
                                otPolicyForm.setId(dbZoneServiceForm.getOtherDefendPolicyForm().getId());
                                otPolicyForm.setServiceId(dbZoneServiceForm.getOtherDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setOtherDefendPolicyForm(otPolicyForm);
                        }
                        if (null != (topNStudyForm = xmlServiceForm.getTopNStudyForm())) {
                            if (null != dbZoneServiceForm.getTopNStudyForm()) {
                                topNStudyForm.setId(dbZoneServiceForm.getTopNStudyForm().getId());
                                topNStudyForm.setServiceId(dbZoneServiceForm.getTopNStudyForm().getServiceId());
                            }
                            dbZoneServiceForm.setTopNStudyForm(topNStudyForm);
                        }
                        servicePort1 = new ArrayList<String>();
                        portListLimit1 = new ArrayList<Integer>();
                        servicePort1.add(servicePort);
                        portListLimit1.add(portListLimit);
                        servicePort = (String)servicePort1.get(0);
                        portListLimit = (Integer)portListLimit1.get(0);
                        dbZoneServiceForm.setDeployState(false);
                        parameters = new Object[]{this.logger, dbZoneServiceForm, portListLimit, dbZoneServiceForm.getPortList().split(";"), servicePort, dbZoneServiceForm.getIpList().split(";")};
                        ZoneUtil.saveZoneService(parameters, this.currentUser);
                    }
                    xmlServiceForm.setZoneId(zoneInfoId);
                    servicePort1 = new ArrayList<String>();
                    portListLimit1 = new ArrayList<Integer>();
                    servicePort1.add(servicePort);
                    portListLimit1.add(portListLimit);
                    xmlServiceForm.setDeployState(false);
                    params = new String[]{xmlPolicyForm.getZoneInfoForm().getZoneDesc(), this.importZoneData.getPolicyString(), this.importZoneData.getZoneString()};
                    if (!CheckImportXml.checkPolicyItem(xmlServiceForm, xmlPolicyForm.getZoneServices(), this.frontOperationList, params)) ** GOTO lbl110
                    checkProtocalAndPort = true;
                    if (!"DEFAULT".equals(xmlServiceForm.getProtocol()) && !CheckImportXml.checkServiceProtocalAndPort(xmlServiceForm, xmlPolicyForm, this.frontOperationList, this.importZoneData.getZoneString(), this.importZoneData.getPolicyString())) {
                        checkProtocalAndPort = false;
                    }
                    if (!checkProtocalAndPort) ** GOTO lbl110
                    parameters = new Object[]{this.logger, xmlServiceForm, portListLimit1.get(0), xmlServiceForm.getPortList().split(";"), servicePort1.get(0), xmlServiceForm.getIpList().split(";")};
                    ZoneUtil.saveZoneService(parameters, this.currentUser);
                }
                catch (LegoCheckedException e) {
                    Locker.getInstance().setImportFlag(false);
                    serviceName = "";
                    serviceName = null == dbZoneServiceForm ? xmlServiceForm.getServiceName() : dbZoneServiceForm.getServiceName();
                    ImportZoneUtil.recordErrorMessg(xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + serviceName, e.getErrorCode(), this.frontOperationList);
                    throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
                }
            } else {
                ImportZoneUtil.recordErrorMessg(xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + xmlServiceForm.getServiceName(), 572017L, this.frontOperationList);
            }
        }
lbl110:
        // 8 sources

        this.logger.info((Object)("The updateZonePolicySaveService() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    private BatchOperationResult parserImportOperationResult() {
        if (this.importZoneData.isRestful()) {
            return new BatchOperationResult();
        }
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        if (null != this.frontOperationList && !this.frontOperationList.isEmpty()) {
            for (BatchOperation batchOperation : this.frontOperationList) {
                batchOpList.add(batchOperation);
            }
        }
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        batchOperationResult.setResult(batchOpList);
        batchOperationResult.setFailCount(batchOpList.size());
        batchOperationResult.setTotalCount(this.totalRow);
        batchOperationResult.setSucceedCount(this.totalRow - batchOpList.size());
        StringBuffer sb = new StringBuffer();
        if ("zone".equals(this.importType)) {
            Object zoneNames;
            if (null != this.importFailedZoneNameList && !this.importFailedZoneNameList.isEmpty()) {
                for (String zoneName : this.importFailedZoneNameList) {
                    sb = sb.append(zoneName + ",");
                }
                zoneNames = sb.toString();
                if (((String)zoneNames).endsWith(",")) {
                    zoneNames = ((String)zoneNames).substring(0, ((String)zoneNames).length() - 1);
                }
                this.processOpeLog((String)zoneNames, false);
            } else if (null != this.frontOperationList && !this.frontOperationList.isEmpty()) {
                this.processOpeLog(sb.toString(), false);
            } else {
                for (ZonePolicyApplyForm zApplyForm : this.zonePolicyForm.getZoneFormList()) {
                    sb = sb.append(zApplyForm.getZoneInfoForm().getZoneDesc() + ",");
                }
                zoneNames = sb.toString();
                if (((String)zoneNames).endsWith(",")) {
                    zoneNames = ((String)zoneNames).substring(0, ((String)zoneNames).length() - 1);
                }
                this.processOpeLog((String)zoneNames, true);
            }
        }
        if ("device".equals(this.importType)) {
            if (!this.importZoneByDeviceIsSucess) {
                this.processOpeLog(this.zonePolicyForm.getDeviceIp(), false);
            } else if (null != this.importFailedZoneNameList && !this.importFailedZoneNameList.isEmpty()) {
                for (String zoneName : this.importFailedZoneNameList) {
                    sb = sb.append(zoneName + ",");
                }
                this.processOpeLog(sb.toString(), false);
            } else if (null != this.frontOperationList && !this.frontOperationList.isEmpty()) {
                this.processOpeLog(sb.toString(), false);
            } else {
                this.processOpeLog(this.zonePolicyForm.getDeviceIp(), true);
            }
        }
        return batchOperationResult;
    }

    private Map<String, AticDevice> getZoneDeviceMap(ZonePolicyApplyForm policyApplyForm) {
        HashMap<String, AticDevice> zoneDevMap = new HashMap<String, AticDevice>();
        if (null != policyApplyForm && null != policyApplyForm.getZoneDeviceForms()) {
            for (ZoneDeviceForm zoneDeviceForm : policyApplyForm.getZoneDeviceForms()) {
                AticDevice aticDevice = this.aticDeviceService.getDeviceByIp(zoneDeviceForm.getDeviceIp());
                if (null == aticDevice) continue;
                zoneDevMap.put(aticDevice.getIpAddress(), aticDevice);
            }
        }
        return zoneDevMap;
    }

    private boolean checkDeviceExist(ZoneDeviceForm zDeviceForm, String zoneName) {
        if (!this.zonePolicyForm.isNeedPolicy()) {
            return false;
        }
        if (AticUtil.isNull((String)zDeviceForm.getDeviceIp())) {
            this.logger.info((Object)("Devices associated with the object are not present on the target ATIC.The deviceIp=" + zDeviceForm.getDeviceIp()));
            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + zoneName, 572040L, this.frontOperationList);
            return false;
        }
        if (IPUtil.isIpv4((String)zDeviceForm.getDeviceIp())) {
            AticDevice aticDevice = this.aticDeviceService.getDeviceByIp(zDeviceForm.getDeviceIp());
            if (null != aticDevice) {
                zDeviceForm.setDeviceId(Long.valueOf(aticDevice.getMoId()));
            }
            if (null == aticDevice) {
                this.logger.info((Object)("Devices associated with the object are not present on the target ATIC.The deviceIp=" + zDeviceForm.getDeviceIp()));
                ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + zoneName + "/" + zDeviceForm.getDeviceIp(), 572006L, this.frontOperationList);
                return false;
            }
        } else {
            this.logger.info((Object)("Device IP format error..The deviceIp=" + zDeviceForm.getDeviceIp()));
            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + zoneName + "/" + zDeviceForm.getDeviceIp(), 572041L, this.frontOperationList);
            return false;
        }
        return true;
    }

    private boolean validateServiceName(ZoneServiceForm serviceForm) {
        String serviceName;
        if (null == serviceForm.getServiceName() || serviceForm.getServiceName().isEmpty()) {
            return false;
        }
        if (!serviceForm.getServiceName().matches("^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}\\w*$") && !"DEFAULT".equals(serviceForm.getProtocol())) {
            return false;
        }
        return !"DEFAULT".equals(serviceForm.getProtocol()) || (serviceName = serviceForm.getServiceName().replace(".", "")).matches("^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}\\w*$");
    }

    private boolean validatePolicyBasicInfo(ZoneServiceForm serviceForm, ZonePolicyApplyForm appForm, List<String> protocoList) {
        String zoneName = appForm.getZoneInfoForm().getZoneDesc();
        if (!this.validateServiceName(serviceForm)) {
            this.logger.info((Object)"import filter  failed, the error  is : name is wrong");
            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + zoneName + "/" + serviceForm.getServiceName(), 572037L, this.frontOperationList);
            return false;
        }
        if ("DEFAULT".equals(serviceForm.getProtocol())) {
            if (!(AticUtil.isNull((String)serviceForm.getDescription()) && AticUtil.isNull((String)serviceForm.getPortList()) && AticUtil.isNull((String)serviceForm.getIpList()))) {
                ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + zoneName + "/" + serviceForm.getServiceName() + "/" + serviceForm.getDescription() + " ;portList: " + serviceForm.getPortList() + " ;ipList: " + serviceForm.getIpList(), 572043L, this.frontOperationList);
                return false;
            }
            serviceForm.setDescription("");
            serviceForm.setPortList("");
            serviceForm.setIpList("");
        } else if (!(Integer.valueOf("0").equals(serviceForm.getPortType()) || Integer.valueOf("1").equals(serviceForm.getPortType()) || Integer.valueOf("2").equals(serviceForm.getPortType()))) {
            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + zoneName + "/" + serviceForm.getServiceName() + "/" + serviceForm.getPortType(), 733034L, this.frontOperationList);
            return false;
        }
        if (null != serviceForm.getDescription() && !serviceForm.getDescription().matches("^[\\w|\\-|\\!|\\@|\\#|\\$|\\^|\\.|\\+|\\}|\\ |\\{]{0,64}$")) {
            this.logger.info((Object)"import filter  failed, the error  is : Description is wrong");
            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + zoneName + "/" + serviceForm.getServiceName() + "/" + serviceForm.getDescription(), 572038L, this.frontOperationList);
            return false;
        }
        if (!protocoList.contains(serviceForm.getProtocol())) {
            this.logger.info((Object)"import filter  failed, the error  is : Protocol is wrong");
            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + zoneName + "/" + serviceForm.getServiceName() + "/" + serviceForm.getProtocol(), 572039L, this.frontOperationList);
            return false;
        }
        if (!AticUtil.isNull((String)serviceForm.getDeviceIp())) {
            if (!IPUtil.isIpv4((String)serviceForm.getDeviceIp())) {
                this.logger.info((Object)"import filter  failed, the error  is : deviceIp is wrong");
                ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + zoneName + "/" + serviceForm.getServiceName() + "/" + serviceForm.getDeviceIp(), 572041L, this.frontOperationList);
                return false;
            }
        } else {
            this.logger.info((Object)"import filter  failed, the error  is : deviceIp is null");
            ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + zoneName + "/" + serviceForm.getServiceName(), 572040L, this.frontOperationList);
            return false;
        }
        if (!AticUtil.isNull((String)serviceForm.getIpList())) {
            String[] ipAddrs;
            for (String ipAddr : ipAddrs = serviceForm.getIpList().split(";")) {
                if (IPUtil.isIpv4((String)ipAddr) || IPUtil.isIpv6((String)ipAddr)) continue;
                this.logger.info((Object)"import filter  failed, the error  is : ipList is wrong");
                ImportZoneUtil.recordErrorMessg(this.importZoneData.getZoneString() + zoneName + "/" + serviceForm.getServiceName() + "/" + ipAddr, 572010L, this.frontOperationList);
                return false;
            }
        }
        return true;
    }

    private void processOpeLog(String target, boolean isSuccess) {
        ISysOptLog sysOptLogMgr = ZoneReferUtil.getSysOptLog();
        SysOptLog sysOptLogLego = new SysOptLog();
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.normal.getValue());
        sysOptLogLego.setModule(this.importZoneData.getSysTargetString());
        sysOptLogLego.setOperation(this.importZoneData.getImportTargetString());
        sysOptLogLego.setOperator(this.importZoneData.getOperator());
        if (!ZoneUtil.isNull(target) && target.length() > 255) {
            try {
                target = ZoneUtil.substring(target, 252, "UTF-8") + "...";
            }
            catch (UnsupportedEncodingException e1) {
                this.logger.info((Object)e1);
            }
        }
        if (!ZoneUtil.isNull(target)) {
            sysOptLogLego.setTarget(target);
        } else {
            sysOptLogLego.setTarget("--");
        }
        sysOptLogLego.setResult(isSuccess ? 1 : 0);
        sysOptLogLego.setDetail(isSuccess ? this.importZoneData.getImportResultSucess() : this.importZoneData.getImportResultFailed());
        sysOptLogLego.setTerminalIp(this.importZoneData.getRemoteAddr());
        sysOptLogMgr.writeOptLog(sysOptLogLego);
    }

    private void initProgressBarByZone() {
        int totalStep = 0;
        if (null != this.zonePolicyForm.getZoneFormList() && !this.zonePolicyForm.getZoneFormList().isEmpty()) {
            totalStep += this.zonePolicyForm.getZoneFormList().size() + 1;
        }
        this.logger.info((Object)("importZone totalStep:=" + totalStep));
        this.totalRow = ++totalStep;
        this.progressState = ProgressManage.getInstance().createProgress(totalStep, this.importZoneData.getProgressBarId());
        this.logger.info((Object)("Progress bar for import policy creation.The Progress is " + this.progressState));
    }

    public boolean isIsEnd() {
        return this.isEnd;
    }

    public void setEnd(boolean isEndStr) {
        this.isEnd = isEndStr;
    }

    public ImportZoneData getImportZoneData() {
        return this.importZoneData;
    }

    public void setImportZoneData(ImportZoneData importZoneData) {
        this.importZoneData = importZoneData;
    }
}

