/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;

public class ViewAllFilterAction
extends BaseAction {
    private static final long serialVersionUID = 9053433705664301713L;
    IZoneMgrNorthSerice zoneMgrNorthSerice;
    private IFilterService filterService;
    private IZoneDeviceService zoneDeviceService;
    private IAticDeviceService aticDeviceService;
    private List<FilterForm> filterFormList;
    private String deleteFilterIds;
    private String deleteFilterNames;
    private String filterId;
    private String filterName;
    private Long zoneId;

    public String viewAllFilterTemplate() {
        if (!this.isValidFilerName(this.filterName)) {
            return null;
        }
        this.filterFormList = new ArrayList<FilterForm>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != this.filterName && !this.filterName.isEmpty()) {
            map.put("filterName", this.filterName.trim());
        }
        Paging page = this.filterService.queryByPage(map, this.start, this.pageSize);
        this.filterFormList = page.getData();
        this.total = page.getCount();
        return "success";
    }

    private boolean isValidFilerName(String value) {
        if (null == value || value.isEmpty()) {
            return true;
        }
        return value.matches("^[a-zA-Z0-9_]{1,63}$");
    }

    public String viewAllFilterForZone() {
        this.filterFormList = new ArrayList<FilterForm>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != this.filterName && !this.filterName.isEmpty()) {
            map.put("filterName", this.filterName.trim());
        }
        Paging page = this.filterService.queryByPage(map, 0, Integer.MAX_VALUE);
        List<FilterForm> tempFitlerFormList = page.getData();
        tempFitlerFormList = this.getFilterListByDeviceType(tempFitlerFormList);
        if (null != this.filterId && !this.filterId.isEmpty()) {
            String[] filterIds = this.filterId.split(",");
            for (int i = 0; tempFitlerFormList.size() > i; ++i) {
                boolean isExist = false;
                for (int j = 0; filterIds.length > j; ++j) {
                    if (!String.valueOf(tempFitlerFormList.get(i).getPkid()).equals(filterIds[j])) continue;
                    isExist = true;
                }
                if (isExist) continue;
                this.filterFormList.add(tempFitlerFormList.get(i));
            }
        } else {
            this.filterFormList = tempFitlerFormList;
        }
        this.total = this.filterFormList.size();
        int last = this.filterFormList.size() > this.start + this.pageSize ? this.start + this.pageSize : this.filterFormList.size();
        this.filterFormList = this.filterFormList.subList(this.start, last);
        return "success";
    }

    public String viewAllOutboundFilterForZone() {
        this.filterFormList = new ArrayList<FilterForm>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != this.filterName && !this.filterName.isEmpty()) {
            map.put("filterName", this.filterName.trim());
        }
        Paging page = this.filterService.queryByPage(map, 0, Integer.MAX_VALUE);
        List<FilterForm> tempFitlerFormList = page.getData();
        tempFitlerFormList = this.getFilterListByDeviceType(tempFitlerFormList);
        if (null != this.filterId && !this.filterId.isEmpty()) {
            String[] filterIds = this.filterId.split(",");
            for (int i = 0; tempFitlerFormList.size() > i; ++i) {
                boolean isExist = false;
                for (int j = 0; filterIds.length > j; ++j) {
                    if (!String.valueOf(tempFitlerFormList.get(i).getPkid()).equals(filterIds[j])) continue;
                    isExist = true;
                }
                if (isExist) continue;
                this.filterFormList.add(tempFitlerFormList.get(i));
            }
        } else {
            this.filterFormList = tempFitlerFormList;
        }
        this.total = this.filterFormList.size();
        int last = this.filterFormList.size() > this.start + this.pageSize ? this.start + this.pageSize : this.filterFormList.size();
        this.filterFormList = this.filterFormList.subList(this.start, last);
        return "success";
    }

    private List<FilterForm> getFilterListByDeviceType(List<FilterForm> filterList) {
        ArrayList<FilterForm> fList = new ArrayList<FilterForm>();
        List deviceIdList = this.zoneDeviceService.getDeviceIdsByZoneId(this.zoneId);
        boolean ddos = false;
        boolean nfa = false;
        for (Long deviceId : deviceIdList) {
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
            if (null != aticDevice && (aticDevice.getDeviceType() == 5 || aticDevice.getDeviceType() == 7)) {
                nfa = true;
                continue;
            }
            ddos = true;
        }
        for (FilterForm filterForm : filterList) {
            if (filterForm.getDeviceType().equals("All") && (ddos || nfa)) {
                fList.add(filterForm);
                continue;
            }
            if (filterForm.getDeviceType().equals("AntiDDoS") && (ddos || !nfa)) {
                fList.add(filterForm);
                continue;
            }
            if (!filterForm.getDeviceType().equals("NFA") || !nfa && ddos) continue;
            fList.add(filterForm);
        }
        return fList;
    }

    public void isBindDevice() {
        if (null == this.zoneId || null == this.zoneDeviceService) {
            this.responseResult("failure");
            return;
        }
        List deviceIdList = this.zoneDeviceService.getDeviceIdsByZoneId(this.zoneId);
        if (null == deviceIdList || deviceIdList.isEmpty()) {
            this.responseResult("failure");
            return;
        }
        this.responseResult("success");
    }

    public void deleteFilter() {
        ArrayList<BatchOperation> batchOperation = new ArrayList<BatchOperation>();
        String[] deleteFilterIdList = this.deleteFilterIds.split(",");
        String[] deleteFilterNameList = this.deleteFilterNames.split(",");
        this.getOperateLog().warning("com.hs.vsm.secservice.ddos.policy.operation.name.delete.filter", "lego.dic.module.ddosApp");
        ArrayList<Long> deleteFilterIdsList = new ArrayList<Long>();
        for (String filterID : deleteFilterIdList) {
            deleteFilterIdsList.add(Long.valueOf(filterID));
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        Long adminId = currentUser.getUserID();
        this.zoneMgrNorthSerice.doUnDeployWithFilter(deleteFilterIdsList, null, null, adminId);
        for (int i = 0; deleteFilterIdList.length > i; ++i) {
            FilterForm filterForm = (FilterForm)this.filterService.query(Long.valueOf(deleteFilterIdList[i]));
            BatchOperation bo = new BatchOperation();
            bo.setTargetId(Long.parseLong(deleteFilterIdList[i]));
            bo.setTargetName(deleteFilterNameList[i]);
            bo.setOptDetail("com.hs.vsm.secservice.ddos.policy.operation.name.delete.filter.success");
            bo.setDetailParam(new String[]{filterForm.getFilterName()});
            batchOperation.add(bo);
        }
        this.batchOperationResult = this.filterService.deleteInBatch(batchOperation);
        this.bathResult(this.batchOperationResult);
    }

    public List<FilterForm> getFilterFormList() {
        return this.filterFormList;
    }

    public void setFilterFormList(List<FilterForm> filterFormList) {
        this.filterFormList = filterFormList;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public String getDeleteFilterIds() {
        return this.deleteFilterIds;
    }

    public void setDeleteFilterIds(String deleteFilterIds) {
        this.deleteFilterIds = deleteFilterIds;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public void setFilterId(String filterId) {
        this.filterId = filterId;
    }

    public String getDeleteFilterNames() {
        return this.deleteFilterNames;
    }

    public void setDeleteFilterNames(String deleteFilterNames) {
        this.deleteFilterNames = deleteFilterNames;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public IFilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(IFilterService filterService) {
        this.filterService = filterService;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IZoneMgrNorthSerice getZoneMgrNorthSerice() {
        return this.zoneMgrNorthSerice;
    }

    public void setZoneMgrNorthSerice(IZoneMgrNorthSerice zoneMgrNorthSerice) {
        this.zoneMgrNorthSerice = zoneMgrNorthSerice;
    }

    public boolean validateFilterId() {
        if ("".equals(this.filterId) || null == this.filterId) {
            return true;
        }
        String ids = this.filterId;
        String[] arrayIds = ids.split(",");
        for (int i = 0; i < arrayIds.length; ++i) {
            long id = 0L;
            try {
                id = Long.parseLong(arrayIds[i]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (id >= 1L) continue;
            return false;
        }
        return true;
    }

    public boolean validatePageSize() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String pageSize = request.getParameter("pageSize");
        if (null == pageSize) {
            return true;
        }
        String regex = "^(10|20|30|50|100)$";
        return pageSize.matches(regex);
    }

    public boolean validateFilterName() {
        if (null == this.filterName || "".equals(this.filterName)) {
            return true;
        }
        if (this.filterName.trim().equalsIgnoreCase("null")) {
            return false;
        }
        String regex = "^(?!\\s*null$)[\\w*]{1,63}$";
        return this.filterName.matches(regex);
    }

    public boolean validateDeleteFilterIds() {
        if (null != this.deleteFilterIds && this.deleteFilterIds.length() == 0) {
            return false;
        }
        if (null == this.deleteFilterIds) {
            return true;
        }
        String[] ids = this.deleteFilterIds.split(",");
        for (int i = 0; i < ids.length; ++i) {
            long id = 0L;
            try {
                id = Long.parseLong(ids[i]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (id >= 1L) continue;
            return false;
        }
        return true;
    }

    public boolean validateDeleteFilterNames() {
        if (null != this.deleteFilterNames && this.deleteFilterNames.length() == 0) {
            return false;
        }
        if (null == this.deleteFilterNames) {
            return true;
        }
        String[] filterNames = this.deleteFilterNames.split(",");
        for (int i = 0; i < filterNames.length; ++i) {
            if (null == filterNames[i] || "".equals(filterNames[i])) {
                return false;
            }
            if (filterNames[i].trim().equalsIgnoreCase("null")) {
                return false;
            }
            String regex = "^(?!\\s*null$)[\\w*]{1,63}$";
            if (filterNames[i].matches(regex)) continue;
            return false;
        }
        return true;
    }
}

