/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceDeployStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneModifyDetailForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyMgrService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class ViewAllZonePolicyAction
extends BaseAction {
    private static final long serialVersionUID = 7874071547671146007L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private String language;
    private String zoneName;
    private String zoneIp;
    private String zoneDeployState;
    private String zoneAbnormalState;
    private String zoneDeployStateValue;
    private String zoneDefendStateValue;
    private String viewAdvanceSearch;
    private Long zoneId;
    private List<LangPair> deployStateList;
    private List<LangPair> defendStateList;
    private List<LangPair> zoneTypeList;
    private String zoneType;
    private String zoneTypeValue;
    private List<LangPair> divertStateList;
    private String divertState;
    private String divertStateValue;
    private List<LangPair> baselineStateList;
    private String baselineState;
    private String baselineStateValue;
    private List<LangPair> serviceStateList;
    private String serviceState;
    private String serviceStateValue;
    private String zoneDdosPolicySel = "";
    private String selectedZoneIds;
    private String languageType;
    private Boolean isNip;
    private boolean isAdmin;
    private List<ZonePolicyApplyForm> zoneDdosPolicy;
    private List<ZoneDeviceDeployStatusForm> deployFailedDataList;
    private List<ZoneModifyDetailForm> zoneModifyDetailFormList;
    private IZonePolicyApplyService zonePolicyApplyService;
    private IAticDeviceService aticDeviceService;
    private boolean supportOutbound = false;

    public static String encode(String text) {
        if (!text.isEmpty()) {
            text = text.replace("&", "&amp;");
            text = text.replace("<", "&lt;");
            text = text.replace(">", "&gt;");
            text = text.replace("\"", "&quot;");
            text = text.replace("'", "&#39;");
            text = text.replace("(", "&#40;");
            text = text.replace(")", "&#41;");
        }
        return text;
    }

    public String quickStart() {
        this.language = ActionContext.getContext().getLocale().getLanguage();
        this.logger.info((Object)"quickStart is execute");
        return "success";
    }

    public String viewAllZonePolicy() {
        this.logger.info((Object)"viewAllZonePolicy is execute");
        ILicenseOutboundService licenseOutboundService = ZoneBisUtil.getLicenseOutboundService();
        this.supportOutbound = licenseOutboundService.isSupportOutbound();
        this.initDefendStateList();
        this.initDeployStateList();
        this.initZoneTypeList();
        this.initServiceStateList();
        this.initBaselineStateList();
        this.initDivertStateList();
        if (StringUtils.isEmpty((CharSequence)this.getViewAdvanceSearch())) {
            this.setViewAdvanceSearch("display:none");
        }
        if (!"display:block".equals(this.getViewAdvanceSearch())) {
            this.setViewAdvanceSearch("display:none");
        }
        this.setViewAdvanceSearch(ViewAllZonePolicyAction.encode(this.getViewAdvanceSearch()));
        this.zoneDdosPolicy = this.getZonePolicys();
        if (null != this.getSelectedZoneIds() && !"".equals(this.getSelectedZoneIds())) {
            this.initZoneDdosPolicySel(this.getSelectedZoneIds());
        }
        User user = (User)this.getSession().getAttribute("currentUser");
        this.isAdmin = Boolean.valueOf(user.getIsAdmin());
        return "success";
    }

    private void initZoneDdosPolicySel(String selectedIds) {
        this.zoneDdosPolicySel = ",";
        String[] zoneIds = selectedIds.split(";");
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        for (String zoneID : zoneIds) {
            zoneIdList.add(Long.valueOf(zoneID));
        }
        int gridIndex = 0;
        if (null != this.zoneDdosPolicy && !this.zoneDdosPolicy.isEmpty()) {
            for (ZonePolicyApplyForm policyApplyForm : this.zoneDdosPolicy) {
                if ("PART_SUCCESS".equals(policyApplyForm.getDeployState())) {
                    Long moId = ZoneBisUtil.getMoidByZoneid(policyApplyForm.getZoneId());
                    ArrayList<Long> moIdList = new ArrayList<Long>();
                    moIdList.add(moId);
                    BisUtil.checkUserSecurity(moIdList);
                    if (zoneIdList.contains(policyApplyForm.getZoneId())) {
                        this.zoneDdosPolicySel = this.zoneDdosPolicySel + gridIndex + ",";
                    }
                }
                ++gridIndex;
            }
        }
    }

    public void lockZoneTry() {
        Long zoneID = this.getZoneId();
        ArrayList<Long> zoneIdsList = new ArrayList<Long>();
        IZonePolicyMgrService policyMgrService = ZoneReferUtil.getZonePolicyMgrService();
        zoneIdsList.add(zoneID);
        policyMgrService.lockZones(zoneIdsList, "editPolicy");
    }

    public List<ZonePolicyApplyForm> getZonePolicys() {
        this.logger.info((Object)"getZonePolicys is execute");
        Map<String, String> queryMap = this.getConditions();
        Paging result = this.zonePolicyApplyService.queryByPage(queryMap, this.start, this.pageSize);
        List zonePolicys = result.getData();
        this.total = result.getCount();
        if (null != zonePolicys && !zonePolicys.isEmpty()) {
            this.logger.info((Object)"getZonePolicys method query device before");
            this.logger.info((Object)"getZonePolicys method query device end");
            User user = (User)this.getSession().getAttribute("currentUser");
            this.isAdmin = Boolean.valueOf(user.getIsAdmin());
            List deviceList = this.aticDeviceService.getAllDevice(user.getUserID(), this.isAdmin);
            for (ZonePolicyApplyForm form : zonePolicys) {
                List<ZoneDeviceForm> zoneDevices = form.getZoneDeviceForms();
                List<AticDevice> aticDeviceList = this.getAticDevice(zoneDevices, deviceList);
                this.fillInDescription(form, aticDeviceList);
            }
        }
        this.getSession().setAttribute("pageSize", (Object)this.pageSize);
        this.getSession().setAttribute("start", (Object)this.start);
        return zonePolicys;
    }

    private List<AticDevice> getAticDevice(List<ZoneDeviceForm> zoneDevices, List<AticDevice> deviceList) {
        ArrayList<AticDevice> aticDeviceList = new ArrayList<AticDevice>();
        for (ZoneDeviceForm zoneDeviceForm : zoneDevices) {
            for (AticDevice device : deviceList) {
                if (device.getMoId() != zoneDeviceForm.getDeviceId().longValue()) continue;
                aticDeviceList.add(device);
            }
        }
        return aticDeviceList;
    }

    private void fillInDescription(ZonePolicyApplyForm form, List<AticDevice> aticDeviceList) {
        StringBuffer deviceNameBuffer = new StringBuffer();
        for (AticDevice aticDevice : aticDeviceList) {
            if (null == aticDevice) continue;
            String deviceName = aticDevice.getName();
            deviceNameBuffer.append(deviceName + ";");
        }
        if (deviceNameBuffer.toString().endsWith(";")) {
            deviceNameBuffer.deleteCharAt(deviceNameBuffer.lastIndexOf(";"));
        }
        form.setDeviceNames(deviceNameBuffer.toString());
    }

    private Map<String, String> getConditions() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (this.zoneName != null && !"".equals(this.zoneName)) {
            queryMap.put("zoneName", this.zoneName.trim());
        }
        if (this.zoneType != null && !"".equals(this.zoneType)) {
            if (!"ALL".equals(this.zoneType)) {
                queryMap.put("zoneType", this.zoneType);
            }
        } else {
            this.setZoneTypeValue(this.getText("atic.public.query.all"));
            this.setZoneType("ALL");
        }
        if (this.zoneIp != null && !"".equals(this.zoneIp)) {
            queryMap.put("zoneIp", this.zoneIp.trim());
        }
        if (this.zoneDeployState != null && !"".equals(this.zoneDeployState)) {
            if (!"ALL".equals(this.zoneDeployState)) {
                queryMap.put("zoneDeployState", this.zoneDeployState);
            }
        } else {
            this.setZoneDeployStateValue(this.getText("com.hs.vsm.secservice.ddos.policy.allstate"));
            this.setZoneDeployState("ALL");
        }
        if (this.divertState != null && !"".equals(this.divertState)) {
            if (!"ALL".equals(this.divertState)) {
                queryMap.put("divertState", this.divertState);
            }
        } else {
            this.setDivertStateValue(this.getText("atic.public.query.all"));
            this.setDivertState("ALL");
        }
        if (this.zoneAbnormalState != null && !"".equals(this.zoneAbnormalState)) {
            if (!"ALL".equals(this.zoneAbnormalState)) {
                queryMap.put("zoneAbnormalState", this.zoneAbnormalState);
            }
        } else {
            this.setZoneDefendStateValue(this.getText("com.hs.vsm.secservice.ddos.policy.allstate"));
            this.setZoneAbnormalState("ALL");
        }
        if (this.baselineState != null && !"".equals(this.baselineState)) {
            if (!"ALL".equals(this.baselineState)) {
                queryMap.put("baselineState", this.baselineState);
            }
        } else {
            this.setBaselineStateValue(this.getText("atic.public.query.all"));
            this.setBaselineState("ALL");
        }
        if (this.serviceState != null && !"".equals(this.serviceState)) {
            if (!"ALL".equals(this.serviceState)) {
                queryMap.put("serviceState", this.serviceState);
            }
        } else {
            this.setServiceStateValue(this.getText("atic.public.query.all"));
            this.setServiceState("ALL");
        }
        User user = (User)this.getSession().getAttribute("currentUser");
        queryMap.put("adminId", String.valueOf(user.getUserID()));
        queryMap.put("isAdmin", user.getIsAdmin());
        return queryMap;
    }

    private void initDeployStateList() {
        this.deployStateList = new ArrayList<LangPair>();
        LangPair com0 = new LangPair("ALL", this.getText("com.hs.vsm.secservice.ddos.policy.allstate"));
        LangPair com1 = new LangPair("UNDEPLOY", this.getText("com.hs.vsm.secservice.ddos.policy.undeployed"));
        LangPair com4 = new LangPair("INCREAMENT_UNDEPLOY", this.getText("com.hs.vsm.secservice.ddos.policy.increament.undeployed"));
        LangPair com2 = new LangPair("SUCCESS", this.getText("com.hs.vsm.secservice.ddos.policy.deployed"));
        LangPair com3 = new LangPair("PART_SUCCESS", this.getText("com.hs.vsm.secservice.ddos.policy.deployed.failed"));
        this.deployStateList.add(com0);
        this.deployStateList.add(com1);
        this.deployStateList.add(com4);
        this.deployStateList.add(com2);
        this.deployStateList.add(com3);
    }

    private void initDefendStateList() {
        this.defendStateList = new ArrayList<LangPair>();
        LangPair com0 = new LangPair("ALL", this.getText("com.hs.vsm.secservice.ddos.policy.allstate"));
        LangPair com1 = new LangPair("NORMAL", this.getText("com.hs.vsm.secservice.ddos.policy.normal"));
        LangPair com2 = new LangPair("ALERTED", this.getText("com.hs.vsm.secservice.ddos.policy.abnormal"));
        LangPair com3 = new LangPair("ATTACKED", this.getText("com.hs.vsm.secservice.ddos.policy.attacked"));
        this.defendStateList.add(com0);
        this.defendStateList.add(com1);
        this.defendStateList.add(com2);
        this.defendStateList.add(com3);
    }

    private void initZoneTypeList() {
        this.zoneTypeList = new ArrayList<LangPair>();
        LangPair com0 = new LangPair("ALL", this.getText("atic.public.query.all"));
        LangPair com1 = new LangPair("1", this.getText("atic.user.type.default"));
        LangPair com2 = new LangPair("2", this.getText("atic.user.type.custome"));
        this.zoneTypeList.add(com0);
        this.zoneTypeList.add(com1);
        this.zoneTypeList.add(com2);
    }

    private void initServiceStateList() {
        this.serviceStateList = new ArrayList<LangPair>();
        LangPair com0 = new LangPair("ALL", this.getText("atic.public.query.all"));
        LangPair com1 = new LangPair("0", this.getText("com.hs.vsm.secservice.ddos.policy.nolearn"));
        LangPair com2 = new LangPair("1", this.getText("com.hs.vsm.secservice.ddos.policy.onlearn"));
        this.serviceStateList.add(com0);
        this.serviceStateList.add(com1);
        this.serviceStateList.add(com2);
    }

    private void initBaselineStateList() {
        this.baselineStateList = new ArrayList<LangPair>();
        LangPair com0 = new LangPair("ALL", this.getText("atic.public.query.all"));
        LangPair com1 = new LangPair("0", this.getText("com.hs.vsm.secservice.ddos.policy.nolearn"));
        LangPair com2 = new LangPair("1", this.getText("com.hs.vsm.secservice.ddos.policy.onlearn"));
        this.baselineStateList.add(com0);
        this.baselineStateList.add(com1);
        this.baselineStateList.add(com2);
    }

    private void initDivertStateList() {
        this.divertStateList = new ArrayList<LangPair>();
        LangPair com0 = new LangPair("ALL", this.getText("atic.public.query.all"));
        LangPair com1 = new LangPair("0", this.getText("com.hs.vsm.secservice.ddos.policy.divert.undivert"));
        LangPair com2 = new LangPair("1", this.getText("com.hs.vsm.secservice.ddos.policy.divert.ondivert"));
        LangPair com3 = new LangPair("2", this.getText("com.hs.vsm.secservice.ddos.policy.divert.part.ondivert"));
        LangPair com4 = new LangPair("3", this.getText("com.hs.vsm.secservice.ddos.policy.divert.manualdivert"));
        this.divertStateList.add(com0);
        this.divertStateList.add(com1);
        this.divertStateList.add(com2);
        this.divertStateList.add(com3);
        this.divertStateList.add(com4);
    }

    public String viewDeployFailedReason() {
        this.logger.info((Object)"viewDeployFailedReason is execute");
        Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        List<ZoneDeviceDeployStatusForm> deployForms = ZoneReferUtil.getDeviceDeployAllStatus(this.getZoneId());
        ArrayList<ZoneDeviceDeployStatusForm> deployFailedForms = new ArrayList<ZoneDeviceDeployStatusForm>(deployForms.size());
        for (ZoneDeviceDeployStatusForm form : deployForms) {
            if (form.getDeployState().booleanValue() && form.getErrorMsgKey().trim().length() <= 2) continue;
            deployFailedForms.add(form);
        }
        this.deployFailedDataList = new ArrayList<ZoneDeviceDeployStatusForm>();
        List deviceForms = ZoneReferUtil.getZoneDeviceService().queryZoneDeviceFormsByZoneID(this.getZoneId());
        if (null == deviceForms || deviceForms.isEmpty()) {
            return "success";
        }
        if (!deployFailedForms.isEmpty()) {
            for (ZoneDeviceDeployStatusForm zoneDeviceDeployStatusForm : deployFailedForms) {
                Long deviceId;
                String errorParam = zoneDeviceDeployStatusForm.getErrorParam();
                String errorKey = zoneDeviceDeployStatusForm.getErrorMsgKey();
                if (null != errorParam && ("".equals(errorKey) || "--".equals(errorKey)) || null == (deviceId = zoneDeviceDeployStatusForm.getDeviceId())) continue;
                AticDevice securityNE = ZoneReferUtil.getDevice(zoneDeviceDeployStatusForm.getDeviceId());
                if (securityNE.getDeviceType() == 1) {
                    zoneDeviceDeployStatusForm.setDeviceName(securityNE.getName());
                    if (null != errorParam && null != errorKey) {
                        if (!(errorKey.toLowerCase(Locale.ENGLISH).contains("lego.err.") || "".equals(errorParam) || "--".equals(errorParam))) {
                            zoneDeviceDeployStatusForm.setErrorMsgKey(zoneDeviceDeployStatusForm.getErrorMsgKey() + "[" + zoneDeviceDeployStatusForm.getErrorParam() + "]");
                        } else {
                            zoneDeviceDeployStatusForm.setErrorMsgKey(this.getText(zoneDeviceDeployStatusForm.getErrorMsgKey()).replaceFirst("\\$0", errorParam));
                        }
                    }
                    this.deployFailedDataList.add(zoneDeviceDeployStatusForm);
                }
                if (securityNE.getDeviceType() != 5 && securityNE.getDeviceType() != 7) continue;
                zoneDeviceDeployStatusForm.setDeviceName(securityNE.getName());
                if (null != errorParam && null != zoneDeviceDeployStatusForm.getErrorMsgKey()) {
                    zoneDeviceDeployStatusForm.setErrorMsgKey(this.getText(zoneDeviceDeployStatusForm.getErrorMsgKey()).replaceFirst("\\$0", errorParam));
                }
                this.deployFailedDataList.add(zoneDeviceDeployStatusForm);
            }
        }
        return "success";
    }

    public String viewModifyDetail() {
        Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        this.zoneModifyDetailFormList = ZoneReferUtil.getZonePolicyService().getZoneModifyDetail(this.zoneId);
        if (null != this.zoneModifyDetailFormList) {
            for (ZoneModifyDetailForm zoneModifyDetailForm : this.zoneModifyDetailFormList) {
                if (zoneModifyDetailForm.getModifyDetail().equals("") || this.getText(zoneModifyDetailForm.getModifyDetail()).indexOf("$0") == -1) continue;
                zoneModifyDetailForm.setModifyDetail(this.getText(zoneModifyDetailForm.getModifyDetail()).replaceFirst("\\$0", zoneModifyDetailForm.getModifyObjName()));
            }
        }
        return "success";
    }

    public String configPrep() {
        this.languageType = ActionContext.getContext().getLocale().getLanguage();
        return "success";
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public List<ZonePolicyApplyForm> getZoneDdosPolicy() {
        return this.zoneDdosPolicy;
    }

    public void setZoneDdosPolicy(List<ZonePolicyApplyForm> zoneDdosPolicy) {
        this.zoneDdosPolicy = zoneDdosPolicy;
    }

    public List<LangPair> getDeployStateList() {
        return this.deployStateList;
    }

    public void setDeployStateList(List<LangPair> deployStateList) {
        this.deployStateList = deployStateList;
    }

    public List<LangPair> getDefendStateList() {
        return this.defendStateList;
    }

    public void setDefendStateList(List<LangPair> defendStateList) {
        this.defendStateList = defendStateList;
    }

    public String getZoneDeployState() {
        return this.zoneDeployState;
    }

    public void setZoneDeployState(String zoneDeployState) {
        this.zoneDeployState = zoneDeployState;
    }

    public String getZoneDeployStateValue() {
        return this.zoneDeployStateValue;
    }

    public void setZoneDeployStateValue(String zoneDeployStateValue) {
        this.zoneDeployStateValue = zoneDeployStateValue;
    }

    public String getZoneDefendStateValue() {
        return this.zoneDefendStateValue;
    }

    public void setZoneDefendStateValue(String zoneDefendStateValue) {
        this.zoneDefendStateValue = zoneDefendStateValue;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setDeployFailedDataList(List<ZoneDeviceDeployStatusForm> deployFailedDataList) {
        this.deployFailedDataList = deployFailedDataList;
    }

    public List<ZoneDeviceDeployStatusForm> getDeployFailedDataList() {
        return this.deployFailedDataList;
    }

    public String getViewAdvanceSearch() {
        return this.viewAdvanceSearch;
    }

    public void setViewAdvanceSearch(String viewAdvanceSearch) {
        this.viewAdvanceSearch = viewAdvanceSearch;
    }

    public String getZoneAbnormalState() {
        return this.zoneAbnormalState;
    }

    public void setZoneAbnormalState(String zoneAbnormalState) {
        this.zoneAbnormalState = zoneAbnormalState;
    }

    public String getZoneDdosPolicySel() {
        return this.zoneDdosPolicySel;
    }

    public void setZoneDdosPolicySel(String zoneDdosPolicySel) {
        this.zoneDdosPolicySel = zoneDdosPolicySel;
    }

    public String getSelectedZoneIds() {
        return this.selectedZoneIds;
    }

    public void setSelectedZoneIds(String selectedZoneIds) {
        this.selectedZoneIds = selectedZoneIds;
    }

    public Boolean getIsNip() {
        return this.isNip;
    }

    public void setIsNip(Boolean isNip) {
        this.isNip = isNip;
    }

    public String getLanguageType() {
        return this.languageType;
    }

    public void setLanguageType(String languageType) {
        this.languageType = languageType;
    }

    public List<ZoneModifyDetailForm> getZoneModifyDetailFormList() {
        return this.zoneModifyDetailFormList;
    }

    public void setZoneModifyDetailFormList(List<ZoneModifyDetailForm> zoneModifyDetailFormList) {
        this.zoneModifyDetailFormList = zoneModifyDetailFormList;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<LangPair> getZoneTypeList() {
        return this.zoneTypeList;
    }

    public void setZoneTypeList(List<LangPair> zoneTypeList) {
        this.zoneTypeList = zoneTypeList;
    }

    public List<LangPair> getDivertStateList() {
        return this.divertStateList;
    }

    public void setDivertStateList(List<LangPair> divertStateList) {
        this.divertStateList = divertStateList;
    }

    public List<LangPair> getBaselineStateList() {
        return this.baselineStateList;
    }

    public void setBaselineStateList(List<LangPair> baselineStateList) {
        this.baselineStateList = baselineStateList;
    }

    public List<LangPair> getServiceStateList() {
        return this.serviceStateList;
    }

    public void setServiceStateList(List<LangPair> serviceStateList) {
        this.serviceStateList = serviceStateList;
    }

    public String getZoneType() {
        return this.zoneType;
    }

    public void setZoneType(String zoneType) {
        this.zoneType = zoneType;
    }

    public String getZoneTypeValue() {
        return this.zoneTypeValue;
    }

    public void setZoneTypeValue(String zoneTypeValue) {
        this.zoneTypeValue = zoneTypeValue;
    }

    public String getDivertState() {
        return this.divertState;
    }

    public void setDivertState(String divertState) {
        this.divertState = divertState;
    }

    public String getDivertStateValue() {
        return this.divertStateValue;
    }

    public void setDivertStateValue(String divertStateValue) {
        this.divertStateValue = divertStateValue;
    }

    public String getBaselineState() {
        return this.baselineState;
    }

    public void setBaselineState(String baselineState) {
        this.baselineState = baselineState;
    }

    public String getBaselineStateValue() {
        return this.baselineStateValue;
    }

    public void setBaselineStateValue(String baselineStateValue) {
        this.baselineStateValue = baselineStateValue;
    }

    public String getServiceState() {
        return this.serviceState;
    }

    public void setServiceState(String serviceState) {
        this.serviceState = serviceState;
    }

    public String getServiceStateValue() {
        return this.serviceStateValue;
    }

    public void setServiceStateValue(String serviceStateValue) {
        this.serviceStateValue = serviceStateValue;
    }

    public String getZoneIp() {
        return this.zoneIp;
    }

    public void setZoneIp(String zoneIp) {
        this.zoneIp = zoneIp;
    }

    public boolean isIsAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean isAdminBool) {
        this.isAdmin = isAdminBool;
    }

    public boolean getSupportOutbound() {
        return this.supportOutbound;
    }

    public void setSupportOutbound(boolean supportOutbound) {
        this.supportOutbound = supportOutbound;
    }

    public boolean validateZoneIp() {
        return IPUtil.isIpv4((String)this.zoneIp) || IPUtil.isIpv6((String)this.zoneIp);
    }

    public boolean validateRefreshTimeValue() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String timeValue = request.getParameter("refreshTimeValue");
        if ("".equals(timeValue) || null == timeValue) {
            return true;
        }
        String regex = "^(0|1|2|3)$";
        boolean flag = timeValue.matches(regex);
        return flag;
    }

    public boolean validateZoneName() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String name = request.getParameter("zoneName");
        if ("".equals(name) || null == name) {
            return true;
        }
        String regex = "^(?!(?i)null$)[\\w|\u4e00-\u9fa5|\\-|!|@|#|$|\\^|\\.|\\+|\\}|\\{]*$";
        boolean flag = name.matches(regex);
        return flag && name.length() >= 1 && name.length() <= 31;
    }

    public boolean validateZoneType() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String type = request.getParameter("zoneType");
        if ("".equals(type) || null == type) {
            return true;
        }
        String regex = "^(ALL|1|2|3)$";
        boolean flag = type.matches(regex);
        return flag;
    }

    public boolean validateViewAdvanceSearch() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String search = request.getParameter("viewAdvanceSearch");
        if ("".equals(search) || null == search) {
            return true;
        }
        String regex = "^(display:none|display:block)$";
        boolean flag = search.matches(regex);
        return flag;
    }

    public boolean validateIp() {
        boolean flag;
        HttpServletRequest request = ServletActionContext.getRequest();
        String ip = request.getParameter("zoneIp");
        if ("".equals(ip) || null == ip) {
            return true;
        }
        boolean bl = flag = IPUtil.isIpv4((String)ip) || IPUtil.isIpv6((String)ip);
        return flag;
    }

    public boolean validateZoneDeployState() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String state = request.getParameter("zoneDeployState");
        if ("".equals(state) || null == state) {
            return true;
        }
        String regex = "^(ALL|INCREAMENT_UNDEPLOY|PART_SUCCESS|SUCCESS|UNDEPLOY)$";
        boolean flag = state.matches(regex);
        return flag;
    }

    public boolean validateDivertState() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String state = request.getParameter("divertState");
        if ("".equals(state) || null == state) {
            return true;
        }
        String regex = "^(ALL|0|1|2|3)$";
        boolean flag = state.matches(regex);
        return flag;
    }

    public boolean validateBaselineState() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String baseline = request.getParameter("baselineState");
        if ("".equals(baseline) || null == baseline) {
            return true;
        }
        String regex = "^(ALL|0|1)$";
        boolean flag = baseline.matches(regex);
        return flag;
    }

    public boolean validateServiceState() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String state = request.getParameter("serviceState");
        if ("".equals(state) || null == state) {
            return true;
        }
        String regex = "^(ALL|0|1)$";
        boolean flag = state.matches(regex);
        return flag;
    }

    public boolean validateZoneAbnormalState() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String state = request.getParameter("zoneAbnormalState");
        if ("".equals(state) || null == state) {
            return true;
        }
        String regex = "^(ALL|ALERTED|ATTACKED|NORMAL|--)$";
        boolean flag = state.matches(regex);
        return flag;
    }

    public boolean validatePageSize() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String page = request.getParameter("pageSize");
        if ("".equals(page) || null == page) {
            return true;
        }
        String regex = "^(10|20|30|50|100)$";
        boolean flag = page.matches(regex);
        return flag;
    }

    public IZonePolicyApplyService getZonePolicyApplyService() {
        return this.zonePolicyApplyService;
    }

    public void setZonePolicyApplyService(IZonePolicyApplyService zonePolicyApplyService) {
        this.zonePolicyApplyService = zonePolicyApplyService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }
}

