/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class ViewAllZoneServiceAction
extends BaseAction {
    private static final long serialVersionUID = 2632006970511518318L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private String zoneId;
    private List<LangPair> protocolTypeList;
    private String queryProtocolType;
    private String queryProtocolTypeName;
    private String queryServiceName;
    private String queryPortType;
    private String queryPortTypeName;
    private List<LangPair> portTypeList;
    private String strViewPage;
    private boolean viewPage;
    private Boolean isSigDeviceOnly;
    private List<ZoneServiceForm> zoneServices;

    public String viewAllZoneServices() {
        logger.info((Object)"viewAllZoneServices is execute");
        IAticDeviceService mgr = ZoneReferUtil.getFirewallService();
        if (null == this.zoneId) {
            throw new LegoCheckedException(630110L);
        }
        this.zoneId = this.zoneId.split(",")[0];
        this.initProtocolTypsList();
        this.initPortTypsList();
        Map<String, String> conditions = this.getConditions(false);
        IZoneServiceService rmi = ZoneReferUtil.getZoneServiceService();
        Paging result = rmi.queryByPage(conditions, this.start, this.pageSize);
        this.zoneServices = result.getData();
        this.total = result.getCount();
        ArrayList<ZoneServiceForm> deleteServices = new ArrayList<ZoneServiceForm>();
        User user = (User)this.getSession().getAttribute("currentUser");
        Boolean isAdmin = Boolean.valueOf(user.getIsAdmin());
        IAticDeviceService aticDeviceService = ZoneReferUtil.getFirewallService();
        List deviceList = aticDeviceService.getAllDevice(user.getUserID(), isAdmin.booleanValue());
        HashSet<Long> deviceSet = new HashSet<Long>();
        for (AticDevice item : deviceList) {
            deviceSet.add(item.getMoId());
        }
        if (!this.zoneServices.isEmpty()) {
            for (ZoneServiceForm zoneServiceForm : this.zoneServices) {
                if (null == zoneServiceForm.getDeviceId()) continue;
                AticDevice securityNE = mgr.getDeviceByMoid(zoneServiceForm.getDeviceId().longValue());
                if (null != securityNE && deviceSet.contains(zoneServiceForm.getDeviceId())) {
                    zoneServiceForm.setDeviceName(securityNE.getName());
                    continue;
                }
                deleteServices.add(zoneServiceForm);
            }
        }
        for (ZoneServiceForm zoneServiceForm : deleteServices) {
            this.zoneServices.remove(zoneServiceForm);
        }
        if ("display:none".equals(this.getStrViewPage())) {
            this.setViewPage(true);
        } else {
            this.setViewPage(false);
        }
        this.setIsSigDeviceOnly(this.onlySigDeviceAssociated(this.zoneId));
        for (ZoneServiceForm zoneServiceForm : this.zoneServices) {
            this.handleOtherService(zoneServiceForm);
        }
        return "success";
    }

    public String viewOutboundZoneServices() {
        logger.info((Object)"viewOutboundZoneServices is execute");
        IAticDeviceService mgr = ZoneReferUtil.getFirewallService();
        if (null == this.zoneId) {
            throw new LegoCheckedException(630110L);
        }
        this.zoneId = this.zoneId.split(",")[0];
        this.initProtocolTypsList();
        Map<String, String> conditions = this.getConditions(true);
        IZoneServiceService rmi = ZoneReferUtil.getZoneServiceService();
        Paging result = rmi.queryByPage(conditions, this.start, this.pageSize);
        this.zoneServices = result.getData();
        this.total = result.getCount();
        ArrayList<ZoneServiceForm> deleteServices = new ArrayList<ZoneServiceForm>();
        User user = (User)this.getSession().getAttribute("currentUser");
        Boolean isAdmin = Boolean.valueOf(user.getIsAdmin());
        IAticDeviceService aticDeviceService = ZoneReferUtil.getFirewallService();
        List deviceList = aticDeviceService.getAllDevice(user.getUserID(), isAdmin.booleanValue());
        HashSet<Long> deviceSet = new HashSet<Long>();
        for (AticDevice item : deviceList) {
            deviceSet.add(item.getMoId());
        }
        if (!this.zoneServices.isEmpty()) {
            for (ZoneServiceForm zoneServiceForm : this.zoneServices) {
                if (null == zoneServiceForm.getDeviceId()) continue;
                AticDevice securityNE = mgr.getDeviceByMoid(zoneServiceForm.getDeviceId().longValue());
                if (null != securityNE && deviceSet.contains(zoneServiceForm.getDeviceId())) {
                    zoneServiceForm.setDeviceName(securityNE.getName());
                    continue;
                }
                deleteServices.add(zoneServiceForm);
            }
        }
        for (ZoneServiceForm zoneServiceForm : deleteServices) {
            this.zoneServices.remove(zoneServiceForm);
        }
        return "success";
    }

    private void handleOtherService(ZoneServiceForm form) {
        String protocol = form.getProtocol();
        if (protocol.equals("Other")) {
            int protocolNum = form.getProtocolNum();
            switch (protocolNum) {
                case 3: {
                    form.setProtocol("GGP");
                    break;
                }
                case 4: {
                    form.setProtocol("IP-in-IP");
                    break;
                }
                case 47: {
                    form.setProtocol("GRE");
                    break;
                }
                case 50: {
                    form.setProtocol("ESP");
                    break;
                }
                case 51: {
                    form.setProtocol("AH");
                    break;
                }
                default: {
                    form.setProtocol(protocol + '[' + protocolNum + ']');
                }
            }
        }
    }

    private Boolean onlySigDeviceAssociated(String zoneID) {
        if (!Constant.ZONE_TYPE_OF_DEFAULT.equals(ZoneReferUtil.getZoneInfoFrom(Long.valueOf(zoneID)).getZoneType())) {
            return false;
        }
        return true;
    }

    private Map<String, String> getConditions(boolean isSupportOutbound) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("zoneId", this.zoneId);
        if (!StringUtils.isEmpty((CharSequence)this.queryProtocolType)) {
            if ("ALL".equals(this.queryProtocolType)) {
                queryMap.put("protocol", this.queryProtocolType);
            }
        } else {
            this.setQueryProtocolType("ALL");
            this.setQueryProtocolTypeName("ALL");
        }
        if (!StringUtils.isEmpty((CharSequence)this.queryPortType) && !"4".equals(this.queryPortType)) {
            queryMap.put("portType", this.queryPortType);
        }
        if (null != this.queryServiceName && !StringUtils.isEmpty((CharSequence)this.queryServiceName)) {
            queryMap.put("serviceName", this.queryServiceName.trim());
        }
        if (isSupportOutbound) {
            queryMap.put("direction", String.valueOf(2));
        } else {
            queryMap.put("direction", String.valueOf(1));
        }
        return queryMap;
    }

    private void initProtocolTypsList() {
        this.protocolTypeList = new ArrayList<LangPair>();
        this.protocolTypeList.add(new LangPair("ALL", "ALL"));
        this.protocolTypeList.add(new LangPair("DEFAULT", this.getText("com.hs.vsm.secservice.ddos.policy.zoneservice.default.service")));
        this.protocolTypeList.add(new LangPair("TCP", "TCP"));
        this.protocolTypeList.add(new LangPair("UDP", "UDP"));
        this.protocolTypeList.add(new LangPair("TCP_DNS", "TCP_DNS"));
        this.protocolTypeList.add(new LangPair("UDP_DNS", "UDP_DNS"));
        this.protocolTypeList.add(new LangPair("HTTP", "HTTP"));
        this.protocolTypeList.add(new LangPair("HTTPS", "HTTPS"));
        this.protocolTypeList.add(new LangPair("SIP", "SIP"));
    }

    private void initPortTypsList() {
        this.portTypeList = new ArrayList<LangPair>();
        this.portTypeList.add(new LangPair("4", this.getText("com.hs.vsm.secservice.ddos.policy.zoneservice.portType.all")));
        this.portTypeList.add(new LangPair("3", this.getText("com.hs.vsm.secservice.ddos.policy.zoneservice.portType.default")));
        this.portTypeList.add(new LangPair("0", this.getText("com.hs.vsm.secservice.ddos.policy.zoneservice.portType.none")));
        this.portTypeList.add(new LangPair("1", this.getText("com.hs.vsm.secservice.ddos.policy.zoneservice.portType.auth")));
        this.portTypeList.add(new LangPair("2", this.getText("com.hs.vsm.secservice.ddos.policy.zoneservice.portType.service")));
    }

    public List<ZoneServiceForm> getZoneServices() {
        return this.zoneServices;
    }

    public void setZoneServices(List<ZoneServiceForm> zoneServices) {
        this.zoneServices = zoneServices;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public List<LangPair> getProtocolTypeList() {
        return this.protocolTypeList;
    }

    public void setProtocolTypeList(List<LangPair> protocolTypeList) {
        this.protocolTypeList = protocolTypeList;
    }

    public String getQueryProtocolType() {
        return this.queryProtocolType;
    }

    public void setQueryProtocolType(String queryProtocolType) {
        this.queryProtocolType = queryProtocolType;
    }

    public String getQueryServiceName() {
        return this.queryServiceName;
    }

    public void setQueryServiceName(String queryServiceName) {
        this.queryServiceName = queryServiceName;
    }

    public String getStrViewPage() {
        return this.strViewPage;
    }

    public void setStrViewPage(String strViewPage) {
        this.strViewPage = strViewPage;
    }

    public boolean isViewPage() {
        return this.viewPage;
    }

    public void setViewPage(boolean viewPage) {
        this.viewPage = viewPage;
    }

    public String getQueryProtocolTypeName() {
        return this.queryProtocolTypeName;
    }

    public void setQueryProtocolTypeName(String queryProtocolTypeName) {
        this.queryProtocolTypeName = queryProtocolTypeName;
    }

    public Boolean getIsSigDeviceOnly() {
        return this.isSigDeviceOnly;
    }

    public void setIsSigDeviceOnly(Boolean isSigDeviceOnly) {
        this.isSigDeviceOnly = isSigDeviceOnly;
    }

    public String getQueryPortType() {
        return this.queryPortType;
    }

    public void setQueryPortType(String queryPortType) {
        this.queryPortType = queryPortType;
    }

    public String getQueryPortTypeName() {
        return this.queryPortTypeName;
    }

    public void setQueryPortTypeName(String queryPortTypeName) {
        this.queryPortTypeName = queryPortTypeName;
    }

    public List<LangPair> getPortTypeList() {
        return this.portTypeList;
    }

    public void setPortTypeList(List<LangPair> portTypeList) {
        this.portTypeList = portTypeList;
    }

    public boolean validateZoneId() {
        if ("".equals(this.zoneId)) {
            return false;
        }
        long id = 0L;
        try {
            id = Long.parseLong(this.zoneId);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return id >= 1L;
    }

    public boolean validateStrViewPage() {
        if (null == this.strViewPage || "".equals(this.strViewPage)) {
            return true;
        }
        String regex = "^(display:none|display:block)$";
        return this.strViewPage.matches(regex);
    }

    public boolean validateViewPage() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String viewPageTemp = request.getParameter("viewPage");
        if (null == viewPageTemp) {
            return true;
        }
        if ("".equals(viewPageTemp)) {
            return false;
        }
        return "true".equals(viewPageTemp) || "false".equals(viewPageTemp);
    }

    public boolean validateQueryServiceName() {
        if (null == this.queryServiceName || "".equals(this.queryServiceName)) {
            return true;
        }
        String regex = "^\\s*[a-zA-Z_0-9]{1}\\w*\\s*$";
        if (this.queryServiceName.length() < 1 || this.queryServiceName.length() > 32) {
            return false;
        }
        return this.queryServiceName.matches(regex);
    }

    public boolean validateQueryProtocolType() {
        if (null == this.queryProtocolType) {
            return true;
        }
        if ("".equals(this.queryProtocolType)) {
            return false;
        }
        String regex = "^(ALL|DEFAULT|TCP|UDP|TCP_DNS|UDP_DNS|HTTP|HTTPS|SIP)$";
        return this.queryProtocolType.matches(regex);
    }

    public boolean validateQueryProtocolTypeName() {
        if (null == this.queryProtocolTypeName) {
            return true;
        }
        if ("".equals(this.queryProtocolTypeName)) {
            return false;
        }
        String regex = "^(ALL|--|TCP|UDP|TCP_DNS|UDP_DNS|HTTP|HTTPS|SIP)$";
        return this.queryProtocolTypeName.matches(regex);
    }

    public boolean validateQueryPortType() {
        if (null == this.queryPortType || "".equals(this.queryPortType)) {
            return true;
        }
        String regex = "^(0|1|2|3|4)$";
        return this.queryPortType.matches(regex);
    }

    public boolean validatePageSize() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String page = request.getParameter("pageSize");
        if (null == page) {
            return true;
        }
        if ("".equals(page)) {
            return false;
        }
        String regex = "^(10|20|30|50|100)$";
        return page.matches(regex);
    }
}

