/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.action.ViewAllFilterAction;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneTemplateForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneTemplateService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class ViewAllZoneTemplateAction
extends BaseAction {
    private static final long serialVersionUID = 728858480131936048L;
    List<ZoneTemplateForm> zoneTemplates;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private IZoneTemplateService zoneTemplateService;
    private String templateName;
    private String protocol = "ALL";
    private List<LangPair> protocolTypeList;
    private Long[] deleteIds;
    private String[] deleteServiceNames;
    private String deviceType;
    private Long deviceId;
    private int direction;

    public Long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String viewAllZoneTemplate() {
        this.logger.info((Object)"viewAllZoneTemplate is exceute!");
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)this.templateName)) {
            queryMap.put("templateName", this.templateName.trim());
        }
        if (!StringUtils.isEmpty((CharSequence)this.deviceType)) {
            queryMap.put("deviceType", this.changeToUniqueDeviceType(this.deviceType));
        }
        if (0 != this.direction) {
            queryMap.put("direction", String.valueOf(this.direction));
        }
        if (this.deviceId != null) {
            IAticDeviceService mgr = ZoneReferUtil.getFirewallService();
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(this.deviceId);
            BisUtil.checkUserSecurity(moIdList);
            AticDevice securityNE = mgr.getDeviceByMoid(this.deviceId.longValue());
            if (null == securityNE) {
                throw new LegoCheckedException(201L);
            }
            if (securityNE.getDeviceType() == 1 && securityNE.getVersion().contains("V500R001")) {
                this.deviceType = "AntiDDoS";
            }
            if (securityNE.getDeviceType() == 5 || securityNE.getDeviceType() == 7) {
                this.deviceType = "NFA";
            }
            if (securityNE.getDeviceType() == 1 && securityNE.getVersion().contains("V500R005C00")) {
                this.deviceType = "AntiDDoS";
            }
            if (securityNE.getDeviceType() == 1 && securityNE.getVersion().contains("V600R006")) {
                this.deviceType = "AntiDDoS";
            }
            queryMap.put("deviceType", this.deviceType);
        }
        if (!StringUtils.isEmpty((CharSequence)this.protocol) && !"ALL".equals(this.protocol)) {
            queryMap.put("protocol", this.protocol);
        }
        Paging page = this.zoneTemplateService.queryByPage(queryMap, this.start, this.pageSize);
        this.zoneTemplates = page.getData();
        this.total = page.getCount();
        this.translateData();
        return "success";
    }

    private String changeToUniqueDeviceType(String deviceTypeStr) {
        if (deviceTypeStr.equals("AntiDDoS_V100R001")) {
            return "AntiDDoS_V100R001";
        }
        return deviceTypeStr;
    }

    private void translateData() {
        for (ZoneTemplateForm form : this.zoneTemplates) {
            SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            form.setAddTimeStr(formate.format(new Date(form.getAddTime() * 1000L)));
        }
    }

    public void deleteZoneTemplate() {
        this.getOperateLog().warning("com.hs.vsm.secservice.ddos.policy.operation.params.delTemplate", "lego.dic.module.ddosApp");
        ArrayList<BatchOperation> batchOperation = new ArrayList<BatchOperation>();
        for (int i = 0; i < this.deleteIds.length; ++i) {
            this.logger.info((Object)("deleteZoneTemplate is exceute! delete ids=" + this.deleteIds[i]));
            BatchOperation bo = new BatchOperation();
            bo.setTargetId(this.deleteIds[i].longValue());
            bo.setTargetName(this.deleteServiceNames[i]);
            bo.setOptDetail("com.hs.vsm.secservice.ddos.policy.operation.params.delTemplate.success");
            bo.setDetailParam(new String[]{this.deleteServiceNames[i]});
            batchOperation.add(bo);
        }
        this.batchOperationResult = this.zoneTemplateService.deleteInBatch(batchOperation);
        this.bathResult(this.batchOperationResult);
    }

    public List<ZoneTemplateForm> getZoneTemplates() {
        return this.zoneTemplates;
    }

    public void setZoneTemplates(List<ZoneTemplateForm> zoneTemplates) {
        this.zoneTemplates = zoneTemplates;
    }

    public List<LangPair> getProtocolTypeList() {
        return this.protocolTypeList;
    }

    public void setProtocolTypeList(List<LangPair> protocolTypeList) {
        this.protocolTypeList = protocolTypeList;
    }

    public String getAddTime(Date date) {
        DateFormat format = SimpleDateFormat.getDateTimeInstance();
        return format.format(date);
    }

    public Long[] getDeleteIds() {
        if (null != this.deleteIds) {
            return (Long[])this.deleteIds.clone();
        }
        return new Long[0];
    }

    public void setDeleteIds(Long[] deleteIds) {
        this.deleteIds = null != deleteIds ? (Long[])deleteIds.clone() : null;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String[] getDeleteServiceNames() {
        if (null != this.deleteServiceNames) {
            return (String[])this.deleteServiceNames.clone();
        }
        return new String[0];
    }

    public void setDeleteServiceNames(String[] deleteServiceNames) {
        this.deleteServiceNames = null != deleteServiceNames ? (String[])deleteServiceNames.clone() : null;
    }

    public boolean validateDeleteIds() {
        if (null == this.deleteIds || 0 == this.deleteIds.length) {
            return false;
        }
        for (Long testId : this.deleteIds) {
            if (null != testId && testId >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean validateDeleteServiceNames() {
        if (null == this.deleteServiceNames || 0 == this.deleteServiceNames.length) {
            return false;
        }
        for (String testName : this.deleteServiceNames) {
            if (AticUtil.isNull((String)testName)) {
                return false;
            }
            if (testName.matches("^[a-zA-Z0-9\u4e00-\u9fa5_-]{1,125}$")) continue;
            return false;
        }
        return true;
    }

    public boolean validatePageSize() {
        return new ViewAllFilterAction().validatePageSize();
    }

    public boolean validateTemplateName() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String nameTemp = request.getParameter("templateName");
        if ("".equals(nameTemp) || null == nameTemp) {
            return true;
        }
        if (nameTemp.length() < 1 || nameTemp.length() > 125) {
            return false;
        }
        String regex = "^(?!\\s*(?i)null$)[a-zA-Z_\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5]*$";
        return nameTemp.matches(regex);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public IZoneTemplateService getZoneTemplateService() {
        return this.zoneTemplateService;
    }

    public void setZoneTemplateService(IZoneTemplateService zoneTemplateService) {
        this.zoneTemplateService = zoneTemplateService;
    }
}

