/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.ddos.policy.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.bis.form.BaselineMetaDataForm;
import com.hs.atic.sdk.bis.form.ZoneBaseLineStudyForm;
import com.hs.atic.sdk.bis.service.IBaseLineService;
import com.hs.atic.sdk.bis.service.IBaselineDataService;
import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.util.BaseLineGetSuggestionValueQueryBean;
import com.hs.atic.sdk.util.TimeTransferUtil;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.action.RadioGroupVO;
import com.hs.vsm.secservice.ddos.policy.beans.StudyResultBean;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.policy.util.DevCapUtil;
import com.hs.vsm.secservice.nfa.util.NfaClusterUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyEditForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.adapter.capability.model.ParaBean;
import com.opensymphony.xwork2.ActionContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class ZoneBaselineAction
extends BaseAction {
    static Comparator<LangPair> comparator = new Comparator<LangPair>(){

        @Override
        public int compare(LangPair o1, LangPair o2) {
            return o1.getLabel().toLowerCase(Locale.ENGLISH).compareTo(o2.getLabel().toLowerCase(Locale.ENGLISH));
        }
    };
    private static final long serialVersionUID = 6242391611179352705L;
    private static final Long NUM_31536000000 = 31536000000L;
    private static final Long NUM_86400000 = 86400000L;
    private static final int K2P = 1024;
    private static final int M2P = 0x100000;
    private static final String POLICY_ITEM_PREFIX = "com.hs.vsm.secservice.ddos.policy.baseline.";
    private static final List<String> DDOS_DEVICE_POLICYS = new ArrayList<String>();
    private static final List<String> NFA_DEVICE_POLICYS = new ArrayList<String>();
    List<RadioGroupVO> effectModeList;
    List<RadioGroupVO> startTimeList;
    List<RadioGroupVO> endTimeList;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private String queryServiceName;
    private String serviceTypeName;
    private Long zoneId;
    private List<StudyResultBean> gridList;
    private Boolean hasStart = false;
    private List<LangPair> deviceList;
    private List<LangPair> protocolTypeList;
    private List<RadioGroupVO> stuTypeList;
    private String deviceIp;
    private List<String> confirmInfo;
    private String deviceName;
    private String serviceType;
    private Boolean isHasNoSupport;
    private ZoneBaseLineStudyForm baseLineStudyForm;
    private String selectDevice;
    private String noSupportDeviceName;
    private List<ZoneBaseLineStudyForm> zoneBaseLineStudyFormList;
    private Long studyId;
    private int direction;
    private String sortType;
    private String sortField;
    private Long[] studyIds;
    private String startTime;
    private String stopTime;
    private boolean supportOutbound = false;

    private void initStartTimeMode() {
        this.startTimeList = new ArrayList<RadioGroupVO>();
        RadioGroupVO radio1 = new RadioGroupVO();
        radio1.setKey(0);
        radio1.setLabel(this.getText("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.startmode.now"));
        RadioGroupVO radio2 = new RadioGroupVO();
        radio2.setKey(1);
        radio2.setLabel(this.getText("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.startmode.define"));
        this.startTimeList.add(radio1);
        this.startTimeList.add(radio2);
    }

    private void initStopTimeMode() {
        this.endTimeList = new ArrayList<RadioGroupVO>();
        RadioGroupVO radio1 = new RadioGroupVO();
        radio1.setKey(0);
        radio1.setLabel(this.getText("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.stopmode.manual"));
        RadioGroupVO radio2 = new RadioGroupVO();
        radio2.setKey(1);
        radio2.setLabel(this.getText("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.stopmode.define"));
        this.endTimeList.add(radio1);
        this.endTimeList.add(radio2);
    }

    private void initEffectModeTypes() {
        this.effectModeList = new ArrayList<RadioGroupVO>();
        RadioGroupVO radio1 = new RadioGroupVO();
        radio1.setKey(0);
        radio1.setLabel(this.getText("com.hs.vsm.secservice.ddos.policy.effect.mode.all"));
        RadioGroupVO radio2 = new RadioGroupVO();
        radio2.setKey(1);
        radio2.setLabel(this.getText("com.hs.vsm.secservice.ddos.policy.effect.mode.max"));
        this.effectModeList.add(radio1);
        this.effectModeList.add(radio2);
    }

    private void initDeviceList() {
        this.deviceList = new ArrayList<LangPair>();
        IBaseLineService baseLineStudyService = ZoneReferUtil.getBaselineService();
        if (null != this.studyId && null != this.zoneId) {
            Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(moId);
            BisUtil.checkUserSecurity(moIdList);
            this.baseLineStudyForm = baseLineStudyService.querySingleBaselineTask(this.studyId, this.zoneId);
        }
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        List forms = ZoneReferUtil.getZoneDeviceService().queryZoneDeviceFormsByZoneID(this.baseLineStudyForm.getZoneId(), currentUser.getUserID(), "true".equalsIgnoreCase(currentUser.getIsAdmin()));
        if (!forms.isEmpty()) {
            for (ZoneDeviceForm form : forms) {
                Long devId = form.getDeviceId();
                AticDevice device = ZoneReferUtil.getDevice(devId);
                LangPair deviceDesc = new LangPair(device.getName(), device.getIpAddress());
                this.deviceList.add(deviceDesc);
            }
        }
        Collections.sort(this.deviceList, comparator);
        if (!this.deviceList.isEmpty() && this.deviceName == null) {
            this.deviceIp = this.deviceList.get(0).getValue();
            this.deviceName = this.deviceList.get(0).getLabel();
        }
    }

    public String viewBaselinePage() {
        this.fetchRequest().setAttribute("zoneId", (Object)this.zoneId);
        this.fetchRequest().setAttribute("studyId", (Object)this.studyId);
        ILicenseOutboundService licenseOutboundService = ZoneBisUtil.getLicenseOutboundService();
        this.supportOutbound = licenseOutboundService.isSupportOutbound();
        this.fetchRequest().setAttribute("isSupportOutbound", (Object)String.valueOf(this.supportOutbound));
        return "success";
    }

    public String viewBaselineData() {
        this.initDeviceList();
        this.queryBaselineData();
        return "success";
    }

    public String viewBaselineDataOutBound() {
        this.initDeviceList();
        this.queryBaselineData();
        return "success";
    }

    public String showMutliBaseline() {
        this.logger.info((Object)"showMutliBaseline start");
        IBaseLineService baseLineStudyService = ZoneReferUtil.getBaselineService();
        Paging page = baseLineStudyService.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
        this.zoneBaseLineStudyFormList = page.getData();
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.setTotal(page.getCount());
        this.logger.info((Object)"showMutliBaseline end");
        return "success";
    }

    private Map<String, String> createQueryMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (null != this.deviceIp && !this.deviceIp.trim().equals("")) {
            queryMap.put("deviceIp", this.deviceIp.trim());
        }
        if (null != this.zoneId) {
            Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(moId);
            BisUtil.checkUserSecurity(moIdList);
            queryMap.put("zoneId", String.valueOf(this.zoneId));
        }
        return queryMap;
    }

    public String addBaselineTask() {
        this.logger.info((Object)"addBaseTask start");
        this.initStartTimeMode();
        this.initStopTimeMode();
        this.initEffectModeTypes();
        this.baseLineStudyForm = new ZoneBaseLineStudyForm();
        this.baseLineStudyForm.setAutoInure(false);
        this.baseLineStudyForm.setEffectMode(0);
        this.baseLineStudyForm.setCyc(1);
        this.baseLineStudyForm.setHistoryHeft(0);
        return "success";
    }

    public void setTaskStartTime() {
        this.logger.info((Object)"addBaseTask set startTime");
        this.baseLineStudyForm = new ZoneBaseLineStudyForm();
        this.baseLineStudyForm.setNewStartTime(TimeTransferUtil.transferlong2String(System.currentTimeMillis() + 300000L));
        String startTimeStr = this.baseLineStudyForm.getNewStartTime();
        this.responseResult(startTimeStr);
    }

    public void setTaskEndTime() {
        this.logger.info((Object)"addBaseTask set endTime");
        String endTimeStr = "";
        if (null != this.baseLineStudyForm.getNewStartTime()) {
            this.baseLineStudyForm.setNewEndTime(TimeTransferUtil.transferlong2String(TimeTransferUtil.convertString2Long(this.baseLineStudyForm.getNewStartTime()) * 1000L + 300000L));
            endTimeStr = this.baseLineStudyForm.getNewEndTime();
        } else {
            this.baseLineStudyForm.setNewEndTime(TimeTransferUtil.transferlong2String(System.currentTimeMillis() + 600000L));
            endTimeStr = this.baseLineStudyForm.getNewEndTime();
        }
        this.responseResult(endTimeStr);
    }

    public String viewBaselineTaskConfig() {
        this.logger.info((Object)"viewBaseTaskConfig start");
        IBaseLineService baseLineStudyService = ZoneReferUtil.getBaselineService();
        this.initStartTimeMode();
        this.initStopTimeMode();
        this.initEffectModeTypes();
        Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        this.baseLineStudyForm = baseLineStudyService.querySingleBaselineTask(this.studyId, this.zoneId);
        return "success";
    }

    public void saveBaselineTask() {
        IBaseLineService baseLineStudyService = ZoneReferUtil.getBaselineService();
        IBaselineDataService baseLineDataService = ZoneReferUtil.getBaselineDataService();
        Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        List<ZoneBaseLineStudyForm> queryBaselineTasks = baseLineStudyService.queryBaselineTaskByZoneId(this.zoneId);
        Integer startMode = this.baseLineStudyForm.getStartMode();
        Integer stopMode = this.baseLineStudyForm.getStopMode();
        this.baseLineStudyForm.setZoneId(this.zoneId);
        if (this.baseLineStudyForm.getAutoInure() == null) {
            this.baseLineStudyForm.setAutoInure(false);
        } else {
            this.baseLineStudyForm.setAutoInure(true);
        }
        long startServiceTimeMills = 0L;
        long endServiceTimeMills = 0L;
        long currentTimeMills = this.getCurrentTimeMills();
        if (startMode == 0) {
            SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.baseLineStudyForm.setNewStartTime(dataFormat.format(new Date(currentTimeMills)));
            this.baseLineStudyForm.setStatus(1);
            if (stopMode == 1) {
                startServiceTimeMills = currentTimeMills;
            }
        } else if (startMode == 1) {
            this.baseLineStudyForm.setNewEndTime(this.baseLineStudyForm.getNewEndTime());
            startServiceTimeMills = this.getTimeInMillis(this.baseLineStudyForm.getNewStartTime());
            if (startServiceTimeMills < currentTimeMills) {
                this.logger.error((Object)("newStartTime:" + startServiceTimeMills + " currentTime:" + currentTimeMills));
                this.responseResult("starttimelessthancurrent");
                return;
            }
        }
        if (stopMode == 0) {
            this.baseLineStudyForm.setNewEndTime("");
        } else if (stopMode == 1) {
            this.baseLineStudyForm.setNewEndTime(this.baseLineStudyForm.getNewEndTime());
            endServiceTimeMills = this.getTimeInMillis(this.baseLineStudyForm.getNewEndTime());
        }
        if (startServiceTimeMills != 0L && endServiceTimeMills != 0L) {
            if (startServiceTimeMills < currentTimeMills) {
                this.logger.error((Object)("newStartTime:" + startServiceTimeMills + " currentTime:" + currentTimeMills));
                this.responseResult("starttimelessthancurrent");
                return;
            }
            if (startServiceTimeMills > endServiceTimeMills) {
                this.logger.error((Object)("newStartTime:" + startServiceTimeMills + " newEndTime:" + endServiceTimeMills));
                this.responseResult("starttimelessthanend");
                return;
            }
            if (endServiceTimeMills - startServiceTimeMills < (long)this.baseLineStudyForm.getCyc().intValue() * NUM_86400000) {
                this.logger.error((Object)("newStartTime:" + startServiceTimeMills + " newEndTime:" + endServiceTimeMills + " cycle:" + this.baseLineStudyForm.getCyc()));
                this.responseResult("cyclelessthanbegintoend");
                return;
            }
            if (endServiceTimeMills > startServiceTimeMills + NUM_31536000000) {
                this.logger.error((Object)("newEndTime:" + startServiceTimeMills + " newStartTime:" + endServiceTimeMills));
                this.responseResult("endtimegreaterthanstart");
                return;
            }
        }
        if (startMode == 1 && (stopMode == 0 || stopMode == 1)) {
            this.baseLineStudyForm.setStatus(0);
        }
        this.baseLineStudyForm.setStartTime(this.baseLineStudyForm.getNewStartTime());
        if ((startMode == 0 && stopMode == 1 || startMode == 1 && stopMode == 1) && (this.getTimeInMillis(this.baseLineStudyForm.getNewEndTime()) - this.getTimeInMillis(this.baseLineStudyForm.getNewStartTime())) / 60000L < 5L) {
            this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.createTask", "lego.dic.module.ddosApp", null, false, "com.hs.vsm.secservice.ddos.policy.zoneservice.detail.create.BaselineTask.failed", null);
            this.responseResult("less5min");
            return;
        }
        IZonePolicyApplyService zonePolicyApplyService = ZoneReferUtil.getZonePolicyService();
        ZonePolicyApplyForm zonePolicyApplyForm = (ZonePolicyApplyForm)zonePolicyApplyService.query(this.baseLineStudyForm.getZoneId());
        if (!"SUCCESS".equals(zonePolicyApplyForm.getDeployState())) {
            this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.createTask", "lego.dic.module.ddosApp", null, false, "com.hs.vsm.secservice.ddos.policy.zoneservice.detail.create.BaselineTask.failed", null);
            throw new LegoCheckedException(630147L);
        }
        long newStartTime = this.getTimeInMillis(this.baseLineStudyForm.getNewStartTime());
        long newEndTime = this.getTimeInMillis(this.baseLineStudyForm.getNewEndTime());
        Integer status = this.baseLineStudyForm.getStatus();
        for (ZoneBaseLineStudyForm zoneBaseLineStudyForm : queryBaselineTasks) {
            long startTimeL = this.getTimeInMillis(zoneBaseLineStudyForm.getNewStartTime());
            long endTime = this.getTimeInMillis(zoneBaseLineStudyForm.getNewEndTime());
            if ((newEndTime != 0L || newStartTime != 0L) && newEndTime >= startTimeL && newStartTime <= endTime) {
                this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.createTask", "lego.dic.module.ddosApp", null, false, "com.hs.vsm.secservice.ddos.policy.zoneservice.detail.create.BaselineTask.failed", null);
                this.responseResult("TimeRangeConflict");
                return;
            }
            if (startMode != 0 && stopMode == 0 && newStartTime > startTimeL && newStartTime < endTime) {
                this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.createTask", "lego.dic.module.ddosApp", null, false, "com.hs.vsm.secservice.ddos.policy.zoneservice.detail.create.BaselineTask.failed", null);
                this.responseResult("TimeRangeConflict");
                return;
            }
            if (zoneBaseLineStudyForm.getStopMode() == 0 && "".equals(zoneBaseLineStudyForm.getNewEndTime())) {
                if ((newEndTime != 0L || newStartTime != 0L) && newEndTime >= startTimeL) {
                    this.responseResult("alreadyManualStopTask");
                    this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.createTask", "lego.dic.module.ddosApp", null, false, "com.hs.vsm.secservice.ddos.policy.zoneservice.detail.create.BaselineTask.failed", null);
                    return;
                }
                if (newStartTime >= startTimeL) {
                    this.responseResult("alreadyManualStopTask");
                    this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.createTask", "lego.dic.module.ddosApp", null, false, "com.hs.vsm.secservice.ddos.policy.zoneservice.detail.create.BaselineTask.failed", null);
                    return;
                }
            }
            if (status != 1 || zoneBaseLineStudyForm.getStatus() == 0 || zoneBaseLineStudyForm.getStatus() != 1) continue;
            this.responseResult("alreadyOpenTask");
            this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.createTask", "lego.dic.module.ddosApp", null, false, "com.hs.vsm.secservice.ddos.policy.zoneservice.detail.create.BaselineTask.failed", null);
            return;
        }
        Long studyID = baseLineStudyService.startBaselineTask(this.baseLineStudyForm);
        try {
            if (this.baseLineStudyForm.getStatus() == 1) {
                baseLineDataService.modifyBaseLineTask(this.baseLineStudyForm.getZoneId(), true, TimeTransferUtil.transferlong2String(System.currentTimeMillis()), this.baseLineStudyForm.getCyc(), studyID);
            }
        }
        catch (LegoCheckedException e) {
            this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.createTask", "lego.dic.module.ddosApp", null, false, "com.hs.vsm.secservice.ddos.policy.zoneservice.detail.create.BaselineTask.failed", null);
            throw new LegoCheckedException(630155L, (Throwable)e);
        }
        this.addOperationLog(this.baseLineStudyForm);
        this.responseResult("success");
    }

    private void addOperationLog(ZoneBaseLineStudyForm zoneBaseLineStudyForm) {
        String startTimeMode = "0".equals(String.valueOf(zoneBaseLineStudyForm.getStartMode())) ? "com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.startmode.now" : "com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.startmode.define";
        String stopTimeMode = "0".equals(String.valueOf(zoneBaseLineStudyForm.getStopMode())) ? "com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.stopmode.manual" : "com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.stopmode.define";
        ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(zoneBaseLineStudyForm.getZoneId());
        String zoneName = zoneInfoForm.getZoneDesc();
        if (zoneBaseLineStudyForm.getAutoInure() != null && zoneBaseLineStudyForm.getAutoInure().booleanValue()) {
            if (zoneBaseLineStudyForm.getEffectMode() == 0) {
                String[] detailPara = new String[]{zoneBaseLineStudyForm.getName(), zoneBaseLineStudyForm.getCyc() + "", zoneBaseLineStudyForm.getHistoryHeft() + "", startTimeMode, zoneBaseLineStudyForm.getNewStartTime(), stopTimeMode, zoneBaseLineStudyForm.getNewEndTime(), "com.hs.vsm.secservice.ddos.policy.operation.params.always"};
                this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.createTask", "lego.dic.module.ddosApp", zoneName, false, "com.hs.vsm.secservice.ddos.policy.zoneservice.detail.create.BaselineTask", detailPara);
            } else {
                String[] detailPara = new String[]{zoneBaseLineStudyForm.getName(), zoneBaseLineStudyForm.getCyc() + "", zoneBaseLineStudyForm.getHistoryHeft() + "", startTimeMode, zoneBaseLineStudyForm.getNewStartTime(), stopTimeMode, zoneBaseLineStudyForm.getNewEndTime(), "com.hs.vsm.secservice.ddos.policy.operation.params.suggestion"};
                this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.createTask", "lego.dic.module.ddosApp", zoneName, false, "com.hs.vsm.secservice.ddos.policy.zoneservice.detail.create.BaselineTask", detailPara);
            }
        } else {
            String[] detailPara = new String[]{zoneBaseLineStudyForm.getName(), zoneBaseLineStudyForm.getCyc() + "", zoneBaseLineStudyForm.getHistoryHeft() + "", startTimeMode, zoneBaseLineStudyForm.getNewStartTime(), stopTimeMode, zoneBaseLineStudyForm.getNewEndTime(), "com.hs.vsm.secservice.ddos.policy.operation.params.unautoInure"};
            this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.createTask", "lego.dic.module.ddosApp", zoneName, false, "com.hs.vsm.secservice.ddos.policy.zoneservice.detail.create.BaselineTask", detailPara);
        }
    }

    private void queryBaselineData() {
        IBaseLineService baseLineStudyService = ZoneReferUtil.getBaselineService();
        this.baseLineStudyForm = baseLineStudyService.querySingleBaselineTask(this.baseLineStudyForm.getStudyId(), this.baseLineStudyForm.getZoneId());
        if ((null == this.baseLineStudyForm.getStopTime() || "".equals(this.baseLineStudyForm.getStopTime())) && this.baseLineStudyForm.getStatus() == 0) {
            this.gridList = new ArrayList<StudyResultBean>();
            return;
        }
        this.startTime = this.baseLineStudyForm.getStartTime();
        this.stopTime = this.baseLineStudyForm.getStopTime();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("zoneId", this.baseLineStudyForm.getZoneId().toString());
        map.put("studyId", this.baseLineStudyForm.getStudyId().toString());
        map.put("direction", this.direction + "");
        if (!StringUtils.isEmpty((CharSequence)this.queryServiceName)) {
            map.put("serviceName", this.queryServiceName.trim());
        }
        if (this.serviceType == null || "".equals(this.serviceType)) {
            this.serviceType = "DEFAULT";
            this.setServiceTypeName(this.getText("com.hs.vsm.secservice.ddos.policy.zoneservice.default.service"));
        }
        this.dealServiceBaseline(map);
    }

    private void dealServiceBaseline(Map<String, String> map) {
        IBaselineDataService baseLineDataService = ZoneReferUtil.getBaselineDataService();
        if (!StringUtils.isEmpty((CharSequence)this.deviceIp)) {
            String version = this.dealDeviceInfo(this.deviceIp);
            map.put("version", version);
            map.put("deviceIp", this.deviceIp);
            map.put("serviceType", this.serviceType);
            map.put("start", this.start + "");
            map.put("pageSize", this.pageSize + "");
            List<BaselineMetaDataForm> result = baseLineDataService.queryByPage(map);
            if (2 == this.direction && !result.isEmpty()) {
                result = this.filterBaseLineResult(result);
            }
            this.transMetaData(result, this.serviceType);
        } else {
            this.gridList = new ArrayList<StudyResultBean>();
        }
    }

    public void confBaselineData() {
        ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(this.zoneId);
        String zoneName = zoneInfoForm.getZoneDesc();
        ArrayList<Long> zoneIds = new ArrayList<Long>();
        if (!this.confirmInfo.isEmpty()) {
            ISysOptLog sysOptLogMgr = ZoneReferUtil.getSysOptLog();
            HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            String terminalIp = request.getRemoteAddr();
            for (String info : this.confirmInfo) {
                SysOptLog sysOptLogLego = new SysOptLog();
                sysOptLogLego.setDate(new Date());
                sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
                sysOptLogLego.setModule("lego.dic.module.ddosApp");
                sysOptLogLego.setOperation("com.hs.vsm.secservice.ddos.policy.operation.name.confirmBaselineTask");
                sysOptLogLego.setOperator(currentUser.getUserName());
                Long serviceId = Long.parseLong(info.split(";")[0]);
                ZoneServiceForm form = (ZoneServiceForm)ZoneReferUtil.getZoneServiceService().query(serviceId);
                String fieldName = info.split(";")[1];
                String voteValue = info.split(";")[2];
                Map<String, String> serviceItemMap = Constant.getPolicyItemMap();
                if ("httpDestQpsAlertRate".equals(fieldName)) {
                    form.setCurrentValue(fieldName, Integer.parseInt(voteValue));
                } else if ("tcpNewSrctipRate".equals(fieldName)) {
                    int nowVoteValue = Integer.parseInt(voteValue);
                    int interval = form.getCurrentValue("tcpNewSrctipInterval");
                    if (0 != interval) {
                        nowVoteValue = interval * nowVoteValue;
                    }
                    form.setCurrentValue(serviceItemMap.get(fieldName), nowVoteValue);
                } else {
                    form.setCurrentValue(serviceItemMap.get(fieldName), Integer.parseInt(voteValue));
                }
                StringBuffer opObject = new StringBuffer(zoneName);
                opObject.append('(').append(form.getServiceName()).append(')');
                sysOptLogLego.setTarget(opObject.toString());
                sysOptLogLego.setTerminalIp(terminalIp);
                try {
                    ZoneReferUtil.getZoneServiceService().create(form);
                    sysOptLogLego.setDetail("com.hs.vsm.secservice.ddos.policy.operation.detail.confirmBaselineTask");
                    sysOptLogLego.setDetailPara(new String[]{fieldName, voteValue});
                    sysOptLogLego.setResult(1);
                }
                catch (LegoCheckedException e) {
                    sysOptLogLego.setResult(0);
                    sysOptLogLego.setDetail(new StringBuffer("lego.err.").append(e.getErrorCode()).toString());
                }
                sysOptLogMgr.writeOptLog(sysOptLogLego);
            }
            zoneIds.add(this.zoneId);
            ZoneReferUtil.getZonePolicyMgrService().deploy(zoneIds, System.currentTimeMillis() / 1000L);
        }
        this.responseResult("success");
    }

    private List<BaselineMetaDataForm> filterBaseLineResult(List<BaselineMetaDataForm> resultList) {
        List<BaselineMetaDataForm> resultTemp = new ArrayList<BaselineMetaDataForm>();
        if (!resultList.isEmpty()) {
            BaselineMetaDataForm baselineMetaDataForm = resultList.get(0);
            AticDevice device = ZoneReferUtil.getDeviceByIp(baselineMetaDataForm.getDeviceIp());
            if (1 == device.getDeviceType()) {
                for (int i = resultList.size() - 1; i >= 0; --i) {
                    BaselineMetaDataForm form = resultList.get(i);
                    if (DDOS_DEVICE_POLICYS.contains(form.getKey())) continue;
                    resultList.remove(i);
                }
            } else {
                for (int i = resultList.size() - 1; i >= 0; --i) {
                    BaselineMetaDataForm form = resultList.get(i);
                    if (NFA_DEVICE_POLICYS.contains(form.getKey())) continue;
                    resultList.remove(i);
                }
            }
            resultTemp = resultList;
        }
        return resultTemp;
    }

    private void transMetaData(List<BaselineMetaDataForm> result, String serviceTypeStr) {
        int total = 0;
        this.gridList = new ArrayList<StudyResultBean>();
        if (!result.isEmpty()) {
            IBaselineDataService baseLineDataService = ZoneReferUtil.getBaselineDataService();
            for (BaselineMetaDataForm form : result) {
                ZoneServiceForm zoneServiceForm = (ZoneServiceForm)ZoneReferUtil.getZoneServiceService().query(form.getServiceId());
                AticDevice device = ZoneReferUtil.getDeviceByIp(form.getDeviceIp());
                if (device.getDeviceType() == 7) {
                    device = NfaClusterUtil.getNfaDeviceInfo(device.getMoId());
                }
                if (zoneServiceForm == null || null == device || (serviceTypeStr == null || "".equals(serviceTypeStr) ? !"DEFAULT".equals(zoneServiceForm.getProtocol()) : !serviceTypeStr.equals(zoneServiceForm.getProtocol()))) continue;
                DevCapUtil devCapUtil = DevCapUtil.getInstance();
                devCapUtil.initContext(device.getMoId(), zoneServiceForm.getProtocol());
                Map<String, String> serviceItemMap = Constant.getPolicyItemMap();
                StudyResultBean row = new StudyResultBean();
                row.setRelateNe(this.deviceName);
                row.setNo(total);
                row.setName(zoneServiceForm.getServiceName());
                row.setDirection(this.direction);
                if (device.getDeviceType() == 5) {
                    this.evaluateNfaNowValue(form, zoneServiceForm, row);
                } else {
                    String policyItem = serviceItemMap.get(form.getKey());
                    if ("httpDestQpsAlertRate".equals(form.getKey()) || "httpQpsAlertRate".equals(form.getKey())) {
                        policyItem = "httpDestQpsAlertRate";
                    } else if (null == policyItem) {
                        policyItem = form.getKey();
                    }
                    if ("tcpNewSrctipRate".equals(policyItem)) {
                        int currentValue = zoneServiceForm.getCurrentValue(policyItem);
                        int interval = zoneServiceForm.getCurrentValue("tcpNewSrctipInterval");
                        if (0 != interval) {
                            currentValue = (int)Math.ceil(Double.valueOf(currentValue) / (double)interval);
                        }
                        row.setNowValue(currentValue);
                    } else {
                        row.setNowValue(zoneServiceForm.getCurrentValue(policyItem));
                    }
                }
                row.setServiceId(zoneServiceForm.getPkid());
                ParaBean paraBean = null;
                for (Map.Entry<String, String> entry : serviceItemMap.entrySet()) {
                    if (!form.getKey().equals(entry.getValue()) && !form.getKey().equals(entry.getKey())) continue;
                    row.setPolicyItem(entry.getKey());
                    row.setDisplayField(this.getText(POLICY_ITEM_PREFIX + entry.getKey()));
                    AticDevice aticDevice = ZoneReferUtil.getDevice(device.getMoId());
                    if (aticDevice.getDeviceType() == 5) {
                        paraBean = devCapUtil.hasParasDiff(entry.getValue(), device.getMoId(), zoneServiceForm.getProtocol());
                        if (null != paraBean) {
                            if (!entry.getKey().contains("Pps")) break;
                            paraBean.setParaUnit("pps");
                            break;
                        }
                        this.logger.error((Object)"paraBean is null");
                        break;
                    }
                    if ("bigPacketRatio".equals(entry.getKey()) || null == (paraBean = devCapUtil.hasParasDiff(entry.getValue(), device.getMoId(), zoneServiceForm.getProtocol()))) break;
                    row.setNowParaUnit(paraBean.getParaUnit());
                    break;
                }
                if ("synratioLimitPackets".equals(form.getKey())) {
                    long baseValue = form.getValue();
                    int interval = zoneServiceForm.getCurrentValue("synratioDuration");
                    if (0 != interval) {
                        baseValue = (int)Math.ceil(Double.valueOf(baseValue) / 10.0 * (double)interval);
                    }
                    row.setBaseValue((int)baseValue);
                } else {
                    row.setBaseValue((int)form.getValue());
                }
                BaseLineGetSuggestionValueQueryBean baseLineGetSuggestionValueQueryBean = new BaseLineGetSuggestionValueQueryBean();
                baseLineGetSuggestionValueQueryBean.setBaselineValue(row.getBaseValue());
                baseLineGetSuggestionValueQueryBean.setCurrentValue(row.getNowValue());
                baseLineGetSuggestionValueQueryBean.setCurrentValueWeight(this.baseLineStudyForm.getHistoryHeft());
                baseLineGetSuggestionValueQueryBean.setPolicyItem(form.getKey());
                baseLineGetSuggestionValueQueryBean.setDevice(device);
                baseLineGetSuggestionValueQueryBean.setServiceType(zoneServiceForm.getProtocol());
                int suggestionValue = (int)baseLineDataService.getSuggestionValue(baseLineGetSuggestionValueQueryBean);
                row.setVoteValue(suggestionValue);
                row.setType(form.getServiceType());
                row.setRealBizId(form.getRealBizId());
                row.setRealdevIp(form.getReadDevIp());
                row.setRealZoneId(form.getRealZoneId());
                row.setRealDevType(form.getRealDevType());
                if ("tcpDesttipNum".equals(form.getKey()) || "tcpSrctipNum".equals(form.getKey())) {
                    row.setParaUnit("com.hs.vsm.secservice.ddos.connections");
                    row.setNowParaUnit("com.hs.vsm.secservice.ddos.connections");
                } else if ("tcpNewSrctipRate".equals(form.getKey())) {
                    row.setParaUnit("com.hs.vsm.secservice.ddos.connections.second");
                    row.setNowParaUnit("com.hs.vsm.secservice.ddos.connections.second");
                } else if (null != paraBean) {
                    row.setParaUnit(paraBean.getParaUnit());
                }
                this.gridList.add(row);
                ++total;
            }
        }
        Collections.sort(this.gridList);
        int end = this.getStart() + this.getPageSize() > total ? total : this.getStart() + this.getPageSize();
        this.gridList = this.gridList.subList(this.getStart(), end);
        this.setTotal(total);
    }

    private void evaluateNfaNowValue(BaselineMetaDataForm form, ZoneServiceForm zoneServiceForm, StudyResultBean row) {
        NfaPolicyEditForm nfaPolicyEditForm = zoneServiceForm.getNfaPolicyEditForm();
        NfaPolicyForm nfaPolicyForm = null;
        if (form.getKey().contains("sipFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getSipFlood();
        }
        if (form.getKey().contains("dnsQueryFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getDnsQueryFlood();
        }
        if (form.getKey().contains("dnsReplyFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getDnsReplyFlood();
        }
        if (form.getKey().contains("httpFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getHttpFlood();
        }
        if (form.getKey().contains("httpsFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getHttpsFlood();
        }
        if (form.getKey().contains("icmpFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getIcmpFlood();
        }
        if (form.getKey().contains("otherFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getOtherFlood();
        }
        if (form.getKey().contains("tcpAckFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getTcpAckFlood();
        }
        if (form.getKey().contains("tcpFragment")) {
            nfaPolicyForm = nfaPolicyEditForm.getTcpFragmentFlood();
        }
        if (form.getKey().contains("tcpRstFin")) {
            nfaPolicyForm = nfaPolicyEditForm.getTcpRstFinFlood();
        }
        if (form.getKey().contains("tcpSynFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getTcpSynFlood();
        }
        if (form.getKey().contains("udpFlood")) {
            nfaPolicyForm = nfaPolicyEditForm.getUdpFlood();
        }
        if (form.getKey().contains("udpFragment")) {
            nfaPolicyForm = nfaPolicyEditForm.getUdpFragmentFlood();
        }
        if (form.getKey().contains("hostTotal")) {
            nfaPolicyForm = nfaPolicyEditForm.getHostTotal();
        }
        if (nfaPolicyForm != null) {
            this.nfaNowVaule(form, row, nfaPolicyForm);
        } else {
            this.nfaNowVaule(form, row, new NfaPolicyForm());
        }
    }

    private void nfaNowVaule(BaselineMetaDataForm form, StudyResultBean row, NfaPolicyForm nfaPolicyForm) {
        if (form.getKey().contains("Pps")) {
            row.setNowValue(nfaPolicyForm.getPpsThreshold() == null ? 0 : nfaPolicyForm.getPpsThreshold());
            row.setNowParaUnit(nfaPolicyForm.getPpsUnit());
        } else {
            int nowValue = 0;
            if (nfaPolicyForm.getBpsThreshold() != null) {
                nowValue = nfaPolicyForm.getBpsThreshold();
                String paraUnit = nfaPolicyForm.getBpsUnit();
                if ("Mbps".equalsIgnoreCase(paraUnit)) {
                    nowValue *= 1024;
                } else if ("Gbps".equalsIgnoreCase(paraUnit)) {
                    nowValue *= 0x100000;
                }
            }
            row.setNowValue(nowValue);
            row.setNowParaUnit("Kbps");
        }
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    private long getTimeInMillis(String time) {
        if (time == null || time.length() == 0) {
            return 0L;
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = formate.parse(time.trim());
            return date.getTime();
        }
        catch (ParseException ex) {
            return 0L;
        }
    }

    public void startBaselineTask() {
        IBaseLineService baseLineStudyService = ZoneReferUtil.getBaselineService();
        IBaselineDataService baseLineDataService = ZoneReferUtil.getBaselineDataService();
        for (int i = 0; i < this.studyIds.length; ++i) {
            List<ZoneBaseLineStudyForm> zoneBaseLineStudyForms;
            Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(moId);
            BisUtil.checkUserSecurity(moIdList);
            this.baseLineStudyForm = baseLineStudyService.querySingleBaselineTask(this.studyIds[i], this.zoneId);
            if (null == this.baseLineStudyForm) {
                this.responseResult("taskIsNull");
                this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.operation.name.startBaselineTask", "lego.dic.module.ddosApp", null, false, "com.hs.vsm.secservice.ddos.policy.operation.detail.startBaselineTask.failed", null);
                return;
            }
            if (this.baseLineStudyForm.getStatus().equals(1)) {
                this.responseResult("alreadyOpenTask");
            }
            if (null != this.baseLineStudyForm.getStopTime() && !"".equals(this.baseLineStudyForm.getStopTime()) && this.getTimeInMillis(this.baseLineStudyForm.getStartTime()) < this.getTimeInMillis(this.baseLineStudyForm.getStopTime())) {
                this.responseResult("noOpenAgain");
            }
            if (null != (zoneBaseLineStudyForms = baseLineStudyService.queryBaselineTaskByZoneId(this.zoneId)) && !zoneBaseLineStudyForms.isEmpty()) {
                for (int j = 0; j < zoneBaseLineStudyForms.size(); ++j) {
                    if (!zoneBaseLineStudyForms.get(j).getStatus().equals(1)) continue;
                    this.responseResult("alreadyOpenTask");
                    this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.operation.name.startBaselineTask", "lego.dic.module.ddosApp", null, false, "com.hs.vsm.secservice.ddos.policy.operation.detail.startBaselineTask.failed", null);
                    return;
                }
            }
            this.baseLineStudyForm.setNewStartTime(TimeTransferUtil.transferlong2String(System.currentTimeMillis()));
            this.baseLineStudyForm.setStartTime(this.baseLineStudyForm.getNewStartTime());
            ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(this.baseLineStudyForm.getZoneId());
            String zoneName = zoneInfoForm.getZoneDesc();
            IZonePolicyApplyService zonePolicyApplyService = ZoneReferUtil.getZonePolicyService();
            ZonePolicyApplyForm zonePolicyApplyForm = (ZonePolicyApplyForm)zonePolicyApplyService.query(this.baseLineStudyForm.getZoneId());
            if (!"SUCCESS".equals(zonePolicyApplyForm.getDeployState())) {
                this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.operation.name.startBaselineTask", "lego.dic.module.ddosApp", null, false, "com.hs.vsm.secservice.ddos.policy.operation.detail.startBaselineTask.failed", null);
                throw new LegoCheckedException(630147L);
            }
            long startServiceTimeMills = this.getTimeInMillis(this.baseLineStudyForm.getNewStartTime());
            long endServiceTimeMills = this.getTimeInMillis(this.baseLineStudyForm.getNewEndTime());
            if (endServiceTimeMills != 0L && startServiceTimeMills > endServiceTimeMills) {
                this.logger.error((Object)("newStartTime:" + startServiceTimeMills + " newEndTime:" + endServiceTimeMills));
                this.responseResult("starttimelessthanend");
                this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.operation.name.startBaselineTask", "lego.dic.module.ddosApp", null, false, "com.hs.vsm.secservice.ddos.policy.operation.detail.startBaselineTask.failed", null);
                return;
            }
            this.startBlistTaskOpt(zoneName);
            this.baseLineStudyForm.setStatus(1);
            baseLineStudyService.startBaselineTask(this.baseLineStudyForm);
            if (baseLineDataService.modifyBaseLineTask(this.baseLineStudyForm.getZoneId(), true, TimeTransferUtil.transferlong2String(System.currentTimeMillis()), this.baseLineStudyForm.getCyc(), this.baseLineStudyForm.getStudyId())) continue;
            baseLineStudyService.deleteBaseLineTask(this.baseLineStudyForm.getZoneId());
            this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.operation.name.startBaselineTask", "lego.dic.module.ddosApp", null, false, "com.hs.vsm.secservice.ddos.policy.operation.detail.startBaselineTask.failed", null);
            this.responseResult("630155");
            return;
        }
        this.responseResult("success");
    }

    public void deleteBaselineTask() {
        IBaseLineService baseLineStudyService = ZoneReferUtil.getBaselineService();
        for (int i = 0; i < this.studyIds.length; ++i) {
            try {
                Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(moId);
                BisUtil.checkUserSecurity(moIdList);
                this.deleteOperationLog(this.studyIds[i], this.zoneId, 1);
                baseLineStudyService.deleteSingeBaselineTask(this.studyIds[i], this.zoneId);
                continue;
            }
            catch (LegoCheckedException e) {
                this.deleteOperationLog(this.studyIds[i], this.zoneId, 0);
                throw new LegoCheckedException(630170L, (Throwable)e);
            }
        }
        this.responseResult("success");
    }

    private void deleteOperationLog(Long studyID, Long zoneID, int flag) {
        IBaseLineService baseLineStudyService = ZoneReferUtil.getBaselineService();
        ISysOptLog sysOptLogService = ZoneReferUtil.getSysOptLog();
        ZoneBaseLineStudyForm zonebaseLineStudyForm = baseLineStudyService.querySingleBaselineTask(studyID, zoneID);
        if (null == zonebaseLineStudyForm) {
            this.responseResult("taskIsNull");
        } else {
            String[] detailPara;
            String startTimeMode = "0".equals(String.valueOf(zonebaseLineStudyForm.getStartMode())) ? "com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.startmode.now" : "com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.startmode.define";
            String stopTimeMode = "0".equals(String.valueOf(zonebaseLineStudyForm.getStopMode())) ? "com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.stopmode.manual" : "com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.stopmode.define";
            User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
            ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(zonebaseLineStudyForm.getZoneId());
            String zoneName = zoneInfoForm.getZoneDesc();
            SysOptLog sysOptLog = new SysOptLog();
            if (zonebaseLineStudyForm.getAutoInure() != null && zonebaseLineStudyForm.getAutoInure().booleanValue()) {
                if (zonebaseLineStudyForm.getEffectMode() == 0) {
                    detailPara = new String[]{zonebaseLineStudyForm.getName(), zonebaseLineStudyForm.getCyc() + "", zonebaseLineStudyForm.getHistoryHeft() + "", startTimeMode, zonebaseLineStudyForm.getNewStartTime(), stopTimeMode, zonebaseLineStudyForm.getNewEndTime(), "com.hs.vsm.secservice.ddos.policy.operation.params.always"};
                    sysOptLog.setDetailPara(detailPara);
                } else {
                    detailPara = new String[]{zonebaseLineStudyForm.getName(), zonebaseLineStudyForm.getCyc() + "", zonebaseLineStudyForm.getHistoryHeft() + "", startTimeMode, zonebaseLineStudyForm.getNewStartTime(), stopTimeMode, zonebaseLineStudyForm.getNewEndTime(), "com.hs.vsm.secservice.ddos.policy.operation.params.suggestion"};
                    sysOptLog.setDetailPara(detailPara);
                }
            } else {
                detailPara = new String[]{zonebaseLineStudyForm.getName(), zonebaseLineStudyForm.getCyc() + "", zonebaseLineStudyForm.getHistoryHeft() + "", startTimeMode, zonebaseLineStudyForm.getNewStartTime(), stopTimeMode, zonebaseLineStudyForm.getNewEndTime(), "com.hs.vsm.secservice.ddos.policy.operation.params.unautoInure"};
                sysOptLog.setDetailPara(detailPara);
            }
            sysOptLog.setDate(new Date());
            sysOptLog.setLevel(SysoplogLevel.info.getValue());
            sysOptLog.setDetail("com.hs.vsm.secservice.ddos.policy.zoneservice.detail.delete.BaselineTask");
            sysOptLog.setModule("lego.dic.module.ddosApp");
            sysOptLog.setResult(flag);
            sysOptLog.setOperation("com.hs.vsm.secservice.ddos.policy.zoneservice.zoneline.deleteTask");
            User user = (User)this.getSession().getAttribute("currentUser");
            sysOptLog.setOperator(user.getUserName());
            sysOptLog.setTarget(zoneName);
            sysOptLog.setTerminalIp(currentUser.getIpAdr());
            sysOptLogService.writeOptLog(sysOptLog);
        }
    }

    private long getCurrentTimeMills() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        return calendar.getTimeInMillis();
    }

    private void startBlistTaskOpt(String zoneName) {
        if (this.baseLineStudyForm.getAutoInure() != null && this.baseLineStudyForm.getAutoInure().booleanValue()) {
            if (this.baseLineStudyForm.getEffectMode() == 0) {
                this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.operation.name.startBaselineTask", "lego.dic.module.ddosApp", zoneName, false, "com.hs.vsm.secservice.ddos.policy.operation.detail.startBaselineTask", new String[]{this.baseLineStudyForm.getName(), this.baseLineStudyForm.getCyc() + "", this.baseLineStudyForm.getStartTime(), this.baseLineStudyForm.getHistoryHeft() + "", "com.hs.vsm.secservice.ddos.policy.operation.params.autoInure.always"});
            } else if (this.baseLineStudyForm.getEffectMode() == 1) {
                this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.operation.name.startBaselineTask", "lego.dic.module.ddosApp", zoneName, false, "com.hs.vsm.secservice.ddos.policy.operation.detail.startBaselineTask", new String[]{this.baseLineStudyForm.getName(), this.baseLineStudyForm.getCyc() + "", this.baseLineStudyForm.getStartTime(), this.baseLineStudyForm.getHistoryHeft() + "", "com.hs.vsm.secservice.ddos.policy.operation.params.autoInure.suggestion"});
            }
        } else {
            this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.operation.name.startBaselineTask", "lego.dic.module.ddosApp", zoneName, false, "com.hs.vsm.secservice.ddos.policy.operation.detail.startBaselineTask", new String[]{this.baseLineStudyForm.getName(), this.baseLineStudyForm.getCyc() + "", this.baseLineStudyForm.getStartTime(), this.baseLineStudyForm.getHistoryHeft() + "", "com.hs.vsm.secservice.ddos.policy.operation.params.unautoInure"});
        }
    }

    public void stopBaselineTask() {
        IBaseLineService baseLineStudyService = ZoneReferUtil.getBaselineService();
        IBaselineDataService baseLineDataService = ZoneReferUtil.getBaselineDataService();
        for (int i = 0; i < this.studyIds.length; ++i) {
            Long moId = ZoneBisUtil.getMoidByZoneid(this.zoneId);
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(moId);
            BisUtil.checkUserSecurity(moIdList);
            this.baseLineStudyForm = baseLineStudyService.querySingleBaselineTask(this.studyIds[i], this.zoneId);
            if (null == this.baseLineStudyForm) {
                this.responseResult("taskIsNull");
                return;
            }
            this.baseLineStudyForm.setStatus(0);
            this.baseLineStudyForm.setStopTime(TimeTransferUtil.transferlong2String(System.currentTimeMillis()));
            this.baseLineStudyForm.setNewEndTime(this.baseLineStudyForm.getStopTime());
            this.optLog();
            if (!baseLineDataService.modifyBaseLineTask(this.baseLineStudyForm.getZoneId(), false, TimeTransferUtil.transferlong2String(System.currentTimeMillis()), this.baseLineStudyForm.getCyc(), this.studyIds[i])) {
                throw new LegoCheckedException(630132L);
            }
            this.baseLineStudyForm = baseLineStudyService.stopBaselineTask(this.baseLineStudyForm);
        }
        this.responseResult("success");
    }

    private void optLog() {
        ZoneInfoForm zoneInfoForm = ZoneReferUtil.getZoneInfoFrom(this.baseLineStudyForm.getZoneId());
        String zoneName = zoneInfoForm.getZoneDesc();
        if (this.baseLineStudyForm.getAutoInure() != null && this.baseLineStudyForm.getAutoInure().booleanValue()) {
            if (this.baseLineStudyForm.getEffectMode() == 0) {
                this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.operation.name.stopBaselineTask", "lego.dic.module.ddosApp", zoneName, false, "com.hs.vsm.secservice.ddos.policy.operation.detail.stopBaselineTask", new String[]{this.baseLineStudyForm.getName(), this.baseLineStudyForm.getCyc() + "", this.baseLineStudyForm.getStopTime(), this.baseLineStudyForm.getHistoryHeft() + "", "com.hs.vsm.secservice.ddos.policy.operation.params.autoInure.always"});
            } else if (this.baseLineStudyForm.getEffectMode() == 1) {
                this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.operation.name.stopBaselineTask", "lego.dic.module.ddosApp", zoneName, false, "com.hs.vsm.secservice.ddos.policy.operation.detail.stopBaselineTask", new String[]{this.baseLineStudyForm.getName(), this.baseLineStudyForm.getCyc() + "", this.baseLineStudyForm.getStopTime(), this.baseLineStudyForm.getHistoryHeft() + "", "com.hs.vsm.secservice.ddos.policy.operation.params.autoInure.suggestion"});
            }
        } else {
            this.getOperateLog().info("com.hs.vsm.secservice.ddos.policy.operation.name.stopBaselineTask", "lego.dic.module.ddosApp", zoneName, false, "com.hs.vsm.secservice.ddos.policy.operation.detail.stopBaselineTask", new String[]{this.baseLineStudyForm.getName(), this.baseLineStudyForm.getCyc() + "", this.baseLineStudyForm.getStopTime(), this.baseLineStudyForm.getHistoryHeft() + "", "com.hs.vsm.secservice.ddos.policy.operation.params.unautoInure"});
        }
    }

    public void changeDevice() {
        String defaultServiceName = this.getText("com.hs.vsm.secservice.ddos.policy.zoneservice.default.service");
        StringBuffer json = new StringBuffer("{data : [{label : '" + defaultServiceName + "', value : 'DEFAULT'}");
        AticDevice ne = ZoneReferUtil.getDeviceByIp(this.selectDevice);
        if (null != ne && "4".equals(ZoneReferUtil.getCommonUtilService().getDDoSVersion(ne.getIpAddress()))) {
            DevCapUtil devCapUtil = DevCapUtil.getInstance();
            devCapUtil.initContext(ne.getMoId(), "DEFAULT");
            ParaBean paraBean = devCapUtil.hasParasDiff("customServiceProtocol", ne.getMoId(), "DEFAULT");
            String serviceTypeStr = "";
            if (null != paraBean) {
                serviceTypeStr = paraBean.getParaRange();
            }
            if (null != serviceTypeStr && !"".equals(serviceTypeStr)) {
                String[] service = serviceTypeStr.split(",");
                for (int i = 0; i < service.length; ++i) {
                    json.append(',');
                    json.append('{').append("label : '").append(service[i]).append("',").append("value : '").append(service[i]).append("'}");
                }
            }
        }
        json.append("]}");
        if (!"DEFAULT".equals(this.serviceType)) {
            this.setServiceTypeName(this.serviceType);
        } else {
            this.setServiceTypeName(defaultServiceName);
        }
        this.responseResult(json.toString());
    }

    public Boolean getHasStart() {
        return this.hasStart;
    }

    public void setHasStart(Boolean hasStart) {
        this.hasStart = hasStart;
    }

    public List<StudyResultBean> getGridList() {
        return this.gridList;
    }

    public void setGridList(List<StudyResultBean> gridList) {
        this.gridList = gridList;
    }

    public List<RadioGroupVO> getStuTypeList() {
        return this.stuTypeList;
    }

    public void setStuTypeList(List<RadioGroupVO> stuTypeList) {
        this.stuTypeList = stuTypeList;
    }

    public ZoneBaseLineStudyForm getBaseLineStudyForm() {
        return this.baseLineStudyForm;
    }

    public void setBaseLineStudyForm(ZoneBaseLineStudyForm baseLineStudyForm) {
        this.baseLineStudyForm = baseLineStudyForm;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public List<LangPair> getDeviceList() {
        return this.deviceList;
    }

    public void setDeviceList(List<LangPair> deviceList) {
        this.deviceList = deviceList;
    }

    public List<LangPair> getProtocolTypeList() {
        return this.protocolTypeList;
    }

    public void setProtocolTypeList(List<LangPair> protocolTypeList) {
        this.protocolTypeList = protocolTypeList;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public String getQueryServiceName() {
        return this.queryServiceName;
    }

    public void setQueryServiceName(String queryServiceName) {
        this.queryServiceName = queryServiceName;
    }

    public String getSelectDevice() {
        return this.selectDevice;
    }

    public void setSelectDevice(String selectDevice) {
        this.selectDevice = selectDevice;
    }

    public String getServiceTypeName() {
        return this.serviceTypeName;
    }

    public void setServiceTypeName(String serviceTypeName) {
        this.serviceTypeName = serviceTypeName;
    }

    public String getNoSupportDeviceName() {
        return this.noSupportDeviceName;
    }

    public void setNoSupportDeviceName(String noSupportDeviceName) {
        this.noSupportDeviceName = noSupportDeviceName;
    }

    public Boolean getIsHasNoSupport() {
        return this.isHasNoSupport;
    }

    public void setIsHasNoSupport(Boolean isHasNoSupport) {
        this.isHasNoSupport = isHasNoSupport;
    }

    public List<RadioGroupVO> getEffectModeList() {
        return this.effectModeList;
    }

    public void setEffectModeList(List<RadioGroupVO> effectModeList) {
        this.effectModeList = effectModeList;
    }

    public List<RadioGroupVO> getStartTimeList() {
        return this.startTimeList;
    }

    public void setStartTimeList(List<RadioGroupVO> startTimeList) {
        this.startTimeList = startTimeList;
    }

    public List<RadioGroupVO> getEndTimeList() {
        return this.endTimeList;
    }

    public void setEndTimeList(List<RadioGroupVO> endTimeList) {
        this.endTimeList = endTimeList;
    }

    public List<ZoneBaseLineStudyForm> getZoneBaseLineStudyFormList() {
        return this.zoneBaseLineStudyFormList;
    }

    public void setZoneBaseLineStudyFormList(List<ZoneBaseLineStudyForm> zoneBaseLineStudyFormList) {
        this.zoneBaseLineStudyFormList = zoneBaseLineStudyFormList;
    }

    public long getStudyId() {
        return this.studyId;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public void setStudyId(long studyId) {
        this.studyId = studyId;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public Long[] getStudyIds() {
        if (null != this.studyIds) {
            return (Long[])this.studyIds.clone();
        }
        return new Long[0];
    }

    public void setStudyIds(Long[] studyIds) {
        this.studyIds = null != studyIds ? (Long[])studyIds.clone() : null;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(String stopTime) {
        this.stopTime = stopTime;
    }

    private String dealDeviceInfo(String deviceIP) {
        return ZoneReferUtil.getCommonUtilService().getDDoSVersion(deviceIP);
    }

    public List<String> getConfirmInfo() {
        return this.confirmInfo;
    }

    public void setConfirmInfo(List<String> confirmInfo) {
        this.confirmInfo = confirmInfo;
    }

    public boolean isSupportOutbound() {
        return this.supportOutbound;
    }

    public void setSupportOutbound(boolean supportOutbound) {
        this.supportOutbound = supportOutbound;
    }

    public static void validateIsBoolean(String parameterName) {
        HttpServletRequest request = ServletActionContext.getRequest();
        String viewPage = request.getParameter(parameterName);
        if (!"true".equals(viewPage) && !"false".equals(viewPage)) {
            throw new LegoCheckedException(570505L);
        }
    }

    public boolean validateStopTime() {
        if (this.baseLineStudyForm != null && (this.baseLineStudyForm.getStopTime() == null || "".equals(this.baseLineStudyForm.getStopTime()))) {
            return true;
        }
        String date = "";
        if (null != this.baseLineStudyForm) {
            date = this.baseLineStudyForm.getStopTime();
        }
        if (AticUtil.isNull((String)date)) {
            return true;
        }
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    public boolean validateStartTime() {
        if (this.baseLineStudyForm != null && (this.baseLineStudyForm.getStopTime() == null || "".equals(this.baseLineStudyForm.getStartTime()))) {
            return true;
        }
        String date = "";
        if (null != this.baseLineStudyForm) {
            date = this.baseLineStudyForm.getStartTime();
        }
        if (AticUtil.isNull((String)date)) {
            return true;
        }
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    public boolean validateNewStartTime() {
        if (null != this.baseLineStudyForm && ("".equals(this.baseLineStudyForm.getNewStartTime()) || null == this.baseLineStudyForm.getNewStartTime())) {
            return true;
        }
        String date = "";
        if (null != this.baseLineStudyForm) {
            date = this.baseLineStudyForm.getNewStartTime();
        }
        if (AticUtil.isNull((String)date)) {
            return true;
        }
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    public boolean validateNewEndTime() {
        if (null != this.baseLineStudyForm && ("".equals(this.baseLineStudyForm.getNewEndTime()) || null == this.baseLineStudyForm.getNewEndTime())) {
            return true;
        }
        String date = "";
        if (null != this.baseLineStudyForm) {
            date = this.baseLineStudyForm.getNewEndTime();
        }
        if (AticUtil.isNull((String)date)) {
            return true;
        }
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    public boolean validateNewStartTimeMayNull() {
        if (this.baseLineStudyForm != null && (this.baseLineStudyForm.getNewStartTime() == null || "".equals(this.baseLineStudyForm.getNewStartTime()))) {
            return true;
        }
        String date = "";
        if (null != this.baseLineStudyForm) {
            date = this.baseLineStudyForm.getNewStartTime();
        }
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    public boolean validateStudyIds() {
        for (int i = 0; i < this.studyIds.length; ++i) {
            if (this.studyIds[i] >= 1L) continue;
            return false;
        }
        return true;
    }

    public boolean validateId(String parameterName) {
        HttpServletRequest request = ServletActionContext.getRequest();
        String idTemp = request.getParameter(parameterName);
        if ("".equals(idTemp)) {
            return false;
        }
        if (null == idTemp) {
            return true;
        }
        long id = 0L;
        try {
            id = Long.parseLong(idTemp);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return id >= 1L;
    }

    public boolean validateDeviceIp() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String ip = request.getParameter("deviceIp");
        if (null == ip) {
            return true;
        }
        if ("".equals(ip)) {
            return false;
        }
        return IPUtil.isIpv4((String)ip) || IPUtil.isIpv6((String)ip);
    }

    public boolean validateServiceName() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String name = request.getParameter("queryServiceName");
        if (null == name || "".equals(name)) {
            return true;
        }
        String regex = "^[\\w*]{1}\\w*$";
        return name.matches(regex);
    }

    public boolean validateDeviceName() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String name = request.getParameter("deviceName");
        if (null == name) {
            return true;
        }
        String regex = "^[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
        return name.matches(regex);
    }

    public boolean validateServiceType() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String type = request.getParameter("serviceType");
        if (null == type) {
            return true;
        }
        if ("".equals(type)) {
            return false;
        }
        String regex = "^(DEFAULT|ALL|TCP|UDP|ICMP|HTTP|HTTPS|DNS|TCP_DNS|UDP_DNS|SIP|Other|WILD|DESTZONE|TOPNSTUDY|FIRSTPACKETCHECK|INFLOWDETECT|OUTFLOWDETECT)$";
        return type.matches(regex);
    }

    public boolean validateServiceTypeName() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String type = request.getParameter("serviceTypeName");
        if (null == type) {
            return true;
        }
        if ("".equals(type)) {
            return false;
        }
        String regex = "^(--|TCP|UDP|HTTP|HTTPS|TCP_DNS|UDP_DNS|SIP|Other)$";
        return type.matches(regex);
    }

    public boolean validateStudyId() {
        if (null != this.baseLineStudyForm && null == this.baseLineStudyForm.getStudyId()) {
            return true;
        }
        return null == this.baseLineStudyForm || this.baseLineStudyForm.getStudyId() >= 1L;
    }

    public boolean validatePageSize() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String page = request.getParameter("pageSize");
        if ("".equals(page) || null == page) {
            return true;
        }
        String regex = "^(10|20|30|50|100)$";
        boolean flag = page.matches(regex);
        return flag;
    }

    public boolean validateConfirmInfo() {
        if (!this.confirmInfo.isEmpty()) {
            for (String info : this.confirmInfo) {
                try {
                    String[] array = info.split(";");
                    if (array.length < 3) {
                        return false;
                    }
                    Long serviceId = Long.parseLong(info.split(";")[0]);
                    String fieldName = info.split(";")[1];
                    String voteValue = info.split(";")[2];
                    String nameRegex = "^[\\w|=|\\-|!|@|%|#|$|*|^|:|,|.|+|}|{]+$";
                    if (Integer.parseInt(voteValue) < 0) {
                        return false;
                    }
                    if (AticUtil.isNullForVpn((String)fieldName)) {
                        return false;
                    }
                    if (!fieldName.matches(nameRegex)) {
                        return false;
                    }
                    if (serviceId >= 0L) continue;
                    return false;
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        return true;
    }

    static {
        DDOS_DEVICE_POLICYS.add("synfloodAlertRate");
        DDOS_DEVICE_POLICYS.add("tcpFragAlertRate");
        DDOS_DEVICE_POLICYS.add("udpMaxSpeed");
        DDOS_DEVICE_POLICYS.add("udpFragMaxSpeed");
        DDOS_DEVICE_POLICYS.add("icmpMaxSpeed");
        NFA_DEVICE_POLICYS.add("tcpSynFloodPpsThreshold");
        NFA_DEVICE_POLICYS.add("tcpSynFloodBpsThreshold");
        NFA_DEVICE_POLICYS.add("tcpFragmentFloodPpsThreshold");
        NFA_DEVICE_POLICYS.add("tcpFragmentFloodBpsThreshold");
        NFA_DEVICE_POLICYS.add("udpFloodPpsThreshold");
        NFA_DEVICE_POLICYS.add("udpFloodBpsThreshold");
        NFA_DEVICE_POLICYS.add("udpFragmentFloodPpsThreshold");
        NFA_DEVICE_POLICYS.add("udpFragmentFloodBpsThreshold");
        NFA_DEVICE_POLICYS.add("icmpFloodPpsThreshold");
        NFA_DEVICE_POLICYS.add("icmpFloodBpsThreshold");
    }
}

